/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dev.types.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.papyrus.dev.types.utils.EClassComparator;
import org.eclipse.uml2.uml.UMLPackage;

public class GenerateElementTypesConfigurationsUtils {
    public static Collection<EReference> findAmbiguousContainments(EReference eReference, Collection<EReference> possibleContainmentsEReference) {
        HashSet<EReference> result = new HashSet<EReference>();
        for (EReference ownerContainment : eReference.getEContainingClass().getEAllContainments()) {
            for (EReference possibleContainement : possibleContainmentsEReference) {
                if (eReference == possibleContainement || !ownerContainment.equals(possibleContainement)) continue;
                result.add(possibleContainement);
            }
        }
        return result;
    }

    public static Collection<EReference> findPossibleContainmentsEReference(EClass ownedEClass, Collection<EClass> ownerTypes) {
        HashSet<EReference> result = new HashSet<EReference>();
        for (EClass candidateOwner : ownerTypes) {
            for (EReference eReference : candidateOwner.getEAllContainments()) {
                if (!GenerateElementTypesConfigurationsUtils.isKindOf(ownedEClass, (EClassifier)eReference.getEReferenceType())) continue;
                result.add(eReference);
            }
        }
        return result;
    }

    public static boolean isKindOf(EClass a, EClassifier b) {
        if (a.getEAllSuperTypes().contains((Object)b)) {
            return true;
        }
        return a.equals(b);
    }

    public static Collection<EClass> getAllEClass(EPackage ePackage) {
        ArrayList<EClass> eClasses = new ArrayList<EClass>();
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            if (!(eClassifier instanceof EClass)) continue;
            eClasses.add((EClass)eClassifier);
        }
        Collections.sort(eClasses, new EClassComparator());
        return eClasses;
    }

    public static String getIdentifier(EClass eClass) {
        return "org.eclipse.papyrus.uml." + eClass.getName();
    }

    public static String getAsName(EReference containmentEReference, EClass container) {
        return "_As_" + ((ENamedElement)container.eContainer()).getName().toUpperCase() + "::" + container.getName() + "::" + containmentEReference.getName();
    }

    public static boolean isSpecializedASpecialization(EClass eClass, EReference containmentEReference) {
        Collection<EReference> possibleContainmentsEReference = GenerateElementTypesConfigurationsUtils.findPossibleContainmentsEReference(eClass, GenerateElementTypesConfigurationsUtils.getAllEClass((EPackage)UMLPackage.eINSTANCE));
        return !GenerateElementTypesConfigurationsUtils.findAmbiguousContainments(containmentEReference, possibleContainmentsEReference).isEmpty();
    }

    public static String findSpecializedTypesIDs(EClass eClass, EReference containmentEReference) {
        if (GenerateElementTypesConfigurationsUtils.isSpecializedASpecialization(eClass, containmentEReference)) {
            return String.valueOf(GenerateElementTypesConfigurationsUtils.getIdentifier(eClass)) + GenerateElementTypesConfigurationsUtils.getAsName(containmentEReference, eClass);
        }
        return GenerateElementTypesConfigurationsUtils.getIdentifier(eClass);
    }
}

