/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.types.core.internal.ui.handlers;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.types.rulebased.AndRuleConfiguration;
import org.eclipse.papyrus.infra.types.rulebased.CompositeRuleConfiguration;
import org.eclipse.papyrus.infra.types.rulebased.NotRuleConfiguration;
import org.eclipse.papyrus.infra.types.rulebased.OrRuleConfiguration;
import org.eclipse.papyrus.infra.types.rulebased.RuleBasedFactory;
import org.eclipse.papyrus.infra.types.rulebased.RuleBasedPackage;
import org.eclipse.papyrus.infra.types.rulebased.RuleConfiguration;
import org.eclipse.ui.handlers.HandlerUtil;

public class RuleRefactoringHandler
extends AbstractHandler
implements IExecutableExtension {
    private static final String PARAM_OPERATION = "operation";
    private BiFunction<EditingDomain, RuleConfiguration, Command> refactoringOperation;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof Map) {
            Map parameters = (Map)data;
            String operationName = (String)parameters.get(PARAM_OPERATION);
            if (operationName == null || operationName.isBlank()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.infra.types.rulebased", "Missing operation parameter in RuleRefactoringHandler initialization"));
            }
            switch (OperationKind.valueOf(String.valueOf(operationName))) {
                case NEGATE: {
                    this.refactoringOperation = this::getNegateCommand;
                    break;
                }
                case ADD_TO_AND: {
                    this.refactoringOperation = this::getAddToAndCommand;
                    break;
                }
                case ADD_TO_OR: {
                    this.refactoringOperation = this::getAddToOrCommand;
                    break;
                }
                case PULL_UP_OPERAND: {
                    this.refactoringOperation = this::getPullUpOperandCommand;
                }
            }
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        RuleConfiguration rule = this.getRuleConfiguration(event.getApplicationContext());
        if (rule != null) {
            try {
                this.execute(rule, event.getCommand().getName());
            }
            catch (NotDefinedException e) {
                throw new ExecutionException("Cannot get command label", (Throwable)e);
            }
        }
        return null;
    }

    protected void execute(final RuleConfiguration rule, String label) {
        final EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)rule);
        domain.getCommandStack().execute((Command)new CommandWrapper(label, label, null){

            protected Command createCommand() {
                return RuleRefactoringHandler.this.refactoringOperation.apply(domain, rule);
            }
        });
    }

    private RuleConfiguration getRuleConfiguration(Object evaluationContext) {
        RuleConfiguration result = null;
        Object selection = HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        if (selection instanceof Iterable) {
            Iterator iter = ((Iterable)selection).iterator();
            while (result == null && iter.hasNext()) {
                EObject next = EMFHelper.getEObject(iter.next());
                if (!(next instanceof RuleConfiguration)) continue;
                result = (RuleConfiguration)next;
            }
        }
        return result;
    }

    RuleConfiguration getContainingRule(EditingDomain domain, RuleConfiguration rule) {
        EObject container = rule.eContainer();
        if (container == null) {
            container = EcoreUtil.UsageCrossReferencer.find((EObject)rule, (ResourceSet)domain.getResourceSet()).stream().filter(setting -> setting.getEStructuralFeature() == RuleBasedPackage.Literals.NOT_RULE_CONFIGURATION__COMPOSED_RULE).map(EStructuralFeature.Setting::getEObject).findFirst().orElse(null);
        }
        return container instanceof RuleConfiguration ? (RuleConfiguration)container : null;
    }

    protected Command replace(EditingDomain domain, EObject object, EObject replacement) {
        EObject container = object.eContainer();
        EReference containment = object.eContainmentFeature();
        return containment.isMany() ? RemoveCommand.create((EditingDomain)domain, (Object)container, (Object)containment, Set.of(object)).chain(AddCommand.create((EditingDomain)domain, (Object)container, (Object)containment, Set.of(replacement))) : SetCommand.create((EditingDomain)domain, (Object)object.eContainer(), (Object)containment, (Object)replacement);
    }

    private Command getNegateCommand(EditingDomain domain, RuleConfiguration rule) {
        RuleConfiguration parent = this.getContainingRule(domain, rule);
        if (parent instanceof NotRuleConfiguration) {
            return this.getNegateCommand(domain, parent);
        }
        if (rule instanceof NotRuleConfiguration) {
            NotRuleConfiguration notRule = (NotRuleConfiguration)rule;
            return SetCommand.create((EditingDomain)domain, (Object)notRule, (Object)RuleBasedPackage.Literals.NOT_RULE_CONFIGURATION__COMPOSED_RULE, (Object)SetCommand.UNSET_VALUE).chain(this.replace(domain, (EObject)notRule, (EObject)notRule.getComposedRule()));
        }
        NotRuleConfiguration notRule = RuleBasedFactory.eINSTANCE.createNotRuleConfiguration();
        return this.replace(domain, (EObject)rule, (EObject)notRule).chain(SetCommand.create((EditingDomain)domain, (Object)notRule, (Object)RuleBasedPackage.Literals.NOT_RULE_CONFIGURATION__COMPOSED_RULE, (Object)rule));
    }

    private Command getAddToAndCommand(EditingDomain domain, RuleConfiguration rule) {
        AndRuleConfiguration andRule = RuleBasedFactory.eINSTANCE.createAndRuleConfiguration();
        return this.replace(domain, (EObject)rule, (EObject)andRule).chain(AddCommand.create((EditingDomain)domain, (Object)andRule, (Object)RuleBasedPackage.Literals.COMPOSITE_RULE_CONFIGURATION__COMPOSED_RULES, Set.of(rule)));
    }

    private Command getAddToOrCommand(EditingDomain domain, RuleConfiguration rule) {
        OrRuleConfiguration orRule = RuleBasedFactory.eINSTANCE.createOrRuleConfiguration();
        return this.replace(domain, (EObject)rule, (EObject)orRule).chain(AddCommand.create((EditingDomain)domain, (Object)orRule, (Object)RuleBasedPackage.Literals.COMPOSITE_RULE_CONFIGURATION__COMPOSED_RULES, Set.of(rule)));
    }

    private Command getPullUpOperandCommand(EditingDomain domain, RuleConfiguration rule) {
        CompositeRuleConfiguration composite = (CompositeRuleConfiguration)rule;
        RuleConfiguration operand = (RuleConfiguration)composite.getComposedRules().get(0);
        return RemoveCommand.create((EditingDomain)domain, (Object)composite, (Object)RuleBasedPackage.Literals.COMPOSITE_RULE_CONFIGURATION__COMPOSED_RULES, Set.of(operand)).chain(this.replace(domain, (EObject)composite, (EObject)operand));
    }

    public static enum OperationKind {
        NEGATE,
        ADD_TO_AND,
        ADD_TO_OR,
        PULL_UP_OPERAND;

    }
}

