/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.services;

import java.util.Collections;
import java.util.List;
import org.eclipse.papyrus.infra.core.services.ServiceStartKind;

public class ServiceDescriptor {
    private String serviceClassname;
    private ServiceStartKind serviceStartKind;
    private ServiceTypeKind serviceTypeKind = ServiceTypeKind.service;
    private int priority;
    private String key;
    private String classBundleID;
    private boolean isAnonymous = false;
    private List<String> requiredServices = Collections.emptyList();
    private static List<String> EMPTY_LIST_STRING = Collections.emptyList();

    public ServiceDescriptor(String key, String serviceClassname, ServiceStartKind serviceStartKind, int priority, List<String> requiredServices) {
        this.key = key;
        this.serviceClassname = serviceClassname;
        this.serviceStartKind = serviceStartKind;
        this.priority = priority;
        this.requiredServices = requiredServices;
    }

    public ServiceDescriptor(Class<?> key, String serviceClassname, ServiceStartKind serviceStartKind, int priority, List<String> requiredServices) {
        this(key.getName(), serviceClassname, serviceStartKind, priority, requiredServices);
    }

    public ServiceDescriptor(String key, String serviceClassname, ServiceStartKind serviceStartKind, int priority, boolean isAnonymous, List<String> requiredServices) {
        this.key = key;
        this.serviceClassname = serviceClassname;
        this.serviceStartKind = serviceStartKind;
        this.priority = priority;
        this.isAnonymous = isAnonymous;
        this.requiredServices = requiredServices;
    }

    public ServiceDescriptor(Class<?> key, String serviceClassname, ServiceStartKind serviceStartKind, int priority, boolean isAnonymous, List<String> requiredServices) {
        this(key.getName(), serviceClassname, serviceStartKind, priority, isAnonymous, requiredServices);
    }

    public ServiceDescriptor(String key, String serviceClassname, ServiceStartKind serviceStartKind, int priority) {
        this(key, serviceClassname, serviceStartKind, priority, EMPTY_LIST_STRING);
    }

    public ServiceDescriptor(Class<?> key, String serviceClassname, ServiceStartKind serviceStartKind, int priority) {
        this(key.getName(), serviceClassname, serviceStartKind, priority, EMPTY_LIST_STRING);
    }

    public ServiceDescriptor(String serviceClassname, ServiceStartKind serviceStartKind, int priority, List<String> requiredServices) {
        this(serviceClassname, serviceClassname, serviceStartKind, priority, requiredServices);
    }

    public ServiceDescriptor(String serviceClassname, ServiceStartKind serviceStartKind, int priority, boolean isAnonymous) {
        this(serviceClassname, serviceClassname, serviceStartKind, priority, isAnonymous, EMPTY_LIST_STRING);
    }

    public ServiceDescriptor(String serviceClassname, ServiceStartKind serviceStartKind, int priority) {
        this(serviceClassname, serviceClassname, serviceStartKind, priority, EMPTY_LIST_STRING);
    }

    public ServiceStartKind getServiceStartKind() {
        return this.serviceStartKind;
    }

    public boolean isStartAtStartup() {
        return this.serviceStartKind == ServiceStartKind.STARTUP;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getKey() {
        return this.key;
    }

    public String getServiceClassname() {
        return this.serviceClassname;
    }

    public String getClassBundleID() {
        return this.classBundleID;
    }

    public void setClassBundleID(String classBundleId) {
        this.classBundleID = classBundleId;
    }

    public List<String> getRequiredServiceKeys() {
        return this.requiredServices;
    }

    public void setRequiredServiceKeys(List<String> requiredServices) {
        this.requiredServices = requiredServices;
    }

    public String toString() {
        return "ServiceDescriptor [key=" + this.key + ", serviceClassname=" + this.serviceClassname + ", serviceStartKind=" + (Object)((Object)this.serviceStartKind) + ", priority=" + this.priority + "]";
    }

    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    public void setAnonymous(boolean isAnonymous) {
        this.isAnonymous = isAnonymous;
    }

    public ServiceTypeKind getServiceTypeKind() {
        return this.serviceTypeKind;
    }

    public void setServiceTypeKind(ServiceTypeKind serviceTypeKind) {
        this.serviceTypeKind = serviceTypeKind;
    }

    public static enum ServiceTypeKind {
        service,
        serviceFactory,
        pojo;

    }
}

