/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.properties.contexts.command;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.properties.contexts.Context;
import org.eclipse.papyrus.infra.properties.contexts.util.ContextUsageCrossReferencer;

public class ContextDeleteCommand
extends DeleteCommand {
    public ContextDeleteCommand(EditingDomain domain, Collection<?> collection) {
        super(domain, collection);
    }

    protected Map<EObject, Collection<EStructuralFeature.Setting>> findReferences(Collection<EObject> eObjects) {
        Set scope = this.domain.getResourceSet().getResources().stream().filter(this::isContextResource).collect(Collectors.toSet());
        return new ContextUsageCrossReferencer(scope).findAllUsage(eObjects);
    }

    boolean isContextResource(Resource resource) {
        if (resource.isLoaded() && !resource.getContents().isEmpty()) {
            if (resource.getContents().stream().anyMatch(Context.class::isInstance)) {
                return true;
            }
        }
        return false;
    }

    public static Command create(EditingDomain domain, Object object) {
        return ContextDeleteCommand.create(domain, Set.of(object));
    }

    public static Command create(EditingDomain domain, Collection<?> collection) {
        return new ContextDeleteCommand(domain, collection);
    }
}

