/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.edit.parts;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.handles.MoveHandle;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.BorderItemSelectionEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemLocator;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.NodeEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultGraphicalNodeEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultSemanticEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.IPapyrusNodeFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.RoundedRectangleNodePlateFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.SelectableBorderedNodeFigure;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.policies.FirstEventRefreshEditPolicy;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.policies.TimingDiagramDragDropEditPolicy;
import org.eclipse.papyrus.uml.diagram.timing.custom.figures.VerticalMarkFigure;
import org.eclipse.papyrus.uml.diagram.timing.custom.locator.LabelInCompartmentLocator;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.TimeObservationAppliedStereotypeEditPart;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.TimeObservationNameEditPart;
import org.eclipse.papyrus.uml.diagram.timing.part.UMLVisualIDRegistry;
import org.eclipse.swt.graphics.Color;

public class TimeObservationEditPart
extends NodeEditPart {
    public static final String VISUAL_ID = "TimeObservation_Shape";
    protected IFigure contentPane;
    protected IFigure primaryShape;

    public TimeObservationEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new DefaultSemanticEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new DefaultGraphicalNodeEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new TimingDiagramDragDropEditPolicy());
        this.installEditPolicy("ViewRefreshRole", (EditPolicy)new FirstEventRefreshEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                EditPolicy result;
                block10: {
                    View childView = (View)child.getModel();
                    String vid = UMLVisualIDRegistry.getVisualID(childView);
                    if (vid == null) break block10;
                    switch (vid) {
                        case "TimeObservation_NameLabel": 
                        case "TimeObservation_StereotypeLabel": {
                            return new BorderItemSelectionEditPolicy(){

                                protected List<?> createSelectionHandles() {
                                    MoveHandle mh = new MoveHandle(this.getHost());
                                    mh.setBorder(null);
                                    return Collections.singletonList(mh);
                                }
                            };
                        }
                    }
                }
                if ((result = child.getEditPolicy((Object)"PrimaryDrag Policy")) == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected IFigure createNodeShape() {
        this.primaryShape = new VerticalMarkFigure();
        return this.primaryShape;
    }

    public VerticalMarkFigure getPrimaryShape() {
        return (VerticalMarkFigure)this.primaryShape;
    }

    protected void addBorderItem(IFigure borderItemContainer, IBorderItemEditPart borderItemEditPart) {
        if (borderItemEditPart instanceof TimeObservationAppliedStereotypeEditPart) {
            BorderItemLocator locator = new BorderItemLocator(this.getMainFigure(), 4);
            locator.setBorderItemOffset(new Dimension(-20, -20));
            borderItemContainer.add(borderItemEditPart.getFigure(), (Object)locator);
        } else if (borderItemEditPart instanceof TimeObservationNameEditPart) {
            LabelInCompartmentLocator locator = new LabelInCompartmentLocator(this.getMainFigure());
            borderItemContainer.add(borderItemEditPart.getFigure(), (Object)locator);
        } else {
            super.addBorderItem(borderItemContainer, borderItemEditPart);
        }
    }

    protected NodeFigure createNodePlate() {
        RoundedRectangleNodePlateFigure result = new RoundedRectangleNodePlateFigure(40, 40);
        return result;
    }

    protected NodeFigure createMainFigure() {
        return new SelectableBorderedNodeFigure((IFigure)this.createMainFigureWithSVG());
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    protected void setForegroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setForegroundColor(color);
        }
    }

    protected void setLineWidth(int width) {
        super.setLineWidth(width);
    }

    protected void setLineType(int style) {
        if (this.primaryShape instanceof IPapyrusNodeFigure) {
            ((IPapyrusNodeFigure)this.primaryShape).setLineStyle(style);
        }
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(UMLVisualIDRegistry.getType("TimeObservation_NameLabel"));
    }
}

