/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.manager.axis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;
import org.eclipse.papyrus.uml.nattable.manager.axis.AbstractUMLSynchronizedOnFeatureAxisManager;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.util.UMLUtil;

public abstract class AbstractStereotypedElementUMLSynchronizedOnFeatureAxisManager<T_StereotypeApplication extends EObject>
extends AbstractUMLSynchronizedOnFeatureAxisManager {
    protected Adapter resourceListener;
    protected Map<EObject, Adapter> listenerMap;
    protected Map<EObject, Element> stereotypedElementsMap;
    protected Collection<Resource> listenedResources;
    private Adapter stereotypeApplicationListener = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            AbstractStereotypedElementUMLSynchronizedOnFeatureAxisManager.this.stereotypeApplicationHasChanged(notification);
        }
    };

    public void init(INattableModelManager manager, AxisManagerRepresentation rep, AbstractAxisProvider provider) {
        this.listenerMap = new HashMap<EObject, Adapter>();
        this.stereotypedElementsMap = new HashMap<EObject, Element>();
        super.init(manager, rep, provider);
    }

    protected void addListeners() {
        super.addListeners();
        this.addResourceListeners();
    }

    private void addResourceListeners() {
        this.resourceListener = new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                AbstractStereotypedElementUMLSynchronizedOnFeatureAxisManager.this.resourceHasChanged(notification);
            }
        };
        for (Resource current : this.getResourceToListen()) {
            current.eAdapters().add((Object)this.resourceListener);
        }
    }

    protected Collection<Resource> getResourceToListen() {
        if (this.listenedResources == null) {
            this.listenedResources = new HashSet<Resource>();
            this.listenedResources.add(this.getTableContext().eResource());
        }
        return this.listenedResources;
    }

    protected void featureValueHasChanged(Notification notification) {
        if (notification.isTouch()) {
            return;
        }
        int eventType = notification.getEventType();
        ArrayList<Object> toAdd = new ArrayList<Object>();
        ArrayList<Object> toRemove = new ArrayList<Object>();
        switch (eventType) {
            case 8: {
                break;
            }
            case 3: {
                T_StereotypeApplication stereotypeApplication;
                Object newValue = notification.getNewValue();
                if (!this.isAllowedContents(newValue) || (stereotypeApplication = this.getStereotypeApplication((Element)newValue)) == null) break;
                toAdd.add(newValue);
                this.addStereotypeApplicationListener((EObject)stereotypeApplication);
                this.stereotypedElementsMap.put((EObject)stereotypeApplication, (Element)newValue);
                break;
            }
            case 5: {
                Collection newValues = (Collection)notification.getNewValue();
                for (Object current : newValues) {
                    T_StereotypeApplication stereotypeApplication;
                    if (!this.isAllowedContents(current) || (stereotypeApplication = this.getStereotypeApplication((Element)current)) == null) continue;
                    toAdd.add(current);
                    this.addStereotypeApplicationListener((EObject)stereotypeApplication);
                    this.stereotypedElementsMap.put((EObject)stereotypeApplication, (Element)current);
                }
                break;
            }
            case 10: {
                break;
            }
            case 7: {
                Collection collection = (Collection)((EObject)notification.getNotifier()).eGet((EStructuralFeature)notification.getFeature());
                Collection subList = this.getSubFromFirstNotEquals(collection, (Integer)notification.getOldValue(), this.getIndex(collection, (EObject)notification.getNewValue()));
                toRemove.addAll(subList);
                toAdd.addAll(subList);
                break;
            }
            case 4: {
                Object oldValue = notification.getOldValue();
                if (!this.managedObject.contains(oldValue)) break;
                toRemove.add(oldValue);
                T_StereotypeApplication stereotypeApplication = this.getStereotypeApplication((Element)oldValue);
                if (stereotypeApplication == null) break;
                this.removeStereotypeApplicationListener((EObject)stereotypeApplication);
                this.stereotypedElementsMap.remove(stereotypeApplication);
                break;
            }
            case 6: {
                Collection oldValues = (Collection)notification.getOldValue();
                for (Object current : oldValues) {
                    if (!this.managedObject.contains(current)) continue;
                    toRemove.add(current);
                    T_StereotypeApplication stereotypeApplication = this.getStereotypeApplication((Element)current);
                    if (stereotypeApplication == null) continue;
                    this.removeStereotypeApplicationListener((EObject)stereotypeApplication);
                    this.stereotypedElementsMap.remove(stereotypeApplication);
                }
                break;
            }
        }
        if (toAdd.size() > 0 || toRemove.size() > 0) {
            this.updateManagedList(toAdd, toRemove);
        }
    }

    protected void initializeManagedObjectList() {
        List featuresValue = this.getFeaturesValue();
        for (Object featureValue : featuresValue) {
            T_StereotypeApplication requiredStereotypeApplication;
            Element el;
            if (!(featureValue instanceof Element) || !this.isAllowedAsBaseElement(el = (Element)featureValue) || (requiredStereotypeApplication = this.getStereotypeApplication(el)) == null) continue;
            this.managedObject.add(el);
            this.stereotypedElementsMap.put((EObject)requiredStereotypeApplication, el);
            this.addStereotypeApplicationListener((EObject)requiredStereotypeApplication);
        }
    }

    protected void resourceHasChanged(Notification notification) {
        if (notification.isTouch()) {
            return;
        }
        int eventType = notification.getEventType();
        ArrayList<Element> toAdd = new ArrayList<Element>();
        ArrayList<Element> toRemove = new ArrayList<Element>();
        switch (eventType) {
            case 3: {
                Object addedValue = notification.getNewValue();
                if (!this.isInstanceOfRequiredStereotypeApplication(addedValue)) break;
                List featureValue = this.getFeaturesValue();
                EObject stereotypeApplication = (EObject)addedValue;
                Element stereotypedElement = this.getStereotypeBaseElement(stereotypeApplication);
                if (stereotypedElement != null && this.isAllowedAsBaseElement(stereotypedElement) && featureValue.contains(stereotypedElement)) {
                    toAdd.add(stereotypedElement);
                    this.stereotypedElementsMap.put(stereotypeApplication, stereotypedElement);
                }
                this.addStereotypeApplicationListener(stereotypeApplication);
                break;
            }
            case 5: {
                Collection addedValues = (Collection)notification.getNewValue();
                List featureValue = this.getFeaturesValue();
                for (Object current : addedValues) {
                    if (!(current instanceof EObject) || !this.isInstanceOfRequiredStereotypeApplication(current)) continue;
                    EObject stereotypeApplication = (EObject)current;
                    Element stereotypedElement = this.getStereotypeBaseElement(stereotypeApplication);
                    if (stereotypedElement != null && this.isAllowedAsBaseElement(stereotypedElement) && featureValue.contains(stereotypedElement)) {
                        toAdd.add(stereotypedElement);
                        this.stereotypedElementsMap.put(stereotypeApplication, stereotypedElement);
                    }
                    this.addStereotypeApplicationListener(stereotypeApplication);
                }
                break;
            }
            case 10: {
                break;
            }
            case 7: {
                Collection collection = (Collection)((EObject)notification.getNotifier()).eGet((EStructuralFeature)notification.getFeature());
                Collection subList = this.getSubFromFirstNotEquals(collection, (Integer)notification.getOldValue(), this.getIndex(collection, (EObject)notification.getNewValue()));
                toRemove.addAll(subList);
                toAdd.addAll(subList);
                break;
            }
            case 4: {
                Element stereotypedElement;
                Object removedValue = notification.getOldValue();
                if (!this.isInstanceOfRequiredStereotypeApplication(removedValue) || (stereotypedElement = this.stereotypedElementsMap.get(removedValue)) == null || !this.managedObject.contains(stereotypedElement)) break;
                toRemove.add(stereotypedElement);
                this.stereotypedElementsMap.remove(removedValue);
                this.removeStereotypeApplicationListener((EObject)removedValue);
                break;
            }
            case 6: {
                Collection removedValues = (Collection)notification.getOldValue();
                for (Object current : removedValues) {
                    Element stereotypedElement;
                    if (!this.isInstanceOfRequiredStereotypeApplication(current) || (stereotypedElement = this.stereotypedElementsMap.get(current)) == null || !this.managedObject.contains(stereotypedElement)) continue;
                    toRemove.add(stereotypedElement);
                    this.stereotypedElementsMap.remove(current);
                    this.removeStereotypeApplicationListener((EObject)current);
                }
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
        }
        if (toAdd.size() > 0 || toRemove.size() > 0) {
            this.updateManagedList(toAdd, toRemove);
        }
    }

    protected final void addStereotypeApplicationListener(EObject stereotypeApplication) {
        if (this.listenerMap.containsKey(stereotypeApplication)) {
            return;
        }
        stereotypeApplication.eAdapters().add((Object)this.stereotypeApplicationListener);
        this.listenerMap.put(stereotypeApplication, this.stereotypeApplicationListener);
    }

    protected final void removeStereotypeApplicationListener(EObject stereotypeApplication) {
        Adapter listener = this.listenerMap.remove(stereotypeApplication);
        stereotypeApplication.eAdapters().remove((Object)listener);
    }

    protected void removeListeners() {
        super.removeListeners();
        for (EObject eObject : this.listenerMap.keySet()) {
            eObject.eAdapters().remove((Object)this.listenerMap.get(eObject));
        }
        if (this.resourceListener != null) {
            for (Resource resource : this.getResourceToListen()) {
                resource.eAdapters().remove((Object)this.resourceListener);
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.listenedResources.clear();
        this.listenedResources = null;
        this.listenerMap.clear();
        this.stereotypedElementsMap.clear();
    }

    protected abstract boolean isInstanceOfRequiredStereotypeApplication(Object var1);

    protected Element getStereotypeBaseElement(T_StereotypeApplication stereotypeApplication) {
        return UMLUtil.getBaseElement(stereotypeApplication);
    }

    protected void stereotypeApplicationHasChanged(Notification notification) {
        if (notification.isTouch()) {
            return;
        }
        Object notifier = notification.getNotifier();
        if (!this.isInstanceOfRequiredStereotypeApplication(notifier)) {
            return;
        }
        Object feature = notification.getFeature();
        int eventType = notification.getEventType();
        if (feature instanceof EReference && ((EReference)feature).getName().startsWith(this.getStereotypeApplicationBasePropertyName())) {
            List featureValues = this.getFeaturesValue();
            switch (eventType) {
                case 1: {
                    Object newValue = notification.getNewValue();
                    Object oldValue = notification.getOldValue();
                    if (newValue instanceof Element && this.isAllowedAsBaseElement((Element)newValue) && featureValues.contains(newValue)) {
                        this.updateManagedList(Collections.singletonList(newValue), Collections.emptyList());
                        this.stereotypedElementsMap.put((EObject)notifier, (Element)newValue);
                        break;
                    }
                    if (newValue != null || !this.managedObject.contains(oldValue)) break;
                    this.updateManagedList(Collections.emptyList(), Collections.singletonList(oldValue));
                    this.stereotypedElementsMap.remove(notifier);
                    this.removeStereotypeApplicationListener((EObject)notifier);
                    break;
                }
                case 2: {
                    Object oldValue2 = notification.getOldValue();
                    if (!(oldValue2 instanceof Element) || !this.managedObject.contains(oldValue2)) break;
                    this.updateManagedList(Collections.emptyList(), Collections.singletonList(oldValue2));
                    this.stereotypedElementsMap.remove(notifier);
                    this.removeStereotypeApplicationListener((EObject)notifier);
                    break;
                }
            }
        }
    }

    public boolean isAllowedContents(Object object) {
        return object instanceof Element && this.isAllowedAsBaseElement((Element)object) && this.hasRequiredStereotypes((Element)object);
    }

    protected final boolean hasRequiredStereotypes(Element element) {
        return this.getStereotypeApplication(element) != null;
    }

    protected abstract boolean isAllowedAsBaseElement(Element var1);

    protected abstract T_StereotypeApplication getStereotypeApplication(Element var1);

    protected abstract String getStereotypeApplicationBasePropertyName();
}

