/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.freeze.command;

import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.freeze.FreezeLayer;
import org.eclipse.nebula.widgets.nattable.freeze.command.IFreezeCoordinatesProvider;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;

public class FreezeColumnStrategy
implements IFreezeCoordinatesProvider {
    private final FreezeLayer freezeLayer;
    private final ViewportLayer viewportLayer;
    private final int columnPosition;

    public FreezeColumnStrategy(FreezeLayer freezeLayer, int columnPosition) {
        this(freezeLayer, null, columnPosition);
    }

    public FreezeColumnStrategy(FreezeLayer freezeLayer, ViewportLayer viewportLayer, int columnPosition) {
        this.freezeLayer = freezeLayer;
        this.viewportLayer = viewportLayer;
        this.columnPosition = columnPosition;
    }

    @Override
    public PositionCoordinate getTopLeftPosition() {
        int columnPosition = 0;
        if (this.viewportLayer != null && (columnPosition = this.viewportLayer.getScrollableLayer().getColumnPositionByX(this.viewportLayer.getOrigin().getX())) > 0 && columnPosition >= this.columnPosition) {
            columnPosition = this.columnPosition;
        }
        return new PositionCoordinate(this.freezeLayer, columnPosition, -1);
    }

    @Override
    public PositionCoordinate getBottomRightPosition() {
        return new PositionCoordinate(this.freezeLayer, this.columnPosition, -1);
    }
}

