/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.navigation;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.infra.gmfdiag.navigation.ExistingNavigableElement;
import org.eclipse.papyrus.infra.gmfdiag.navigation.IModelLinker;
import org.eclipse.papyrus.infra.gmfdiag.navigation.INavigationRule;
import org.eclipse.papyrus.infra.gmfdiag.navigation.NavigableElement;
import org.eclipse.papyrus.uml.diagram.navigation.UMLRuleHelper;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.UMLPackage;

public class TransitionRule
implements INavigationRule {
    public boolean handle(EObject element) {
        return element instanceof Transition;
    }

    public List<NavigableElement> getNextPossibleElements(NavigableElement currentNavElement) {
        LinkedList<NavigableElement> nextPossibleElements = new LinkedList<NavigableElement>();
        EReference feature = UMLPackage.Literals.TRANSITION__EFFECT;
        final Transition transition = (Transition)currentNavElement.getElement();
        if (transition.getEffect() != null) {
            nextPossibleElements.add((NavigableElement)new ExistingNavigableElement((EObject)transition.getEffect(), (EStructuralFeature)feature));
        } else {
            UMLRuleHelper.addBehaviorCreatedNavigableElements(nextPossibleElements, currentNavElement, (EStructuralFeature)feature, new IModelLinker(){

                public void linkToModel(EObject toLink) {
                    transition.setEffect((Behavior)toLink);
                }
            });
        }
        return nextPossibleElements;
    }
}

