/**
 */
package org.eclipse.papyrus.uml.alf;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 * <li>each class,</li>
 * <li>each feature of each class,</li>
 * <li>each operation of each class,</li>
 * <li>each enum,</li>
 * <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.papyrus.uml.alf.AlfFactory
 * @model kind="package"
 *        annotation="http://www.eclipse.org/OCL/Import ecore='http://www.eclipse.org/emf/2002/Ecore' types='http://www.eclipse.org/uml2/5.0.0/Types' uml='http://www.eclipse.org/uml2/5.0.0/UML'"
 *        annotation="http://www.eclipse.org/emf/2002/Ecore invocationDelegates='http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot' settingDelegates='http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot' validationDelegates='http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot'"
 * @generated
 */
public interface AlfPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "alf";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.omg.org/spec/ALF/20120827";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "alf";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	AlfPackage eINSTANCE = org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.AssignedSourceImpl <em>Assigned Source</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.AssignedSourceImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getAssignedSource()
	 * @generated
	 */
	int ASSIGNED_SOURCE = 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNED_SOURCE__NAME = 0;

	/**
	 * The feature id for the '<em><b>Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNED_SOURCE__SOURCE = 1;

	/**
	 * The feature id for the '<em><b>Upper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNED_SOURCE__UPPER = 2;

	/**
	 * The feature id for the '<em><b>Lower</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNED_SOURCE__LOWER = 3;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNED_SOURCE__TYPE = 4;

	/**
	 * The feature id for the '<em><b>Is Parallel Local Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNED_SOURCE__IS_PARALLEL_LOCAL_NAME = 5;

	/**
	 * The number of structural features of the '<em>Assigned Source</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNED_SOURCE_FEATURE_COUNT = 6;

	/**
	 * The operation id for the '<em>Is New</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNED_SOURCE___IS_NEW__ELIST = 0;

	/**
	 * The operation id for the '<em>Update</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNED_SOURCE___UPDATE__ELIST = 1;

	/**
	 * The operation id for the '<em>Copy</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNED_SOURCE___COPY__SYNTAXELEMENT_BOOLEAN = 2;

	/**
	 * The number of operations of the '<em>Assigned Source</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNED_SOURCE_OPERATION_COUNT = 3;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.SyntaxElementImpl <em>Syntax Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.SyntaxElementImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getSyntaxElement()
	 * @generated
	 */
	int SYNTAX_ELEMENT = 1;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNTAX_ELEMENT__OWNER = 0;

	/**
	 * The number of structural features of the '<em>Syntax Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNTAX_ELEMENT_FEATURE_COUNT = 1;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNTAX_ELEMENT___TO_REFERENCE = 0;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNTAX_ELEMENT___OWNER = 1;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNTAX_ELEMENT___SYNTAX_ELEMENT_OWNER = 2;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNTAX_ELEMENT___CURRENT_SCOPE = 3;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNTAX_ELEMENT___SYNTAX_ELEMENT_CURRENT_SCOPE = 4;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNTAX_ELEMENT___ENCLOSING_STATEMENT = 5;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNTAX_ELEMENT___ENCLOSING_EXPRESSION = 6;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNTAX_ELEMENT___ASSIGNMENTS_BEFORE = 7;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNTAX_ELEMENT___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = 8;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNTAX_ELEMENT___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = 9;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNTAX_ELEMENT___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = 10;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNTAX_ELEMENT___UPDATE_ALL__ELIST_ELIST = 11;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNTAX_ELEMENT___COMMON_ANCESTOR__ELIST = 12;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNTAX_ELEMENT___COMMON_ANCESTORS__ELIST = 13;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNTAX_ELEMENT___REMOVE_DUPLICATE_ELEMENTS__ELIST = 14;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNTAX_ELEMENT___RESOLVE_IN_LIBRARY__STRING = 15;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNTAX_ELEMENT___PRIMITIVE_TYPE__STRING = 16;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNTAX_ELEMENT___PRIMITIVE_TYPE____STRING = 17;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNTAX_ELEMENT___BOOLEAN_TYPE = 18;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNTAX_ELEMENT___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = 19;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNTAX_ELEMENT___INTEGER_TYPE = 20;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNTAX_ELEMENT___IS_INTEGER_TYPE__ELEMENTREFERENCE = 21;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNTAX_ELEMENT___STRING_TYPE = 22;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNTAX_ELEMENT___IS_STRING_TYPE__ELEMENTREFERENCE = 23;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNTAX_ELEMENT___UNLIMITED_NATURAL_TYPE = 24;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNTAX_ELEMENT___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = 25;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNTAX_ELEMENT___BIT_STRING_TYPE = 26;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNTAX_ELEMENT___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = 27;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNTAX_ELEMENT___NATURAL_TYPE = 28;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNTAX_ELEMENT___IS_NATURAL_TYPE__ELEMENTREFERENCE = 29;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNTAX_ELEMENT___IS_NUMERIC_TYPE__ELEMENTREFERENCE = 30;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNTAX_ELEMENT___COLLECTION_FUNCTION_ADD = 31;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNTAX_ELEMENT___IS_COLLECTION_CLASS__ELEMENTREFERENCE = 32;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNTAX_ELEMENT___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = 33;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNTAX_ELEMENT___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = 34;

	/**
	 * The number of operations of the '<em>Syntax Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYNTAX_ELEMENT_OPERATION_COUNT = 35;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.AssignableElementImpl <em>Assignable Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.AssignableElementImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getAssignableElement()
	 * @generated
	 */
	int ASSIGNABLE_ELEMENT = 9;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.ElementReferenceImpl <em>Element Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.ElementReferenceImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getElementReference()
	 * @generated
	 */
	int ELEMENT_REFERENCE = 2;

	/**
	 * The number of structural features of the '<em>Element Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE_FEATURE_COUNT = 0;

	/**
	 * The operation id for the '<em>Is Uml</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_UML = 0;

	/**
	 * The operation id for the '<em>Is Alf</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_ALF = 1;

	/**
	 * The operation id for the '<em>As Uml</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___AS_UML = 2;

	/**
	 * The operation id for the '<em>As Alf</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___AS_ALF = 3;

	/**
	 * The operation id for the '<em>As Member</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___AS_MEMBER = 4;

	/**
	 * The operation id for the '<em>Is Same Kind As</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_SAME_KIND_AS__ELEMENTREFERENCE = 5;

	/**
	 * The operation id for the '<em>Is Named Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_NAMED_ELEMENT = 6;

	/**
	 * The operation id for the '<em>Is Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_NAMESPACE = 7;

	/**
	 * The operation id for the '<em>Is Namespace For</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_NAMESPACE_FOR__UNITDEFINITION = 8;

	/**
	 * The operation id for the '<em>Is Model Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_MODEL_NAMESPACE = 9;

	/**
	 * The operation id for the '<em>Is Package</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_PACKAGE = 10;

	/**
	 * The operation id for the '<em>Is Profile</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_PROFILE = 11;

	/**
	 * The operation id for the '<em>Is Packageable Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_PACKAGEABLE_ELEMENT = 12;

	/**
	 * The operation id for the '<em>Is Classifier</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_CLASSIFIER = 13;

	/**
	 * The operation id for the '<em>Is Abstract Classifier</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_ABSTRACT_CLASSIFIER = 14;

	/**
	 * The operation id for the '<em>Is Association</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_ASSOCIATION = 15;

	/**
	 * The operation id for the '<em>Is Data Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_DATA_TYPE = 16;

	/**
	 * The operation id for the '<em>Is Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_CLASS = 17;

	/**
	 * The operation id for the '<em>Is Active Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_ACTIVE_CLASS = 18;

	/**
	 * The operation id for the '<em>Is Signal</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_SIGNAL = 19;

	/**
	 * The operation id for the '<em>Is Enumeration</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_ENUMERATION = 20;

	/**
	 * The operation id for the '<em>Is Behavior</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_BEHAVIOR = 21;

	/**
	 * The operation id for the '<em>Is Activity</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_ACTIVITY = 22;

	/**
	 * The operation id for the '<em>Is Method</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_METHOD = 23;

	/**
	 * The operation id for the '<em>Is Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_PRIMITIVE_TYPE = 24;

	/**
	 * The operation id for the '<em>Is Reception</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_RECEPTION = 25;

	/**
	 * The operation id for the '<em>Is Operation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_OPERATION = 26;

	/**
	 * The operation id for the '<em>Is Constructor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_CONSTRUCTOR = 27;

	/**
	 * The operation id for the '<em>Is Destructor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_DESTRUCTOR = 28;

	/**
	 * The operation id for the '<em>Is Feature</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_FEATURE = 29;

	/**
	 * The operation id for the '<em>Is Property</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_PROPERTY = 30;

	/**
	 * The operation id for the '<em>Is Association End</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_ASSOCIATION_END = 31;

	/**
	 * The operation id for the '<em>Is Parameter</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_PARAMETER = 32;

	/**
	 * The operation id for the '<em>Is Template</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_TEMPLATE = 33;

	/**
	 * The operation id for the '<em>Is Template Parameter</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_TEMPLATE_PARAMETER = 34;

	/**
	 * The operation id for the '<em>Is Classifier Template Parameter</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_CLASSIFIER_TEMPLATE_PARAMETER = 35;

	/**
	 * The operation id for the '<em>Is Parametered Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_PARAMETERED_ELEMENT = 36;

	/**
	 * The operation id for the '<em>Is Template Binding</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_TEMPLATE_BINDING = 37;

	/**
	 * The operation id for the '<em>Is Stereotype</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_STEREOTYPE = 38;

	/**
	 * The operation id for the '<em>Is Enumeration Literal</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_ENUMERATION_LITERAL = 39;

	/**
	 * The operation id for the '<em>Is Loop Variable</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_LOOP_VARIABLE = 40;

	/**
	 * The operation id for the '<em>Is Annotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_ANNOTATION = 41;

	/**
	 * The operation id for the '<em>Is Sequence Expansion Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_SEQUENCE_EXPANSION_EXPRESSION = 42;

	/**
	 * The operation id for the '<em>Is Any Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_ANY_TYPE = 43;

	/**
	 * The operation id for the '<em>Is Distinguishable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_DISTINGUISHABLE_FROM__ELEMENTREFERENCE = 44;

	/**
	 * The operation id for the '<em>Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT = 45;

	/**
	 * The operation id for the '<em>Collection Argument</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___COLLECTION_ARGUMENT = 46;

	/**
	 * The operation id for the '<em>Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___NAME = 47;

	/**
	 * The operation id for the '<em>Visibility</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___VISIBILITY = 48;

	/**
	 * The operation id for the '<em>Owned Members</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___OWNED_MEMBERS = 49;

	/**
	 * The operation id for the '<em>Members</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___MEMBERS = 50;

	/**
	 * The operation id for the '<em>Visible Members</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___VISIBLE_MEMBERS = 51;

	/**
	 * The operation id for the '<em>Nested Classifiers</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___NESTED_CLASSIFIERS = 52;

	/**
	 * The operation id for the '<em>Properties</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___PROPERTIES = 53;

	/**
	 * The operation id for the '<em>Association Ends</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___ASSOCIATION_ENDS = 54;

	/**
	 * The operation id for the '<em>Opposite</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___OPPOSITE = 55;

	/**
	 * The operation id for the '<em>Receptions</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___RECEPTIONS = 56;

	/**
	 * The operation id for the '<em>Signal</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___SIGNAL = 57;

	/**
	 * The operation id for the '<em>Parameters</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___PARAMETERS = 58;

	/**
	 * The operation id for the '<em>Return Parameter</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___RETURN_PARAMETER = 59;

	/**
	 * The operation id for the '<em>Specification</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___SPECIFICATION = 60;

	/**
	 * The operation id for the '<em>Redefined Operations</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___REDEFINED_OPERATIONS = 61;

	/**
	 * The operation id for the '<em>Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___NAMESPACE = 62;

	/**
	 * The operation id for the '<em>Template</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___TEMPLATE = 63;

	/**
	 * The operation id for the '<em>Template Parameters</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___TEMPLATE_PARAMETERS = 64;

	/**
	 * The operation id for the '<em>Parametered Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___PARAMETERED_ELEMENTS = 65;

	/**
	 * The operation id for the '<em>Template Actuals</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___TEMPLATE_ACTUALS = 66;

	/**
	 * The operation id for the '<em>Direction</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___DIRECTION = 67;

	/**
	 * The operation id for the '<em>Association</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___ASSOCIATION = 68;

	/**
	 * The operation id for the '<em>Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___TYPE = 69;

	/**
	 * The operation id for the '<em>Lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___LOWER = 70;

	/**
	 * The operation id for the '<em>Upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___UPPER = 71;

	/**
	 * The operation id for the '<em>Is Ordered</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_ORDERED = 72;

	/**
	 * The operation id for the '<em>Is Nonunique</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_NONUNIQUE = 73;

	/**
	 * The operation id for the '<em>Parents</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___PARENTS = 74;

	/**
	 * The operation id for the '<em>All Parents</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___ALL_PARENTS = 75;

	/**
	 * The operation id for the '<em>Classifier Behavior</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___CLASSIFIER_BEHAVIOR = 76;

	/**
	 * The operation id for the '<em>Context</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___CONTEXT = 77;

	/**
	 * The operation id for the '<em>Applied Profiles</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___APPLIED_PROFILES = 78;

	/**
	 * The operation id for the '<em>Base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___BASE = 79;

	/**
	 * The operation id for the '<em>Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___REFERENCE = 80;

	/**
	 * The operation id for the '<em>Template Binding</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___TEMPLATE_BINDING = 81;

	/**
	 * The operation id for the '<em>Bind</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___BIND__ELIST = 82;

	/**
	 * The operation id for the '<em>Bound Element Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___BOUND_ELEMENT_NAME__ELIST = 83;

	/**
	 * The operation id for the '<em>Bound Path Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___BOUND_PATH_NAME = 84;

	/**
	 * The operation id for the '<em>Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___QUALIFIED_NAME = 85;

	/**
	 * The operation id for the '<em>Active Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___ACTIVE_CLASS = 86;

	/**
	 * The operation id for the '<em>Is Active Behavior</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___IS_ACTIVE_BEHAVIOR = 87;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___CONFORMS_TO__ELEMENTREFERENCE = 88;

	/**
	 * The operation id for the '<em>Equals</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___EQUALS__ELEMENTREFERENCE = 89;

	/**
	 * The operation id for the '<em>Contained In</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___CONTAINED_IN__ELIST = 90;

	/**
	 * The operation id for the '<em>Count In</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___COUNT_IN__ELIST = 91;

	/**
	 * The operation id for the '<em>Position In</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___POSITION_IN__ELIST = 92;

	/**
	 * The operation id for the '<em>Copy</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___COPY = 93;

	/**
	 * The operation id for the '<em>Model Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___MODEL_SCOPE = 94;

	/**
	 * The operation id for the '<em>Resolve Path Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___RESOLVE_PATH_NAME__STRING = 95;

	/**
	 * The operation id for the '<em>Resolve In Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___RESOLVE_IN_SCOPE__STRING = 96;

	/**
	 * The operation id for the '<em>Resolve Stereotype</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___RESOLVE_STEREOTYPE__STRING = 97;

	/**
	 * The operation id for the '<em>Resolve</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___RESOLVE__STRING = 98;

	/**
	 * The operation id for the '<em>Resolve Visible</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___RESOLVE_VISIBLE__STRING_ELEMENTREFERENCE = 99;

	/**
	 * The operation id for the '<em>Resolve Association End</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___RESOLVE_ASSOCIATION_END__ELEMENTREFERENCE_STRING = 100;

	/**
	 * The operation id for the '<em>Contains Member</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___CONTAINS_MEMBER__ELEMENTREFERENCE = 101;

	/**
	 * The operation id for the '<em>Allow Package Only</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___ALLOW_PACKAGE_ONLY = 102;

	/**
	 * The operation id for the '<em>Stub</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___STUB = 103;

	/**
	 * The operation id for the '<em>Stub For</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___STUB_FOR__UNITDEFINITION = 104;

	/**
	 * The operation id for the '<em>Constructor Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE___CONSTRUCTOR_REFERENCE = 105;

	/**
	 * The number of operations of the '<em>Element Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_REFERENCE_OPERATION_COUNT = 106;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.InternalElementReferenceImpl <em>Internal Element Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.InternalElementReferenceImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getInternalElementReference()
	 * @generated
	 */
	int INTERNAL_ELEMENT_REFERENCE = 3;

	/**
	 * The feature id for the '<em><b>Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE__ELEMENT = ELEMENT_REFERENCE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Internal Element Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE_FEATURE_COUNT = ELEMENT_REFERENCE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Is Uml</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_UML = ELEMENT_REFERENCE___IS_UML;

	/**
	 * The operation id for the '<em>As Uml</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___AS_UML = ELEMENT_REFERENCE___AS_UML;

	/**
	 * The operation id for the '<em>Is Distinguishable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_DISTINGUISHABLE_FROM__ELEMENTREFERENCE = ELEMENT_REFERENCE___IS_DISTINGUISHABLE_FROM__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT = ELEMENT_REFERENCE___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Collection Argument</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___COLLECTION_ARGUMENT = ELEMENT_REFERENCE___COLLECTION_ARGUMENT;

	/**
	 * The operation id for the '<em>Visible Members</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___VISIBLE_MEMBERS = ELEMENT_REFERENCE___VISIBLE_MEMBERS;

	/**
	 * The operation id for the '<em>Properties</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___PROPERTIES = ELEMENT_REFERENCE___PROPERTIES;

	/**
	 * The operation id for the '<em>Association Ends</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___ASSOCIATION_ENDS = ELEMENT_REFERENCE___ASSOCIATION_ENDS;

	/**
	 * The operation id for the '<em>Receptions</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___RECEPTIONS = ELEMENT_REFERENCE___RECEPTIONS;

	/**
	 * The operation id for the '<em>Redefined Operations</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___REDEFINED_OPERATIONS = ELEMENT_REFERENCE___REDEFINED_OPERATIONS;

	/**
	 * The operation id for the '<em>Base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___BASE = ELEMENT_REFERENCE___BASE;

	/**
	 * The operation id for the '<em>Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___REFERENCE = ELEMENT_REFERENCE___REFERENCE;

	/**
	 * The operation id for the '<em>Template Binding</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___TEMPLATE_BINDING = ELEMENT_REFERENCE___TEMPLATE_BINDING;

	/**
	 * The operation id for the '<em>Bind</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___BIND__ELIST = ELEMENT_REFERENCE___BIND__ELIST;

	/**
	 * The operation id for the '<em>Bound Element Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___BOUND_ELEMENT_NAME__ELIST = ELEMENT_REFERENCE___BOUND_ELEMENT_NAME__ELIST;

	/**
	 * The operation id for the '<em>Bound Path Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___BOUND_PATH_NAME = ELEMENT_REFERENCE___BOUND_PATH_NAME;

	/**
	 * The operation id for the '<em>Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___QUALIFIED_NAME = ELEMENT_REFERENCE___QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Is Active Behavior</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_ACTIVE_BEHAVIOR = ELEMENT_REFERENCE___IS_ACTIVE_BEHAVIOR;

	/**
	 * The operation id for the '<em>Contained In</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___CONTAINED_IN__ELIST = ELEMENT_REFERENCE___CONTAINED_IN__ELIST;

	/**
	 * The operation id for the '<em>Count In</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___COUNT_IN__ELIST = ELEMENT_REFERENCE___COUNT_IN__ELIST;

	/**
	 * The operation id for the '<em>Position In</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___POSITION_IN__ELIST = ELEMENT_REFERENCE___POSITION_IN__ELIST;

	/**
	 * The operation id for the '<em>Resolve Stereotype</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___RESOLVE_STEREOTYPE__STRING = ELEMENT_REFERENCE___RESOLVE_STEREOTYPE__STRING;

	/**
	 * The operation id for the '<em>Resolve</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___RESOLVE__STRING = ELEMENT_REFERENCE___RESOLVE__STRING;

	/**
	 * The operation id for the '<em>Resolve Visible</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___RESOLVE_VISIBLE__STRING_ELEMENTREFERENCE = ELEMENT_REFERENCE___RESOLVE_VISIBLE__STRING_ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Resolve Association End</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___RESOLVE_ASSOCIATION_END__ELEMENTREFERENCE_STRING = ELEMENT_REFERENCE___RESOLVE_ASSOCIATION_END__ELEMENTREFERENCE_STRING;

	/**
	 * The operation id for the '<em>Contains Member</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___CONTAINS_MEMBER__ELEMENTREFERENCE = ELEMENT_REFERENCE___CONTAINS_MEMBER__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Allow Package Only</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___ALLOW_PACKAGE_ONLY = ELEMENT_REFERENCE___ALLOW_PACKAGE_ONLY;

	/**
	 * The operation id for the '<em>Constructor Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___CONSTRUCTOR_REFERENCE = ELEMENT_REFERENCE___CONSTRUCTOR_REFERENCE;

	/**
	 * The operation id for the '<em>Is Alf</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_ALF = ELEMENT_REFERENCE_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>As Alf</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___AS_ALF = ELEMENT_REFERENCE_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>As Member</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___AS_MEMBER = ELEMENT_REFERENCE_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Is Same Kind As</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_SAME_KIND_AS__ELEMENTREFERENCE = ELEMENT_REFERENCE_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Is Named Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_NAMED_ELEMENT = ELEMENT_REFERENCE_OPERATION_COUNT + 4;

	/**
	 * The operation id for the '<em>Is Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_NAMESPACE = ELEMENT_REFERENCE_OPERATION_COUNT + 5;

	/**
	 * The operation id for the '<em>Is Namespace For</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_NAMESPACE_FOR__UNITDEFINITION = ELEMENT_REFERENCE_OPERATION_COUNT + 6;

	/**
	 * The operation id for the '<em>Is Model Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_MODEL_NAMESPACE = ELEMENT_REFERENCE_OPERATION_COUNT + 7;

	/**
	 * The operation id for the '<em>Is Package</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_PACKAGE = ELEMENT_REFERENCE_OPERATION_COUNT + 8;

	/**
	 * The operation id for the '<em>Is Profile</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_PROFILE = ELEMENT_REFERENCE_OPERATION_COUNT + 9;

	/**
	 * The operation id for the '<em>Is Packageable Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_PACKAGEABLE_ELEMENT = ELEMENT_REFERENCE_OPERATION_COUNT + 10;

	/**
	 * The operation id for the '<em>Is Classifier</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_CLASSIFIER = ELEMENT_REFERENCE_OPERATION_COUNT + 11;

	/**
	 * The operation id for the '<em>Is Abstract Classifier</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_ABSTRACT_CLASSIFIER = ELEMENT_REFERENCE_OPERATION_COUNT + 12;

	/**
	 * The operation id for the '<em>Is Association</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_ASSOCIATION = ELEMENT_REFERENCE_OPERATION_COUNT + 13;

	/**
	 * The operation id for the '<em>Is Data Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_DATA_TYPE = ELEMENT_REFERENCE_OPERATION_COUNT + 14;

	/**
	 * The operation id for the '<em>Is Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_CLASS = ELEMENT_REFERENCE_OPERATION_COUNT + 15;

	/**
	 * The operation id for the '<em>Is Active Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_ACTIVE_CLASS = ELEMENT_REFERENCE_OPERATION_COUNT + 16;

	/**
	 * The operation id for the '<em>Is Signal</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_SIGNAL = ELEMENT_REFERENCE_OPERATION_COUNT + 17;

	/**
	 * The operation id for the '<em>Is Enumeration</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_ENUMERATION = ELEMENT_REFERENCE_OPERATION_COUNT + 18;

	/**
	 * The operation id for the '<em>Is Behavior</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_BEHAVIOR = ELEMENT_REFERENCE_OPERATION_COUNT + 19;

	/**
	 * The operation id for the '<em>Is Activity</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_ACTIVITY = ELEMENT_REFERENCE_OPERATION_COUNT + 20;

	/**
	 * The operation id for the '<em>Is Method</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_METHOD = ELEMENT_REFERENCE_OPERATION_COUNT + 21;

	/**
	 * The operation id for the '<em>Is Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_PRIMITIVE_TYPE = ELEMENT_REFERENCE_OPERATION_COUNT + 22;

	/**
	 * The operation id for the '<em>Is Reception</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_RECEPTION = ELEMENT_REFERENCE_OPERATION_COUNT + 23;

	/**
	 * The operation id for the '<em>Is Operation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_OPERATION = ELEMENT_REFERENCE_OPERATION_COUNT + 24;

	/**
	 * The operation id for the '<em>Is Constructor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_CONSTRUCTOR = ELEMENT_REFERENCE_OPERATION_COUNT + 25;

	/**
	 * The operation id for the '<em>Is Destructor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_DESTRUCTOR = ELEMENT_REFERENCE_OPERATION_COUNT + 26;

	/**
	 * The operation id for the '<em>Is Feature</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_FEATURE = ELEMENT_REFERENCE_OPERATION_COUNT + 27;

	/**
	 * The operation id for the '<em>Is Property</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_PROPERTY = ELEMENT_REFERENCE_OPERATION_COUNT + 28;

	/**
	 * The operation id for the '<em>Is Association End</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_ASSOCIATION_END = ELEMENT_REFERENCE_OPERATION_COUNT + 29;

	/**
	 * The operation id for the '<em>Is Parameter</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_PARAMETER = ELEMENT_REFERENCE_OPERATION_COUNT + 30;

	/**
	 * The operation id for the '<em>Is Template</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_TEMPLATE = ELEMENT_REFERENCE_OPERATION_COUNT + 31;

	/**
	 * The operation id for the '<em>Is Template Parameter</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_TEMPLATE_PARAMETER = ELEMENT_REFERENCE_OPERATION_COUNT + 32;

	/**
	 * The operation id for the '<em>Is Classifier Template Parameter</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_CLASSIFIER_TEMPLATE_PARAMETER = ELEMENT_REFERENCE_OPERATION_COUNT + 33;

	/**
	 * The operation id for the '<em>Is Parametered Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_PARAMETERED_ELEMENT = ELEMENT_REFERENCE_OPERATION_COUNT + 34;

	/**
	 * The operation id for the '<em>Is Template Binding</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_TEMPLATE_BINDING = ELEMENT_REFERENCE_OPERATION_COUNT + 35;

	/**
	 * The operation id for the '<em>Is Stereotype</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_STEREOTYPE = ELEMENT_REFERENCE_OPERATION_COUNT + 36;

	/**
	 * The operation id for the '<em>Is Enumeration Literal</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_ENUMERATION_LITERAL = ELEMENT_REFERENCE_OPERATION_COUNT + 37;

	/**
	 * The operation id for the '<em>Is Loop Variable</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_LOOP_VARIABLE = ELEMENT_REFERENCE_OPERATION_COUNT + 38;

	/**
	 * The operation id for the '<em>Is Annotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_ANNOTATION = ELEMENT_REFERENCE_OPERATION_COUNT + 39;

	/**
	 * The operation id for the '<em>Is Sequence Expansion Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_SEQUENCE_EXPANSION_EXPRESSION = ELEMENT_REFERENCE_OPERATION_COUNT + 40;

	/**
	 * The operation id for the '<em>Is Any Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_ANY_TYPE = ELEMENT_REFERENCE_OPERATION_COUNT + 41;

	/**
	 * The operation id for the '<em>Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___NAME = ELEMENT_REFERENCE_OPERATION_COUNT + 42;

	/**
	 * The operation id for the '<em>Visibility</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___VISIBILITY = ELEMENT_REFERENCE_OPERATION_COUNT + 43;

	/**
	 * The operation id for the '<em>Owned Members</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___OWNED_MEMBERS = ELEMENT_REFERENCE_OPERATION_COUNT + 44;

	/**
	 * The operation id for the '<em>Members</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___MEMBERS = ELEMENT_REFERENCE_OPERATION_COUNT + 45;

	/**
	 * The operation id for the '<em>Nested Classifiers</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___NESTED_CLASSIFIERS = ELEMENT_REFERENCE_OPERATION_COUNT + 46;

	/**
	 * The operation id for the '<em>Opposite</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___OPPOSITE = ELEMENT_REFERENCE_OPERATION_COUNT + 47;

	/**
	 * The operation id for the '<em>Signal</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___SIGNAL = ELEMENT_REFERENCE_OPERATION_COUNT + 48;

	/**
	 * The operation id for the '<em>Parameters</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___PARAMETERS = ELEMENT_REFERENCE_OPERATION_COUNT + 49;

	/**
	 * The operation id for the '<em>Return Parameter</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___RETURN_PARAMETER = ELEMENT_REFERENCE_OPERATION_COUNT + 50;

	/**
	 * The operation id for the '<em>Specification</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___SPECIFICATION = ELEMENT_REFERENCE_OPERATION_COUNT + 51;

	/**
	 * The operation id for the '<em>Redefined Operaions</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___REDEFINED_OPERAIONS = ELEMENT_REFERENCE_OPERATION_COUNT + 52;

	/**
	 * The operation id for the '<em>Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___NAMESPACE = ELEMENT_REFERENCE_OPERATION_COUNT + 53;

	/**
	 * The operation id for the '<em>Template</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___TEMPLATE = ELEMENT_REFERENCE_OPERATION_COUNT + 54;

	/**
	 * The operation id for the '<em>Template Parameters</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___TEMPLATE_PARAMETERS = ELEMENT_REFERENCE_OPERATION_COUNT + 55;

	/**
	 * The operation id for the '<em>Parametered Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___PARAMETERED_ELEMENTS = ELEMENT_REFERENCE_OPERATION_COUNT + 56;

	/**
	 * The operation id for the '<em>Template Actuals</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___TEMPLATE_ACTUALS = ELEMENT_REFERENCE_OPERATION_COUNT + 57;

	/**
	 * The operation id for the '<em>Direction</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___DIRECTION = ELEMENT_REFERENCE_OPERATION_COUNT + 58;

	/**
	 * The operation id for the '<em>Association</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___ASSOCIATION = ELEMENT_REFERENCE_OPERATION_COUNT + 59;

	/**
	 * The operation id for the '<em>Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___TYPE = ELEMENT_REFERENCE_OPERATION_COUNT + 60;

	/**
	 * The operation id for the '<em>Lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___LOWER = ELEMENT_REFERENCE_OPERATION_COUNT + 61;

	/**
	 * The operation id for the '<em>Upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___UPPER = ELEMENT_REFERENCE_OPERATION_COUNT + 62;

	/**
	 * The operation id for the '<em>Is Ordered</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_ORDERED = ELEMENT_REFERENCE_OPERATION_COUNT + 63;

	/**
	 * The operation id for the '<em>Is Nonunique</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___IS_NONUNIQUE = ELEMENT_REFERENCE_OPERATION_COUNT + 64;

	/**
	 * The operation id for the '<em>Parents</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___PARENTS = ELEMENT_REFERENCE_OPERATION_COUNT + 65;

	/**
	 * The operation id for the '<em>All Parents</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___ALL_PARENTS = ELEMENT_REFERENCE_OPERATION_COUNT + 66;

	/**
	 * The operation id for the '<em>Classifier Behavior</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___CLASSIFIER_BEHAVIOR = ELEMENT_REFERENCE_OPERATION_COUNT + 67;

	/**
	 * The operation id for the '<em>Applied Profiles</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___APPLIED_PROFILES = ELEMENT_REFERENCE_OPERATION_COUNT + 68;

	/**
	 * The operation id for the '<em>Active Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___ACTIVE_CLASS = ELEMENT_REFERENCE_OPERATION_COUNT + 69;

	/**
	 * The operation id for the '<em>Context</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___CONTEXT = ELEMENT_REFERENCE_OPERATION_COUNT + 70;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___CONFORMS_TO__ELEMENTREFERENCE = ELEMENT_REFERENCE_OPERATION_COUNT + 71;

	/**
	 * The operation id for the '<em>Equals</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___EQUALS__ELEMENTREFERENCE = ELEMENT_REFERENCE_OPERATION_COUNT + 72;

	/**
	 * The operation id for the '<em>Copy</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___COPY = ELEMENT_REFERENCE_OPERATION_COUNT + 73;

	/**
	 * The operation id for the '<em>Model Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___MODEL_SCOPE = ELEMENT_REFERENCE_OPERATION_COUNT + 74;

	/**
	 * The operation id for the '<em>Resolve Path Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___RESOLVE_PATH_NAME__STRING = ELEMENT_REFERENCE_OPERATION_COUNT + 75;

	/**
	 * The operation id for the '<em>Resolve In Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___RESOLVE_IN_SCOPE__STRING = ELEMENT_REFERENCE_OPERATION_COUNT + 76;

	/**
	 * The operation id for the '<em>Resolve Stereotype Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___RESOLVE_STEREOTYPE_NAME__STRING = ELEMENT_REFERENCE_OPERATION_COUNT + 77;

	/**
	 * The operation id for the '<em>Stub</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___STUB = ELEMENT_REFERENCE_OPERATION_COUNT + 78;

	/**
	 * The operation id for the '<em>Stub For</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE___STUB_FOR__UNITDEFINITION = ELEMENT_REFERENCE_OPERATION_COUNT + 79;

	/**
	 * The number of operations of the '<em>Internal Element Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_ELEMENT_REFERENCE_OPERATION_COUNT = ELEMENT_REFERENCE_OPERATION_COUNT + 80;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.ExternalElementReferenceImpl <em>External Element Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.ExternalElementReferenceImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getExternalElementReference()
	 * @generated
	 */
	int EXTERNAL_ELEMENT_REFERENCE = 4;

	/**
	 * The feature id for the '<em><b>Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE__ELEMENT = ELEMENT_REFERENCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Alias</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE__ALIAS = ELEMENT_REFERENCE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>External Element Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE_FEATURE_COUNT = ELEMENT_REFERENCE_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Is Alf</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_ALF = ELEMENT_REFERENCE___IS_ALF;

	/**
	 * The operation id for the '<em>As Alf</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___AS_ALF = ELEMENT_REFERENCE___AS_ALF;

	/**
	 * The operation id for the '<em>Is Any Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_ANY_TYPE = ELEMENT_REFERENCE___IS_ANY_TYPE;

	/**
	 * The operation id for the '<em>Is Distinguishable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_DISTINGUISHABLE_FROM__ELEMENTREFERENCE = ELEMENT_REFERENCE___IS_DISTINGUISHABLE_FROM__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT = ELEMENT_REFERENCE___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Collection Argument</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___COLLECTION_ARGUMENT = ELEMENT_REFERENCE___COLLECTION_ARGUMENT;

	/**
	 * The operation id for the '<em>Visible Members</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___VISIBLE_MEMBERS = ELEMENT_REFERENCE___VISIBLE_MEMBERS;

	/**
	 * The operation id for the '<em>Receptions</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___RECEPTIONS = ELEMENT_REFERENCE___RECEPTIONS;

	/**
	 * The operation id for the '<em>Base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___BASE = ELEMENT_REFERENCE___BASE;

	/**
	 * The operation id for the '<em>Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___REFERENCE = ELEMENT_REFERENCE___REFERENCE;

	/**
	 * The operation id for the '<em>Template Binding</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___TEMPLATE_BINDING = ELEMENT_REFERENCE___TEMPLATE_BINDING;

	/**
	 * The operation id for the '<em>Bind</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___BIND__ELIST = ELEMENT_REFERENCE___BIND__ELIST;

	/**
	 * The operation id for the '<em>Bound Element Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___BOUND_ELEMENT_NAME__ELIST = ELEMENT_REFERENCE___BOUND_ELEMENT_NAME__ELIST;

	/**
	 * The operation id for the '<em>Bound Path Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___BOUND_PATH_NAME = ELEMENT_REFERENCE___BOUND_PATH_NAME;

	/**
	 * The operation id for the '<em>Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___QUALIFIED_NAME = ELEMENT_REFERENCE___QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Is Active Behavior</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_ACTIVE_BEHAVIOR = ELEMENT_REFERENCE___IS_ACTIVE_BEHAVIOR;

	/**
	 * The operation id for the '<em>Contained In</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___CONTAINED_IN__ELIST = ELEMENT_REFERENCE___CONTAINED_IN__ELIST;

	/**
	 * The operation id for the '<em>Count In</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___COUNT_IN__ELIST = ELEMENT_REFERENCE___COUNT_IN__ELIST;

	/**
	 * The operation id for the '<em>Position In</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___POSITION_IN__ELIST = ELEMENT_REFERENCE___POSITION_IN__ELIST;

	/**
	 * The operation id for the '<em>Resolve</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___RESOLVE__STRING = ELEMENT_REFERENCE___RESOLVE__STRING;

	/**
	 * The operation id for the '<em>Resolve Visible</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___RESOLVE_VISIBLE__STRING_ELEMENTREFERENCE = ELEMENT_REFERENCE___RESOLVE_VISIBLE__STRING_ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Resolve Association End</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___RESOLVE_ASSOCIATION_END__ELEMENTREFERENCE_STRING = ELEMENT_REFERENCE___RESOLVE_ASSOCIATION_END__ELEMENTREFERENCE_STRING;

	/**
	 * The operation id for the '<em>Contains Member</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___CONTAINS_MEMBER__ELEMENTREFERENCE = ELEMENT_REFERENCE___CONTAINS_MEMBER__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Allow Package Only</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___ALLOW_PACKAGE_ONLY = ELEMENT_REFERENCE___ALLOW_PACKAGE_ONLY;

	/**
	 * The operation id for the '<em>Constructor Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___CONSTRUCTOR_REFERENCE = ELEMENT_REFERENCE___CONSTRUCTOR_REFERENCE;

	/**
	 * The operation id for the '<em>Is Uml</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_UML = ELEMENT_REFERENCE_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>As Uml</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___AS_UML = ELEMENT_REFERENCE_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>As Member</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___AS_MEMBER = ELEMENT_REFERENCE_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Is Same Kind As</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_SAME_KIND_AS__ELEMENTREFERENCE = ELEMENT_REFERENCE_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Is Named Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_NAMED_ELEMENT = ELEMENT_REFERENCE_OPERATION_COUNT + 4;

	/**
	 * The operation id for the '<em>Is Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_NAMESPACE = ELEMENT_REFERENCE_OPERATION_COUNT + 5;

	/**
	 * The operation id for the '<em>Is Namespace For</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_NAMESPACE_FOR__UNITDEFINITION = ELEMENT_REFERENCE_OPERATION_COUNT + 6;

	/**
	 * The operation id for the '<em>Is Model Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_MODEL_NAMESPACE = ELEMENT_REFERENCE_OPERATION_COUNT + 7;

	/**
	 * The operation id for the '<em>Is Package</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_PACKAGE = ELEMENT_REFERENCE_OPERATION_COUNT + 8;

	/**
	 * The operation id for the '<em>Is Profile</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_PROFILE = ELEMENT_REFERENCE_OPERATION_COUNT + 9;

	/**
	 * The operation id for the '<em>Is Packageable Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_PACKAGEABLE_ELEMENT = ELEMENT_REFERENCE_OPERATION_COUNT + 10;

	/**
	 * The operation id for the '<em>Is Classifier</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_CLASSIFIER = ELEMENT_REFERENCE_OPERATION_COUNT + 11;

	/**
	 * The operation id for the '<em>Is Abstract Classifier</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_ABSTRACT_CLASSIFIER = ELEMENT_REFERENCE_OPERATION_COUNT + 12;

	/**
	 * The operation id for the '<em>Is Association</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_ASSOCIATION = ELEMENT_REFERENCE_OPERATION_COUNT + 13;

	/**
	 * The operation id for the '<em>Is Data Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_DATA_TYPE = ELEMENT_REFERENCE_OPERATION_COUNT + 14;

	/**
	 * The operation id for the '<em>Is Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_CLASS = ELEMENT_REFERENCE_OPERATION_COUNT + 15;

	/**
	 * The operation id for the '<em>Is Active Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_ACTIVE_CLASS = ELEMENT_REFERENCE_OPERATION_COUNT + 16;

	/**
	 * The operation id for the '<em>Is Signal</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_SIGNAL = ELEMENT_REFERENCE_OPERATION_COUNT + 17;

	/**
	 * The operation id for the '<em>Is Enumeration</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_ENUMERATION = ELEMENT_REFERENCE_OPERATION_COUNT + 18;

	/**
	 * The operation id for the '<em>Is Behavior</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_BEHAVIOR = ELEMENT_REFERENCE_OPERATION_COUNT + 19;

	/**
	 * The operation id for the '<em>Is Activity</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_ACTIVITY = ELEMENT_REFERENCE_OPERATION_COUNT + 20;

	/**
	 * The operation id for the '<em>Is Method</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_METHOD = ELEMENT_REFERENCE_OPERATION_COUNT + 21;

	/**
	 * The operation id for the '<em>Is Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_PRIMITIVE_TYPE = ELEMENT_REFERENCE_OPERATION_COUNT + 22;

	/**
	 * The operation id for the '<em>Is Reception</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_RECEPTION = ELEMENT_REFERENCE_OPERATION_COUNT + 23;

	/**
	 * The operation id for the '<em>Is Operation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_OPERATION = ELEMENT_REFERENCE_OPERATION_COUNT + 24;

	/**
	 * The operation id for the '<em>Is Constructor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_CONSTRUCTOR = ELEMENT_REFERENCE_OPERATION_COUNT + 25;

	/**
	 * The operation id for the '<em>Is Destructor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_DESTRUCTOR = ELEMENT_REFERENCE_OPERATION_COUNT + 26;

	/**
	 * The operation id for the '<em>Is Feature</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_FEATURE = ELEMENT_REFERENCE_OPERATION_COUNT + 27;

	/**
	 * The operation id for the '<em>Is Property</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_PROPERTY = ELEMENT_REFERENCE_OPERATION_COUNT + 28;

	/**
	 * The operation id for the '<em>Is Association End</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_ASSOCIATION_END = ELEMENT_REFERENCE_OPERATION_COUNT + 29;

	/**
	 * The operation id for the '<em>Is Parameter</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_PARAMETER = ELEMENT_REFERENCE_OPERATION_COUNT + 30;

	/**
	 * The operation id for the '<em>Is Template</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_TEMPLATE = ELEMENT_REFERENCE_OPERATION_COUNT + 31;

	/**
	 * The operation id for the '<em>Is Template Parameter</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_TEMPLATE_PARAMETER = ELEMENT_REFERENCE_OPERATION_COUNT + 32;

	/**
	 * The operation id for the '<em>Is Classifier Template Parameter</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_CLASSIFIER_TEMPLATE_PARAMETER = ELEMENT_REFERENCE_OPERATION_COUNT + 33;

	/**
	 * The operation id for the '<em>Is Parametered Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_PARAMETERED_ELEMENT = ELEMENT_REFERENCE_OPERATION_COUNT + 34;

	/**
	 * The operation id for the '<em>Is Template Binding</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_TEMPLATE_BINDING = ELEMENT_REFERENCE_OPERATION_COUNT + 35;

	/**
	 * The operation id for the '<em>Is Stereotype</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_STEREOTYPE = ELEMENT_REFERENCE_OPERATION_COUNT + 36;

	/**
	 * The operation id for the '<em>Is Enumeration Literal</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_ENUMERATION_LITERAL = ELEMENT_REFERENCE_OPERATION_COUNT + 37;

	/**
	 * The operation id for the '<em>Is Loop Variable</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_LOOP_VARIABLE = ELEMENT_REFERENCE_OPERATION_COUNT + 38;

	/**
	 * The operation id for the '<em>Is Annotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_ANNOTATION = ELEMENT_REFERENCE_OPERATION_COUNT + 39;

	/**
	 * The operation id for the '<em>Is Sequence Expansion Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_SEQUENCE_EXPANSION_EXPRESSION = ELEMENT_REFERENCE_OPERATION_COUNT + 40;

	/**
	 * The operation id for the '<em>Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___NAME = ELEMENT_REFERENCE_OPERATION_COUNT + 41;

	/**
	 * The operation id for the '<em>Visibility</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___VISIBILITY = ELEMENT_REFERENCE_OPERATION_COUNT + 42;

	/**
	 * The operation id for the '<em>Owned Members</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___OWNED_MEMBERS = ELEMENT_REFERENCE_OPERATION_COUNT + 43;

	/**
	 * The operation id for the '<em>Enumeration Members</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___ENUMERATION_MEMBERS = ELEMENT_REFERENCE_OPERATION_COUNT + 44;

	/**
	 * The operation id for the '<em>Members</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___MEMBERS = ELEMENT_REFERENCE_OPERATION_COUNT + 45;

	/**
	 * The operation id for the '<em>Additional Members</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___ADDITIONAL_MEMBERS = ELEMENT_REFERENCE_OPERATION_COUNT + 46;

	/**
	 * The operation id for the '<em>Inherit</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___INHERIT__ELIST = ELEMENT_REFERENCE_OPERATION_COUNT + 47;

	/**
	 * The operation id for the '<em>Nested Classifiers</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___NESTED_CLASSIFIERS = ELEMENT_REFERENCE_OPERATION_COUNT + 48;

	/**
	 * The operation id for the '<em>Properties</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___PROPERTIES = ELEMENT_REFERENCE_OPERATION_COUNT + 49;

	/**
	 * The operation id for the '<em>Association Ends</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___ASSOCIATION_ENDS = ELEMENT_REFERENCE_OPERATION_COUNT + 50;

	/**
	 * The operation id for the '<em>Opposite</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___OPPOSITE = ELEMENT_REFERENCE_OPERATION_COUNT + 51;

	/**
	 * The operation id for the '<em>Signal</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___SIGNAL = ELEMENT_REFERENCE_OPERATION_COUNT + 52;

	/**
	 * The operation id for the '<em>Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___NAMESPACE = ELEMENT_REFERENCE_OPERATION_COUNT + 53;

	/**
	 * The operation id for the '<em>Owned Parameters</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___OWNED_PARAMETERS = ELEMENT_REFERENCE_OPERATION_COUNT + 54;

	/**
	 * The operation id for the '<em>Parameters</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___PARAMETERS = ELEMENT_REFERENCE_OPERATION_COUNT + 55;

	/**
	 * The operation id for the '<em>Return Parameter</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___RETURN_PARAMETER = ELEMENT_REFERENCE_OPERATION_COUNT + 56;

	/**
	 * The operation id for the '<em>Specification</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___SPECIFICATION = ELEMENT_REFERENCE_OPERATION_COUNT + 57;

	/**
	 * The operation id for the '<em>Redefined Operations</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___REDEFINED_OPERATIONS = ELEMENT_REFERENCE_OPERATION_COUNT + 58;

	/**
	 * The operation id for the '<em>Template</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___TEMPLATE = ELEMENT_REFERENCE_OPERATION_COUNT + 59;

	/**
	 * The operation id for the '<em>Uml Template Binding</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___UML_TEMPLATE_BINDING = ELEMENT_REFERENCE_OPERATION_COUNT + 60;

	/**
	 * The operation id for the '<em>Template Parameters</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___TEMPLATE_PARAMETERS = ELEMENT_REFERENCE_OPERATION_COUNT + 61;

	/**
	 * The operation id for the '<em>Parametered Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___PARAMETERED_ELEMENTS = ELEMENT_REFERENCE_OPERATION_COUNT + 62;

	/**
	 * The operation id for the '<em>Template Actuals</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___TEMPLATE_ACTUALS = ELEMENT_REFERENCE_OPERATION_COUNT + 63;

	/**
	 * The operation id for the '<em>Direction</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___DIRECTION = ELEMENT_REFERENCE_OPERATION_COUNT + 64;

	/**
	 * The operation id for the '<em>Association</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___ASSOCIATION = ELEMENT_REFERENCE_OPERATION_COUNT + 65;

	/**
	 * The operation id for the '<em>Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___TYPE = ELEMENT_REFERENCE_OPERATION_COUNT + 66;

	/**
	 * The operation id for the '<em>Lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___LOWER = ELEMENT_REFERENCE_OPERATION_COUNT + 67;

	/**
	 * The operation id for the '<em>Upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___UPPER = ELEMENT_REFERENCE_OPERATION_COUNT + 68;

	/**
	 * The operation id for the '<em>Is Ordered</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_ORDERED = ELEMENT_REFERENCE_OPERATION_COUNT + 69;

	/**
	 * The operation id for the '<em>Is Nonunique</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___IS_NONUNIQUE = ELEMENT_REFERENCE_OPERATION_COUNT + 70;

	/**
	 * The operation id for the '<em>Parents</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___PARENTS = ELEMENT_REFERENCE_OPERATION_COUNT + 71;

	/**
	 * The operation id for the '<em>All Parents</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___ALL_PARENTS = ELEMENT_REFERENCE_OPERATION_COUNT + 72;

	/**
	 * The operation id for the '<em>Classifier Behavior</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___CLASSIFIER_BEHAVIOR = ELEMENT_REFERENCE_OPERATION_COUNT + 73;

	/**
	 * The operation id for the '<em>Applied Profiles</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___APPLIED_PROFILES = ELEMENT_REFERENCE_OPERATION_COUNT + 74;

	/**
	 * The operation id for the '<em>Active Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___ACTIVE_CLASS = ELEMENT_REFERENCE_OPERATION_COUNT + 75;

	/**
	 * The operation id for the '<em>Context</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___CONTEXT = ELEMENT_REFERENCE_OPERATION_COUNT + 76;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___CONFORMS_TO__ELEMENTREFERENCE = ELEMENT_REFERENCE_OPERATION_COUNT + 77;

	/**
	 * The operation id for the '<em>Equals</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___EQUALS__ELEMENTREFERENCE = ELEMENT_REFERENCE_OPERATION_COUNT + 78;

	/**
	 * The operation id for the '<em>Copy</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___COPY = ELEMENT_REFERENCE_OPERATION_COUNT + 79;

	/**
	 * The operation id for the '<em>Model Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___MODEL_SCOPE = ELEMENT_REFERENCE_OPERATION_COUNT + 80;

	/**
	 * The operation id for the '<em>Resolve Path Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___RESOLVE_PATH_NAME__STRING = ELEMENT_REFERENCE_OPERATION_COUNT + 81;

	/**
	 * The operation id for the '<em>External Element Reference resolve Path Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___EXTERNAL_ELEMENT_REFERENCE_RESOLVE_PATH_NAME__STRING = ELEMENT_REFERENCE_OPERATION_COUNT + 82;

	/**
	 * The operation id for the '<em>Resolve In Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___RESOLVE_IN_SCOPE__STRING = ELEMENT_REFERENCE_OPERATION_COUNT + 83;

	/**
	 * The operation id for the '<em>Resolve Stereotype</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___RESOLVE_STEREOTYPE__STRING = ELEMENT_REFERENCE_OPERATION_COUNT + 84;

	/**
	 * The operation id for the '<em>Stub</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___STUB = ELEMENT_REFERENCE_OPERATION_COUNT + 85;

	/**
	 * The operation id for the '<em>Stub For</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE___STUB_FOR__UNITDEFINITION = ELEMENT_REFERENCE_OPERATION_COUNT + 86;

	/**
	 * The number of operations of the '<em>External Element Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ELEMENT_REFERENCE_OPERATION_COUNT = ELEMENT_REFERENCE_OPERATION_COUNT + 87;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.ExternalEnumerationLiteralReferenceImpl <em>External Enumeration Literal Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.ExternalEnumerationLiteralReferenceImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getExternalEnumerationLiteralReference()
	 * @generated
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE = 5;

	/**
	 * The feature id for the '<em><b>Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE__ELEMENT = EXTERNAL_ELEMENT_REFERENCE__ELEMENT;

	/**
	 * The feature id for the '<em><b>Alias</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE__ALIAS = EXTERNAL_ELEMENT_REFERENCE__ALIAS;

	/**
	 * The number of structural features of the '<em>External Enumeration Literal Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE_FEATURE_COUNT = EXTERNAL_ELEMENT_REFERENCE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Is Alf</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_ALF = EXTERNAL_ELEMENT_REFERENCE___IS_ALF;

	/**
	 * The operation id for the '<em>As Alf</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___AS_ALF = EXTERNAL_ELEMENT_REFERENCE___AS_ALF;

	/**
	 * The operation id for the '<em>Is Any Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_ANY_TYPE = EXTERNAL_ELEMENT_REFERENCE___IS_ANY_TYPE;

	/**
	 * The operation id for the '<em>Is Distinguishable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_DISTINGUISHABLE_FROM__ELEMENTREFERENCE = EXTERNAL_ELEMENT_REFERENCE___IS_DISTINGUISHABLE_FROM__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT = EXTERNAL_ELEMENT_REFERENCE___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Collection Argument</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___COLLECTION_ARGUMENT = EXTERNAL_ELEMENT_REFERENCE___COLLECTION_ARGUMENT;

	/**
	 * The operation id for the '<em>Visible Members</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___VISIBLE_MEMBERS = EXTERNAL_ELEMENT_REFERENCE___VISIBLE_MEMBERS;

	/**
	 * The operation id for the '<em>Receptions</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___RECEPTIONS = EXTERNAL_ELEMENT_REFERENCE___RECEPTIONS;

	/**
	 * The operation id for the '<em>Base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___BASE = EXTERNAL_ELEMENT_REFERENCE___BASE;

	/**
	 * The operation id for the '<em>Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___REFERENCE = EXTERNAL_ELEMENT_REFERENCE___REFERENCE;

	/**
	 * The operation id for the '<em>Template Binding</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___TEMPLATE_BINDING = EXTERNAL_ELEMENT_REFERENCE___TEMPLATE_BINDING;

	/**
	 * The operation id for the '<em>Bind</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___BIND__ELIST = EXTERNAL_ELEMENT_REFERENCE___BIND__ELIST;

	/**
	 * The operation id for the '<em>Bound Element Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___BOUND_ELEMENT_NAME__ELIST = EXTERNAL_ELEMENT_REFERENCE___BOUND_ELEMENT_NAME__ELIST;

	/**
	 * The operation id for the '<em>Bound Path Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___BOUND_PATH_NAME = EXTERNAL_ELEMENT_REFERENCE___BOUND_PATH_NAME;

	/**
	 * The operation id for the '<em>Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___QUALIFIED_NAME = EXTERNAL_ELEMENT_REFERENCE___QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Is Active Behavior</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_ACTIVE_BEHAVIOR = EXTERNAL_ELEMENT_REFERENCE___IS_ACTIVE_BEHAVIOR;

	/**
	 * The operation id for the '<em>Contained In</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___CONTAINED_IN__ELIST = EXTERNAL_ELEMENT_REFERENCE___CONTAINED_IN__ELIST;

	/**
	 * The operation id for the '<em>Count In</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___COUNT_IN__ELIST = EXTERNAL_ELEMENT_REFERENCE___COUNT_IN__ELIST;

	/**
	 * The operation id for the '<em>Position In</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___POSITION_IN__ELIST = EXTERNAL_ELEMENT_REFERENCE___POSITION_IN__ELIST;

	/**
	 * The operation id for the '<em>Resolve</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___RESOLVE__STRING = EXTERNAL_ELEMENT_REFERENCE___RESOLVE__STRING;

	/**
	 * The operation id for the '<em>Resolve Visible</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___RESOLVE_VISIBLE__STRING_ELEMENTREFERENCE = EXTERNAL_ELEMENT_REFERENCE___RESOLVE_VISIBLE__STRING_ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Resolve Association End</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___RESOLVE_ASSOCIATION_END__ELEMENTREFERENCE_STRING = EXTERNAL_ELEMENT_REFERENCE___RESOLVE_ASSOCIATION_END__ELEMENTREFERENCE_STRING;

	/**
	 * The operation id for the '<em>Contains Member</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___CONTAINS_MEMBER__ELEMENTREFERENCE = EXTERNAL_ELEMENT_REFERENCE___CONTAINS_MEMBER__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Allow Package Only</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___ALLOW_PACKAGE_ONLY = EXTERNAL_ELEMENT_REFERENCE___ALLOW_PACKAGE_ONLY;

	/**
	 * The operation id for the '<em>Constructor Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___CONSTRUCTOR_REFERENCE = EXTERNAL_ELEMENT_REFERENCE___CONSTRUCTOR_REFERENCE;

	/**
	 * The operation id for the '<em>Is Uml</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_UML = EXTERNAL_ELEMENT_REFERENCE___IS_UML;

	/**
	 * The operation id for the '<em>As Uml</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___AS_UML = EXTERNAL_ELEMENT_REFERENCE___AS_UML;

	/**
	 * The operation id for the '<em>As Member</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___AS_MEMBER = EXTERNAL_ELEMENT_REFERENCE___AS_MEMBER;

	/**
	 * The operation id for the '<em>Is Same Kind As</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_SAME_KIND_AS__ELEMENTREFERENCE = EXTERNAL_ELEMENT_REFERENCE___IS_SAME_KIND_AS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Named Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_NAMED_ELEMENT = EXTERNAL_ELEMENT_REFERENCE___IS_NAMED_ELEMENT;

	/**
	 * The operation id for the '<em>Is Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_NAMESPACE = EXTERNAL_ELEMENT_REFERENCE___IS_NAMESPACE;

	/**
	 * The operation id for the '<em>Is Namespace For</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_NAMESPACE_FOR__UNITDEFINITION = EXTERNAL_ELEMENT_REFERENCE___IS_NAMESPACE_FOR__UNITDEFINITION;

	/**
	 * The operation id for the '<em>Is Model Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_MODEL_NAMESPACE = EXTERNAL_ELEMENT_REFERENCE___IS_MODEL_NAMESPACE;

	/**
	 * The operation id for the '<em>Is Package</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_PACKAGE = EXTERNAL_ELEMENT_REFERENCE___IS_PACKAGE;

	/**
	 * The operation id for the '<em>Is Profile</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_PROFILE = EXTERNAL_ELEMENT_REFERENCE___IS_PROFILE;

	/**
	 * The operation id for the '<em>Is Packageable Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_PACKAGEABLE_ELEMENT = EXTERNAL_ELEMENT_REFERENCE___IS_PACKAGEABLE_ELEMENT;

	/**
	 * The operation id for the '<em>Is Abstract Classifier</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_ABSTRACT_CLASSIFIER = EXTERNAL_ELEMENT_REFERENCE___IS_ABSTRACT_CLASSIFIER;

	/**
	 * The operation id for the '<em>Is Association</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_ASSOCIATION = EXTERNAL_ELEMENT_REFERENCE___IS_ASSOCIATION;

	/**
	 * The operation id for the '<em>Is Data Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_DATA_TYPE = EXTERNAL_ELEMENT_REFERENCE___IS_DATA_TYPE;

	/**
	 * The operation id for the '<em>Is Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_CLASS = EXTERNAL_ELEMENT_REFERENCE___IS_CLASS;

	/**
	 * The operation id for the '<em>Is Active Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_ACTIVE_CLASS = EXTERNAL_ELEMENT_REFERENCE___IS_ACTIVE_CLASS;

	/**
	 * The operation id for the '<em>Is Signal</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_SIGNAL = EXTERNAL_ELEMENT_REFERENCE___IS_SIGNAL;

	/**
	 * The operation id for the '<em>Is Enumeration</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_ENUMERATION = EXTERNAL_ELEMENT_REFERENCE___IS_ENUMERATION;

	/**
	 * The operation id for the '<em>Is Behavior</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_BEHAVIOR = EXTERNAL_ELEMENT_REFERENCE___IS_BEHAVIOR;

	/**
	 * The operation id for the '<em>Is Activity</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_ACTIVITY = EXTERNAL_ELEMENT_REFERENCE___IS_ACTIVITY;

	/**
	 * The operation id for the '<em>Is Method</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_METHOD = EXTERNAL_ELEMENT_REFERENCE___IS_METHOD;

	/**
	 * The operation id for the '<em>Is Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_PRIMITIVE_TYPE = EXTERNAL_ELEMENT_REFERENCE___IS_PRIMITIVE_TYPE;

	/**
	 * The operation id for the '<em>Is Reception</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_RECEPTION = EXTERNAL_ELEMENT_REFERENCE___IS_RECEPTION;

	/**
	 * The operation id for the '<em>Is Operation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_OPERATION = EXTERNAL_ELEMENT_REFERENCE___IS_OPERATION;

	/**
	 * The operation id for the '<em>Is Constructor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_CONSTRUCTOR = EXTERNAL_ELEMENT_REFERENCE___IS_CONSTRUCTOR;

	/**
	 * The operation id for the '<em>Is Destructor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_DESTRUCTOR = EXTERNAL_ELEMENT_REFERENCE___IS_DESTRUCTOR;

	/**
	 * The operation id for the '<em>Is Feature</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_FEATURE = EXTERNAL_ELEMENT_REFERENCE___IS_FEATURE;

	/**
	 * The operation id for the '<em>Is Property</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_PROPERTY = EXTERNAL_ELEMENT_REFERENCE___IS_PROPERTY;

	/**
	 * The operation id for the '<em>Is Association End</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_ASSOCIATION_END = EXTERNAL_ELEMENT_REFERENCE___IS_ASSOCIATION_END;

	/**
	 * The operation id for the '<em>Is Template</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_TEMPLATE = EXTERNAL_ELEMENT_REFERENCE___IS_TEMPLATE;

	/**
	 * The operation id for the '<em>Is Template Parameter</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_TEMPLATE_PARAMETER = EXTERNAL_ELEMENT_REFERENCE___IS_TEMPLATE_PARAMETER;

	/**
	 * The operation id for the '<em>Is Classifier Template Parameter</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_CLASSIFIER_TEMPLATE_PARAMETER = EXTERNAL_ELEMENT_REFERENCE___IS_CLASSIFIER_TEMPLATE_PARAMETER;

	/**
	 * The operation id for the '<em>Is Parametered Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_PARAMETERED_ELEMENT = EXTERNAL_ELEMENT_REFERENCE___IS_PARAMETERED_ELEMENT;

	/**
	 * The operation id for the '<em>Is Template Binding</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_TEMPLATE_BINDING = EXTERNAL_ELEMENT_REFERENCE___IS_TEMPLATE_BINDING;

	/**
	 * The operation id for the '<em>Is Stereotype</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_STEREOTYPE = EXTERNAL_ELEMENT_REFERENCE___IS_STEREOTYPE;

	/**
	 * The operation id for the '<em>Is Loop Variable</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_LOOP_VARIABLE = EXTERNAL_ELEMENT_REFERENCE___IS_LOOP_VARIABLE;

	/**
	 * The operation id for the '<em>Is Annotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_ANNOTATION = EXTERNAL_ELEMENT_REFERENCE___IS_ANNOTATION;

	/**
	 * The operation id for the '<em>Is Sequence Expansion Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_SEQUENCE_EXPANSION_EXPRESSION = EXTERNAL_ELEMENT_REFERENCE___IS_SEQUENCE_EXPANSION_EXPRESSION;

	/**
	 * The operation id for the '<em>Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___NAME = EXTERNAL_ELEMENT_REFERENCE___NAME;

	/**
	 * The operation id for the '<em>Owned Members</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___OWNED_MEMBERS = EXTERNAL_ELEMENT_REFERENCE___OWNED_MEMBERS;

	/**
	 * The operation id for the '<em>Enumeration Members</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___ENUMERATION_MEMBERS = EXTERNAL_ELEMENT_REFERENCE___ENUMERATION_MEMBERS;

	/**
	 * The operation id for the '<em>Members</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___MEMBERS = EXTERNAL_ELEMENT_REFERENCE___MEMBERS;

	/**
	 * The operation id for the '<em>Additional Members</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___ADDITIONAL_MEMBERS = EXTERNAL_ELEMENT_REFERENCE___ADDITIONAL_MEMBERS;

	/**
	 * The operation id for the '<em>Inherit</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___INHERIT__ELIST = EXTERNAL_ELEMENT_REFERENCE___INHERIT__ELIST;

	/**
	 * The operation id for the '<em>Nested Classifiers</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___NESTED_CLASSIFIERS = EXTERNAL_ELEMENT_REFERENCE___NESTED_CLASSIFIERS;

	/**
	 * The operation id for the '<em>Properties</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___PROPERTIES = EXTERNAL_ELEMENT_REFERENCE___PROPERTIES;

	/**
	 * The operation id for the '<em>Association Ends</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___ASSOCIATION_ENDS = EXTERNAL_ELEMENT_REFERENCE___ASSOCIATION_ENDS;

	/**
	 * The operation id for the '<em>Opposite</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___OPPOSITE = EXTERNAL_ELEMENT_REFERENCE___OPPOSITE;

	/**
	 * The operation id for the '<em>Signal</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___SIGNAL = EXTERNAL_ELEMENT_REFERENCE___SIGNAL;

	/**
	 * The operation id for the '<em>Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___NAMESPACE = EXTERNAL_ELEMENT_REFERENCE___NAMESPACE;

	/**
	 * The operation id for the '<em>Owned Parameters</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___OWNED_PARAMETERS = EXTERNAL_ELEMENT_REFERENCE___OWNED_PARAMETERS;

	/**
	 * The operation id for the '<em>Parameters</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___PARAMETERS = EXTERNAL_ELEMENT_REFERENCE___PARAMETERS;

	/**
	 * The operation id for the '<em>Return Parameter</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___RETURN_PARAMETER = EXTERNAL_ELEMENT_REFERENCE___RETURN_PARAMETER;

	/**
	 * The operation id for the '<em>Specification</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___SPECIFICATION = EXTERNAL_ELEMENT_REFERENCE___SPECIFICATION;

	/**
	 * The operation id for the '<em>Redefined Operations</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___REDEFINED_OPERATIONS = EXTERNAL_ELEMENT_REFERENCE___REDEFINED_OPERATIONS;

	/**
	 * The operation id for the '<em>Template</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___TEMPLATE = EXTERNAL_ELEMENT_REFERENCE___TEMPLATE;

	/**
	 * The operation id for the '<em>Uml Template Binding</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___UML_TEMPLATE_BINDING = EXTERNAL_ELEMENT_REFERENCE___UML_TEMPLATE_BINDING;

	/**
	 * The operation id for the '<em>Template Parameters</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___TEMPLATE_PARAMETERS = EXTERNAL_ELEMENT_REFERENCE___TEMPLATE_PARAMETERS;

	/**
	 * The operation id for the '<em>Parametered Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___PARAMETERED_ELEMENTS = EXTERNAL_ELEMENT_REFERENCE___PARAMETERED_ELEMENTS;

	/**
	 * The operation id for the '<em>Template Actuals</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___TEMPLATE_ACTUALS = EXTERNAL_ELEMENT_REFERENCE___TEMPLATE_ACTUALS;

	/**
	 * The operation id for the '<em>Direction</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___DIRECTION = EXTERNAL_ELEMENT_REFERENCE___DIRECTION;

	/**
	 * The operation id for the '<em>Association</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___ASSOCIATION = EXTERNAL_ELEMENT_REFERENCE___ASSOCIATION;

	/**
	 * The operation id for the '<em>Lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___LOWER = EXTERNAL_ELEMENT_REFERENCE___LOWER;

	/**
	 * The operation id for the '<em>Upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___UPPER = EXTERNAL_ELEMENT_REFERENCE___UPPER;

	/**
	 * The operation id for the '<em>Is Ordered</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_ORDERED = EXTERNAL_ELEMENT_REFERENCE___IS_ORDERED;

	/**
	 * The operation id for the '<em>Is Nonunique</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_NONUNIQUE = EXTERNAL_ELEMENT_REFERENCE___IS_NONUNIQUE;

	/**
	 * The operation id for the '<em>Parents</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___PARENTS = EXTERNAL_ELEMENT_REFERENCE___PARENTS;

	/**
	 * The operation id for the '<em>All Parents</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___ALL_PARENTS = EXTERNAL_ELEMENT_REFERENCE___ALL_PARENTS;

	/**
	 * The operation id for the '<em>Classifier Behavior</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___CLASSIFIER_BEHAVIOR = EXTERNAL_ELEMENT_REFERENCE___CLASSIFIER_BEHAVIOR;

	/**
	 * The operation id for the '<em>Applied Profiles</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___APPLIED_PROFILES = EXTERNAL_ELEMENT_REFERENCE___APPLIED_PROFILES;

	/**
	 * The operation id for the '<em>Active Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___ACTIVE_CLASS = EXTERNAL_ELEMENT_REFERENCE___ACTIVE_CLASS;

	/**
	 * The operation id for the '<em>Context</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___CONTEXT = EXTERNAL_ELEMENT_REFERENCE___CONTEXT;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___CONFORMS_TO__ELEMENTREFERENCE = EXTERNAL_ELEMENT_REFERENCE___CONFORMS_TO__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Equals</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___EQUALS__ELEMENTREFERENCE = EXTERNAL_ELEMENT_REFERENCE___EQUALS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Copy</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___COPY = EXTERNAL_ELEMENT_REFERENCE___COPY;

	/**
	 * The operation id for the '<em>Model Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___MODEL_SCOPE = EXTERNAL_ELEMENT_REFERENCE___MODEL_SCOPE;

	/**
	 * The operation id for the '<em>Resolve Path Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___RESOLVE_PATH_NAME__STRING = EXTERNAL_ELEMENT_REFERENCE___RESOLVE_PATH_NAME__STRING;

	/**
	 * The operation id for the '<em>External Element Reference resolve Path Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___EXTERNAL_ELEMENT_REFERENCE_RESOLVE_PATH_NAME__STRING = EXTERNAL_ELEMENT_REFERENCE___EXTERNAL_ELEMENT_REFERENCE_RESOLVE_PATH_NAME__STRING;

	/**
	 * The operation id for the '<em>Resolve In Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___RESOLVE_IN_SCOPE__STRING = EXTERNAL_ELEMENT_REFERENCE___RESOLVE_IN_SCOPE__STRING;

	/**
	 * The operation id for the '<em>Resolve Stereotype</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___RESOLVE_STEREOTYPE__STRING = EXTERNAL_ELEMENT_REFERENCE___RESOLVE_STEREOTYPE__STRING;

	/**
	 * The operation id for the '<em>Stub</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___STUB = EXTERNAL_ELEMENT_REFERENCE___STUB;

	/**
	 * The operation id for the '<em>Stub For</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___STUB_FOR__UNITDEFINITION = EXTERNAL_ELEMENT_REFERENCE___STUB_FOR__UNITDEFINITION;

	/**
	 * The operation id for the '<em>Is Named Eement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_NAMED_EEMENT = EXTERNAL_ELEMENT_REFERENCE_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Is Classifier</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_CLASSIFIER = EXTERNAL_ELEMENT_REFERENCE_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Is Parameter</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_PARAMETER = EXTERNAL_ELEMENT_REFERENCE_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Is Enumeration Literal</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___IS_ENUMERATION_LITERAL = EXTERNAL_ELEMENT_REFERENCE_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>External Enumeration Literal Reference visibility</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___EXTERNAL_ENUMERATION_LITERAL_REFERENCE_VISIBILITY = EXTERNAL_ELEMENT_REFERENCE_OPERATION_COUNT + 4;

	/**
	 * The operation id for the '<em>Visibility</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___VISIBILITY = EXTERNAL_ELEMENT_REFERENCE_OPERATION_COUNT + 5;

	/**
	 * The operation id for the '<em>External Enumeration Literal Reference type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___EXTERNAL_ENUMERATION_LITERAL_REFERENCE_TYPE = EXTERNAL_ELEMENT_REFERENCE_OPERATION_COUNT + 6;

	/**
	 * The operation id for the '<em>Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE___TYPE = EXTERNAL_ELEMENT_REFERENCE_OPERATION_COUNT + 7;

	/**
	 * The number of operations of the '<em>External Enumeration Literal Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ENUMERATION_LITERAL_REFERENCE_OPERATION_COUNT = EXTERNAL_ELEMENT_REFERENCE_OPERATION_COUNT + 8;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.BoundElementReferenceImpl <em>Bound Element Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.BoundElementReferenceImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getBoundElementReference()
	 * @generated
	 */
	int BOUND_ELEMENT_REFERENCE = 6;

	/**
	 * The feature id for the '<em><b>Referent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE__REFERENT = ELEMENT_REFERENCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Namespace</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE__NAMESPACE = ELEMENT_REFERENCE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Template Binding</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE__TEMPLATE_BINDING = ELEMENT_REFERENCE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Bound Element Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE_FEATURE_COUNT = ELEMENT_REFERENCE_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Is Any Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_ANY_TYPE = ELEMENT_REFERENCE___IS_ANY_TYPE;

	/**
	 * The operation id for the '<em>Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT = ELEMENT_REFERENCE___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Collection Argument</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___COLLECTION_ARGUMENT = ELEMENT_REFERENCE___COLLECTION_ARGUMENT;

	/**
	 * The operation id for the '<em>Visible Members</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___VISIBLE_MEMBERS = ELEMENT_REFERENCE___VISIBLE_MEMBERS;

	/**
	 * The operation id for the '<em>Receptions</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___RECEPTIONS = ELEMENT_REFERENCE___RECEPTIONS;

	/**
	 * The operation id for the '<em>Base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___BASE = ELEMENT_REFERENCE___BASE;

	/**
	 * The operation id for the '<em>Bind</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___BIND__ELIST = ELEMENT_REFERENCE___BIND__ELIST;

	/**
	 * The operation id for the '<em>Bound Element Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___BOUND_ELEMENT_NAME__ELIST = ELEMENT_REFERENCE___BOUND_ELEMENT_NAME__ELIST;

	/**
	 * The operation id for the '<em>Bound Path Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___BOUND_PATH_NAME = ELEMENT_REFERENCE___BOUND_PATH_NAME;

	/**
	 * The operation id for the '<em>Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___QUALIFIED_NAME = ELEMENT_REFERENCE___QUALIFIED_NAME;

	/**
	 * The operation id for the '<em>Contained In</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___CONTAINED_IN__ELIST = ELEMENT_REFERENCE___CONTAINED_IN__ELIST;

	/**
	 * The operation id for the '<em>Count In</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___COUNT_IN__ELIST = ELEMENT_REFERENCE___COUNT_IN__ELIST;

	/**
	 * The operation id for the '<em>Position In</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___POSITION_IN__ELIST = ELEMENT_REFERENCE___POSITION_IN__ELIST;

	/**
	 * The operation id for the '<em>Resolve</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___RESOLVE__STRING = ELEMENT_REFERENCE___RESOLVE__STRING;

	/**
	 * The operation id for the '<em>Resolve Visible</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___RESOLVE_VISIBLE__STRING_ELEMENTREFERENCE = ELEMENT_REFERENCE___RESOLVE_VISIBLE__STRING_ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Resolve Association End</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___RESOLVE_ASSOCIATION_END__ELEMENTREFERENCE_STRING = ELEMENT_REFERENCE___RESOLVE_ASSOCIATION_END__ELEMENTREFERENCE_STRING;

	/**
	 * The operation id for the '<em>Contains Member</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___CONTAINS_MEMBER__ELEMENTREFERENCE = ELEMENT_REFERENCE___CONTAINS_MEMBER__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Allow Package Only</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___ALLOW_PACKAGE_ONLY = ELEMENT_REFERENCE___ALLOW_PACKAGE_ONLY;

	/**
	 * The operation id for the '<em>Constructor Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___CONSTRUCTOR_REFERENCE = ELEMENT_REFERENCE___CONSTRUCTOR_REFERENCE;

	/**
	 * The operation id for the '<em>Is Uml</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_UML = ELEMENT_REFERENCE_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Is Alf</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_ALF = ELEMENT_REFERENCE_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>As Uml</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___AS_UML = ELEMENT_REFERENCE_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>As Alf</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___AS_ALF = ELEMENT_REFERENCE_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>As Member</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___AS_MEMBER = ELEMENT_REFERENCE_OPERATION_COUNT + 4;

	/**
	 * The operation id for the '<em>Is Same Kind As</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_SAME_KIND_AS__ELEMENTREFERENCE = ELEMENT_REFERENCE_OPERATION_COUNT + 5;

	/**
	 * The operation id for the '<em>Is Named Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_NAMED_ELEMENT = ELEMENT_REFERENCE_OPERATION_COUNT + 6;

	/**
	 * The operation id for the '<em>Is Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_NAMESPACE = ELEMENT_REFERENCE_OPERATION_COUNT + 7;

	/**
	 * The operation id for the '<em>Is Namespace For</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_NAMESPACE_FOR__UNITDEFINITION = ELEMENT_REFERENCE_OPERATION_COUNT + 8;

	/**
	 * The operation id for the '<em>Is Model Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_MODEL_NAMESPACE = ELEMENT_REFERENCE_OPERATION_COUNT + 9;

	/**
	 * The operation id for the '<em>Is Package</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_PACKAGE = ELEMENT_REFERENCE_OPERATION_COUNT + 10;

	/**
	 * The operation id for the '<em>Is Profile</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_PROFILE = ELEMENT_REFERENCE_OPERATION_COUNT + 11;

	/**
	 * The operation id for the '<em>Is Packageable Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_PACKAGEABLE_ELEMENT = ELEMENT_REFERENCE_OPERATION_COUNT + 12;

	/**
	 * The operation id for the '<em>Is Classifier</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_CLASSIFIER = ELEMENT_REFERENCE_OPERATION_COUNT + 13;

	/**
	 * The operation id for the '<em>Is Abstract Classifier</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_ABSTRACT_CLASSIFIER = ELEMENT_REFERENCE_OPERATION_COUNT + 14;

	/**
	 * The operation id for the '<em>Is Association</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_ASSOCIATION = ELEMENT_REFERENCE_OPERATION_COUNT + 15;

	/**
	 * The operation id for the '<em>Is Data Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_DATA_TYPE = ELEMENT_REFERENCE_OPERATION_COUNT + 16;

	/**
	 * The operation id for the '<em>Is Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_CLASS = ELEMENT_REFERENCE_OPERATION_COUNT + 17;

	/**
	 * The operation id for the '<em>Is Active Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_ACTIVE_CLASS = ELEMENT_REFERENCE_OPERATION_COUNT + 18;

	/**
	 * The operation id for the '<em>Is Signal</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_SIGNAL = ELEMENT_REFERENCE_OPERATION_COUNT + 19;

	/**
	 * The operation id for the '<em>Is Enumeration</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_ENUMERATION = ELEMENT_REFERENCE_OPERATION_COUNT + 20;

	/**
	 * The operation id for the '<em>Is Behavior</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_BEHAVIOR = ELEMENT_REFERENCE_OPERATION_COUNT + 21;

	/**
	 * The operation id for the '<em>Is Activity</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_ACTIVITY = ELEMENT_REFERENCE_OPERATION_COUNT + 22;

	/**
	 * The operation id for the '<em>Is Method</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_METHOD = ELEMENT_REFERENCE_OPERATION_COUNT + 23;

	/**
	 * The operation id for the '<em>Is Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_PRIMITIVE_TYPE = ELEMENT_REFERENCE_OPERATION_COUNT + 24;

	/**
	 * The operation id for the '<em>Is Reception</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_RECEPTION = ELEMENT_REFERENCE_OPERATION_COUNT + 25;

	/**
	 * The operation id for the '<em>Is Operation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_OPERATION = ELEMENT_REFERENCE_OPERATION_COUNT + 26;

	/**
	 * The operation id for the '<em>Is Constructor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_CONSTRUCTOR = ELEMENT_REFERENCE_OPERATION_COUNT + 27;

	/**
	 * The operation id for the '<em>Is Destructor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_DESTRUCTOR = ELEMENT_REFERENCE_OPERATION_COUNT + 28;

	/**
	 * The operation id for the '<em>Is Feature</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_FEATURE = ELEMENT_REFERENCE_OPERATION_COUNT + 29;

	/**
	 * The operation id for the '<em>Is Property</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_PROPERTY = ELEMENT_REFERENCE_OPERATION_COUNT + 30;

	/**
	 * The operation id for the '<em>Is Association End</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_ASSOCIATION_END = ELEMENT_REFERENCE_OPERATION_COUNT + 31;

	/**
	 * The operation id for the '<em>Is Parameter</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_PARAMETER = ELEMENT_REFERENCE_OPERATION_COUNT + 32;

	/**
	 * The operation id for the '<em>Is Template</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_TEMPLATE = ELEMENT_REFERENCE_OPERATION_COUNT + 33;

	/**
	 * The operation id for the '<em>Is Template Parameter</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_TEMPLATE_PARAMETER = ELEMENT_REFERENCE_OPERATION_COUNT + 34;

	/**
	 * The operation id for the '<em>Is Classifier Template Parameter</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_CLASSIFIER_TEMPLATE_PARAMETER = ELEMENT_REFERENCE_OPERATION_COUNT + 35;

	/**
	 * The operation id for the '<em>Is Parametered Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_PARAMETERED_ELEMENT = ELEMENT_REFERENCE_OPERATION_COUNT + 36;

	/**
	 * The operation id for the '<em>Is Stereotype</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_STEREOTYPE = ELEMENT_REFERENCE_OPERATION_COUNT + 37;

	/**
	 * The operation id for the '<em>Is Enumeration Literal</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_ENUMERATION_LITERAL = ELEMENT_REFERENCE_OPERATION_COUNT + 38;

	/**
	 * The operation id for the '<em>Is Loop Variable</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_LOOP_VARIABLE = ELEMENT_REFERENCE_OPERATION_COUNT + 39;

	/**
	 * The operation id for the '<em>Is Annotation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_ANNOTATION = ELEMENT_REFERENCE_OPERATION_COUNT + 40;

	/**
	 * The operation id for the '<em>Is Sequence Expansion Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_SEQUENCE_EXPANSION_EXPRESSION = ELEMENT_REFERENCE_OPERATION_COUNT + 41;

	/**
	 * The operation id for the '<em>Is Distinguishable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_DISTINGUISHABLE_FROM__ELEMENTREFERENCE = ELEMENT_REFERENCE_OPERATION_COUNT + 42;

	/**
	 * The operation id for the '<em>Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___NAME = ELEMENT_REFERENCE_OPERATION_COUNT + 43;

	/**
	 * The operation id for the '<em>Visibility</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___VISIBILITY = ELEMENT_REFERENCE_OPERATION_COUNT + 44;

	/**
	 * The operation id for the '<em>Owned Members</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___OWNED_MEMBERS = ELEMENT_REFERENCE_OPERATION_COUNT + 45;

	/**
	 * The operation id for the '<em>Members</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___MEMBERS = ELEMENT_REFERENCE_OPERATION_COUNT + 46;

	/**
	 * The operation id for the '<em>Nested Classifiers</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___NESTED_CLASSIFIERS = ELEMENT_REFERENCE_OPERATION_COUNT + 47;

	/**
	 * The operation id for the '<em>Properties</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___PROPERTIES = ELEMENT_REFERENCE_OPERATION_COUNT + 48;

	/**
	 * The operation id for the '<em>Association Ends</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___ASSOCIATION_ENDS = ELEMENT_REFERENCE_OPERATION_COUNT + 49;

	/**
	 * The operation id for the '<em>Opposite</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___OPPOSITE = ELEMENT_REFERENCE_OPERATION_COUNT + 50;

	/**
	 * The operation id for the '<em>Signal</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___SIGNAL = ELEMENT_REFERENCE_OPERATION_COUNT + 51;

	/**
	 * The operation id for the '<em>Parameters</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___PARAMETERS = ELEMENT_REFERENCE_OPERATION_COUNT + 52;

	/**
	 * The operation id for the '<em>Return Parameter</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___RETURN_PARAMETER = ELEMENT_REFERENCE_OPERATION_COUNT + 53;

	/**
	 * The operation id for the '<em>Specification</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___SPECIFICATION = ELEMENT_REFERENCE_OPERATION_COUNT + 54;

	/**
	 * The operation id for the '<em>Redefined Operations</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___REDEFINED_OPERATIONS = ELEMENT_REFERENCE_OPERATION_COUNT + 55;

	/**
	 * The operation id for the '<em>Namespace</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___NAMESPACE = ELEMENT_REFERENCE_OPERATION_COUNT + 56;

	/**
	 * The operation id for the '<em>Template</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___TEMPLATE = ELEMENT_REFERENCE_OPERATION_COUNT + 57;

	/**
	 * The operation id for the '<em>Template Parameters</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___TEMPLATE_PARAMETERS = ELEMENT_REFERENCE_OPERATION_COUNT + 58;

	/**
	 * The operation id for the '<em>Parametered Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___PARAMETERED_ELEMENTS = ELEMENT_REFERENCE_OPERATION_COUNT + 59;

	/**
	 * The operation id for the '<em>Is Template Binding</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_TEMPLATE_BINDING = ELEMENT_REFERENCE_OPERATION_COUNT + 60;

	/**
	 * The operation id for the '<em>Template Actuals</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___TEMPLATE_ACTUALS = ELEMENT_REFERENCE_OPERATION_COUNT + 61;

	/**
	 * The operation id for the '<em>Direction</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___DIRECTION = ELEMENT_REFERENCE_OPERATION_COUNT + 62;

	/**
	 * The operation id for the '<em>Association</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___ASSOCIATION = ELEMENT_REFERENCE_OPERATION_COUNT + 63;

	/**
	 * The operation id for the '<em>Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___TYPE = ELEMENT_REFERENCE_OPERATION_COUNT + 64;

	/**
	 * The operation id for the '<em>Lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___LOWER = ELEMENT_REFERENCE_OPERATION_COUNT + 65;

	/**
	 * The operation id for the '<em>Upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___UPPER = ELEMENT_REFERENCE_OPERATION_COUNT + 66;

	/**
	 * The operation id for the '<em>Is Ordered</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_ORDERED = ELEMENT_REFERENCE_OPERATION_COUNT + 67;

	/**
	 * The operation id for the '<em>Is Nonunique</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_NONUNIQUE = ELEMENT_REFERENCE_OPERATION_COUNT + 68;

	/**
	 * The operation id for the '<em>Parents</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___PARENTS = ELEMENT_REFERENCE_OPERATION_COUNT + 69;

	/**
	 * The operation id for the '<em>All Parents</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___ALL_PARENTS = ELEMENT_REFERENCE_OPERATION_COUNT + 70;

	/**
	 * The operation id for the '<em>Classifier Behavior</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___CLASSIFIER_BEHAVIOR = ELEMENT_REFERENCE_OPERATION_COUNT + 71;

	/**
	 * The operation id for the '<em>Applied Profiles</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___APPLIED_PROFILES = ELEMENT_REFERENCE_OPERATION_COUNT + 72;

	/**
	 * The operation id for the '<em>Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___REFERENCE = ELEMENT_REFERENCE_OPERATION_COUNT + 73;

	/**
	 * The operation id for the '<em>Template Binding</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___TEMPLATE_BINDING = ELEMENT_REFERENCE_OPERATION_COUNT + 74;

	/**
	 * The operation id for the '<em>Active Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___ACTIVE_CLASS = ELEMENT_REFERENCE_OPERATION_COUNT + 75;

	/**
	 * The operation id for the '<em>Context</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___CONTEXT = ELEMENT_REFERENCE_OPERATION_COUNT + 76;

	/**
	 * The operation id for the '<em>Is Active Behavior</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___IS_ACTIVE_BEHAVIOR = ELEMENT_REFERENCE_OPERATION_COUNT + 77;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___CONFORMS_TO__ELEMENTREFERENCE = ELEMENT_REFERENCE_OPERATION_COUNT + 78;

	/**
	 * The operation id for the '<em>Equals</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___EQUALS__ELEMENTREFERENCE = ELEMENT_REFERENCE_OPERATION_COUNT + 79;

	/**
	 * The operation id for the '<em>Copy</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___COPY = ELEMENT_REFERENCE_OPERATION_COUNT + 80;

	/**
	 * The operation id for the '<em>Model Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___MODEL_SCOPE = ELEMENT_REFERENCE_OPERATION_COUNT + 81;

	/**
	 * The operation id for the '<em>Resolve Path Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___RESOLVE_PATH_NAME__STRING = ELEMENT_REFERENCE_OPERATION_COUNT + 82;

	/**
	 * The operation id for the '<em>Resolve In Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___RESOLVE_IN_SCOPE__STRING = ELEMENT_REFERENCE_OPERATION_COUNT + 83;

	/**
	 * The operation id for the '<em>Resolve Stereotype</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___RESOLVE_STEREOTYPE__STRING = ELEMENT_REFERENCE_OPERATION_COUNT + 84;

	/**
	 * The operation id for the '<em>Stub</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___STUB = ELEMENT_REFERENCE_OPERATION_COUNT + 85;

	/**
	 * The operation id for the '<em>Stub For</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___STUB_FOR__UNITDEFINITION = ELEMENT_REFERENCE_OPERATION_COUNT + 86;

	/**
	 * The operation id for the '<em>Bound Reference To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___BOUND_REFERENCE_TO__ELEMENTREFERENCE = ELEMENT_REFERENCE_OPERATION_COUNT + 87;

	/**
	 * The operation id for the '<em>Bound Reference To1</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___BOUND_REFERENCE_TO1__ELEMENTREFERENCE = ELEMENT_REFERENCE_OPERATION_COUNT + 88;

	/**
	 * The operation id for the '<em>Bound References To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE___BOUND_REFERENCES_TO__ELIST = ELEMENT_REFERENCE_OPERATION_COUNT + 89;

	/**
	 * The number of operations of the '<em>Bound Element Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUND_ELEMENT_REFERENCE_OPERATION_COUNT = ELEMENT_REFERENCE_OPERATION_COUNT + 90;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.DocumentedElementImpl <em>Documented Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.DocumentedElementImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getDocumentedElement()
	 * @generated
	 */
	int DOCUMENTED_ELEMENT = 7;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTED_ELEMENT__OWNER = SYNTAX_ELEMENT__OWNER;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTED_ELEMENT__DOCUMENTATION = SYNTAX_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Documented Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTED_ELEMENT_FEATURE_COUNT = SYNTAX_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTED_ELEMENT___TO_REFERENCE = SYNTAX_ELEMENT___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTED_ELEMENT___OWNER = SYNTAX_ELEMENT___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTED_ELEMENT___SYNTAX_ELEMENT_OWNER = SYNTAX_ELEMENT___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTED_ELEMENT___CURRENT_SCOPE = SYNTAX_ELEMENT___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTED_ELEMENT___SYNTAX_ELEMENT_CURRENT_SCOPE = SYNTAX_ELEMENT___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTED_ELEMENT___ENCLOSING_STATEMENT = SYNTAX_ELEMENT___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTED_ELEMENT___ENCLOSING_EXPRESSION = SYNTAX_ELEMENT___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTED_ELEMENT___ASSIGNMENTS_BEFORE = SYNTAX_ELEMENT___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTED_ELEMENT___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = SYNTAX_ELEMENT___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTED_ELEMENT___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = SYNTAX_ELEMENT___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTED_ELEMENT___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = SYNTAX_ELEMENT___ASSIGNMENTS_BEFORE__SYNTAXELEMENT;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTED_ELEMENT___UPDATE_ALL__ELIST_ELIST = SYNTAX_ELEMENT___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTED_ELEMENT___COMMON_ANCESTOR__ELIST = SYNTAX_ELEMENT___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTED_ELEMENT___COMMON_ANCESTORS__ELIST = SYNTAX_ELEMENT___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTED_ELEMENT___REMOVE_DUPLICATE_ELEMENTS__ELIST = SYNTAX_ELEMENT___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTED_ELEMENT___RESOLVE_IN_LIBRARY__STRING = SYNTAX_ELEMENT___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTED_ELEMENT___PRIMITIVE_TYPE__STRING = SYNTAX_ELEMENT___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTED_ELEMENT___PRIMITIVE_TYPE____STRING = SYNTAX_ELEMENT___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTED_ELEMENT___BOOLEAN_TYPE = SYNTAX_ELEMENT___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTED_ELEMENT___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTED_ELEMENT___INTEGER_TYPE = SYNTAX_ELEMENT___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTED_ELEMENT___IS_INTEGER_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTED_ELEMENT___STRING_TYPE = SYNTAX_ELEMENT___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTED_ELEMENT___IS_STRING_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTED_ELEMENT___UNLIMITED_NATURAL_TYPE = SYNTAX_ELEMENT___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTED_ELEMENT___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTED_ELEMENT___BIT_STRING_TYPE = SYNTAX_ELEMENT___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTED_ELEMENT___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTED_ELEMENT___NATURAL_TYPE = SYNTAX_ELEMENT___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTED_ELEMENT___IS_NATURAL_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTED_ELEMENT___IS_NUMERIC_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTED_ELEMENT___COLLECTION_FUNCTION_ADD = SYNTAX_ELEMENT___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTED_ELEMENT___IS_COLLECTION_CLASS__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTED_ELEMENT___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTED_ELEMENT___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The number of operations of the '<em>Documented Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTED_ELEMENT_OPERATION_COUNT = SYNTAX_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT__OWNER = SYNTAX_ELEMENT__OWNER;

	/**
	 * The feature id for the '<em><b>Upper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT__UPPER = SYNTAX_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Lower</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT__LOWER = SYNTAX_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT__TYPE = SYNTAX_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Assignable Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_FEATURE_COUNT = SYNTAX_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___TO_REFERENCE = SYNTAX_ELEMENT___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___OWNER = SYNTAX_ELEMENT___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___SYNTAX_ELEMENT_OWNER = SYNTAX_ELEMENT___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___CURRENT_SCOPE = SYNTAX_ELEMENT___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___SYNTAX_ELEMENT_CURRENT_SCOPE = SYNTAX_ELEMENT___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___ENCLOSING_STATEMENT = SYNTAX_ELEMENT___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___ENCLOSING_EXPRESSION = SYNTAX_ELEMENT___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___ASSIGNMENTS_BEFORE = SYNTAX_ELEMENT___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = SYNTAX_ELEMENT___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = SYNTAX_ELEMENT___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = SYNTAX_ELEMENT___ASSIGNMENTS_BEFORE__SYNTAXELEMENT;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___UPDATE_ALL__ELIST_ELIST = SYNTAX_ELEMENT___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___COMMON_ANCESTOR__ELIST = SYNTAX_ELEMENT___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___COMMON_ANCESTORS__ELIST = SYNTAX_ELEMENT___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___REMOVE_DUPLICATE_ELEMENTS__ELIST = SYNTAX_ELEMENT___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___RESOLVE_IN_LIBRARY__STRING = SYNTAX_ELEMENT___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___PRIMITIVE_TYPE__STRING = SYNTAX_ELEMENT___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___PRIMITIVE_TYPE____STRING = SYNTAX_ELEMENT___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___BOOLEAN_TYPE = SYNTAX_ELEMENT___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___INTEGER_TYPE = SYNTAX_ELEMENT___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___IS_INTEGER_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___STRING_TYPE = SYNTAX_ELEMENT___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___IS_STRING_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___UNLIMITED_NATURAL_TYPE = SYNTAX_ELEMENT___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___BIT_STRING_TYPE = SYNTAX_ELEMENT___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___NATURAL_TYPE = SYNTAX_ELEMENT___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___IS_NATURAL_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___IS_NUMERIC_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___COLLECTION_FUNCTION_ADD = SYNTAX_ELEMENT___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___IS_COLLECTION_CLASS__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Type Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___TYPE_CACHED = SYNTAX_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___TYPE = SYNTAX_ELEMENT_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___LOWER = SYNTAX_ELEMENT_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___UPPER = SYNTAX_ELEMENT_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Is Null</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___IS_NULL = SYNTAX_ELEMENT_OPERATION_COUNT + 4;

	/**
	 * The operation id for the '<em>Is Assignable From Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE = SYNTAX_ELEMENT_OPERATION_COUNT + 5;

	/**
	 * The operation id for the '<em>Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT = SYNTAX_ELEMENT_OPERATION_COUNT + 6;

	/**
	 * The operation id for the '<em>Is Type Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT = SYNTAX_ELEMENT_OPERATION_COUNT + 7;

	/**
	 * The operation id for the '<em>Is Conformant With Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT_OPERATION_COUNT + 8;

	/**
	 * The operation id for the '<em>Is Multiplicity Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT = SYNTAX_ELEMENT_OPERATION_COUNT + 9;

	/**
	 * The number of operations of the '<em>Assignable Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_OPERATION_COUNT = SYNTAX_ELEMENT_OPERATION_COUNT + 10;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.ExpressionImpl <em>Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.ExpressionImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getExpression()
	 * @generated
	 */
	int EXPRESSION = 11;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION__OWNER = ASSIGNABLE_ELEMENT__OWNER;

	/**
	 * The feature id for the '<em><b>Upper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION__UPPER = ASSIGNABLE_ELEMENT__UPPER;

	/**
	 * The feature id for the '<em><b>Lower</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION__LOWER = ASSIGNABLE_ELEMENT__LOWER;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION__TYPE = ASSIGNABLE_ELEMENT__TYPE;

	/**
	 * The feature id for the '<em><b>Assignment Before</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION__ASSIGNMENT_BEFORE = ASSIGNABLE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Assignment After</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION__ASSIGNMENT_AFTER = ASSIGNABLE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_FEATURE_COUNT = ASSIGNABLE_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___TO_REFERENCE = ASSIGNABLE_ELEMENT___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___OWNER = ASSIGNABLE_ELEMENT___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___SYNTAX_ELEMENT_OWNER = ASSIGNABLE_ELEMENT___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___CURRENT_SCOPE = ASSIGNABLE_ELEMENT___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE = ASSIGNABLE_ELEMENT___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___ENCLOSING_STATEMENT = ASSIGNABLE_ELEMENT___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___ENCLOSING_EXPRESSION = ASSIGNABLE_ELEMENT___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___ASSIGNMENTS_BEFORE = ASSIGNABLE_ELEMENT___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = ASSIGNABLE_ELEMENT___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = ASSIGNABLE_ELEMENT___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = ASSIGNABLE_ELEMENT___ASSIGNMENTS_BEFORE__SYNTAXELEMENT;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___UPDATE_ALL__ELIST_ELIST = ASSIGNABLE_ELEMENT___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___COMMON_ANCESTOR__ELIST = ASSIGNABLE_ELEMENT___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___COMMON_ANCESTORS__ELIST = ASSIGNABLE_ELEMENT___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST = ASSIGNABLE_ELEMENT___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___RESOLVE_IN_LIBRARY__STRING = ASSIGNABLE_ELEMENT___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___PRIMITIVE_TYPE__STRING = ASSIGNABLE_ELEMENT___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___PRIMITIVE_TYPE____STRING = ASSIGNABLE_ELEMENT___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___BOOLEAN_TYPE = ASSIGNABLE_ELEMENT___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = ASSIGNABLE_ELEMENT___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___INTEGER_TYPE = ASSIGNABLE_ELEMENT___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE = ASSIGNABLE_ELEMENT___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___STRING_TYPE = ASSIGNABLE_ELEMENT___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE = ASSIGNABLE_ELEMENT___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___UNLIMITED_NATURAL_TYPE = ASSIGNABLE_ELEMENT___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = ASSIGNABLE_ELEMENT___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___BIT_STRING_TYPE = ASSIGNABLE_ELEMENT___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = ASSIGNABLE_ELEMENT___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___NATURAL_TYPE = ASSIGNABLE_ELEMENT___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE = ASSIGNABLE_ELEMENT___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE = ASSIGNABLE_ELEMENT___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___COLLECTION_FUNCTION_ADD = ASSIGNABLE_ELEMENT___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE = ASSIGNABLE_ELEMENT___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = ASSIGNABLE_ELEMENT___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = ASSIGNABLE_ELEMENT___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Type Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___TYPE_CACHED = ASSIGNABLE_ELEMENT___TYPE_CACHED;

	/**
	 * The operation id for the '<em>Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___TYPE = ASSIGNABLE_ELEMENT___TYPE;

	/**
	 * The operation id for the '<em>Lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___LOWER = ASSIGNABLE_ELEMENT___LOWER;

	/**
	 * The operation id for the '<em>Upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___UPPER = ASSIGNABLE_ELEMENT___UPPER;

	/**
	 * The operation id for the '<em>Is Null</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___IS_NULL = ASSIGNABLE_ELEMENT___IS_NULL;

	/**
	 * The operation id for the '<em>Is Assignable From Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE = ASSIGNABLE_ELEMENT___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT = ASSIGNABLE_ELEMENT___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Type Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT = ASSIGNABLE_ELEMENT___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Conformant With Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE = ASSIGNABLE_ELEMENT___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Multiplicity Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT = ASSIGNABLE_ELEMENT___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___REFERENCE = ASSIGNABLE_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>New Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___NEW_ASSIGNMENTS = ASSIGNABLE_ELEMENT_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___UPDATE_ASSIGNMENTS = ASSIGNABLE_ELEMENT_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Expression update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS = ASSIGNABLE_ELEMENT_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Update Assignments Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___UPDATE_ASSIGNMENTS_CACHED = ASSIGNABLE_ELEMENT_OPERATION_COUNT + 4;

	/**
	 * The operation id for the '<em>Resolve</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___RESOLVE__STRING = ASSIGNABLE_ELEMENT_OPERATION_COUNT + 5;

	/**
	 * The operation id for the '<em>Is Add Target</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___IS_ADD_TARGET__EXPRESSION = ASSIGNABLE_ELEMENT_OPERATION_COUNT + 6;

	/**
	 * The operation id for the '<em>Expression Assignment After Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP = ASSIGNABLE_ELEMENT_OPERATION_COUNT + 7;

	/**
	 * The operation id for the '<em>Expression Unique Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP = ASSIGNABLE_ELEMENT_OPERATION_COUNT + 8;

	/**
	 * The number of operations of the '<em>Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_OPERATION_COUNT = ASSIGNABLE_ELEMENT_OPERATION_COUNT + 9;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.SequenceExpansionExpressionImpl <em>Sequence Expansion Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.SequenceExpansionExpressionImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getSequenceExpansionExpression()
	 * @generated
	 */
	int SEQUENCE_EXPANSION_EXPRESSION = 8;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION__OWNER = EXPRESSION__OWNER;

	/**
	 * The feature id for the '<em><b>Upper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION__UPPER = EXPRESSION__UPPER;

	/**
	 * The feature id for the '<em><b>Lower</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION__LOWER = EXPRESSION__LOWER;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION__TYPE = EXPRESSION__TYPE;

	/**
	 * The feature id for the '<em><b>Assignment Before</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION__ASSIGNMENT_BEFORE = EXPRESSION__ASSIGNMENT_BEFORE;

	/**
	 * The feature id for the '<em><b>Assignment After</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION__ASSIGNMENT_AFTER = EXPRESSION__ASSIGNMENT_AFTER;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION__OPERATION = EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Variable</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION__VARIABLE = EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Variable Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION__VARIABLE_SOURCE = EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION__ARGUMENT = EXPRESSION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Primary</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION__PRIMARY = EXPRESSION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Is Select Or Reject</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION__IS_SELECT_OR_REJECT = EXPRESSION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Is Collect Or Iterate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION__IS_COLLECT_OR_ITERATE = EXPRESSION_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Is For All Or Exists Or One</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION__IS_FOR_ALL_OR_EXISTS_OR_ONE = EXPRESSION_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Is Is Unique</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION__IS_IS_UNIQUE = EXPRESSION_FEATURE_COUNT + 8;

	/**
	 * The number of structural features of the '<em>Sequence Expansion Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION_FEATURE_COUNT = EXPRESSION_FEATURE_COUNT + 9;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___TO_REFERENCE = EXPRESSION___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___OWNER = EXPRESSION___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___SYNTAX_ELEMENT_OWNER = EXPRESSION___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___CURRENT_SCOPE = EXPRESSION___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE = EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___ENCLOSING_STATEMENT = EXPRESSION___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___ENCLOSING_EXPRESSION = EXPRESSION___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___ASSIGNMENTS_BEFORE = EXPRESSION___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___UPDATE_ALL__ELIST_ELIST = EXPRESSION___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___COMMON_ANCESTOR__ELIST = EXPRESSION___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___COMMON_ANCESTORS__ELIST = EXPRESSION___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST = EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___RESOLVE_IN_LIBRARY__STRING = EXPRESSION___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___PRIMITIVE_TYPE__STRING = EXPRESSION___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___PRIMITIVE_TYPE____STRING = EXPRESSION___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___BOOLEAN_TYPE = EXPRESSION___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___INTEGER_TYPE = EXPRESSION___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___STRING_TYPE = EXPRESSION___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___UNLIMITED_NATURAL_TYPE = EXPRESSION___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___BIT_STRING_TYPE = EXPRESSION___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___NATURAL_TYPE = EXPRESSION___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___COLLECTION_FUNCTION_ADD = EXPRESSION___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE = EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Type Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___TYPE_CACHED = EXPRESSION___TYPE_CACHED;

	/**
	 * The operation id for the '<em>Is Null</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___IS_NULL = EXPRESSION___IS_NULL;

	/**
	 * The operation id for the '<em>Is Assignable From Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE = EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT = EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Type Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT = EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Conformant With Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Multiplicity Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT = EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___REFERENCE = EXPRESSION___REFERENCE;

	/**
	 * The operation id for the '<em>New Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___NEW_ASSIGNMENTS = EXPRESSION___NEW_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Expression update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS = EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Update Assignments Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___UPDATE_ASSIGNMENTS_CACHED = EXPRESSION___UPDATE_ASSIGNMENTS_CACHED;

	/**
	 * The operation id for the '<em>Resolve</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___RESOLVE__STRING = EXPRESSION___RESOLVE__STRING;

	/**
	 * The operation id for the '<em>Is Add Target</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___IS_ADD_TARGET__EXPRESSION = EXPRESSION___IS_ADD_TARGET__EXPRESSION;

	/**
	 * The operation id for the '<em>Expression Assignment After Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Expression Unique Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP = EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Assignments After Primary</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___ASSIGNMENTS_AFTER_PRIMARY = EXPRESSION_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___TYPE = EXPRESSION_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___LOWER = EXPRESSION_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___UPPER = EXPRESSION_OPERATION_COUNT + 4;

	/**
	 * The operation id for the '<em>Sequence Expansion Expression Variable Source Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_VARIABLE_SOURCE_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 5;

	/**
	 * The operation id for the '<em>Sequence Expansion Expression Assignments Before Primary</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_ASSIGNMENTS_BEFORE_PRIMARY__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 6;

	/**
	 * The operation id for the '<em>Sequence Expansion Expression Assignments Before Argument</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_ASSIGNMENTS_BEFORE_ARGUMENT__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 7;

	/**
	 * The operation id for the '<em>Sequence Expansion Expression Variable Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_VARIABLE_NAME__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 8;

	/**
	 * The operation id for the '<em>Sequence Expansion Expression Assignments After Argument</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_ASSIGNMENTS_AFTER_ARGUMENT__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 9;

	/**
	 * The operation id for the '<em>Select Or Reject Expression Type Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___SELECT_OR_REJECT_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 10;

	/**
	 * The operation id for the '<em>Select Or Reject Expression Lower Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___SELECT_OR_REJECT_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 11;

	/**
	 * The operation id for the '<em>Select Or Reject Expression Upper Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___SELECT_OR_REJECT_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 12;

	/**
	 * The operation id for the '<em>Select Or Reject Expression Argument</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___SELECT_OR_REJECT_EXPRESSION_ARGUMENT__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 13;

	/**
	 * The operation id for the '<em>Collect Or Iterate Expression Type Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___COLLECT_OR_ITERATE_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 14;

	/**
	 * The operation id for the '<em>Collect Or Iterate Expression Lower Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___COLLECT_OR_ITERATE_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 15;

	/**
	 * The operation id for the '<em>Collect Or Iterate Expression Upper Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___COLLECT_OR_ITERATE_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 16;

	/**
	 * The operation id for the '<em>For All Or Exists Or One Expression Type Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 17;

	/**
	 * The operation id for the '<em>For All Or Exists Or One Expression Lower Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 18;

	/**
	 * The operation id for the '<em>For All Or Exists Or One Expression Upper Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 19;

	/**
	 * The operation id for the '<em>For All Or Exists Or One Expression Argument</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION_ARGUMENT__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 20;

	/**
	 * The operation id for the '<em>Is Unique Expression Type Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___IS_UNIQUE_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 21;

	/**
	 * The operation id for the '<em>Is Unique Expression Lower Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___IS_UNIQUE_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 22;

	/**
	 * The operation id for the '<em>Is Unique Expression Upper Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___IS_UNIQUE_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 23;

	/**
	 * The operation id for the '<em>Is Unique Expression Expression Argument</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___IS_UNIQUE_EXPRESSION_EXPRESSION_ARGUMENT__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 24;

	/**
	 * The operation id for the '<em>Update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___UPDATE_ASSIGNMENTS = EXPRESSION_OPERATION_COUNT + 25;

	/**
	 * The operation id for the '<em>Sequence Expansion Expression Operation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_OPERATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 26;

	/**
	 * The number of operations of the '<em>Sequence Expansion Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_EXPANSION_EXPRESSION_OPERATION_COUNT = EXPRESSION_OPERATION_COUNT + 27;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.AssignableElementReferenceImpl <em>Assignable Element Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.AssignableElementReferenceImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getAssignableElementReference()
	 * @generated
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE = 10;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE__OWNER = ASSIGNABLE_ELEMENT__OWNER;

	/**
	 * The feature id for the '<em><b>Upper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE__UPPER = ASSIGNABLE_ELEMENT__UPPER;

	/**
	 * The feature id for the '<em><b>Lower</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE__LOWER = ASSIGNABLE_ELEMENT__LOWER;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE__TYPE = ASSIGNABLE_ELEMENT__TYPE;

	/**
	 * The feature id for the '<em><b>Reference</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE__REFERENCE = ASSIGNABLE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Assignable Element Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE_FEATURE_COUNT = ASSIGNABLE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___TO_REFERENCE = ASSIGNABLE_ELEMENT___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___OWNER = ASSIGNABLE_ELEMENT___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___SYNTAX_ELEMENT_OWNER = ASSIGNABLE_ELEMENT___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___CURRENT_SCOPE = ASSIGNABLE_ELEMENT___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___SYNTAX_ELEMENT_CURRENT_SCOPE = ASSIGNABLE_ELEMENT___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___ENCLOSING_STATEMENT = ASSIGNABLE_ELEMENT___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___ENCLOSING_EXPRESSION = ASSIGNABLE_ELEMENT___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___ASSIGNMENTS_BEFORE = ASSIGNABLE_ELEMENT___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = ASSIGNABLE_ELEMENT___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = ASSIGNABLE_ELEMENT___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = ASSIGNABLE_ELEMENT___ASSIGNMENTS_BEFORE__SYNTAXELEMENT;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___UPDATE_ALL__ELIST_ELIST = ASSIGNABLE_ELEMENT___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___COMMON_ANCESTOR__ELIST = ASSIGNABLE_ELEMENT___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___COMMON_ANCESTORS__ELIST = ASSIGNABLE_ELEMENT___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___REMOVE_DUPLICATE_ELEMENTS__ELIST = ASSIGNABLE_ELEMENT___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___RESOLVE_IN_LIBRARY__STRING = ASSIGNABLE_ELEMENT___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___PRIMITIVE_TYPE__STRING = ASSIGNABLE_ELEMENT___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___PRIMITIVE_TYPE____STRING = ASSIGNABLE_ELEMENT___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___BOOLEAN_TYPE = ASSIGNABLE_ELEMENT___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = ASSIGNABLE_ELEMENT___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___INTEGER_TYPE = ASSIGNABLE_ELEMENT___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___IS_INTEGER_TYPE__ELEMENTREFERENCE = ASSIGNABLE_ELEMENT___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___STRING_TYPE = ASSIGNABLE_ELEMENT___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___IS_STRING_TYPE__ELEMENTREFERENCE = ASSIGNABLE_ELEMENT___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___UNLIMITED_NATURAL_TYPE = ASSIGNABLE_ELEMENT___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = ASSIGNABLE_ELEMENT___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___BIT_STRING_TYPE = ASSIGNABLE_ELEMENT___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = ASSIGNABLE_ELEMENT___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___NATURAL_TYPE = ASSIGNABLE_ELEMENT___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___IS_NATURAL_TYPE__ELEMENTREFERENCE = ASSIGNABLE_ELEMENT___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___IS_NUMERIC_TYPE__ELEMENTREFERENCE = ASSIGNABLE_ELEMENT___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___COLLECTION_FUNCTION_ADD = ASSIGNABLE_ELEMENT___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___IS_COLLECTION_CLASS__ELEMENTREFERENCE = ASSIGNABLE_ELEMENT___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = ASSIGNABLE_ELEMENT___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = ASSIGNABLE_ELEMENT___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Type Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___TYPE_CACHED = ASSIGNABLE_ELEMENT___TYPE_CACHED;

	/**
	 * The operation id for the '<em>Is Null</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___IS_NULL = ASSIGNABLE_ELEMENT___IS_NULL;

	/**
	 * The operation id for the '<em>Is Assignable From Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE = ASSIGNABLE_ELEMENT___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT = ASSIGNABLE_ELEMENT___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Type Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT = ASSIGNABLE_ELEMENT___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Conformant With Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE = ASSIGNABLE_ELEMENT___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Multiplicity Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT = ASSIGNABLE_ELEMENT___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___TYPE = ASSIGNABLE_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___LOWER = ASSIGNABLE_ELEMENT_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE___UPPER = ASSIGNABLE_ELEMENT_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Assignable Element Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNABLE_ELEMENT_REFERENCE_OPERATION_COUNT = ASSIGNABLE_ELEMENT_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.ExpressionReferenceImpl <em>Expression Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.ExpressionReferenceImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getExpressionReference()
	 * @generated
	 */
	int EXPRESSION_REFERENCE = 12;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE__OWNER = EXPRESSION__OWNER;

	/**
	 * The feature id for the '<em><b>Upper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE__UPPER = EXPRESSION__UPPER;

	/**
	 * The feature id for the '<em><b>Lower</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE__LOWER = EXPRESSION__LOWER;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE__TYPE = EXPRESSION__TYPE;

	/**
	 * The feature id for the '<em><b>Assignment Before</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE__ASSIGNMENT_BEFORE = EXPRESSION__ASSIGNMENT_BEFORE;

	/**
	 * The feature id for the '<em><b>Assignment After</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE__ASSIGNMENT_AFTER = EXPRESSION__ASSIGNMENT_AFTER;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE__EXPRESSION = EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Expression Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE_FEATURE_COUNT = EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___TO_REFERENCE = EXPRESSION___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___OWNER = EXPRESSION___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___SYNTAX_ELEMENT_OWNER = EXPRESSION___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___CURRENT_SCOPE = EXPRESSION___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___SYNTAX_ELEMENT_CURRENT_SCOPE = EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___ENCLOSING_STATEMENT = EXPRESSION___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___ENCLOSING_EXPRESSION = EXPRESSION___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___UPDATE_ALL__ELIST_ELIST = EXPRESSION___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___COMMON_ANCESTOR__ELIST = EXPRESSION___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___COMMON_ANCESTORS__ELIST = EXPRESSION___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___REMOVE_DUPLICATE_ELEMENTS__ELIST = EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___RESOLVE_IN_LIBRARY__STRING = EXPRESSION___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___PRIMITIVE_TYPE__STRING = EXPRESSION___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___PRIMITIVE_TYPE____STRING = EXPRESSION___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___BOOLEAN_TYPE = EXPRESSION___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___INTEGER_TYPE = EXPRESSION___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___IS_INTEGER_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___STRING_TYPE = EXPRESSION___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___IS_STRING_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___UNLIMITED_NATURAL_TYPE = EXPRESSION___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___BIT_STRING_TYPE = EXPRESSION___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___NATURAL_TYPE = EXPRESSION___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___IS_NATURAL_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___IS_NUMERIC_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___COLLECTION_FUNCTION_ADD = EXPRESSION___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___IS_COLLECTION_CLASS__ELEMENTREFERENCE = EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Type Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___TYPE_CACHED = EXPRESSION___TYPE_CACHED;

	/**
	 * The operation id for the '<em>Is Null</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___IS_NULL = EXPRESSION___IS_NULL;

	/**
	 * The operation id for the '<em>Is Assignable From Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE = EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT = EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Type Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT = EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Conformant With Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Multiplicity Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT = EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___REFERENCE = EXPRESSION___REFERENCE;

	/**
	 * The operation id for the '<em>New Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___NEW_ASSIGNMENTS = EXPRESSION___NEW_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Expression update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___EXPRESSION_UPDATE_ASSIGNMENTS = EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Update Assignments Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___UPDATE_ASSIGNMENTS_CACHED = EXPRESSION___UPDATE_ASSIGNMENTS_CACHED;

	/**
	 * The operation id for the '<em>Resolve</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___RESOLVE__STRING = EXPRESSION___RESOLVE__STRING;

	/**
	 * The operation id for the '<em>Expression Assignment After Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Expression Unique Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP = EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___TYPE = EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___LOWER = EXPRESSION_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___UPPER = EXPRESSION_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Is Add Target</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___IS_ADD_TARGET__EXPRESSION = EXPRESSION_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___ASSIGNMENTS_BEFORE = EXPRESSION_OPERATION_COUNT + 4;

	/**
	 * The operation id for the '<em>Update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE___UPDATE_ASSIGNMENTS = EXPRESSION_OPERATION_COUNT + 5;

	/**
	 * The number of operations of the '<em>Expression Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPRESSION_REFERENCE_OPERATION_COUNT = EXPRESSION_OPERATION_COUNT + 6;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.ExtentOrExpressionImpl <em>Extent Or Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.ExtentOrExpressionImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getExtentOrExpression()
	 * @generated
	 */
	int EXTENT_OR_EXPRESSION = 13;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION__OWNER = EXPRESSION__OWNER;

	/**
	 * The feature id for the '<em><b>Upper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION__UPPER = EXPRESSION__UPPER;

	/**
	 * The feature id for the '<em><b>Lower</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION__LOWER = EXPRESSION__LOWER;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION__TYPE = EXPRESSION__TYPE;

	/**
	 * The feature id for the '<em><b>Assignment Before</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION__ASSIGNMENT_BEFORE = EXPRESSION__ASSIGNMENT_BEFORE;

	/**
	 * The feature id for the '<em><b>Assignment After</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION__ASSIGNMENT_AFTER = EXPRESSION__ASSIGNMENT_AFTER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION__NAME = EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION__EXPRESSION = EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Non Name Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION__NON_NAME_EXPRESSION = EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Extent Or Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION_FEATURE_COUNT = EXPRESSION_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___TO_REFERENCE = EXPRESSION___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___OWNER = EXPRESSION___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___SYNTAX_ELEMENT_OWNER = EXPRESSION___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___CURRENT_SCOPE = EXPRESSION___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE = EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___ENCLOSING_STATEMENT = EXPRESSION___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___ENCLOSING_EXPRESSION = EXPRESSION___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___ASSIGNMENTS_BEFORE = EXPRESSION___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___UPDATE_ALL__ELIST_ELIST = EXPRESSION___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___COMMON_ANCESTOR__ELIST = EXPRESSION___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___COMMON_ANCESTORS__ELIST = EXPRESSION___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST = EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___RESOLVE_IN_LIBRARY__STRING = EXPRESSION___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___PRIMITIVE_TYPE__STRING = EXPRESSION___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___PRIMITIVE_TYPE____STRING = EXPRESSION___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___BOOLEAN_TYPE = EXPRESSION___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___INTEGER_TYPE = EXPRESSION___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___STRING_TYPE = EXPRESSION___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___UNLIMITED_NATURAL_TYPE = EXPRESSION___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___BIT_STRING_TYPE = EXPRESSION___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___NATURAL_TYPE = EXPRESSION___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___COLLECTION_FUNCTION_ADD = EXPRESSION___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE = EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Type Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___TYPE_CACHED = EXPRESSION___TYPE_CACHED;

	/**
	 * The operation id for the '<em>Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___TYPE = EXPRESSION___TYPE;

	/**
	 * The operation id for the '<em>Lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___LOWER = EXPRESSION___LOWER;

	/**
	 * The operation id for the '<em>Upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___UPPER = EXPRESSION___UPPER;

	/**
	 * The operation id for the '<em>Is Null</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___IS_NULL = EXPRESSION___IS_NULL;

	/**
	 * The operation id for the '<em>Is Assignable From Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE = EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT = EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Type Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT = EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Conformant With Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Multiplicity Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT = EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___REFERENCE = EXPRESSION___REFERENCE;

	/**
	 * The operation id for the '<em>New Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___NEW_ASSIGNMENTS = EXPRESSION___NEW_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___UPDATE_ASSIGNMENTS = EXPRESSION___UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Expression update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS = EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Update Assignments Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___UPDATE_ASSIGNMENTS_CACHED = EXPRESSION___UPDATE_ASSIGNMENTS_CACHED;

	/**
	 * The operation id for the '<em>Resolve</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___RESOLVE__STRING = EXPRESSION___RESOLVE__STRING;

	/**
	 * The operation id for the '<em>Expression Assignment After Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Expression Unique Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP = EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Is Add Target</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___IS_ADD_TARGET__EXPRESSION = EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Extent Or Expression Expression Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___EXTENT_OR_EXPRESSION_EXPRESSION_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Extent Or Expression Extent Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___EXTENT_OR_EXPRESSION_EXTENT_TYPE__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Extent Or Expression Resolution</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION___EXTENT_OR_EXPRESSION_RESOLUTION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 3;

	/**
	 * The number of operations of the '<em>Extent Or Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTENT_OR_EXPRESSION_OPERATION_COUNT = EXPRESSION_OPERATION_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.QualifiedNameImpl <em>Qualified Name</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.QualifiedNameImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getQualifiedName()
	 * @generated
	 */
	int QUALIFIED_NAME = 14;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME__OWNER = SYNTAX_ELEMENT__OWNER;

	/**
	 * The feature id for the '<em><b>Is Ambiguous</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME__IS_AMBIGUOUS = SYNTAX_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Path Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME__PATH_NAME = SYNTAX_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Is Feature Reference</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME__IS_FEATURE_REFERENCE = SYNTAX_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Qualification</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME__QUALIFICATION = SYNTAX_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Disambiguation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME__DISAMBIGUATION = SYNTAX_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Name Binding</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME__NAME_BINDING = SYNTAX_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Referent</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME__REFERENT = SYNTAX_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Unqualified Name</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME__UNQUALIFIED_NAME = SYNTAX_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Template Name</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME__TEMPLATE_NAME = SYNTAX_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The number of structural features of the '<em>Qualified Name</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME_FEATURE_COUNT = SYNTAX_ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___TO_REFERENCE = SYNTAX_ELEMENT___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___OWNER = SYNTAX_ELEMENT___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___SYNTAX_ELEMENT_OWNER = SYNTAX_ELEMENT___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___CURRENT_SCOPE = SYNTAX_ELEMENT___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___SYNTAX_ELEMENT_CURRENT_SCOPE = SYNTAX_ELEMENT___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___ENCLOSING_STATEMENT = SYNTAX_ELEMENT___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___ENCLOSING_EXPRESSION = SYNTAX_ELEMENT___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___ASSIGNMENTS_BEFORE = SYNTAX_ELEMENT___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = SYNTAX_ELEMENT___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = SYNTAX_ELEMENT___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = SYNTAX_ELEMENT___ASSIGNMENTS_BEFORE__SYNTAXELEMENT;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___UPDATE_ALL__ELIST_ELIST = SYNTAX_ELEMENT___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___COMMON_ANCESTOR__ELIST = SYNTAX_ELEMENT___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___COMMON_ANCESTORS__ELIST = SYNTAX_ELEMENT___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___REMOVE_DUPLICATE_ELEMENTS__ELIST = SYNTAX_ELEMENT___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___RESOLVE_IN_LIBRARY__STRING = SYNTAX_ELEMENT___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___PRIMITIVE_TYPE__STRING = SYNTAX_ELEMENT___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___PRIMITIVE_TYPE____STRING = SYNTAX_ELEMENT___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___BOOLEAN_TYPE = SYNTAX_ELEMENT___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___INTEGER_TYPE = SYNTAX_ELEMENT___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___IS_INTEGER_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___STRING_TYPE = SYNTAX_ELEMENT___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___IS_STRING_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___UNLIMITED_NATURAL_TYPE = SYNTAX_ELEMENT___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___BIT_STRING_TYPE = SYNTAX_ELEMENT___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___NATURAL_TYPE = SYNTAX_ELEMENT___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___IS_NATURAL_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___IS_NUMERIC_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___COLLECTION_FUNCTION_ADD = SYNTAX_ELEMENT___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___IS_COLLECTION_CLASS__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Copy</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___COPY = SYNTAX_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Add Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___ADD_NAME__STRING = SYNTAX_ELEMENT_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Add Name Bindings</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___ADD_NAME_BINDINGS__ELIST = SYNTAX_ELEMENT_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Model Referents</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___MODEL_REFERENTS = SYNTAX_ELEMENT_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Qualified Name Unqualified Name Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___QUALIFIED_NAME_UNQUALIFIED_NAME_DERIVATION__DIAGNOSTICCHAIN_MAP = SYNTAX_ELEMENT_OPERATION_COUNT + 4;

	/**
	 * The operation id for the '<em>Qualified Name Path Name Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___QUALIFIED_NAME_PATH_NAME_DERIVATION__DIAGNOSTICCHAIN_MAP = SYNTAX_ELEMENT_OPERATION_COUNT + 5;

	/**
	 * The operation id for the '<em>Qualified Name Is Feature Reference Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___QUALIFIED_NAME_IS_FEATURE_REFERENCE_DERIVATION__DIAGNOSTICCHAIN_MAP = SYNTAX_ELEMENT_OPERATION_COUNT + 6;

	/**
	 * The operation id for the '<em>Qualified Name Qualification Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___QUALIFIED_NAME_QUALIFICATION_DERIVATION__DIAGNOSTICCHAIN_MAP = SYNTAX_ELEMENT_OPERATION_COUNT + 7;

	/**
	 * The operation id for the '<em>Qualified Name Disambiguation Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___QUALIFIED_NAME_DISAMBIGUATION_DERIVATION__DIAGNOSTICCHAIN_MAP = SYNTAX_ELEMENT_OPERATION_COUNT + 8;

	/**
	 * The operation id for the '<em>Qualified Name Referent Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___QUALIFIED_NAME_REFERENT_DERIVATION__DIAGNOSTICCHAIN_MAP = SYNTAX_ELEMENT_OPERATION_COUNT + 9;

	/**
	 * The operation id for the '<em>Qualified Name Local Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___QUALIFIED_NAME_LOCAL_NAME__DIAGNOSTICCHAIN_MAP = SYNTAX_ELEMENT_OPERATION_COUNT + 10;

	/**
	 * The operation id for the '<em>Qualified Name Non Local Unqualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___QUALIFIED_NAME_NON_LOCAL_UNQUALIFIED_NAME__DIAGNOSTICCHAIN_MAP = SYNTAX_ELEMENT_OPERATION_COUNT + 11;

	/**
	 * The operation id for the '<em>Qualified Name Qualified Resolution</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___QUALIFIED_NAME_QUALIFIED_RESOLUTION__DIAGNOSTICCHAIN_MAP = SYNTAX_ELEMENT_OPERATION_COUNT + 12;

	/**
	 * The operation id for the '<em>Qualified Name Template Binding</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___QUALIFIED_NAME_TEMPLATE_BINDING__DIAGNOSTICCHAIN_MAP = SYNTAX_ELEMENT_OPERATION_COUNT + 13;

	/**
	 * The operation id for the '<em>Qualified Name Template Name Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___QUALIFIED_NAME_TEMPLATE_NAME_DERIVATION__DIAGNOSTICCHAIN_MAP = SYNTAX_ELEMENT_OPERATION_COUNT + 14;

	/**
	 * The operation id for the '<em>Disambiguation Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___DISAMBIGUATION_CACHED = SYNTAX_ELEMENT_OPERATION_COUNT + 15;

	/**
	 * The operation id for the '<em>Disambiguation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___DISAMBIGUATION = SYNTAX_ELEMENT_OPERATION_COUNT + 16;

	/**
	 * The operation id for the '<em>Referent Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___REFERENT_CACHED = SYNTAX_ELEMENT_OPERATION_COUNT + 17;

	/**
	 * The operation id for the '<em>Referent</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME___REFERENT = SYNTAX_ELEMENT_OPERATION_COUNT + 18;

	/**
	 * The number of operations of the '<em>Qualified Name</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUALIFIED_NAME_OPERATION_COUNT = SYNTAX_ELEMENT_OPERATION_COUNT + 19;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.FeatureReferenceImpl <em>Feature Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.FeatureReferenceImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getFeatureReference()
	 * @generated
	 */
	int FEATURE_REFERENCE = 15;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE__OWNER = EXPRESSION__OWNER;

	/**
	 * The feature id for the '<em><b>Upper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE__UPPER = EXPRESSION__UPPER;

	/**
	 * The feature id for the '<em><b>Lower</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE__LOWER = EXPRESSION__LOWER;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE__TYPE = EXPRESSION__TYPE;

	/**
	 * The feature id for the '<em><b>Assignment Before</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE__ASSIGNMENT_BEFORE = EXPRESSION__ASSIGNMENT_BEFORE;

	/**
	 * The feature id for the '<em><b>Assignment After</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE__ASSIGNMENT_AFTER = EXPRESSION__ASSIGNMENT_AFTER;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE__EXPRESSION = EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Referent</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE__REFERENT = EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Name Binding</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE__NAME_BINDING = EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Feature Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE_FEATURE_COUNT = EXPRESSION_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___TO_REFERENCE = EXPRESSION___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___OWNER = EXPRESSION___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___SYNTAX_ELEMENT_OWNER = EXPRESSION___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___CURRENT_SCOPE = EXPRESSION___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___SYNTAX_ELEMENT_CURRENT_SCOPE = EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___ENCLOSING_STATEMENT = EXPRESSION___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___ENCLOSING_EXPRESSION = EXPRESSION___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___ASSIGNMENTS_BEFORE = EXPRESSION___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___UPDATE_ALL__ELIST_ELIST = EXPRESSION___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___COMMON_ANCESTOR__ELIST = EXPRESSION___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___COMMON_ANCESTORS__ELIST = EXPRESSION___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___REMOVE_DUPLICATE_ELEMENTS__ELIST = EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___RESOLVE_IN_LIBRARY__STRING = EXPRESSION___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___PRIMITIVE_TYPE__STRING = EXPRESSION___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___PRIMITIVE_TYPE____STRING = EXPRESSION___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___BOOLEAN_TYPE = EXPRESSION___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___INTEGER_TYPE = EXPRESSION___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___IS_INTEGER_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___STRING_TYPE = EXPRESSION___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___IS_STRING_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___UNLIMITED_NATURAL_TYPE = EXPRESSION___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___BIT_STRING_TYPE = EXPRESSION___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___NATURAL_TYPE = EXPRESSION___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___IS_NATURAL_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___IS_NUMERIC_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___COLLECTION_FUNCTION_ADD = EXPRESSION___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___IS_COLLECTION_CLASS__ELEMENTREFERENCE = EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Type Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___TYPE_CACHED = EXPRESSION___TYPE_CACHED;

	/**
	 * The operation id for the '<em>Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___TYPE = EXPRESSION___TYPE;

	/**
	 * The operation id for the '<em>Lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___LOWER = EXPRESSION___LOWER;

	/**
	 * The operation id for the '<em>Upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___UPPER = EXPRESSION___UPPER;

	/**
	 * The operation id for the '<em>Is Null</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___IS_NULL = EXPRESSION___IS_NULL;

	/**
	 * The operation id for the '<em>Is Assignable From Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE = EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT = EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Type Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT = EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Conformant With Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Multiplicity Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT = EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___REFERENCE = EXPRESSION___REFERENCE;

	/**
	 * The operation id for the '<em>New Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___NEW_ASSIGNMENTS = EXPRESSION___NEW_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Expression update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___EXPRESSION_UPDATE_ASSIGNMENTS = EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Update Assignments Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___UPDATE_ASSIGNMENTS_CACHED = EXPRESSION___UPDATE_ASSIGNMENTS_CACHED;

	/**
	 * The operation id for the '<em>Resolve</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___RESOLVE__STRING = EXPRESSION___RESOLVE__STRING;

	/**
	 * The operation id for the '<em>Is Add Target</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___IS_ADD_TARGET__EXPRESSION = EXPRESSION___IS_ADD_TARGET__EXPRESSION;

	/**
	 * The operation id for the '<em>Expression Assignment After Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Expression Unique Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP = EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___UPDATE_ASSIGNMENTS = EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Behavioral Feature Referent</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___BEHAVIORAL_FEATURE_REFERENT__INVOCATIONEXPRESSION = EXPRESSION_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Feature Reference Referent Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___FEATURE_REFERENCE_REFERENT_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Feature Reference Target Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___FEATURE_REFERENCE_TARGET_TYPE__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Referent Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___REFERENT_CACHED = EXPRESSION_OPERATION_COUNT + 4;

	/**
	 * The operation id for the '<em>Referent</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___REFERENT = EXPRESSION_OPERATION_COUNT + 5;

	/**
	 * The operation id for the '<em>Feature Reference referent</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE___FEATURE_REFERENCE_REFERENT = EXPRESSION_OPERATION_COUNT + 6;

	/**
	 * The number of operations of the '<em>Feature Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_REFERENCE_OPERATION_COUNT = EXPRESSION_OPERATION_COUNT + 7;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.NameBindingImpl <em>Name Binding</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.NameBindingImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getNameBinding()
	 * @generated
	 */
	int NAME_BINDING = 16;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING__OWNER = SYNTAX_ELEMENT__OWNER;

	/**
	 * The feature id for the '<em><b>Binding</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING__BINDING = SYNTAX_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING__NAME = SYNTAX_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Name Binding</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING_FEATURE_COUNT = SYNTAX_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___TO_REFERENCE = SYNTAX_ELEMENT___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___OWNER = SYNTAX_ELEMENT___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___SYNTAX_ELEMENT_OWNER = SYNTAX_ELEMENT___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___CURRENT_SCOPE = SYNTAX_ELEMENT___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___SYNTAX_ELEMENT_CURRENT_SCOPE = SYNTAX_ELEMENT___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___ENCLOSING_STATEMENT = SYNTAX_ELEMENT___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___ENCLOSING_EXPRESSION = SYNTAX_ELEMENT___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___ASSIGNMENTS_BEFORE = SYNTAX_ELEMENT___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = SYNTAX_ELEMENT___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = SYNTAX_ELEMENT___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = SYNTAX_ELEMENT___ASSIGNMENTS_BEFORE__SYNTAXELEMENT;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___UPDATE_ALL__ELIST_ELIST = SYNTAX_ELEMENT___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___COMMON_ANCESTOR__ELIST = SYNTAX_ELEMENT___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___COMMON_ANCESTORS__ELIST = SYNTAX_ELEMENT___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___REMOVE_DUPLICATE_ELEMENTS__ELIST = SYNTAX_ELEMENT___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___RESOLVE_IN_LIBRARY__STRING = SYNTAX_ELEMENT___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___PRIMITIVE_TYPE__STRING = SYNTAX_ELEMENT___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___PRIMITIVE_TYPE____STRING = SYNTAX_ELEMENT___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___BOOLEAN_TYPE = SYNTAX_ELEMENT___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___INTEGER_TYPE = SYNTAX_ELEMENT___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___IS_INTEGER_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___STRING_TYPE = SYNTAX_ELEMENT___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___IS_STRING_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___UNLIMITED_NATURAL_TYPE = SYNTAX_ELEMENT___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___BIT_STRING_TYPE = SYNTAX_ELEMENT___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___NATURAL_TYPE = SYNTAX_ELEMENT___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___IS_NATURAL_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___IS_NUMERIC_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___COLLECTION_FUNCTION_ADD = SYNTAX_ELEMENT___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___IS_COLLECTION_CLASS__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>To String</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___TO_STRING = SYNTAX_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>To Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___TO_NAME = SYNTAX_ELEMENT_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Process</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___PROCESS__STRING = SYNTAX_ELEMENT_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Escape</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___ESCAPE__STRING = SYNTAX_ELEMENT_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Copy</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___COPY = SYNTAX_ELEMENT_OPERATION_COUNT + 4;

	/**
	 * The operation id for the '<em>To Qualified Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___TO_QUALIFIED_NAME__SYNTAXELEMENT = SYNTAX_ELEMENT_OPERATION_COUNT + 5;

	/**
	 * The operation id for the '<em>To Qualified Name With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING___TO_QUALIFIED_NAME_WITH__NAMEBINDING_SYNTAXELEMENT = SYNTAX_ELEMENT_OPERATION_COUNT + 6;

	/**
	 * The number of operations of the '<em>Name Binding</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_BINDING_OPERATION_COUNT = SYNTAX_ELEMENT_OPERATION_COUNT + 7;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.TemplateBindingImpl <em>Template Binding</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.TemplateBindingImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getTemplateBinding()
	 * @generated
	 */
	int TEMPLATE_BINDING = 17;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING__OWNER = SYNTAX_ELEMENT__OWNER;

	/**
	 * The number of structural features of the '<em>Template Binding</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING_FEATURE_COUNT = SYNTAX_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING___TO_REFERENCE = SYNTAX_ELEMENT___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING___OWNER = SYNTAX_ELEMENT___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING___SYNTAX_ELEMENT_OWNER = SYNTAX_ELEMENT___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING___CURRENT_SCOPE = SYNTAX_ELEMENT___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING___SYNTAX_ELEMENT_CURRENT_SCOPE = SYNTAX_ELEMENT___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING___ENCLOSING_STATEMENT = SYNTAX_ELEMENT___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING___ENCLOSING_EXPRESSION = SYNTAX_ELEMENT___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING___ASSIGNMENTS_BEFORE = SYNTAX_ELEMENT___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = SYNTAX_ELEMENT___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = SYNTAX_ELEMENT___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = SYNTAX_ELEMENT___ASSIGNMENTS_BEFORE__SYNTAXELEMENT;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING___UPDATE_ALL__ELIST_ELIST = SYNTAX_ELEMENT___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING___COMMON_ANCESTOR__ELIST = SYNTAX_ELEMENT___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING___COMMON_ANCESTORS__ELIST = SYNTAX_ELEMENT___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING___REMOVE_DUPLICATE_ELEMENTS__ELIST = SYNTAX_ELEMENT___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING___RESOLVE_IN_LIBRARY__STRING = SYNTAX_ELEMENT___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING___PRIMITIVE_TYPE__STRING = SYNTAX_ELEMENT___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING___PRIMITIVE_TYPE____STRING = SYNTAX_ELEMENT___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING___BOOLEAN_TYPE = SYNTAX_ELEMENT___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING___INTEGER_TYPE = SYNTAX_ELEMENT___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING___IS_INTEGER_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING___STRING_TYPE = SYNTAX_ELEMENT___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING___IS_STRING_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING___UNLIMITED_NATURAL_TYPE = SYNTAX_ELEMENT___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING___BIT_STRING_TYPE = SYNTAX_ELEMENT___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING___NATURAL_TYPE = SYNTAX_ELEMENT___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING___IS_NATURAL_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING___IS_NUMERIC_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING___COLLECTION_FUNCTION_ADD = SYNTAX_ELEMENT___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING___IS_COLLECTION_CLASS__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>To String</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING___TO_STRING = SYNTAX_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Matches</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING___MATCHES__ELEMENTREFERENCE = SYNTAX_ELEMENT_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Copy</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING___COPY = SYNTAX_ELEMENT_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Bind To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING___BIND_TO__ELEMENTREFERENCE = SYNTAX_ELEMENT_OPERATION_COUNT + 3;

	/**
	 * The number of operations of the '<em>Template Binding</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING_OPERATION_COUNT = SYNTAX_ELEMENT_OPERATION_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.NamedTemplateBindingImpl <em>Named Template Binding</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.NamedTemplateBindingImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getNamedTemplateBinding()
	 * @generated
	 */
	int NAMED_TEMPLATE_BINDING = 18;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING__OWNER = TEMPLATE_BINDING__OWNER;

	/**
	 * The feature id for the '<em><b>Substitution</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING__SUBSTITUTION = TEMPLATE_BINDING_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Named Template Binding</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING_FEATURE_COUNT = TEMPLATE_BINDING_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___TO_REFERENCE = TEMPLATE_BINDING___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___OWNER = TEMPLATE_BINDING___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___SYNTAX_ELEMENT_OWNER = TEMPLATE_BINDING___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___CURRENT_SCOPE = TEMPLATE_BINDING___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___SYNTAX_ELEMENT_CURRENT_SCOPE = TEMPLATE_BINDING___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___ENCLOSING_STATEMENT = TEMPLATE_BINDING___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___ENCLOSING_EXPRESSION = TEMPLATE_BINDING___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___ASSIGNMENTS_BEFORE = TEMPLATE_BINDING___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = TEMPLATE_BINDING___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = TEMPLATE_BINDING___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = TEMPLATE_BINDING___ASSIGNMENTS_BEFORE__SYNTAXELEMENT;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___UPDATE_ALL__ELIST_ELIST = TEMPLATE_BINDING___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___COMMON_ANCESTOR__ELIST = TEMPLATE_BINDING___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___COMMON_ANCESTORS__ELIST = TEMPLATE_BINDING___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___REMOVE_DUPLICATE_ELEMENTS__ELIST = TEMPLATE_BINDING___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___RESOLVE_IN_LIBRARY__STRING = TEMPLATE_BINDING___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___PRIMITIVE_TYPE__STRING = TEMPLATE_BINDING___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___PRIMITIVE_TYPE____STRING = TEMPLATE_BINDING___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___BOOLEAN_TYPE = TEMPLATE_BINDING___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = TEMPLATE_BINDING___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___INTEGER_TYPE = TEMPLATE_BINDING___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___IS_INTEGER_TYPE__ELEMENTREFERENCE = TEMPLATE_BINDING___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___STRING_TYPE = TEMPLATE_BINDING___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___IS_STRING_TYPE__ELEMENTREFERENCE = TEMPLATE_BINDING___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___UNLIMITED_NATURAL_TYPE = TEMPLATE_BINDING___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = TEMPLATE_BINDING___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___BIT_STRING_TYPE = TEMPLATE_BINDING___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = TEMPLATE_BINDING___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___NATURAL_TYPE = TEMPLATE_BINDING___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___IS_NATURAL_TYPE__ELEMENTREFERENCE = TEMPLATE_BINDING___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___IS_NUMERIC_TYPE__ELEMENTREFERENCE = TEMPLATE_BINDING___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___COLLECTION_FUNCTION_ADD = TEMPLATE_BINDING___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___IS_COLLECTION_CLASS__ELEMENTREFERENCE = TEMPLATE_BINDING___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = TEMPLATE_BINDING___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = TEMPLATE_BINDING___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>To String</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___TO_STRING = TEMPLATE_BINDING_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Matches</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___MATCHES__ELEMENTREFERENCE = TEMPLATE_BINDING_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Matches Parameter</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___MATCHES_PARAMETER__ELEMENTREFERENCE = TEMPLATE_BINDING_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Bind To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___BIND_TO__ELEMENTREFERENCE = TEMPLATE_BINDING_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Copy</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING___COPY = TEMPLATE_BINDING_OPERATION_COUNT + 4;

	/**
	 * The number of operations of the '<em>Named Template Binding</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_TEMPLATE_BINDING_OPERATION_COUNT = TEMPLATE_BINDING_OPERATION_COUNT + 5;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.TemplateParameterSubstitutionImpl <em>Template Parameter Substitution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.TemplateParameterSubstitutionImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getTemplateParameterSubstitution()
	 * @generated
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION = 19;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION__OWNER = SYNTAX_ELEMENT__OWNER;

	/**
	 * The feature id for the '<em><b>Parameter Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION__PARAMETER_NAME = SYNTAX_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Argument Name</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION__ARGUMENT_NAME = SYNTAX_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Referent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION__REFERENT = SYNTAX_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Template Parameter Substitution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION_FEATURE_COUNT = SYNTAX_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION___TO_REFERENCE = SYNTAX_ELEMENT___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION___OWNER = SYNTAX_ELEMENT___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION___SYNTAX_ELEMENT_OWNER = SYNTAX_ELEMENT___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION___CURRENT_SCOPE = SYNTAX_ELEMENT___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION___SYNTAX_ELEMENT_CURRENT_SCOPE = SYNTAX_ELEMENT___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION___ENCLOSING_STATEMENT = SYNTAX_ELEMENT___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION___ENCLOSING_EXPRESSION = SYNTAX_ELEMENT___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION___ASSIGNMENTS_BEFORE = SYNTAX_ELEMENT___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = SYNTAX_ELEMENT___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = SYNTAX_ELEMENT___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = SYNTAX_ELEMENT___ASSIGNMENTS_BEFORE__SYNTAXELEMENT;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION___UPDATE_ALL__ELIST_ELIST = SYNTAX_ELEMENT___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION___COMMON_ANCESTOR__ELIST = SYNTAX_ELEMENT___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION___COMMON_ANCESTORS__ELIST = SYNTAX_ELEMENT___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION___REMOVE_DUPLICATE_ELEMENTS__ELIST = SYNTAX_ELEMENT___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION___RESOLVE_IN_LIBRARY__STRING = SYNTAX_ELEMENT___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION___PRIMITIVE_TYPE__STRING = SYNTAX_ELEMENT___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION___PRIMITIVE_TYPE____STRING = SYNTAX_ELEMENT___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION___BOOLEAN_TYPE = SYNTAX_ELEMENT___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION___INTEGER_TYPE = SYNTAX_ELEMENT___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION___IS_INTEGER_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION___STRING_TYPE = SYNTAX_ELEMENT___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION___IS_STRING_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION___UNLIMITED_NATURAL_TYPE = SYNTAX_ELEMENT___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION___BIT_STRING_TYPE = SYNTAX_ELEMENT___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION___NATURAL_TYPE = SYNTAX_ELEMENT___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION___IS_NATURAL_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION___IS_NUMERIC_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION___COLLECTION_FUNCTION_ADD = SYNTAX_ELEMENT___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION___IS_COLLECTION_CLASS__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Actual Parameter Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION___ACTUAL_PARAMETER_NAME = SYNTAX_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>To String</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION___TO_STRING = SYNTAX_ELEMENT_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Copy</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION___COPY = SYNTAX_ELEMENT_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Template Parameter Substitution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_SUBSTITUTION_OPERATION_COUNT = SYNTAX_ELEMENT_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.UnaryExpressionImpl <em>Unary Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.UnaryExpressionImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getUnaryExpression()
	 * @generated
	 */
	int UNARY_EXPRESSION = 21;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION__OWNER = EXPRESSION__OWNER;

	/**
	 * The feature id for the '<em><b>Upper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION__UPPER = EXPRESSION__UPPER;

	/**
	 * The feature id for the '<em><b>Lower</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION__LOWER = EXPRESSION__LOWER;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION__TYPE = EXPRESSION__TYPE;

	/**
	 * The feature id for the '<em><b>Assignment Before</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION__ASSIGNMENT_BEFORE = EXPRESSION__ASSIGNMENT_BEFORE;

	/**
	 * The feature id for the '<em><b>Assignment After</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION__ASSIGNMENT_AFTER = EXPRESSION__ASSIGNMENT_AFTER;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION__OPERATOR = EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Operand</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION__OPERAND = EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Unary Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION_FEATURE_COUNT = EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___TO_REFERENCE = EXPRESSION___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___OWNER = EXPRESSION___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___SYNTAX_ELEMENT_OWNER = EXPRESSION___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___CURRENT_SCOPE = EXPRESSION___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE = EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___ENCLOSING_STATEMENT = EXPRESSION___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___ENCLOSING_EXPRESSION = EXPRESSION___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___ASSIGNMENTS_BEFORE = EXPRESSION___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___UPDATE_ALL__ELIST_ELIST = EXPRESSION___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___COMMON_ANCESTOR__ELIST = EXPRESSION___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___COMMON_ANCESTORS__ELIST = EXPRESSION___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST = EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___RESOLVE_IN_LIBRARY__STRING = EXPRESSION___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___PRIMITIVE_TYPE__STRING = EXPRESSION___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___PRIMITIVE_TYPE____STRING = EXPRESSION___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___BOOLEAN_TYPE = EXPRESSION___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___INTEGER_TYPE = EXPRESSION___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___STRING_TYPE = EXPRESSION___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___UNLIMITED_NATURAL_TYPE = EXPRESSION___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___BIT_STRING_TYPE = EXPRESSION___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___NATURAL_TYPE = EXPRESSION___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___COLLECTION_FUNCTION_ADD = EXPRESSION___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE = EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Type Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___TYPE_CACHED = EXPRESSION___TYPE_CACHED;

	/**
	 * The operation id for the '<em>Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___TYPE = EXPRESSION___TYPE;

	/**
	 * The operation id for the '<em>Lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___LOWER = EXPRESSION___LOWER;

	/**
	 * The operation id for the '<em>Upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___UPPER = EXPRESSION___UPPER;

	/**
	 * The operation id for the '<em>Is Null</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___IS_NULL = EXPRESSION___IS_NULL;

	/**
	 * The operation id for the '<em>Is Assignable From Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE = EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT = EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Type Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT = EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Conformant With Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Multiplicity Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT = EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___REFERENCE = EXPRESSION___REFERENCE;

	/**
	 * The operation id for the '<em>New Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___NEW_ASSIGNMENTS = EXPRESSION___NEW_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Expression update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS = EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Update Assignments Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___UPDATE_ASSIGNMENTS_CACHED = EXPRESSION___UPDATE_ASSIGNMENTS_CACHED;

	/**
	 * The operation id for the '<em>Resolve</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___RESOLVE__STRING = EXPRESSION___RESOLVE__STRING;

	/**
	 * The operation id for the '<em>Is Add Target</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___IS_ADD_TARGET__EXPRESSION = EXPRESSION___IS_ADD_TARGET__EXPRESSION;

	/**
	 * The operation id for the '<em>Expression Assignment After Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Expression Unique Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP = EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Unary Expression Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___UNARY_EXPRESSION_ASSIGNMENTS_BEFORE__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION___UPDATE_ASSIGNMENTS = EXPRESSION_OPERATION_COUNT + 1;

	/**
	 * The number of operations of the '<em>Unary Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_EXPRESSION_OPERATION_COUNT = EXPRESSION_OPERATION_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.NumericUnaryExpressionImpl <em>Numeric Unary Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.NumericUnaryExpressionImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getNumericUnaryExpression()
	 * @generated
	 */
	int NUMERIC_UNARY_EXPRESSION = 20;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION__OWNER = UNARY_EXPRESSION__OWNER;

	/**
	 * The feature id for the '<em><b>Upper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION__UPPER = UNARY_EXPRESSION__UPPER;

	/**
	 * The feature id for the '<em><b>Lower</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION__LOWER = UNARY_EXPRESSION__LOWER;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION__TYPE = UNARY_EXPRESSION__TYPE;

	/**
	 * The feature id for the '<em><b>Assignment Before</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION__ASSIGNMENT_BEFORE = UNARY_EXPRESSION__ASSIGNMENT_BEFORE;

	/**
	 * The feature id for the '<em><b>Assignment After</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION__ASSIGNMENT_AFTER = UNARY_EXPRESSION__ASSIGNMENT_AFTER;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION__OPERATOR = UNARY_EXPRESSION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Operand</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION__OPERAND = UNARY_EXPRESSION__OPERAND;

	/**
	 * The number of structural features of the '<em>Numeric Unary Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION_FEATURE_COUNT = UNARY_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___TO_REFERENCE = UNARY_EXPRESSION___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___OWNER = UNARY_EXPRESSION___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___SYNTAX_ELEMENT_OWNER = UNARY_EXPRESSION___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___CURRENT_SCOPE = UNARY_EXPRESSION___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE = UNARY_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___ENCLOSING_STATEMENT = UNARY_EXPRESSION___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___ENCLOSING_EXPRESSION = UNARY_EXPRESSION___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___ASSIGNMENTS_BEFORE = UNARY_EXPRESSION___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = UNARY_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = UNARY_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = UNARY_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___UPDATE_ALL__ELIST_ELIST = UNARY_EXPRESSION___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___COMMON_ANCESTOR__ELIST = UNARY_EXPRESSION___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___COMMON_ANCESTORS__ELIST = UNARY_EXPRESSION___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST = UNARY_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___RESOLVE_IN_LIBRARY__STRING = UNARY_EXPRESSION___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___PRIMITIVE_TYPE__STRING = UNARY_EXPRESSION___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___PRIMITIVE_TYPE____STRING = UNARY_EXPRESSION___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___BOOLEAN_TYPE = UNARY_EXPRESSION___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = UNARY_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___INTEGER_TYPE = UNARY_EXPRESSION___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE = UNARY_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___STRING_TYPE = UNARY_EXPRESSION___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE = UNARY_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___UNLIMITED_NATURAL_TYPE = UNARY_EXPRESSION___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = UNARY_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___BIT_STRING_TYPE = UNARY_EXPRESSION___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = UNARY_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___NATURAL_TYPE = UNARY_EXPRESSION___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE = UNARY_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE = UNARY_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___COLLECTION_FUNCTION_ADD = UNARY_EXPRESSION___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE = UNARY_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = UNARY_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = UNARY_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Type Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___TYPE_CACHED = UNARY_EXPRESSION___TYPE_CACHED;

	/**
	 * The operation id for the '<em>Is Null</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___IS_NULL = UNARY_EXPRESSION___IS_NULL;

	/**
	 * The operation id for the '<em>Is Assignable From Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE = UNARY_EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT = UNARY_EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Type Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT = UNARY_EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Conformant With Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE = UNARY_EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Multiplicity Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT = UNARY_EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___REFERENCE = UNARY_EXPRESSION___REFERENCE;

	/**
	 * The operation id for the '<em>New Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___NEW_ASSIGNMENTS = UNARY_EXPRESSION___NEW_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Expression update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS = UNARY_EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Update Assignments Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___UPDATE_ASSIGNMENTS_CACHED = UNARY_EXPRESSION___UPDATE_ASSIGNMENTS_CACHED;

	/**
	 * The operation id for the '<em>Resolve</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___RESOLVE__STRING = UNARY_EXPRESSION___RESOLVE__STRING;

	/**
	 * The operation id for the '<em>Is Add Target</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___IS_ADD_TARGET__EXPRESSION = UNARY_EXPRESSION___IS_ADD_TARGET__EXPRESSION;

	/**
	 * The operation id for the '<em>Expression Assignment After Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP = UNARY_EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Expression Unique Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP = UNARY_EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Unary Expression Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___UNARY_EXPRESSION_ASSIGNMENTS_BEFORE__DIAGNOSTICCHAIN_MAP = UNARY_EXPRESSION___UNARY_EXPRESSION_ASSIGNMENTS_BEFORE__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___UPDATE_ASSIGNMENTS = UNARY_EXPRESSION___UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___TYPE = UNARY_EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___LOWER = UNARY_EXPRESSION_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___UPPER = UNARY_EXPRESSION_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Numeric Unary Expression Type Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___NUMERIC_UNARY_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP = UNARY_EXPRESSION_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Numeric Unary Expression Lower Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___NUMERIC_UNARY_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP = UNARY_EXPRESSION_OPERATION_COUNT + 4;

	/**
	 * The operation id for the '<em>Numeric Unary Expression Upper Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___NUMERIC_UNARY_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP = UNARY_EXPRESSION_OPERATION_COUNT + 5;

	/**
	 * The operation id for the '<em>Numeric Unary Expression Operand</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION___NUMERIC_UNARY_EXPRESSION_OPERAND__DIAGNOSTICCHAIN_MAP = UNARY_EXPRESSION_OPERATION_COUNT + 6;

	/**
	 * The number of operations of the '<em>Numeric Unary Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERIC_UNARY_EXPRESSION_OPERATION_COUNT = UNARY_EXPRESSION_OPERATION_COUNT + 7;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.ForAllOrExistsOrOneExpressionImpl <em>For All Or Exists Or One Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.ForAllOrExistsOrOneExpressionImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getForAllOrExistsOrOneExpression()
	 * @generated
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION = 22;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION__OWNER = SEQUENCE_EXPANSION_EXPRESSION__OWNER;

	/**
	 * The feature id for the '<em><b>Upper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION__UPPER = SEQUENCE_EXPANSION_EXPRESSION__UPPER;

	/**
	 * The feature id for the '<em><b>Lower</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION__LOWER = SEQUENCE_EXPANSION_EXPRESSION__LOWER;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION__TYPE = SEQUENCE_EXPANSION_EXPRESSION__TYPE;

	/**
	 * The feature id for the '<em><b>Assignment Before</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION__ASSIGNMENT_BEFORE = SEQUENCE_EXPANSION_EXPRESSION__ASSIGNMENT_BEFORE;

	/**
	 * The feature id for the '<em><b>Assignment After</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION__ASSIGNMENT_AFTER = SEQUENCE_EXPANSION_EXPRESSION__ASSIGNMENT_AFTER;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION__OPERATION = SEQUENCE_EXPANSION_EXPRESSION__OPERATION;

	/**
	 * The feature id for the '<em><b>Variable</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION__VARIABLE = SEQUENCE_EXPANSION_EXPRESSION__VARIABLE;

	/**
	 * The feature id for the '<em><b>Variable Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION__VARIABLE_SOURCE = SEQUENCE_EXPANSION_EXPRESSION__VARIABLE_SOURCE;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION__ARGUMENT = SEQUENCE_EXPANSION_EXPRESSION__ARGUMENT;

	/**
	 * The feature id for the '<em><b>Primary</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION__PRIMARY = SEQUENCE_EXPANSION_EXPRESSION__PRIMARY;

	/**
	 * The feature id for the '<em><b>Is Select Or Reject</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION__IS_SELECT_OR_REJECT = SEQUENCE_EXPANSION_EXPRESSION__IS_SELECT_OR_REJECT;

	/**
	 * The feature id for the '<em><b>Is Collect Or Iterate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION__IS_COLLECT_OR_ITERATE = SEQUENCE_EXPANSION_EXPRESSION__IS_COLLECT_OR_ITERATE;

	/**
	 * The feature id for the '<em><b>Is For All Or Exists Or One</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION__IS_FOR_ALL_OR_EXISTS_OR_ONE = SEQUENCE_EXPANSION_EXPRESSION__IS_FOR_ALL_OR_EXISTS_OR_ONE;

	/**
	 * The feature id for the '<em><b>Is Is Unique</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION__IS_IS_UNIQUE = SEQUENCE_EXPANSION_EXPRESSION__IS_IS_UNIQUE;

	/**
	 * The number of structural features of the '<em>For All Or Exists Or One Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION_FEATURE_COUNT = SEQUENCE_EXPANSION_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___TO_REFERENCE = SEQUENCE_EXPANSION_EXPRESSION___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___OWNER = SEQUENCE_EXPANSION_EXPRESSION___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___SYNTAX_ELEMENT_OWNER = SEQUENCE_EXPANSION_EXPRESSION___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___CURRENT_SCOPE = SEQUENCE_EXPANSION_EXPRESSION___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE = SEQUENCE_EXPANSION_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___ENCLOSING_STATEMENT = SEQUENCE_EXPANSION_EXPRESSION___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___ENCLOSING_EXPRESSION = SEQUENCE_EXPANSION_EXPRESSION___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___ASSIGNMENTS_BEFORE = SEQUENCE_EXPANSION_EXPRESSION___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = SEQUENCE_EXPANSION_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = SEQUENCE_EXPANSION_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___UPDATE_ALL__ELIST_ELIST = SEQUENCE_EXPANSION_EXPRESSION___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___COMMON_ANCESTOR__ELIST = SEQUENCE_EXPANSION_EXPRESSION___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___COMMON_ANCESTORS__ELIST = SEQUENCE_EXPANSION_EXPRESSION___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST = SEQUENCE_EXPANSION_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___RESOLVE_IN_LIBRARY__STRING = SEQUENCE_EXPANSION_EXPRESSION___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___PRIMITIVE_TYPE__STRING = SEQUENCE_EXPANSION_EXPRESSION___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___PRIMITIVE_TYPE____STRING = SEQUENCE_EXPANSION_EXPRESSION___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___BOOLEAN_TYPE = SEQUENCE_EXPANSION_EXPRESSION___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___INTEGER_TYPE = SEQUENCE_EXPANSION_EXPRESSION___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___STRING_TYPE = SEQUENCE_EXPANSION_EXPRESSION___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___UNLIMITED_NATURAL_TYPE = SEQUENCE_EXPANSION_EXPRESSION___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___BIT_STRING_TYPE = SEQUENCE_EXPANSION_EXPRESSION___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___NATURAL_TYPE = SEQUENCE_EXPANSION_EXPRESSION___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___COLLECTION_FUNCTION_ADD = SEQUENCE_EXPANSION_EXPRESSION___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Type Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___TYPE_CACHED = SEQUENCE_EXPANSION_EXPRESSION___TYPE_CACHED;

	/**
	 * The operation id for the '<em>Is Null</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___IS_NULL = SEQUENCE_EXPANSION_EXPRESSION___IS_NULL;

	/**
	 * The operation id for the '<em>Is Assignable From Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT = SEQUENCE_EXPANSION_EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Type Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT = SEQUENCE_EXPANSION_EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Conformant With Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Multiplicity Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT = SEQUENCE_EXPANSION_EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___REFERENCE = SEQUENCE_EXPANSION_EXPRESSION___REFERENCE;

	/**
	 * The operation id for the '<em>New Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___NEW_ASSIGNMENTS = SEQUENCE_EXPANSION_EXPRESSION___NEW_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Expression update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS = SEQUENCE_EXPANSION_EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Update Assignments Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___UPDATE_ASSIGNMENTS_CACHED = SEQUENCE_EXPANSION_EXPRESSION___UPDATE_ASSIGNMENTS_CACHED;

	/**
	 * The operation id for the '<em>Resolve</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___RESOLVE__STRING = SEQUENCE_EXPANSION_EXPRESSION___RESOLVE__STRING;

	/**
	 * The operation id for the '<em>Is Add Target</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___IS_ADD_TARGET__EXPRESSION = SEQUENCE_EXPANSION_EXPRESSION___IS_ADD_TARGET__EXPRESSION;

	/**
	 * The operation id for the '<em>Expression Assignment After Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Expression Unique Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = SEQUENCE_EXPANSION_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT;

	/**
	 * The operation id for the '<em>Assignments After Primary</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___ASSIGNMENTS_AFTER_PRIMARY = SEQUENCE_EXPANSION_EXPRESSION___ASSIGNMENTS_AFTER_PRIMARY;

	/**
	 * The operation id for the '<em>Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___TYPE = SEQUENCE_EXPANSION_EXPRESSION___TYPE;

	/**
	 * The operation id for the '<em>Lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___LOWER = SEQUENCE_EXPANSION_EXPRESSION___LOWER;

	/**
	 * The operation id for the '<em>Upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___UPPER = SEQUENCE_EXPANSION_EXPRESSION___UPPER;

	/**
	 * The operation id for the '<em>Sequence Expansion Expression Variable Source Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_VARIABLE_SOURCE_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_VARIABLE_SOURCE_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Sequence Expansion Expression Assignments Before Primary</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_ASSIGNMENTS_BEFORE_PRIMARY__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_ASSIGNMENTS_BEFORE_PRIMARY__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Sequence Expansion Expression Assignments Before Argument</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_ASSIGNMENTS_BEFORE_ARGUMENT__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_ASSIGNMENTS_BEFORE_ARGUMENT__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Sequence Expansion Expression Variable Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_VARIABLE_NAME__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_VARIABLE_NAME__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Sequence Expansion Expression Assignments After Argument</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_ASSIGNMENTS_AFTER_ARGUMENT__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_ASSIGNMENTS_AFTER_ARGUMENT__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Select Or Reject Expression Type Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___SELECT_OR_REJECT_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___SELECT_OR_REJECT_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Select Or Reject Expression Lower Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___SELECT_OR_REJECT_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___SELECT_OR_REJECT_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Select Or Reject Expression Upper Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___SELECT_OR_REJECT_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___SELECT_OR_REJECT_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Select Or Reject Expression Argument</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___SELECT_OR_REJECT_EXPRESSION_ARGUMENT__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___SELECT_OR_REJECT_EXPRESSION_ARGUMENT__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Collect Or Iterate Expression Type Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___COLLECT_OR_ITERATE_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___COLLECT_OR_ITERATE_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Collect Or Iterate Expression Lower Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___COLLECT_OR_ITERATE_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___COLLECT_OR_ITERATE_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Collect Or Iterate Expression Upper Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___COLLECT_OR_ITERATE_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___COLLECT_OR_ITERATE_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Is Unique Expression Type Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___IS_UNIQUE_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___IS_UNIQUE_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Is Unique Expression Lower Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___IS_UNIQUE_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___IS_UNIQUE_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Is Unique Expression Upper Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___IS_UNIQUE_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___IS_UNIQUE_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Is Unique Expression Expression Argument</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___IS_UNIQUE_EXPRESSION_EXPRESSION_ARGUMENT__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___IS_UNIQUE_EXPRESSION_EXPRESSION_ARGUMENT__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___UPDATE_ASSIGNMENTS = SEQUENCE_EXPANSION_EXPRESSION___UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Sequence Expansion Expression Operation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_OPERATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_OPERATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>For All Or Exists Or One Expression Type Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>For All Or Exists Or One Expression Lower Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>For All Or Exists Or One Expression Upper Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>For All Or Exists Or One Expression Argument</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION___FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION_ARGUMENT__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION_OPERATION_COUNT + 3;

	/**
	 * The number of operations of the '<em>For All Or Exists Or One Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION_OPERATION_COUNT = SEQUENCE_EXPANSION_EXPRESSION_OPERATION_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.IsolationExpressionImpl <em>Isolation Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.IsolationExpressionImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getIsolationExpression()
	 * @generated
	 */
	int ISOLATION_EXPRESSION = 23;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION__OWNER = UNARY_EXPRESSION__OWNER;

	/**
	 * The feature id for the '<em><b>Upper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION__UPPER = UNARY_EXPRESSION__UPPER;

	/**
	 * The feature id for the '<em><b>Lower</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION__LOWER = UNARY_EXPRESSION__LOWER;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION__TYPE = UNARY_EXPRESSION__TYPE;

	/**
	 * The feature id for the '<em><b>Assignment Before</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION__ASSIGNMENT_BEFORE = UNARY_EXPRESSION__ASSIGNMENT_BEFORE;

	/**
	 * The feature id for the '<em><b>Assignment After</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION__ASSIGNMENT_AFTER = UNARY_EXPRESSION__ASSIGNMENT_AFTER;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION__OPERATOR = UNARY_EXPRESSION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Operand</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION__OPERAND = UNARY_EXPRESSION__OPERAND;

	/**
	 * The number of structural features of the '<em>Isolation Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION_FEATURE_COUNT = UNARY_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___TO_REFERENCE = UNARY_EXPRESSION___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___OWNER = UNARY_EXPRESSION___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___SYNTAX_ELEMENT_OWNER = UNARY_EXPRESSION___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___CURRENT_SCOPE = UNARY_EXPRESSION___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE = UNARY_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___ENCLOSING_STATEMENT = UNARY_EXPRESSION___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___ENCLOSING_EXPRESSION = UNARY_EXPRESSION___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___ASSIGNMENTS_BEFORE = UNARY_EXPRESSION___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = UNARY_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = UNARY_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = UNARY_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___UPDATE_ALL__ELIST_ELIST = UNARY_EXPRESSION___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___COMMON_ANCESTOR__ELIST = UNARY_EXPRESSION___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___COMMON_ANCESTORS__ELIST = UNARY_EXPRESSION___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST = UNARY_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___RESOLVE_IN_LIBRARY__STRING = UNARY_EXPRESSION___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___PRIMITIVE_TYPE__STRING = UNARY_EXPRESSION___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___PRIMITIVE_TYPE____STRING = UNARY_EXPRESSION___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___BOOLEAN_TYPE = UNARY_EXPRESSION___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = UNARY_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___INTEGER_TYPE = UNARY_EXPRESSION___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE = UNARY_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___STRING_TYPE = UNARY_EXPRESSION___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE = UNARY_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___UNLIMITED_NATURAL_TYPE = UNARY_EXPRESSION___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = UNARY_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___BIT_STRING_TYPE = UNARY_EXPRESSION___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = UNARY_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___NATURAL_TYPE = UNARY_EXPRESSION___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE = UNARY_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE = UNARY_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___COLLECTION_FUNCTION_ADD = UNARY_EXPRESSION___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE = UNARY_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = UNARY_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = UNARY_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Type Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___TYPE_CACHED = UNARY_EXPRESSION___TYPE_CACHED;

	/**
	 * The operation id for the '<em>Is Null</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___IS_NULL = UNARY_EXPRESSION___IS_NULL;

	/**
	 * The operation id for the '<em>Is Assignable From Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE = UNARY_EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT = UNARY_EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Type Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT = UNARY_EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Conformant With Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE = UNARY_EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Multiplicity Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT = UNARY_EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___REFERENCE = UNARY_EXPRESSION___REFERENCE;

	/**
	 * The operation id for the '<em>New Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___NEW_ASSIGNMENTS = UNARY_EXPRESSION___NEW_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Expression update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS = UNARY_EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Update Assignments Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___UPDATE_ASSIGNMENTS_CACHED = UNARY_EXPRESSION___UPDATE_ASSIGNMENTS_CACHED;

	/**
	 * The operation id for the '<em>Resolve</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___RESOLVE__STRING = UNARY_EXPRESSION___RESOLVE__STRING;

	/**
	 * The operation id for the '<em>Is Add Target</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___IS_ADD_TARGET__EXPRESSION = UNARY_EXPRESSION___IS_ADD_TARGET__EXPRESSION;

	/**
	 * The operation id for the '<em>Expression Assignment After Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP = UNARY_EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Expression Unique Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP = UNARY_EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Unary Expression Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___UNARY_EXPRESSION_ASSIGNMENTS_BEFORE__DIAGNOSTICCHAIN_MAP = UNARY_EXPRESSION___UNARY_EXPRESSION_ASSIGNMENTS_BEFORE__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___UPDATE_ASSIGNMENTS = UNARY_EXPRESSION___UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___TYPE = UNARY_EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___LOWER = UNARY_EXPRESSION_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___UPPER = UNARY_EXPRESSION_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Isolation Expression Type Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___ISOLATION_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP = UNARY_EXPRESSION_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Isolation Expression Lower Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___ISOLATION_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP = UNARY_EXPRESSION_OPERATION_COUNT + 4;

	/**
	 * The operation id for the '<em>Isolation Expression Upper Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION___ISOLATION_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP = UNARY_EXPRESSION_OPERATION_COUNT + 5;

	/**
	 * The number of operations of the '<em>Isolation Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ISOLATION_EXPRESSION_OPERATION_COUNT = UNARY_EXPRESSION_OPERATION_COUNT + 6;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.BinaryExpressionImpl <em>Binary Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.BinaryExpressionImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getBinaryExpression()
	 * @generated
	 */
	int BINARY_EXPRESSION = 24;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION__OWNER = EXPRESSION__OWNER;

	/**
	 * The feature id for the '<em><b>Upper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION__UPPER = EXPRESSION__UPPER;

	/**
	 * The feature id for the '<em><b>Lower</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION__LOWER = EXPRESSION__LOWER;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION__TYPE = EXPRESSION__TYPE;

	/**
	 * The feature id for the '<em><b>Assignment Before</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION__ASSIGNMENT_BEFORE = EXPRESSION__ASSIGNMENT_BEFORE;

	/**
	 * The feature id for the '<em><b>Assignment After</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION__ASSIGNMENT_AFTER = EXPRESSION__ASSIGNMENT_AFTER;

	/**
	 * The feature id for the '<em><b>Operand1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION__OPERAND1 = EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Operand2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION__OPERAND2 = EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION__OPERATOR = EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Binary Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION_FEATURE_COUNT = EXPRESSION_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___TO_REFERENCE = EXPRESSION___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___OWNER = EXPRESSION___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___SYNTAX_ELEMENT_OWNER = EXPRESSION___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___CURRENT_SCOPE = EXPRESSION___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE = EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___ENCLOSING_STATEMENT = EXPRESSION___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___ENCLOSING_EXPRESSION = EXPRESSION___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___ASSIGNMENTS_BEFORE = EXPRESSION___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___UPDATE_ALL__ELIST_ELIST = EXPRESSION___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___COMMON_ANCESTOR__ELIST = EXPRESSION___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___COMMON_ANCESTORS__ELIST = EXPRESSION___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST = EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___RESOLVE_IN_LIBRARY__STRING = EXPRESSION___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___PRIMITIVE_TYPE__STRING = EXPRESSION___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___PRIMITIVE_TYPE____STRING = EXPRESSION___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___BOOLEAN_TYPE = EXPRESSION___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___INTEGER_TYPE = EXPRESSION___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___STRING_TYPE = EXPRESSION___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___UNLIMITED_NATURAL_TYPE = EXPRESSION___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___BIT_STRING_TYPE = EXPRESSION___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___NATURAL_TYPE = EXPRESSION___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___COLLECTION_FUNCTION_ADD = EXPRESSION___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE = EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Type Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___TYPE_CACHED = EXPRESSION___TYPE_CACHED;

	/**
	 * The operation id for the '<em>Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___TYPE = EXPRESSION___TYPE;

	/**
	 * The operation id for the '<em>Lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___LOWER = EXPRESSION___LOWER;

	/**
	 * The operation id for the '<em>Upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___UPPER = EXPRESSION___UPPER;

	/**
	 * The operation id for the '<em>Is Null</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___IS_NULL = EXPRESSION___IS_NULL;

	/**
	 * The operation id for the '<em>Is Assignable From Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE = EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT = EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Type Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT = EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Conformant With Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Multiplicity Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT = EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___REFERENCE = EXPRESSION___REFERENCE;

	/**
	 * The operation id for the '<em>New Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___NEW_ASSIGNMENTS = EXPRESSION___NEW_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Expression update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS = EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Update Assignments Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___UPDATE_ASSIGNMENTS_CACHED = EXPRESSION___UPDATE_ASSIGNMENTS_CACHED;

	/**
	 * The operation id for the '<em>Resolve</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___RESOLVE__STRING = EXPRESSION___RESOLVE__STRING;

	/**
	 * The operation id for the '<em>Is Add Target</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___IS_ADD_TARGET__EXPRESSION = EXPRESSION___IS_ADD_TARGET__EXPRESSION;

	/**
	 * The operation id for the '<em>Expression Assignment After Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Expression Unique Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP = EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Validate Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___VALIDATE_ASSIGNMENTS = EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>No Null Arguments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___NO_NULL_ARGUMENTS = EXPRESSION_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Binary Expression Operand Multiplicity</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___BINARY_EXPRESSION_OPERAND_MULTIPLICITY__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Binary Expression Operand Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___BINARY_EXPRESSION_OPERAND_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION___UPDATE_ASSIGNMENTS = EXPRESSION_OPERATION_COUNT + 4;

	/**
	 * The number of operations of the '<em>Binary Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_EXPRESSION_OPERATION_COUNT = EXPRESSION_OPERATION_COUNT + 5;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.BooleanUnaryExpressionImpl <em>Boolean Unary Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.BooleanUnaryExpressionImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getBooleanUnaryExpression()
	 * @generated
	 */
	int BOOLEAN_UNARY_EXPRESSION = 25;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION__OWNER = UNARY_EXPRESSION__OWNER;

	/**
	 * The feature id for the '<em><b>Upper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION__UPPER = UNARY_EXPRESSION__UPPER;

	/**
	 * The feature id for the '<em><b>Lower</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION__LOWER = UNARY_EXPRESSION__LOWER;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION__TYPE = UNARY_EXPRESSION__TYPE;

	/**
	 * The feature id for the '<em><b>Assignment Before</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION__ASSIGNMENT_BEFORE = UNARY_EXPRESSION__ASSIGNMENT_BEFORE;

	/**
	 * The feature id for the '<em><b>Assignment After</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION__ASSIGNMENT_AFTER = UNARY_EXPRESSION__ASSIGNMENT_AFTER;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION__OPERATOR = UNARY_EXPRESSION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Operand</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION__OPERAND = UNARY_EXPRESSION__OPERAND;

	/**
	 * The number of structural features of the '<em>Boolean Unary Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION_FEATURE_COUNT = UNARY_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___TO_REFERENCE = UNARY_EXPRESSION___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___OWNER = UNARY_EXPRESSION___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___SYNTAX_ELEMENT_OWNER = UNARY_EXPRESSION___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___CURRENT_SCOPE = UNARY_EXPRESSION___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE = UNARY_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___ENCLOSING_STATEMENT = UNARY_EXPRESSION___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___ENCLOSING_EXPRESSION = UNARY_EXPRESSION___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___ASSIGNMENTS_BEFORE = UNARY_EXPRESSION___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = UNARY_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = UNARY_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = UNARY_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___UPDATE_ALL__ELIST_ELIST = UNARY_EXPRESSION___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___COMMON_ANCESTOR__ELIST = UNARY_EXPRESSION___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___COMMON_ANCESTORS__ELIST = UNARY_EXPRESSION___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST = UNARY_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___RESOLVE_IN_LIBRARY__STRING = UNARY_EXPRESSION___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___PRIMITIVE_TYPE__STRING = UNARY_EXPRESSION___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___PRIMITIVE_TYPE____STRING = UNARY_EXPRESSION___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___BOOLEAN_TYPE = UNARY_EXPRESSION___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = UNARY_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___INTEGER_TYPE = UNARY_EXPRESSION___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE = UNARY_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___STRING_TYPE = UNARY_EXPRESSION___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE = UNARY_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___UNLIMITED_NATURAL_TYPE = UNARY_EXPRESSION___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = UNARY_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___BIT_STRING_TYPE = UNARY_EXPRESSION___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = UNARY_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___NATURAL_TYPE = UNARY_EXPRESSION___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE = UNARY_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE = UNARY_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___COLLECTION_FUNCTION_ADD = UNARY_EXPRESSION___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE = UNARY_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = UNARY_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = UNARY_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Type Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___TYPE_CACHED = UNARY_EXPRESSION___TYPE_CACHED;

	/**
	 * The operation id for the '<em>Is Null</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___IS_NULL = UNARY_EXPRESSION___IS_NULL;

	/**
	 * The operation id for the '<em>Is Assignable From Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE = UNARY_EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT = UNARY_EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Type Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT = UNARY_EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Conformant With Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE = UNARY_EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Multiplicity Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT = UNARY_EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___REFERENCE = UNARY_EXPRESSION___REFERENCE;

	/**
	 * The operation id for the '<em>New Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___NEW_ASSIGNMENTS = UNARY_EXPRESSION___NEW_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Expression update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS = UNARY_EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Update Assignments Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___UPDATE_ASSIGNMENTS_CACHED = UNARY_EXPRESSION___UPDATE_ASSIGNMENTS_CACHED;

	/**
	 * The operation id for the '<em>Resolve</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___RESOLVE__STRING = UNARY_EXPRESSION___RESOLVE__STRING;

	/**
	 * The operation id for the '<em>Is Add Target</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___IS_ADD_TARGET__EXPRESSION = UNARY_EXPRESSION___IS_ADD_TARGET__EXPRESSION;

	/**
	 * The operation id for the '<em>Expression Assignment After Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP = UNARY_EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Expression Unique Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP = UNARY_EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Unary Expression Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___UNARY_EXPRESSION_ASSIGNMENTS_BEFORE__DIAGNOSTICCHAIN_MAP = UNARY_EXPRESSION___UNARY_EXPRESSION_ASSIGNMENTS_BEFORE__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___UPDATE_ASSIGNMENTS = UNARY_EXPRESSION___UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___TYPE = UNARY_EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___LOWER = UNARY_EXPRESSION_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___UPPER = UNARY_EXPRESSION_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Boolean Unary Expression Type Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___BOOLEAN_UNARY_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP = UNARY_EXPRESSION_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Boolean Unary Expression Lower Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___BOOLEAN_UNARY_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP = UNARY_EXPRESSION_OPERATION_COUNT + 4;

	/**
	 * The operation id for the '<em>Boolean Unary Expression Upper Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___BOOLEAN_UNARY_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP = UNARY_EXPRESSION_OPERATION_COUNT + 5;

	/**
	 * The operation id for the '<em>Boolean Unary Expression Operand</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION___BOOLEAN_UNARY_EXPRESSION_OPERAND__DIAGNOSTICCHAIN_MAP = UNARY_EXPRESSION_OPERATION_COUNT + 6;

	/**
	 * The number of operations of the '<em>Boolean Unary Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_UNARY_EXPRESSION_OPERATION_COUNT = UNARY_EXPRESSION_OPERATION_COUNT + 7;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.CastExpressionImpl <em>Cast Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.CastExpressionImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getCastExpression()
	 * @generated
	 */
	int CAST_EXPRESSION = 26;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION__OWNER = EXPRESSION__OWNER;

	/**
	 * The feature id for the '<em><b>Upper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION__UPPER = EXPRESSION__UPPER;

	/**
	 * The feature id for the '<em><b>Lower</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION__LOWER = EXPRESSION__LOWER;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION__TYPE = EXPRESSION__TYPE;

	/**
	 * The feature id for the '<em><b>Assignment Before</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION__ASSIGNMENT_BEFORE = EXPRESSION__ASSIGNMENT_BEFORE;

	/**
	 * The feature id for the '<em><b>Assignment After</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION__ASSIGNMENT_AFTER = EXPRESSION__ASSIGNMENT_AFTER;

	/**
	 * The feature id for the '<em><b>Operand</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION__OPERAND = EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Type Name</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION__TYPE_NAME = EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Is Any</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION__IS_ANY = EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Cast Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION_FEATURE_COUNT = EXPRESSION_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___TO_REFERENCE = EXPRESSION___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___OWNER = EXPRESSION___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___SYNTAX_ELEMENT_OWNER = EXPRESSION___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___CURRENT_SCOPE = EXPRESSION___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE = EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___ENCLOSING_STATEMENT = EXPRESSION___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___ENCLOSING_EXPRESSION = EXPRESSION___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___ASSIGNMENTS_BEFORE = EXPRESSION___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___UPDATE_ALL__ELIST_ELIST = EXPRESSION___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___COMMON_ANCESTOR__ELIST = EXPRESSION___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___COMMON_ANCESTORS__ELIST = EXPRESSION___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST = EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___RESOLVE_IN_LIBRARY__STRING = EXPRESSION___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___PRIMITIVE_TYPE__STRING = EXPRESSION___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___PRIMITIVE_TYPE____STRING = EXPRESSION___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___BOOLEAN_TYPE = EXPRESSION___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___INTEGER_TYPE = EXPRESSION___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___STRING_TYPE = EXPRESSION___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___UNLIMITED_NATURAL_TYPE = EXPRESSION___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___BIT_STRING_TYPE = EXPRESSION___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___NATURAL_TYPE = EXPRESSION___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___COLLECTION_FUNCTION_ADD = EXPRESSION___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE = EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Type Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___TYPE_CACHED = EXPRESSION___TYPE_CACHED;

	/**
	 * The operation id for the '<em>Is Null</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___IS_NULL = EXPRESSION___IS_NULL;

	/**
	 * The operation id for the '<em>Is Assignable From Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE = EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT = EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Type Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT = EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Conformant With Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Multiplicity Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT = EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___REFERENCE = EXPRESSION___REFERENCE;

	/**
	 * The operation id for the '<em>New Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___NEW_ASSIGNMENTS = EXPRESSION___NEW_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Expression update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS = EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Update Assignments Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___UPDATE_ASSIGNMENTS_CACHED = EXPRESSION___UPDATE_ASSIGNMENTS_CACHED;

	/**
	 * The operation id for the '<em>Resolve</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___RESOLVE__STRING = EXPRESSION___RESOLVE__STRING;

	/**
	 * The operation id for the '<em>Is Add Target</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___IS_ADD_TARGET__EXPRESSION = EXPRESSION___IS_ADD_TARGET__EXPRESSION;

	/**
	 * The operation id for the '<em>Expression Assignment After Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Expression Unique Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP = EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___TYPE = EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___LOWER = EXPRESSION_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___UPPER = EXPRESSION_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Cast Expression Type Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___CAST_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Cast Expression Lower Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___CAST_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 4;

	/**
	 * The operation id for the '<em>Cast Expression Upper Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___CAST_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 5;

	/**
	 * The operation id for the '<em>Cast Expression Type Resolution</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___CAST_EXPRESSION_TYPE_RESOLUTION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 6;

	/**
	 * The operation id for the '<em>Cast Expression Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___CAST_EXPRESSION_ASSIGNMENTS_BEFORE__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 7;

	/**
	 * The operation id for the '<em>Update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION___UPDATE_ASSIGNMENTS = EXPRESSION_OPERATION_COUNT + 8;

	/**
	 * The number of operations of the '<em>Cast Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAST_EXPRESSION_OPERATION_COUNT = EXPRESSION_OPERATION_COUNT + 9;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.TupleImpl <em>Tuple</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.TupleImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getTuple()
	 * @generated
	 */
	int TUPLE = 28;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE__OWNER = SYNTAX_ELEMENT__OWNER;

	/**
	 * The feature id for the '<em><b>Input</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE__INPUT = SYNTAX_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Invocation</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE__INVOCATION = SYNTAX_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Output</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE__OUTPUT = SYNTAX_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Tuple</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE_FEATURE_COUNT = SYNTAX_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___TO_REFERENCE = SYNTAX_ELEMENT___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___OWNER = SYNTAX_ELEMENT___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___SYNTAX_ELEMENT_OWNER = SYNTAX_ELEMENT___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___CURRENT_SCOPE = SYNTAX_ELEMENT___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___SYNTAX_ELEMENT_CURRENT_SCOPE = SYNTAX_ELEMENT___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___ENCLOSING_STATEMENT = SYNTAX_ELEMENT___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___ENCLOSING_EXPRESSION = SYNTAX_ELEMENT___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___ASSIGNMENTS_BEFORE = SYNTAX_ELEMENT___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = SYNTAX_ELEMENT___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = SYNTAX_ELEMENT___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___UPDATE_ALL__ELIST_ELIST = SYNTAX_ELEMENT___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___COMMON_ANCESTOR__ELIST = SYNTAX_ELEMENT___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___COMMON_ANCESTORS__ELIST = SYNTAX_ELEMENT___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___REMOVE_DUPLICATE_ELEMENTS__ELIST = SYNTAX_ELEMENT___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___RESOLVE_IN_LIBRARY__STRING = SYNTAX_ELEMENT___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___PRIMITIVE_TYPE__STRING = SYNTAX_ELEMENT___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___PRIMITIVE_TYPE____STRING = SYNTAX_ELEMENT___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___BOOLEAN_TYPE = SYNTAX_ELEMENT___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___INTEGER_TYPE = SYNTAX_ELEMENT___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___IS_INTEGER_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___STRING_TYPE = SYNTAX_ELEMENT___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___IS_STRING_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___UNLIMITED_NATURAL_TYPE = SYNTAX_ELEMENT___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___BIT_STRING_TYPE = SYNTAX_ELEMENT___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___NATURAL_TYPE = SYNTAX_ELEMENT___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___IS_NATURAL_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___IS_NUMERIC_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___COLLECTION_FUNCTION_ADD = SYNTAX_ELEMENT___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___IS_COLLECTION_CLASS__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Size</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___SIZE = SYNTAX_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Input Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___INPUT_CACHED = SYNTAX_ELEMENT_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Input</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___INPUT = SYNTAX_ELEMENT_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Input For</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___INPUT_FOR__ELIST = SYNTAX_ELEMENT_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Output Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___OUTPUT_CACHED = SYNTAX_ELEMENT_OPERATION_COUNT + 4;

	/**
	 * The operation id for the '<em>Output</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___OUTPUT = SYNTAX_ELEMENT_OPERATION_COUNT + 5;

	/**
	 * The operation id for the '<em>Output For</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___OUTPUT_FOR__ELIST = SYNTAX_ELEMENT_OPERATION_COUNT + 6;

	/**
	 * The operation id for the '<em>Output For Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___OUTPUT_FOR_EXPRESSION__EXPRESSION = SYNTAX_ELEMENT_OPERATION_COUNT + 7;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = SYNTAX_ELEMENT_OPERATION_COUNT + 8;

	/**
	 * The operation id for the '<em>Assignments After</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___ASSIGNMENTS_AFTER = SYNTAX_ELEMENT_OPERATION_COUNT + 9;

	/**
	 * The operation id for the '<em>New Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___NEW_ASSIGNMENTS = SYNTAX_ELEMENT_OPERATION_COUNT + 10;

	/**
	 * The operation id for the '<em>Update For</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___UPDATE_FOR__ELIST_OUTPUTNAMEDEXPRESSION = SYNTAX_ELEMENT_OPERATION_COUNT + 11;

	/**
	 * The operation id for the '<em>Tuple Input Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___TUPLE_INPUT_DERIVATION__DIAGNOSTICCHAIN_MAP = SYNTAX_ELEMENT_OPERATION_COUNT + 12;

	/**
	 * The operation id for the '<em>Tuple Output Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___TUPLE_OUTPUT_DERIVATION__DIAGNOSTICCHAIN_MAP = SYNTAX_ELEMENT_OPERATION_COUNT + 13;

	/**
	 * The operation id for the '<em>Tuple Null Inputs</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___TUPLE_NULL_INPUTS__DIAGNOSTICCHAIN_MAP = SYNTAX_ELEMENT_OPERATION_COUNT + 14;

	/**
	 * The operation id for the '<em>Tuple Outputs</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___TUPLE_OUTPUTS__DIAGNOSTICCHAIN_MAP = SYNTAX_ELEMENT_OPERATION_COUNT + 15;

	/**
	 * The operation id for the '<em>Tuple Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___TUPLE_ASSIGNMENTS_BEFORE__DIAGNOSTICCHAIN_MAP = SYNTAX_ELEMENT_OPERATION_COUNT + 16;

	/**
	 * The operation id for the '<em>Tuple Assignments After</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE___TUPLE_ASSIGNMENTS_AFTER__DIAGNOSTICCHAIN_MAP = SYNTAX_ELEMENT_OPERATION_COUNT + 17;

	/**
	 * The number of operations of the '<em>Tuple</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE_OPERATION_COUNT = SYNTAX_ELEMENT_OPERATION_COUNT + 18;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.PositionalTupleImpl <em>Positional Tuple</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.PositionalTupleImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getPositionalTuple()
	 * @generated
	 */
	int POSITIONAL_TUPLE = 27;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE__OWNER = TUPLE__OWNER;

	/**
	 * The feature id for the '<em><b>Input</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE__INPUT = TUPLE__INPUT;

	/**
	 * The feature id for the '<em><b>Invocation</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE__INVOCATION = TUPLE__INVOCATION;

	/**
	 * The feature id for the '<em><b>Output</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE__OUTPUT = TUPLE__OUTPUT;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE__EXPRESSION = TUPLE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Positional Tuple</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE_FEATURE_COUNT = TUPLE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___TO_REFERENCE = TUPLE___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___OWNER = TUPLE___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___SYNTAX_ELEMENT_OWNER = TUPLE___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___CURRENT_SCOPE = TUPLE___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___SYNTAX_ELEMENT_CURRENT_SCOPE = TUPLE___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___ENCLOSING_STATEMENT = TUPLE___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___ENCLOSING_EXPRESSION = TUPLE___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___ASSIGNMENTS_BEFORE = TUPLE___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = TUPLE___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = TUPLE___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___UPDATE_ALL__ELIST_ELIST = TUPLE___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___COMMON_ANCESTOR__ELIST = TUPLE___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___COMMON_ANCESTORS__ELIST = TUPLE___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___REMOVE_DUPLICATE_ELEMENTS__ELIST = TUPLE___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___RESOLVE_IN_LIBRARY__STRING = TUPLE___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___PRIMITIVE_TYPE__STRING = TUPLE___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___PRIMITIVE_TYPE____STRING = TUPLE___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___BOOLEAN_TYPE = TUPLE___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = TUPLE___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___INTEGER_TYPE = TUPLE___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___IS_INTEGER_TYPE__ELEMENTREFERENCE = TUPLE___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___STRING_TYPE = TUPLE___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___IS_STRING_TYPE__ELEMENTREFERENCE = TUPLE___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___UNLIMITED_NATURAL_TYPE = TUPLE___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = TUPLE___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___BIT_STRING_TYPE = TUPLE___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = TUPLE___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___NATURAL_TYPE = TUPLE___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___IS_NATURAL_TYPE__ELEMENTREFERENCE = TUPLE___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___IS_NUMERIC_TYPE__ELEMENTREFERENCE = TUPLE___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___COLLECTION_FUNCTION_ADD = TUPLE___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___IS_COLLECTION_CLASS__ELEMENTREFERENCE = TUPLE___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = TUPLE___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = TUPLE___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Input Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___INPUT_CACHED = TUPLE___INPUT_CACHED;

	/**
	 * The operation id for the '<em>Input</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___INPUT = TUPLE___INPUT;

	/**
	 * The operation id for the '<em>Output Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___OUTPUT_CACHED = TUPLE___OUTPUT_CACHED;

	/**
	 * The operation id for the '<em>Output</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___OUTPUT = TUPLE___OUTPUT;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = TUPLE___ASSIGNMENTS_BEFORE__SYNTAXELEMENT;

	/**
	 * The operation id for the '<em>Assignments After</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___ASSIGNMENTS_AFTER = TUPLE___ASSIGNMENTS_AFTER;

	/**
	 * The operation id for the '<em>New Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___NEW_ASSIGNMENTS = TUPLE___NEW_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Update For</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___UPDATE_FOR__ELIST_OUTPUTNAMEDEXPRESSION = TUPLE___UPDATE_FOR__ELIST_OUTPUTNAMEDEXPRESSION;

	/**
	 * The operation id for the '<em>Tuple Input Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___TUPLE_INPUT_DERIVATION__DIAGNOSTICCHAIN_MAP = TUPLE___TUPLE_INPUT_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Tuple Output Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___TUPLE_OUTPUT_DERIVATION__DIAGNOSTICCHAIN_MAP = TUPLE___TUPLE_OUTPUT_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Tuple Null Inputs</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___TUPLE_NULL_INPUTS__DIAGNOSTICCHAIN_MAP = TUPLE___TUPLE_NULL_INPUTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Tuple Outputs</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___TUPLE_OUTPUTS__DIAGNOSTICCHAIN_MAP = TUPLE___TUPLE_OUTPUTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Tuple Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___TUPLE_ASSIGNMENTS_BEFORE__DIAGNOSTICCHAIN_MAP = TUPLE___TUPLE_ASSIGNMENTS_BEFORE__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Tuple Assignments After</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___TUPLE_ASSIGNMENTS_AFTER__DIAGNOSTICCHAIN_MAP = TUPLE___TUPLE_ASSIGNMENTS_AFTER__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Size</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___SIZE = TUPLE_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Input For</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___INPUT_FOR__ELIST = TUPLE_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Output For</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___OUTPUT_FOR__ELIST = TUPLE_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Output For Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___OUTPUT_FOR_EXPRESSION__EXPRESSION = TUPLE_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Positional Tuple Arguments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE___POSITIONAL_TUPLE_ARGUMENTS__DIAGNOSTICCHAIN_MAP = TUPLE_OPERATION_COUNT + 4;

	/**
	 * The number of operations of the '<em>Positional Tuple</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TUPLE_OPERATION_COUNT = TUPLE_OPERATION_COUNT + 5;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.NamedExpressionImpl <em>Named Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.NamedExpressionImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getNamedExpression()
	 * @generated
	 */
	int NAMED_EXPRESSION = 29;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION__OWNER = SYNTAX_ELEMENT__OWNER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION__NAME = SYNTAX_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION__EXPRESSION = SYNTAX_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Index</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION__INDEX = SYNTAX_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Named Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION_FEATURE_COUNT = SYNTAX_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION___TO_REFERENCE = SYNTAX_ELEMENT___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION___OWNER = SYNTAX_ELEMENT___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION___SYNTAX_ELEMENT_OWNER = SYNTAX_ELEMENT___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION___CURRENT_SCOPE = SYNTAX_ELEMENT___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE = SYNTAX_ELEMENT___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION___ENCLOSING_STATEMENT = SYNTAX_ELEMENT___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION___ENCLOSING_EXPRESSION = SYNTAX_ELEMENT___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION___ASSIGNMENTS_BEFORE = SYNTAX_ELEMENT___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = SYNTAX_ELEMENT___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = SYNTAX_ELEMENT___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = SYNTAX_ELEMENT___ASSIGNMENTS_BEFORE__SYNTAXELEMENT;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION___UPDATE_ALL__ELIST_ELIST = SYNTAX_ELEMENT___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION___COMMON_ANCESTOR__ELIST = SYNTAX_ELEMENT___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION___COMMON_ANCESTORS__ELIST = SYNTAX_ELEMENT___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST = SYNTAX_ELEMENT___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION___RESOLVE_IN_LIBRARY__STRING = SYNTAX_ELEMENT___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION___PRIMITIVE_TYPE__STRING = SYNTAX_ELEMENT___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION___PRIMITIVE_TYPE____STRING = SYNTAX_ELEMENT___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION___BOOLEAN_TYPE = SYNTAX_ELEMENT___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION___INTEGER_TYPE = SYNTAX_ELEMENT___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION___STRING_TYPE = SYNTAX_ELEMENT___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION___UNLIMITED_NATURAL_TYPE = SYNTAX_ELEMENT___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION___BIT_STRING_TYPE = SYNTAX_ELEMENT___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION___NATURAL_TYPE = SYNTAX_ELEMENT___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION___COLLECTION_FUNCTION_ADD = SYNTAX_ELEMENT___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Actual Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION___ACTUAL_NAME = SYNTAX_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Named Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_EXPRESSION_OPERATION_COUNT = SYNTAX_ELEMENT_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.InputNamedExpressionImpl <em>Input Named Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.InputNamedExpressionImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getInputNamedExpression()
	 * @generated
	 */
	int INPUT_NAMED_EXPRESSION = 30;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION__OWNER = SYNTAX_ELEMENT__OWNER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION__NAME = SYNTAX_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION__EXPRESSION = SYNTAX_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Index</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION__INDEX = SYNTAX_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Is Collection Conversion</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION__IS_COLLECTION_CONVERSION = SYNTAX_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Is Bit String Conversion</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION__IS_BIT_STRING_CONVERSION = SYNTAX_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Input Named Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION_FEATURE_COUNT = SYNTAX_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION___TO_REFERENCE = SYNTAX_ELEMENT___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION___OWNER = SYNTAX_ELEMENT___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION___SYNTAX_ELEMENT_OWNER = SYNTAX_ELEMENT___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION___CURRENT_SCOPE = SYNTAX_ELEMENT___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE = SYNTAX_ELEMENT___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION___ENCLOSING_STATEMENT = SYNTAX_ELEMENT___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION___ENCLOSING_EXPRESSION = SYNTAX_ELEMENT___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION___ASSIGNMENTS_BEFORE = SYNTAX_ELEMENT___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = SYNTAX_ELEMENT___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = SYNTAX_ELEMENT___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = SYNTAX_ELEMENT___ASSIGNMENTS_BEFORE__SYNTAXELEMENT;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION___UPDATE_ALL__ELIST_ELIST = SYNTAX_ELEMENT___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION___COMMON_ANCESTOR__ELIST = SYNTAX_ELEMENT___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION___COMMON_ANCESTORS__ELIST = SYNTAX_ELEMENT___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST = SYNTAX_ELEMENT___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION___RESOLVE_IN_LIBRARY__STRING = SYNTAX_ELEMENT___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION___PRIMITIVE_TYPE__STRING = SYNTAX_ELEMENT___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION___PRIMITIVE_TYPE____STRING = SYNTAX_ELEMENT___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION___BOOLEAN_TYPE = SYNTAX_ELEMENT___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION___INTEGER_TYPE = SYNTAX_ELEMENT___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION___STRING_TYPE = SYNTAX_ELEMENT___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION___UNLIMITED_NATURAL_TYPE = SYNTAX_ELEMENT___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION___BIT_STRING_TYPE = SYNTAX_ELEMENT___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION___NATURAL_TYPE = SYNTAX_ELEMENT___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION___COLLECTION_FUNCTION_ADD = SYNTAX_ELEMENT___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Tuple</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION___TUPLE = SYNTAX_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Named Expression Is Collection Conversion Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION___NAMED_EXPRESSION_IS_COLLECTION_CONVERSION_DERIVATION__DIAGNOSTICCHAIN_MAP = SYNTAX_ELEMENT_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Named Expression Is Bit String Conversion Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION___NAMED_EXPRESSION_IS_BIT_STRING_CONVERSION_DERIVATION__DIAGNOSTICCHAIN_MAP = SYNTAX_ELEMENT_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Input Named Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INPUT_NAMED_EXPRESSION_OPERATION_COUNT = SYNTAX_ELEMENT_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.InvocationExpressionImpl <em>Invocation Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.InvocationExpressionImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getInvocationExpression()
	 * @generated
	 */
	int INVOCATION_EXPRESSION = 31;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION__OWNER = EXPRESSION__OWNER;

	/**
	 * The feature id for the '<em><b>Upper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION__UPPER = EXPRESSION__UPPER;

	/**
	 * The feature id for the '<em><b>Lower</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION__LOWER = EXPRESSION__LOWER;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION__TYPE = EXPRESSION__TYPE;

	/**
	 * The feature id for the '<em><b>Assignment Before</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION__ASSIGNMENT_BEFORE = EXPRESSION__ASSIGNMENT_BEFORE;

	/**
	 * The feature id for the '<em><b>Assignment After</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION__ASSIGNMENT_AFTER = EXPRESSION__ASSIGNMENT_AFTER;

	/**
	 * The feature id for the '<em><b>Is Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION__IS_BEHAVIOR = EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Is Association End</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION__IS_ASSOCIATION_END = EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Feature</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION__FEATURE = EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Is Operation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION__IS_OPERATION = EXPRESSION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Is Destructor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION__IS_DESTRUCTOR = EXPRESSION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Is Implicit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION__IS_IMPLICIT = EXPRESSION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Referent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION__REFERENT = EXPRESSION_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Parameter</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION__PARAMETER = EXPRESSION_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Is Signal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION__IS_SIGNAL = EXPRESSION_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Tuple</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION__TUPLE = EXPRESSION_FEATURE_COUNT + 9;

	/**
	 * The number of structural features of the '<em>Invocation Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION_FEATURE_COUNT = EXPRESSION_FEATURE_COUNT + 10;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___TO_REFERENCE = EXPRESSION___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___OWNER = EXPRESSION___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___SYNTAX_ELEMENT_OWNER = EXPRESSION___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___CURRENT_SCOPE = EXPRESSION___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE = EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___ENCLOSING_STATEMENT = EXPRESSION___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___ENCLOSING_EXPRESSION = EXPRESSION___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___ASSIGNMENTS_BEFORE = EXPRESSION___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___UPDATE_ALL__ELIST_ELIST = EXPRESSION___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___COMMON_ANCESTOR__ELIST = EXPRESSION___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___COMMON_ANCESTORS__ELIST = EXPRESSION___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST = EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___RESOLVE_IN_LIBRARY__STRING = EXPRESSION___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___PRIMITIVE_TYPE__STRING = EXPRESSION___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___PRIMITIVE_TYPE____STRING = EXPRESSION___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___BOOLEAN_TYPE = EXPRESSION___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___INTEGER_TYPE = EXPRESSION___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___STRING_TYPE = EXPRESSION___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___UNLIMITED_NATURAL_TYPE = EXPRESSION___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___BIT_STRING_TYPE = EXPRESSION___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___NATURAL_TYPE = EXPRESSION___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___COLLECTION_FUNCTION_ADD = EXPRESSION___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE = EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Type Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___TYPE_CACHED = EXPRESSION___TYPE_CACHED;

	/**
	 * The operation id for the '<em>Is Null</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___IS_NULL = EXPRESSION___IS_NULL;

	/**
	 * The operation id for the '<em>Is Assignable From Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE = EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT = EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Type Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT = EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Conformant With Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Multiplicity Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT = EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___REFERENCE = EXPRESSION___REFERENCE;

	/**
	 * The operation id for the '<em>New Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___NEW_ASSIGNMENTS = EXPRESSION___NEW_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Expression update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS = EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Update Assignments Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___UPDATE_ASSIGNMENTS_CACHED = EXPRESSION___UPDATE_ASSIGNMENTS_CACHED;

	/**
	 * The operation id for the '<em>Resolve</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___RESOLVE__STRING = EXPRESSION___RESOLVE__STRING;

	/**
	 * The operation id for the '<em>Is Add Target</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___IS_ADD_TARGET__EXPRESSION = EXPRESSION___IS_ADD_TARGET__EXPRESSION;

	/**
	 * The operation id for the '<em>Expression Assignment After Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Expression Unique Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP = EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Feature</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___FEATURE = EXPRESSION_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Referent</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___REFERENT = EXPRESSION_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Referent Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___REFERENT_CACHED = EXPRESSION_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___TYPE = EXPRESSION_OPERATION_COUNT + 4;

	/**
	 * The operation id for the '<em>Invocation Expression type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_TYPE = EXPRESSION_OPERATION_COUNT + 5;

	/**
	 * The operation id for the '<em>Upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___UPPER = EXPRESSION_OPERATION_COUNT + 6;

	/**
	 * The operation id for the '<em>Invocation Expression upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_UPPER = EXPRESSION_OPERATION_COUNT + 7;

	/**
	 * The operation id for the '<em>Lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___LOWER = EXPRESSION_OPERATION_COUNT + 8;

	/**
	 * The operation id for the '<em>Invocation Expression lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_LOWER = EXPRESSION_OPERATION_COUNT + 9;

	/**
	 * The operation id for the '<em>Parameter Named</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___PARAMETER_NAMED__STRING = EXPRESSION_OPERATION_COUNT + 10;

	/**
	 * The operation id for the '<em>Parameter Count</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___PARAMETER_COUNT = EXPRESSION_OPERATION_COUNT + 11;

	/**
	 * The operation id for the '<em>Parameter Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___PARAMETER_IS_ASSIGNABLE_FROM__INPUTNAMEDEXPRESSION = EXPRESSION_OPERATION_COUNT + 12;

	/**
	 * The operation id for the '<em>Parameter Is Assignable To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___PARAMETER_IS_ASSIGNABLE_TO__OUTPUTNAMEDEXPRESSION = EXPRESSION_OPERATION_COUNT + 13;

	/**
	 * The operation id for the '<em>Alternative Constructor Is Valid</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___ALTERNATIVE_CONSTRUCTOR_IS_VALID = EXPRESSION_OPERATION_COUNT + 14;

	/**
	 * The operation id for the '<em>Bind Template Implicit Arguments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___BIND_TEMPLATE_IMPLICIT_ARGUMENTS__ELEMENTREFERENCE_EXPRESSION = EXPRESSION_OPERATION_COUNT + 15;

	/**
	 * The operation id for the '<em>Bind Template Implicit Arguments1</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___BIND_TEMPLATE_IMPLICIT_ARGUMENTS1__ELEMENTREFERENCE_EXPRESSION = EXPRESSION_OPERATION_COUNT + 16;

	/**
	 * The operation id for the '<em>Effective Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___EFFECTIVE_TYPE__ELEMENTREFERENCE_EXPRESSION = EXPRESSION_OPERATION_COUNT + 17;

	/**
	 * The operation id for the '<em>Parameter Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___PARAMETER_ELEMENTS = EXPRESSION_OPERATION_COUNT + 18;

	/**
	 * The operation id for the '<em>Invocation Expression parameter Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_PARAMETER_ELEMENTS = EXPRESSION_OPERATION_COUNT + 19;

	/**
	 * The operation id for the '<em>Parameter From Property</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___PARAMETER_FROM_PROPERTY__ELEMENTREFERENCE = EXPRESSION_OPERATION_COUNT + 20;

	/**
	 * The operation id for the '<em>Parameter From Property With Multiplicity</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___PARAMETER_FROM_PROPERTY_WITH_MULTIPLICITY__ELEMENTREFERENCE_STRING_STRING = EXPRESSION_OPERATION_COUNT + 21;

	/**
	 * The operation id for the '<em>Invocation Expression Is Behavior Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_IS_BEHAVIOR_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 22;

	/**
	 * The operation id for the '<em>Invocation Expression Is Association End Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_IS_ASSOCIATION_END_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 23;

	/**
	 * The operation id for the '<em>Invocation Expression Is Operation Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_IS_OPERATION_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 24;

	/**
	 * The operation id for the '<em>Invocation Expression Is Destructor Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_IS_DESTRUCTOR_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 25;

	/**
	 * The operation id for the '<em>Invocation Expression Is Implicit Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_IS_IMPLICIT_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 26;

	/**
	 * The operation id for the '<em>Invocation Expression Is Signal Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_IS_SIGNAL_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 27;

	/**
	 * The operation id for the '<em>Invocation Expression Parameter Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_PARAMETER_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 28;

	/**
	 * The operation id for the '<em>Invocation Expression Type Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 29;

	/**
	 * The operation id for the '<em>Invocation Expression Upper Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 30;

	/**
	 * The operation id for the '<em>Invocation Expression Lower Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 31;

	/**
	 * The operation id for the '<em>Invocation Expression Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_ASSIGNMENTS_BEFORE__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 32;

	/**
	 * The operation id for the '<em>Update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___UPDATE_ASSIGNMENTS = EXPRESSION_OPERATION_COUNT + 33;

	/**
	 * The operation id for the '<em>Invocation Expression Template Parameters</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_TEMPLATE_PARAMETERS__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 34;

	/**
	 * The number of operations of the '<em>Invocation Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVOCATION_EXPRESSION_OPERATION_COUNT = EXPRESSION_OPERATION_COUNT + 35;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.OutputNamedExpressionImpl <em>Output Named Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.OutputNamedExpressionImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getOutputNamedExpression()
	 * @generated
	 */
	int OUTPUT_NAMED_EXPRESSION = 32;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION__OWNER = INPUT_NAMED_EXPRESSION__OWNER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION__NAME = INPUT_NAMED_EXPRESSION__NAME;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION__EXPRESSION = INPUT_NAMED_EXPRESSION__EXPRESSION;

	/**
	 * The feature id for the '<em><b>Index</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION__INDEX = INPUT_NAMED_EXPRESSION__INDEX;

	/**
	 * The feature id for the '<em><b>Is Collection Conversion</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION__IS_COLLECTION_CONVERSION = INPUT_NAMED_EXPRESSION__IS_COLLECTION_CONVERSION;

	/**
	 * The feature id for the '<em><b>Is Bit String Conversion</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION__IS_BIT_STRING_CONVERSION = INPUT_NAMED_EXPRESSION__IS_BIT_STRING_CONVERSION;

	/**
	 * The feature id for the '<em><b>Left Hand Side</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION__LEFT_HAND_SIDE = INPUT_NAMED_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Output Named Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION_FEATURE_COUNT = INPUT_NAMED_EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___TO_REFERENCE = INPUT_NAMED_EXPRESSION___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___OWNER = INPUT_NAMED_EXPRESSION___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___SYNTAX_ELEMENT_OWNER = INPUT_NAMED_EXPRESSION___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___CURRENT_SCOPE = INPUT_NAMED_EXPRESSION___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE = INPUT_NAMED_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___ENCLOSING_STATEMENT = INPUT_NAMED_EXPRESSION___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___ENCLOSING_EXPRESSION = INPUT_NAMED_EXPRESSION___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___ASSIGNMENTS_BEFORE = INPUT_NAMED_EXPRESSION___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = INPUT_NAMED_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = INPUT_NAMED_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = INPUT_NAMED_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___UPDATE_ALL__ELIST_ELIST = INPUT_NAMED_EXPRESSION___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___COMMON_ANCESTOR__ELIST = INPUT_NAMED_EXPRESSION___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___COMMON_ANCESTORS__ELIST = INPUT_NAMED_EXPRESSION___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST = INPUT_NAMED_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___RESOLVE_IN_LIBRARY__STRING = INPUT_NAMED_EXPRESSION___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___PRIMITIVE_TYPE__STRING = INPUT_NAMED_EXPRESSION___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___PRIMITIVE_TYPE____STRING = INPUT_NAMED_EXPRESSION___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___BOOLEAN_TYPE = INPUT_NAMED_EXPRESSION___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = INPUT_NAMED_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___INTEGER_TYPE = INPUT_NAMED_EXPRESSION___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE = INPUT_NAMED_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___STRING_TYPE = INPUT_NAMED_EXPRESSION___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE = INPUT_NAMED_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___UNLIMITED_NATURAL_TYPE = INPUT_NAMED_EXPRESSION___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = INPUT_NAMED_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___BIT_STRING_TYPE = INPUT_NAMED_EXPRESSION___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = INPUT_NAMED_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___NATURAL_TYPE = INPUT_NAMED_EXPRESSION___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE = INPUT_NAMED_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE = INPUT_NAMED_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___COLLECTION_FUNCTION_ADD = INPUT_NAMED_EXPRESSION___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE = INPUT_NAMED_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = INPUT_NAMED_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = INPUT_NAMED_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Tuple</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___TUPLE = INPUT_NAMED_EXPRESSION___TUPLE;

	/**
	 * The operation id for the '<em>Named Expression Is Collection Conversion Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___NAMED_EXPRESSION_IS_COLLECTION_CONVERSION_DERIVATION__DIAGNOSTICCHAIN_MAP = INPUT_NAMED_EXPRESSION___NAMED_EXPRESSION_IS_COLLECTION_CONVERSION_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Named Expression Is Bit String Conversion Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___NAMED_EXPRESSION_IS_BIT_STRING_CONVERSION_DERIVATION__DIAGNOSTICCHAIN_MAP = INPUT_NAMED_EXPRESSION___NAMED_EXPRESSION_IS_BIT_STRING_CONVERSION_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Output Named Expression Left Hand Side Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___OUTPUT_NAMED_EXPRESSION_LEFT_HAND_SIDE_DERIVATION__DIAGNOSTICCHAIN_MAP = INPUT_NAMED_EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Output Named Expression Form</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___OUTPUT_NAMED_EXPRESSION_FORM__DIAGNOSTICCHAIN_MAP = INPUT_NAMED_EXPRESSION_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Has Legal Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION___HAS_LEGAL_EXPRESSION = INPUT_NAMED_EXPRESSION_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Output Named Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_NAMED_EXPRESSION_OPERATION_COUNT = INPUT_NAMED_EXPRESSION_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.LeftHandSideImpl <em>Left Hand Side</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.LeftHandSideImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getLeftHandSide()
	 * @generated
	 */
	int LEFT_HAND_SIDE = 33;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE__OWNER = ASSIGNABLE_ELEMENT__OWNER;

	/**
	 * The feature id for the '<em><b>Upper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE__UPPER = ASSIGNABLE_ELEMENT__UPPER;

	/**
	 * The feature id for the '<em><b>Lower</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE__LOWER = ASSIGNABLE_ELEMENT__LOWER;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE__TYPE = ASSIGNABLE_ELEMENT__TYPE;

	/**
	 * The feature id for the '<em><b>Assignment Before</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE__ASSIGNMENT_BEFORE = ASSIGNABLE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Assignment After</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE__ASSIGNMENT_AFTER = ASSIGNABLE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Referent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE__REFERENT = ASSIGNABLE_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Left Hand Side</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE_FEATURE_COUNT = ASSIGNABLE_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___TO_REFERENCE = ASSIGNABLE_ELEMENT___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___OWNER = ASSIGNABLE_ELEMENT___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___SYNTAX_ELEMENT_OWNER = ASSIGNABLE_ELEMENT___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___CURRENT_SCOPE = ASSIGNABLE_ELEMENT___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___SYNTAX_ELEMENT_CURRENT_SCOPE = ASSIGNABLE_ELEMENT___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___ENCLOSING_STATEMENT = ASSIGNABLE_ELEMENT___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___ENCLOSING_EXPRESSION = ASSIGNABLE_ELEMENT___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___ASSIGNMENTS_BEFORE = ASSIGNABLE_ELEMENT___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = ASSIGNABLE_ELEMENT___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = ASSIGNABLE_ELEMENT___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___UPDATE_ALL__ELIST_ELIST = ASSIGNABLE_ELEMENT___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___COMMON_ANCESTOR__ELIST = ASSIGNABLE_ELEMENT___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___COMMON_ANCESTORS__ELIST = ASSIGNABLE_ELEMENT___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___REMOVE_DUPLICATE_ELEMENTS__ELIST = ASSIGNABLE_ELEMENT___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___RESOLVE_IN_LIBRARY__STRING = ASSIGNABLE_ELEMENT___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___PRIMITIVE_TYPE__STRING = ASSIGNABLE_ELEMENT___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___PRIMITIVE_TYPE____STRING = ASSIGNABLE_ELEMENT___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___BOOLEAN_TYPE = ASSIGNABLE_ELEMENT___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = ASSIGNABLE_ELEMENT___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___INTEGER_TYPE = ASSIGNABLE_ELEMENT___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___IS_INTEGER_TYPE__ELEMENTREFERENCE = ASSIGNABLE_ELEMENT___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___STRING_TYPE = ASSIGNABLE_ELEMENT___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___IS_STRING_TYPE__ELEMENTREFERENCE = ASSIGNABLE_ELEMENT___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___UNLIMITED_NATURAL_TYPE = ASSIGNABLE_ELEMENT___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = ASSIGNABLE_ELEMENT___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___BIT_STRING_TYPE = ASSIGNABLE_ELEMENT___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = ASSIGNABLE_ELEMENT___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___NATURAL_TYPE = ASSIGNABLE_ELEMENT___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___IS_NATURAL_TYPE__ELEMENTREFERENCE = ASSIGNABLE_ELEMENT___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___IS_NUMERIC_TYPE__ELEMENTREFERENCE = ASSIGNABLE_ELEMENT___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___COLLECTION_FUNCTION_ADD = ASSIGNABLE_ELEMENT___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___IS_COLLECTION_CLASS__ELEMENTREFERENCE = ASSIGNABLE_ELEMENT___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = ASSIGNABLE_ELEMENT___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = ASSIGNABLE_ELEMENT___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Type Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___TYPE_CACHED = ASSIGNABLE_ELEMENT___TYPE_CACHED;

	/**
	 * The operation id for the '<em>Is Null</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___IS_NULL = ASSIGNABLE_ELEMENT___IS_NULL;

	/**
	 * The operation id for the '<em>Is Assignable From Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE = ASSIGNABLE_ELEMENT___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT = ASSIGNABLE_ELEMENT___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Type Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT = ASSIGNABLE_ELEMENT___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Conformant With Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE = ASSIGNABLE_ELEMENT___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Multiplicity Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT = ASSIGNABLE_ELEMENT___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = ASSIGNABLE_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Assignments After</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___ASSIGNMENTS_AFTER = ASSIGNABLE_ELEMENT_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___TYPE = ASSIGNABLE_ELEMENT_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Left Hand Side type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___LEFT_HAND_SIDE_TYPE = ASSIGNABLE_ELEMENT_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___UPPER = ASSIGNABLE_ELEMENT_OPERATION_COUNT + 4;

	/**
	 * The operation id for the '<em>Left Hand Side upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___LEFT_HAND_SIDE_UPPER = ASSIGNABLE_ELEMENT_OPERATION_COUNT + 5;

	/**
	 * The operation id for the '<em>Lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___LOWER = ASSIGNABLE_ELEMENT_OPERATION_COUNT + 6;

	/**
	 * The operation id for the '<em>Left Hand Side lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___LEFT_HAND_SIDE_LOWER = ASSIGNABLE_ELEMENT_OPERATION_COUNT + 7;

	/**
	 * The operation id for the '<em>Referent</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___REFERENT = ASSIGNABLE_ELEMENT_OPERATION_COUNT + 8;

	/**
	 * The operation id for the '<em>Assigned Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___ASSIGNED_NAME = ASSIGNABLE_ELEMENT_OPERATION_COUNT + 9;

	/**
	 * The operation id for the '<em>Local Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___LOCAL_NAME = ASSIGNABLE_ELEMENT_OPERATION_COUNT + 10;

	/**
	 * The operation id for the '<em>Feature</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___FEATURE = ASSIGNABLE_ELEMENT_OPERATION_COUNT + 11;

	/**
	 * The operation id for the '<em>Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___EXPRESSION = ASSIGNABLE_ELEMENT_OPERATION_COUNT + 12;

	/**
	 * The operation id for the '<em>Is Data Value Update</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___IS_DATA_VALUE_UPDATE = ASSIGNABLE_ELEMENT_OPERATION_COUNT + 13;

	/**
	 * The operation id for the '<em>Left Hand Side Index Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___LEFT_HAND_SIDE_INDEX_EXPRESSION__DIAGNOSTICCHAIN_MAP = ASSIGNABLE_ELEMENT_OPERATION_COUNT + 14;

	/**
	 * The operation id for the '<em>Index</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE___INDEX = ASSIGNABLE_ELEMENT_OPERATION_COUNT + 15;

	/**
	 * The number of operations of the '<em>Left Hand Side</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LEFT_HAND_SIDE_OPERATION_COUNT = ASSIGNABLE_ELEMENT_OPERATION_COUNT + 16;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.SequenceAccessExpressionImpl <em>Sequence Access Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.SequenceAccessExpressionImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getSequenceAccessExpression()
	 * @generated
	 */
	int SEQUENCE_ACCESS_EXPRESSION = 34;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION__OWNER = EXPRESSION__OWNER;

	/**
	 * The feature id for the '<em><b>Upper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION__UPPER = EXPRESSION__UPPER;

	/**
	 * The feature id for the '<em><b>Lower</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION__LOWER = EXPRESSION__LOWER;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION__TYPE = EXPRESSION__TYPE;

	/**
	 * The feature id for the '<em><b>Assignment Before</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION__ASSIGNMENT_BEFORE = EXPRESSION__ASSIGNMENT_BEFORE;

	/**
	 * The feature id for the '<em><b>Assignment After</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION__ASSIGNMENT_AFTER = EXPRESSION__ASSIGNMENT_AFTER;

	/**
	 * The feature id for the '<em><b>Primary</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION__PRIMARY = EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Index</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION__INDEX = EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Sequence Access Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION_FEATURE_COUNT = EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___TO_REFERENCE = EXPRESSION___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___OWNER = EXPRESSION___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___SYNTAX_ELEMENT_OWNER = EXPRESSION___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___CURRENT_SCOPE = EXPRESSION___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE = EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___ENCLOSING_STATEMENT = EXPRESSION___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___ENCLOSING_EXPRESSION = EXPRESSION___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___ASSIGNMENTS_BEFORE = EXPRESSION___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___UPDATE_ALL__ELIST_ELIST = EXPRESSION___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___COMMON_ANCESTOR__ELIST = EXPRESSION___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___COMMON_ANCESTORS__ELIST = EXPRESSION___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST = EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___RESOLVE_IN_LIBRARY__STRING = EXPRESSION___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___PRIMITIVE_TYPE__STRING = EXPRESSION___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___PRIMITIVE_TYPE____STRING = EXPRESSION___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___BOOLEAN_TYPE = EXPRESSION___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___INTEGER_TYPE = EXPRESSION___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___STRING_TYPE = EXPRESSION___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___UNLIMITED_NATURAL_TYPE = EXPRESSION___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___BIT_STRING_TYPE = EXPRESSION___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___NATURAL_TYPE = EXPRESSION___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___COLLECTION_FUNCTION_ADD = EXPRESSION___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE = EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Type Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___TYPE_CACHED = EXPRESSION___TYPE_CACHED;

	/**
	 * The operation id for the '<em>Is Null</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___IS_NULL = EXPRESSION___IS_NULL;

	/**
	 * The operation id for the '<em>Is Assignable From Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE = EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT = EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Type Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT = EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Conformant With Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Multiplicity Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT = EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___REFERENCE = EXPRESSION___REFERENCE;

	/**
	 * The operation id for the '<em>New Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___NEW_ASSIGNMENTS = EXPRESSION___NEW_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Expression update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS = EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Update Assignments Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___UPDATE_ASSIGNMENTS_CACHED = EXPRESSION___UPDATE_ASSIGNMENTS_CACHED;

	/**
	 * The operation id for the '<em>Resolve</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___RESOLVE__STRING = EXPRESSION___RESOLVE__STRING;

	/**
	 * The operation id for the '<em>Is Add Target</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___IS_ADD_TARGET__EXPRESSION = EXPRESSION___IS_ADD_TARGET__EXPRESSION;

	/**
	 * The operation id for the '<em>Expression Assignment After Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Expression Unique Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP = EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___TYPE = EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___LOWER = EXPRESSION_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___UPPER = EXPRESSION_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___UPDATE_ASSIGNMENTS = EXPRESSION_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Sequence Access Expression Type Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___SEQUENCE_ACCESS_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 4;

	/**
	 * The operation id for the '<em>Sequence Access Expression Lower Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___SEQUENCE_ACCESS_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 5;

	/**
	 * The operation id for the '<em>Sequence Access Expression Upper Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___SEQUENCE_ACCESS_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 6;

	/**
	 * The operation id for the '<em>Sequence Access Expression Index Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___SEQUENCE_ACCESS_EXPRESSION_INDEX_TYPE__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 7;

	/**
	 * The operation id for the '<em>Sequence Access Expression Index Multiplicity</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION___SEQUENCE_ACCESS_EXPRESSION_INDEX_MULTIPLICITY__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 8;

	/**
	 * The number of operations of the '<em>Sequence Access Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ACCESS_EXPRESSION_OPERATION_COUNT = EXPRESSION_OPERATION_COUNT + 9;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.LiteralExpressionImpl <em>Literal Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.LiteralExpressionImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getLiteralExpression()
	 * @generated
	 */
	int LITERAL_EXPRESSION = 36;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION__OWNER = EXPRESSION__OWNER;

	/**
	 * The feature id for the '<em><b>Upper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION__UPPER = EXPRESSION__UPPER;

	/**
	 * The feature id for the '<em><b>Lower</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION__LOWER = EXPRESSION__LOWER;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION__TYPE = EXPRESSION__TYPE;

	/**
	 * The feature id for the '<em><b>Assignment Before</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION__ASSIGNMENT_BEFORE = EXPRESSION__ASSIGNMENT_BEFORE;

	/**
	 * The feature id for the '<em><b>Assignment After</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION__ASSIGNMENT_AFTER = EXPRESSION__ASSIGNMENT_AFTER;

	/**
	 * The number of structural features of the '<em>Literal Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION_FEATURE_COUNT = EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___TO_REFERENCE = EXPRESSION___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___OWNER = EXPRESSION___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___SYNTAX_ELEMENT_OWNER = EXPRESSION___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___CURRENT_SCOPE = EXPRESSION___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE = EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___ENCLOSING_STATEMENT = EXPRESSION___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___ENCLOSING_EXPRESSION = EXPRESSION___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___ASSIGNMENTS_BEFORE = EXPRESSION___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___UPDATE_ALL__ELIST_ELIST = EXPRESSION___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___COMMON_ANCESTOR__ELIST = EXPRESSION___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___COMMON_ANCESTORS__ELIST = EXPRESSION___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST = EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___RESOLVE_IN_LIBRARY__STRING = EXPRESSION___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___PRIMITIVE_TYPE__STRING = EXPRESSION___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___PRIMITIVE_TYPE____STRING = EXPRESSION___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___BOOLEAN_TYPE = EXPRESSION___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___INTEGER_TYPE = EXPRESSION___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___STRING_TYPE = EXPRESSION___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___UNLIMITED_NATURAL_TYPE = EXPRESSION___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___BIT_STRING_TYPE = EXPRESSION___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___NATURAL_TYPE = EXPRESSION___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___COLLECTION_FUNCTION_ADD = EXPRESSION___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE = EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Type Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___TYPE_CACHED = EXPRESSION___TYPE_CACHED;

	/**
	 * The operation id for the '<em>Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___TYPE = EXPRESSION___TYPE;

	/**
	 * The operation id for the '<em>Is Null</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___IS_NULL = EXPRESSION___IS_NULL;

	/**
	 * The operation id for the '<em>Is Assignable From Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE = EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT = EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Type Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT = EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Conformant With Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Multiplicity Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT = EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___REFERENCE = EXPRESSION___REFERENCE;

	/**
	 * The operation id for the '<em>New Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___NEW_ASSIGNMENTS = EXPRESSION___NEW_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___UPDATE_ASSIGNMENTS = EXPRESSION___UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Expression update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS = EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Update Assignments Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___UPDATE_ASSIGNMENTS_CACHED = EXPRESSION___UPDATE_ASSIGNMENTS_CACHED;

	/**
	 * The operation id for the '<em>Resolve</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___RESOLVE__STRING = EXPRESSION___RESOLVE__STRING;

	/**
	 * The operation id for the '<em>Is Add Target</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___IS_ADD_TARGET__EXPRESSION = EXPRESSION___IS_ADD_TARGET__EXPRESSION;

	/**
	 * The operation id for the '<em>Expression Assignment After Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Expression Unique Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP = EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___UPPER = EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___LOWER = EXPRESSION_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Literal Expression Upper Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___LITERAL_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Literal Expression Lower Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION___LITERAL_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 3;

	/**
	 * The number of operations of the '<em>Literal Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXPRESSION_OPERATION_COUNT = EXPRESSION_OPERATION_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.StringLiteralExpressionImpl <em>String Literal Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.StringLiteralExpressionImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getStringLiteralExpression()
	 * @generated
	 */
	int STRING_LITERAL_EXPRESSION = 35;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION__OWNER = LITERAL_EXPRESSION__OWNER;

	/**
	 * The feature id for the '<em><b>Upper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION__UPPER = LITERAL_EXPRESSION__UPPER;

	/**
	 * The feature id for the '<em><b>Lower</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION__LOWER = LITERAL_EXPRESSION__LOWER;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION__TYPE = LITERAL_EXPRESSION__TYPE;

	/**
	 * The feature id for the '<em><b>Assignment Before</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION__ASSIGNMENT_BEFORE = LITERAL_EXPRESSION__ASSIGNMENT_BEFORE;

	/**
	 * The feature id for the '<em><b>Assignment After</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION__ASSIGNMENT_AFTER = LITERAL_EXPRESSION__ASSIGNMENT_AFTER;

	/**
	 * The feature id for the '<em><b>Image</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION__IMAGE = LITERAL_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>String Literal Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION_FEATURE_COUNT = LITERAL_EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___TO_REFERENCE = LITERAL_EXPRESSION___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___OWNER = LITERAL_EXPRESSION___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___SYNTAX_ELEMENT_OWNER = LITERAL_EXPRESSION___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___CURRENT_SCOPE = LITERAL_EXPRESSION___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE = LITERAL_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___ENCLOSING_STATEMENT = LITERAL_EXPRESSION___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___ENCLOSING_EXPRESSION = LITERAL_EXPRESSION___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___ASSIGNMENTS_BEFORE = LITERAL_EXPRESSION___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = LITERAL_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = LITERAL_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = LITERAL_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___UPDATE_ALL__ELIST_ELIST = LITERAL_EXPRESSION___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___COMMON_ANCESTOR__ELIST = LITERAL_EXPRESSION___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___COMMON_ANCESTORS__ELIST = LITERAL_EXPRESSION___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST = LITERAL_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___RESOLVE_IN_LIBRARY__STRING = LITERAL_EXPRESSION___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___PRIMITIVE_TYPE__STRING = LITERAL_EXPRESSION___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___PRIMITIVE_TYPE____STRING = LITERAL_EXPRESSION___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___BOOLEAN_TYPE = LITERAL_EXPRESSION___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = LITERAL_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___INTEGER_TYPE = LITERAL_EXPRESSION___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE = LITERAL_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___STRING_TYPE = LITERAL_EXPRESSION___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE = LITERAL_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___UNLIMITED_NATURAL_TYPE = LITERAL_EXPRESSION___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = LITERAL_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___BIT_STRING_TYPE = LITERAL_EXPRESSION___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = LITERAL_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___NATURAL_TYPE = LITERAL_EXPRESSION___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE = LITERAL_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE = LITERAL_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___COLLECTION_FUNCTION_ADD = LITERAL_EXPRESSION___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE = LITERAL_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = LITERAL_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = LITERAL_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Type Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___TYPE_CACHED = LITERAL_EXPRESSION___TYPE_CACHED;

	/**
	 * The operation id for the '<em>Is Null</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___IS_NULL = LITERAL_EXPRESSION___IS_NULL;

	/**
	 * The operation id for the '<em>Is Assignable From Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE = LITERAL_EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT = LITERAL_EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Type Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT = LITERAL_EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Conformant With Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE = LITERAL_EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Multiplicity Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT = LITERAL_EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___REFERENCE = LITERAL_EXPRESSION___REFERENCE;

	/**
	 * The operation id for the '<em>New Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___NEW_ASSIGNMENTS = LITERAL_EXPRESSION___NEW_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___UPDATE_ASSIGNMENTS = LITERAL_EXPRESSION___UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Expression update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS = LITERAL_EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Update Assignments Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___UPDATE_ASSIGNMENTS_CACHED = LITERAL_EXPRESSION___UPDATE_ASSIGNMENTS_CACHED;

	/**
	 * The operation id for the '<em>Resolve</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___RESOLVE__STRING = LITERAL_EXPRESSION___RESOLVE__STRING;

	/**
	 * The operation id for the '<em>Is Add Target</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___IS_ADD_TARGET__EXPRESSION = LITERAL_EXPRESSION___IS_ADD_TARGET__EXPRESSION;

	/**
	 * The operation id for the '<em>Expression Assignment After Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP = LITERAL_EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Expression Unique Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP = LITERAL_EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___UPPER = LITERAL_EXPRESSION___UPPER;

	/**
	 * The operation id for the '<em>Lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___LOWER = LITERAL_EXPRESSION___LOWER;

	/**
	 * The operation id for the '<em>Literal Expression Upper Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___LITERAL_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP = LITERAL_EXPRESSION___LITERAL_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Literal Expression Lower Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___LITERAL_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP = LITERAL_EXPRESSION___LITERAL_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___TYPE = LITERAL_EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>String Literal Expression Type Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION___STRING_LITERAL_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP = LITERAL_EXPRESSION_OPERATION_COUNT + 1;

	/**
	 * The number of operations of the '<em>String Literal Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_LITERAL_EXPRESSION_OPERATION_COUNT = LITERAL_EXPRESSION_OPERATION_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.SequenceOperationExpressionImpl <em>Sequence Operation Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.SequenceOperationExpressionImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getSequenceOperationExpression()
	 * @generated
	 */
	int SEQUENCE_OPERATION_EXPRESSION = 37;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION__OWNER = INVOCATION_EXPRESSION__OWNER;

	/**
	 * The feature id for the '<em><b>Upper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION__UPPER = INVOCATION_EXPRESSION__UPPER;

	/**
	 * The feature id for the '<em><b>Lower</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION__LOWER = INVOCATION_EXPRESSION__LOWER;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION__TYPE = INVOCATION_EXPRESSION__TYPE;

	/**
	 * The feature id for the '<em><b>Assignment Before</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION__ASSIGNMENT_BEFORE = INVOCATION_EXPRESSION__ASSIGNMENT_BEFORE;

	/**
	 * The feature id for the '<em><b>Assignment After</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION__ASSIGNMENT_AFTER = INVOCATION_EXPRESSION__ASSIGNMENT_AFTER;

	/**
	 * The feature id for the '<em><b>Is Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION__IS_BEHAVIOR = INVOCATION_EXPRESSION__IS_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Is Association End</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION__IS_ASSOCIATION_END = INVOCATION_EXPRESSION__IS_ASSOCIATION_END;

	/**
	 * The feature id for the '<em><b>Feature</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION__FEATURE = INVOCATION_EXPRESSION__FEATURE;

	/**
	 * The feature id for the '<em><b>Is Operation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION__IS_OPERATION = INVOCATION_EXPRESSION__IS_OPERATION;

	/**
	 * The feature id for the '<em><b>Is Destructor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION__IS_DESTRUCTOR = INVOCATION_EXPRESSION__IS_DESTRUCTOR;

	/**
	 * The feature id for the '<em><b>Is Implicit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION__IS_IMPLICIT = INVOCATION_EXPRESSION__IS_IMPLICIT;

	/**
	 * The feature id for the '<em><b>Referent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION__REFERENT = INVOCATION_EXPRESSION__REFERENT;

	/**
	 * The feature id for the '<em><b>Parameter</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION__PARAMETER = INVOCATION_EXPRESSION__PARAMETER;

	/**
	 * The feature id for the '<em><b>Is Signal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION__IS_SIGNAL = INVOCATION_EXPRESSION__IS_SIGNAL;

	/**
	 * The feature id for the '<em><b>Tuple</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION__TUPLE = INVOCATION_EXPRESSION__TUPLE;

	/**
	 * The feature id for the '<em><b>Primary</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION__PRIMARY = INVOCATION_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION__OPERATION = INVOCATION_EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Is Collection Conversion</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION__IS_COLLECTION_CONVERSION = INVOCATION_EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Is Bit String Conversion</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION__IS_BIT_STRING_CONVERSION = INVOCATION_EXPRESSION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Left Hand Side</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION__LEFT_HAND_SIDE = INVOCATION_EXPRESSION_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Sequence Operation Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION_FEATURE_COUNT = INVOCATION_EXPRESSION_FEATURE_COUNT + 5;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___TO_REFERENCE = INVOCATION_EXPRESSION___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___OWNER = INVOCATION_EXPRESSION___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___SYNTAX_ELEMENT_OWNER = INVOCATION_EXPRESSION___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___CURRENT_SCOPE = INVOCATION_EXPRESSION___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE = INVOCATION_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___ENCLOSING_STATEMENT = INVOCATION_EXPRESSION___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___ENCLOSING_EXPRESSION = INVOCATION_EXPRESSION___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___ASSIGNMENTS_BEFORE = INVOCATION_EXPRESSION___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = INVOCATION_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = INVOCATION_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___UPDATE_ALL__ELIST_ELIST = INVOCATION_EXPRESSION___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___COMMON_ANCESTOR__ELIST = INVOCATION_EXPRESSION___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___COMMON_ANCESTORS__ELIST = INVOCATION_EXPRESSION___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST = INVOCATION_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___RESOLVE_IN_LIBRARY__STRING = INVOCATION_EXPRESSION___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___PRIMITIVE_TYPE__STRING = INVOCATION_EXPRESSION___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___PRIMITIVE_TYPE____STRING = INVOCATION_EXPRESSION___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___BOOLEAN_TYPE = INVOCATION_EXPRESSION___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = INVOCATION_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___INTEGER_TYPE = INVOCATION_EXPRESSION___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE = INVOCATION_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___STRING_TYPE = INVOCATION_EXPRESSION___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE = INVOCATION_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___UNLIMITED_NATURAL_TYPE = INVOCATION_EXPRESSION___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = INVOCATION_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___BIT_STRING_TYPE = INVOCATION_EXPRESSION___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = INVOCATION_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___NATURAL_TYPE = INVOCATION_EXPRESSION___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE = INVOCATION_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE = INVOCATION_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___COLLECTION_FUNCTION_ADD = INVOCATION_EXPRESSION___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE = INVOCATION_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = INVOCATION_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = INVOCATION_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Type Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___TYPE_CACHED = INVOCATION_EXPRESSION___TYPE_CACHED;

	/**
	 * The operation id for the '<em>Is Null</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___IS_NULL = INVOCATION_EXPRESSION___IS_NULL;

	/**
	 * The operation id for the '<em>Is Assignable From Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE = INVOCATION_EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT = INVOCATION_EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Type Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT = INVOCATION_EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Conformant With Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE = INVOCATION_EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Multiplicity Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT = INVOCATION_EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___REFERENCE = INVOCATION_EXPRESSION___REFERENCE;

	/**
	 * The operation id for the '<em>New Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___NEW_ASSIGNMENTS = INVOCATION_EXPRESSION___NEW_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Expression update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS = INVOCATION_EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Update Assignments Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___UPDATE_ASSIGNMENTS_CACHED = INVOCATION_EXPRESSION___UPDATE_ASSIGNMENTS_CACHED;

	/**
	 * The operation id for the '<em>Resolve</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___RESOLVE__STRING = INVOCATION_EXPRESSION___RESOLVE__STRING;

	/**
	 * The operation id for the '<em>Expression Assignment After Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Expression Unique Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = INVOCATION_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT;

	/**
	 * The operation id for the '<em>Referent Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___REFERENT_CACHED = INVOCATION_EXPRESSION___REFERENT_CACHED;

	/**
	 * The operation id for the '<em>Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___TYPE = INVOCATION_EXPRESSION___TYPE;

	/**
	 * The operation id for the '<em>Invocation Expression type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___INVOCATION_EXPRESSION_TYPE = INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_TYPE;

	/**
	 * The operation id for the '<em>Upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___UPPER = INVOCATION_EXPRESSION___UPPER;

	/**
	 * The operation id for the '<em>Invocation Expression upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___INVOCATION_EXPRESSION_UPPER = INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_UPPER;

	/**
	 * The operation id for the '<em>Lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___LOWER = INVOCATION_EXPRESSION___LOWER;

	/**
	 * The operation id for the '<em>Invocation Expression lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___INVOCATION_EXPRESSION_LOWER = INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_LOWER;

	/**
	 * The operation id for the '<em>Parameter Named</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___PARAMETER_NAMED__STRING = INVOCATION_EXPRESSION___PARAMETER_NAMED__STRING;

	/**
	 * The operation id for the '<em>Parameter Count</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___PARAMETER_COUNT = INVOCATION_EXPRESSION___PARAMETER_COUNT;

	/**
	 * The operation id for the '<em>Parameter Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___PARAMETER_IS_ASSIGNABLE_FROM__INPUTNAMEDEXPRESSION = INVOCATION_EXPRESSION___PARAMETER_IS_ASSIGNABLE_FROM__INPUTNAMEDEXPRESSION;

	/**
	 * The operation id for the '<em>Parameter Is Assignable To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___PARAMETER_IS_ASSIGNABLE_TO__OUTPUTNAMEDEXPRESSION = INVOCATION_EXPRESSION___PARAMETER_IS_ASSIGNABLE_TO__OUTPUTNAMEDEXPRESSION;

	/**
	 * The operation id for the '<em>Alternative Constructor Is Valid</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___ALTERNATIVE_CONSTRUCTOR_IS_VALID = INVOCATION_EXPRESSION___ALTERNATIVE_CONSTRUCTOR_IS_VALID;

	/**
	 * The operation id for the '<em>Bind Template Implicit Arguments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___BIND_TEMPLATE_IMPLICIT_ARGUMENTS__ELEMENTREFERENCE_EXPRESSION = INVOCATION_EXPRESSION___BIND_TEMPLATE_IMPLICIT_ARGUMENTS__ELEMENTREFERENCE_EXPRESSION;

	/**
	 * The operation id for the '<em>Bind Template Implicit Arguments1</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___BIND_TEMPLATE_IMPLICIT_ARGUMENTS1__ELEMENTREFERENCE_EXPRESSION = INVOCATION_EXPRESSION___BIND_TEMPLATE_IMPLICIT_ARGUMENTS1__ELEMENTREFERENCE_EXPRESSION;

	/**
	 * The operation id for the '<em>Effective Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___EFFECTIVE_TYPE__ELEMENTREFERENCE_EXPRESSION = INVOCATION_EXPRESSION___EFFECTIVE_TYPE__ELEMENTREFERENCE_EXPRESSION;

	/**
	 * The operation id for the '<em>Invocation Expression parameter Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___INVOCATION_EXPRESSION_PARAMETER_ELEMENTS = INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_PARAMETER_ELEMENTS;

	/**
	 * The operation id for the '<em>Parameter From Property</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___PARAMETER_FROM_PROPERTY__ELEMENTREFERENCE = INVOCATION_EXPRESSION___PARAMETER_FROM_PROPERTY__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Parameter From Property With Multiplicity</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___PARAMETER_FROM_PROPERTY_WITH_MULTIPLICITY__ELEMENTREFERENCE_STRING_STRING = INVOCATION_EXPRESSION___PARAMETER_FROM_PROPERTY_WITH_MULTIPLICITY__ELEMENTREFERENCE_STRING_STRING;

	/**
	 * The operation id for the '<em>Invocation Expression Is Behavior Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___INVOCATION_EXPRESSION_IS_BEHAVIOR_DERIVATION__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_IS_BEHAVIOR_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Invocation Expression Is Association End Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___INVOCATION_EXPRESSION_IS_ASSOCIATION_END_DERIVATION__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_IS_ASSOCIATION_END_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Invocation Expression Is Operation Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___INVOCATION_EXPRESSION_IS_OPERATION_DERIVATION__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_IS_OPERATION_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Invocation Expression Is Destructor Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___INVOCATION_EXPRESSION_IS_DESTRUCTOR_DERIVATION__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_IS_DESTRUCTOR_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Invocation Expression Is Implicit Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___INVOCATION_EXPRESSION_IS_IMPLICIT_DERIVATION__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_IS_IMPLICIT_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Invocation Expression Is Signal Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___INVOCATION_EXPRESSION_IS_SIGNAL_DERIVATION__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_IS_SIGNAL_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Invocation Expression Parameter Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___INVOCATION_EXPRESSION_PARAMETER_DERIVATION__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_PARAMETER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Invocation Expression Type Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___INVOCATION_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Invocation Expression Upper Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___INVOCATION_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Invocation Expression Lower Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___INVOCATION_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Invocation Expression Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___INVOCATION_EXPRESSION_ASSIGNMENTS_BEFORE__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_ASSIGNMENTS_BEFORE__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Invocation Expression Template Parameters</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___INVOCATION_EXPRESSION_TEMPLATE_PARAMETERS__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_TEMPLATE_PARAMETERS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Feature</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___FEATURE = INVOCATION_EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Referent</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___REFERENT = INVOCATION_EXPRESSION_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Is Add Target</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___IS_ADD_TARGET__EXPRESSION = INVOCATION_EXPRESSION_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>First Parameter</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___FIRST_PARAMETER = INVOCATION_EXPRESSION_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>First Argument</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___FIRST_ARGUMENT = INVOCATION_EXPRESSION_OPERATION_COUNT + 4;

	/**
	 * The operation id for the '<em>Sequence Operation Expression Referent Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___SEQUENCE_OPERATION_EXPRESSION_REFERENT_DERIVATION__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION_OPERATION_COUNT + 5;

	/**
	 * The operation id for the '<em>Sequence Operation Expression Feature Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___SEQUENCE_OPERATION_EXPRESSION_FEATURE_DERIVATION__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION_OPERATION_COUNT + 6;

	/**
	 * The operation id for the '<em>Sequence Operation Expression Operation Referent</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___SEQUENCE_OPERATION_EXPRESSION_OPERATION_REFERENT__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION_OPERATION_COUNT + 7;

	/**
	 * The operation id for the '<em>Sequence Operation Expression Target Compatibility</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___SEQUENCE_OPERATION_EXPRESSION_TARGET_COMPATIBILITY__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION_OPERATION_COUNT + 8;

	/**
	 * The operation id for the '<em>Sequence Operation Expression Argument Compatibility</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___SEQUENCE_OPERATION_EXPRESSION_ARGUMENT_COMPATIBILITY__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION_OPERATION_COUNT + 9;

	/**
	 * The operation id for the '<em>Sequence Operation Expression Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___SEQUENCE_OPERATION_EXPRESSION_ASSIGNMENTS_BEFORE__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION_OPERATION_COUNT + 10;

	/**
	 * The operation id for the '<em>Sequence Operation Expression Is Collection Conversion Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___SEQUENCE_OPERATION_EXPRESSION_IS_COLLECTION_CONVERSION_DERIVATION__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION_OPERATION_COUNT + 11;

	/**
	 * The operation id for the '<em>Sequence Operation Expression Is Bit String Conversion Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___SEQUENCE_OPERATION_EXPRESSION_IS_BIT_STRING_CONVERSION_DERIVATION__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION_OPERATION_COUNT + 12;

	/**
	 * The operation id for the '<em>Sequence Operation Expression Assignments After</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___SEQUENCE_OPERATION_EXPRESSION_ASSIGNMENTS_AFTER__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION_OPERATION_COUNT + 13;

	/**
	 * The operation id for the '<em>Sequence Operation Expression Left Hand Side Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___SEQUENCE_OPERATION_EXPRESSION_LEFT_HAND_SIDE_DERIVATION__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION_OPERATION_COUNT + 14;

	/**
	 * The operation id for the '<em>Update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___UPDATE_ASSIGNMENTS = INVOCATION_EXPRESSION_OPERATION_COUNT + 15;

	/**
	 * The operation id for the '<em>Parameter Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION___PARAMETER_ELEMENTS = INVOCATION_EXPRESSION_OPERATION_COUNT + 16;

	/**
	 * The number of operations of the '<em>Sequence Operation Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_OPERATION_EXPRESSION_OPERATION_COUNT = INVOCATION_EXPRESSION_OPERATION_COUNT + 17;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.SelectOrRejectExpressionImpl <em>Select Or Reject Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.SelectOrRejectExpressionImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getSelectOrRejectExpression()
	 * @generated
	 */
	int SELECT_OR_REJECT_EXPRESSION = 38;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION__OWNER = SEQUENCE_EXPANSION_EXPRESSION__OWNER;

	/**
	 * The feature id for the '<em><b>Upper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION__UPPER = SEQUENCE_EXPANSION_EXPRESSION__UPPER;

	/**
	 * The feature id for the '<em><b>Lower</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION__LOWER = SEQUENCE_EXPANSION_EXPRESSION__LOWER;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION__TYPE = SEQUENCE_EXPANSION_EXPRESSION__TYPE;

	/**
	 * The feature id for the '<em><b>Assignment Before</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION__ASSIGNMENT_BEFORE = SEQUENCE_EXPANSION_EXPRESSION__ASSIGNMENT_BEFORE;

	/**
	 * The feature id for the '<em><b>Assignment After</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION__ASSIGNMENT_AFTER = SEQUENCE_EXPANSION_EXPRESSION__ASSIGNMENT_AFTER;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION__OPERATION = SEQUENCE_EXPANSION_EXPRESSION__OPERATION;

	/**
	 * The feature id for the '<em><b>Variable</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION__VARIABLE = SEQUENCE_EXPANSION_EXPRESSION__VARIABLE;

	/**
	 * The feature id for the '<em><b>Variable Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION__VARIABLE_SOURCE = SEQUENCE_EXPANSION_EXPRESSION__VARIABLE_SOURCE;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION__ARGUMENT = SEQUENCE_EXPANSION_EXPRESSION__ARGUMENT;

	/**
	 * The feature id for the '<em><b>Primary</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION__PRIMARY = SEQUENCE_EXPANSION_EXPRESSION__PRIMARY;

	/**
	 * The feature id for the '<em><b>Is Select Or Reject</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION__IS_SELECT_OR_REJECT = SEQUENCE_EXPANSION_EXPRESSION__IS_SELECT_OR_REJECT;

	/**
	 * The feature id for the '<em><b>Is Collect Or Iterate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION__IS_COLLECT_OR_ITERATE = SEQUENCE_EXPANSION_EXPRESSION__IS_COLLECT_OR_ITERATE;

	/**
	 * The feature id for the '<em><b>Is For All Or Exists Or One</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION__IS_FOR_ALL_OR_EXISTS_OR_ONE = SEQUENCE_EXPANSION_EXPRESSION__IS_FOR_ALL_OR_EXISTS_OR_ONE;

	/**
	 * The feature id for the '<em><b>Is Is Unique</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION__IS_IS_UNIQUE = SEQUENCE_EXPANSION_EXPRESSION__IS_IS_UNIQUE;

	/**
	 * The number of structural features of the '<em>Select Or Reject Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION_FEATURE_COUNT = SEQUENCE_EXPANSION_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___TO_REFERENCE = SEQUENCE_EXPANSION_EXPRESSION___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___OWNER = SEQUENCE_EXPANSION_EXPRESSION___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___SYNTAX_ELEMENT_OWNER = SEQUENCE_EXPANSION_EXPRESSION___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___CURRENT_SCOPE = SEQUENCE_EXPANSION_EXPRESSION___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE = SEQUENCE_EXPANSION_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___ENCLOSING_STATEMENT = SEQUENCE_EXPANSION_EXPRESSION___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___ENCLOSING_EXPRESSION = SEQUENCE_EXPANSION_EXPRESSION___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___ASSIGNMENTS_BEFORE = SEQUENCE_EXPANSION_EXPRESSION___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = SEQUENCE_EXPANSION_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = SEQUENCE_EXPANSION_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___UPDATE_ALL__ELIST_ELIST = SEQUENCE_EXPANSION_EXPRESSION___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___COMMON_ANCESTOR__ELIST = SEQUENCE_EXPANSION_EXPRESSION___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___COMMON_ANCESTORS__ELIST = SEQUENCE_EXPANSION_EXPRESSION___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST = SEQUENCE_EXPANSION_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___RESOLVE_IN_LIBRARY__STRING = SEQUENCE_EXPANSION_EXPRESSION___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___PRIMITIVE_TYPE__STRING = SEQUENCE_EXPANSION_EXPRESSION___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___PRIMITIVE_TYPE____STRING = SEQUENCE_EXPANSION_EXPRESSION___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___BOOLEAN_TYPE = SEQUENCE_EXPANSION_EXPRESSION___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___INTEGER_TYPE = SEQUENCE_EXPANSION_EXPRESSION___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___STRING_TYPE = SEQUENCE_EXPANSION_EXPRESSION___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___UNLIMITED_NATURAL_TYPE = SEQUENCE_EXPANSION_EXPRESSION___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___BIT_STRING_TYPE = SEQUENCE_EXPANSION_EXPRESSION___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___NATURAL_TYPE = SEQUENCE_EXPANSION_EXPRESSION___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___COLLECTION_FUNCTION_ADD = SEQUENCE_EXPANSION_EXPRESSION___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Type Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___TYPE_CACHED = SEQUENCE_EXPANSION_EXPRESSION___TYPE_CACHED;

	/**
	 * The operation id for the '<em>Is Null</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___IS_NULL = SEQUENCE_EXPANSION_EXPRESSION___IS_NULL;

	/**
	 * The operation id for the '<em>Is Assignable From Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT = SEQUENCE_EXPANSION_EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Type Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT = SEQUENCE_EXPANSION_EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Conformant With Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Multiplicity Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT = SEQUENCE_EXPANSION_EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___REFERENCE = SEQUENCE_EXPANSION_EXPRESSION___REFERENCE;

	/**
	 * The operation id for the '<em>New Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___NEW_ASSIGNMENTS = SEQUENCE_EXPANSION_EXPRESSION___NEW_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Expression update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS = SEQUENCE_EXPANSION_EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Update Assignments Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___UPDATE_ASSIGNMENTS_CACHED = SEQUENCE_EXPANSION_EXPRESSION___UPDATE_ASSIGNMENTS_CACHED;

	/**
	 * The operation id for the '<em>Resolve</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___RESOLVE__STRING = SEQUENCE_EXPANSION_EXPRESSION___RESOLVE__STRING;

	/**
	 * The operation id for the '<em>Is Add Target</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___IS_ADD_TARGET__EXPRESSION = SEQUENCE_EXPANSION_EXPRESSION___IS_ADD_TARGET__EXPRESSION;

	/**
	 * The operation id for the '<em>Expression Assignment After Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Expression Unique Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = SEQUENCE_EXPANSION_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT;

	/**
	 * The operation id for the '<em>Assignments After Primary</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___ASSIGNMENTS_AFTER_PRIMARY = SEQUENCE_EXPANSION_EXPRESSION___ASSIGNMENTS_AFTER_PRIMARY;

	/**
	 * The operation id for the '<em>Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___TYPE = SEQUENCE_EXPANSION_EXPRESSION___TYPE;

	/**
	 * The operation id for the '<em>Lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___LOWER = SEQUENCE_EXPANSION_EXPRESSION___LOWER;

	/**
	 * The operation id for the '<em>Upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___UPPER = SEQUENCE_EXPANSION_EXPRESSION___UPPER;

	/**
	 * The operation id for the '<em>Sequence Expansion Expression Variable Source Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_VARIABLE_SOURCE_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_VARIABLE_SOURCE_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Sequence Expansion Expression Assignments Before Primary</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_ASSIGNMENTS_BEFORE_PRIMARY__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_ASSIGNMENTS_BEFORE_PRIMARY__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Sequence Expansion Expression Assignments Before Argument</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_ASSIGNMENTS_BEFORE_ARGUMENT__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_ASSIGNMENTS_BEFORE_ARGUMENT__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Sequence Expansion Expression Variable Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_VARIABLE_NAME__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_VARIABLE_NAME__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Sequence Expansion Expression Assignments After Argument</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_ASSIGNMENTS_AFTER_ARGUMENT__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_ASSIGNMENTS_AFTER_ARGUMENT__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Collect Or Iterate Expression Type Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___COLLECT_OR_ITERATE_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___COLLECT_OR_ITERATE_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Collect Or Iterate Expression Lower Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___COLLECT_OR_ITERATE_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___COLLECT_OR_ITERATE_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Collect Or Iterate Expression Upper Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___COLLECT_OR_ITERATE_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___COLLECT_OR_ITERATE_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>For All Or Exists Or One Expression Type Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>For All Or Exists Or One Expression Lower Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>For All Or Exists Or One Expression Upper Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>For All Or Exists Or One Expression Argument</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION_ARGUMENT__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION_ARGUMENT__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Is Unique Expression Type Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___IS_UNIQUE_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___IS_UNIQUE_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Is Unique Expression Lower Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___IS_UNIQUE_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___IS_UNIQUE_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Is Unique Expression Upper Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___IS_UNIQUE_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___IS_UNIQUE_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Is Unique Expression Expression Argument</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___IS_UNIQUE_EXPRESSION_EXPRESSION_ARGUMENT__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___IS_UNIQUE_EXPRESSION_EXPRESSION_ARGUMENT__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___UPDATE_ASSIGNMENTS = SEQUENCE_EXPANSION_EXPRESSION___UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Sequence Expansion Expression Operation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_OPERATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_OPERATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Select Or Reject Expression Type Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___SELECT_OR_REJECT_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Select Or Reject Expression Lower Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___SELECT_OR_REJECT_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Select Or Reject Expression Upper Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___SELECT_OR_REJECT_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Select Or Reject Expression Argument</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION___SELECT_OR_REJECT_EXPRESSION_ARGUMENT__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION_OPERATION_COUNT + 3;

	/**
	 * The number of operations of the '<em>Select Or Reject Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELECT_OR_REJECT_EXPRESSION_OPERATION_COUNT = SEQUENCE_EXPANSION_EXPRESSION_OPERATION_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.ClassExtentExpressionImpl <em>Class Extent Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.ClassExtentExpressionImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getClassExtentExpression()
	 * @generated
	 */
	int CLASS_EXTENT_EXPRESSION = 39;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION__OWNER = EXPRESSION__OWNER;

	/**
	 * The feature id for the '<em><b>Upper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION__UPPER = EXPRESSION__UPPER;

	/**
	 * The feature id for the '<em><b>Lower</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION__LOWER = EXPRESSION__LOWER;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION__TYPE = EXPRESSION__TYPE;

	/**
	 * The feature id for the '<em><b>Assignment Before</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION__ASSIGNMENT_BEFORE = EXPRESSION__ASSIGNMENT_BEFORE;

	/**
	 * The feature id for the '<em><b>Assignment After</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION__ASSIGNMENT_AFTER = EXPRESSION__ASSIGNMENT_AFTER;

	/**
	 * The feature id for the '<em><b>Class Name</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION__CLASS_NAME = EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Class Extent Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION_FEATURE_COUNT = EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___TO_REFERENCE = EXPRESSION___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___OWNER = EXPRESSION___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___SYNTAX_ELEMENT_OWNER = EXPRESSION___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___CURRENT_SCOPE = EXPRESSION___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE = EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___ENCLOSING_STATEMENT = EXPRESSION___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___ENCLOSING_EXPRESSION = EXPRESSION___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___ASSIGNMENTS_BEFORE = EXPRESSION___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___UPDATE_ALL__ELIST_ELIST = EXPRESSION___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___COMMON_ANCESTOR__ELIST = EXPRESSION___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___COMMON_ANCESTORS__ELIST = EXPRESSION___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST = EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___RESOLVE_IN_LIBRARY__STRING = EXPRESSION___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___PRIMITIVE_TYPE__STRING = EXPRESSION___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___PRIMITIVE_TYPE____STRING = EXPRESSION___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___BOOLEAN_TYPE = EXPRESSION___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___INTEGER_TYPE = EXPRESSION___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___STRING_TYPE = EXPRESSION___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___UNLIMITED_NATURAL_TYPE = EXPRESSION___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___BIT_STRING_TYPE = EXPRESSION___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___NATURAL_TYPE = EXPRESSION___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___COLLECTION_FUNCTION_ADD = EXPRESSION___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE = EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Type Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___TYPE_CACHED = EXPRESSION___TYPE_CACHED;

	/**
	 * The operation id for the '<em>Is Null</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___IS_NULL = EXPRESSION___IS_NULL;

	/**
	 * The operation id for the '<em>Is Assignable From Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE = EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT = EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Type Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT = EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Conformant With Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Multiplicity Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT = EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___REFERENCE = EXPRESSION___REFERENCE;

	/**
	 * The operation id for the '<em>New Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___NEW_ASSIGNMENTS = EXPRESSION___NEW_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___UPDATE_ASSIGNMENTS = EXPRESSION___UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Expression update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS = EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Update Assignments Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___UPDATE_ASSIGNMENTS_CACHED = EXPRESSION___UPDATE_ASSIGNMENTS_CACHED;

	/**
	 * The operation id for the '<em>Resolve</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___RESOLVE__STRING = EXPRESSION___RESOLVE__STRING;

	/**
	 * The operation id for the '<em>Is Add Target</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___IS_ADD_TARGET__EXPRESSION = EXPRESSION___IS_ADD_TARGET__EXPRESSION;

	/**
	 * The operation id for the '<em>Expression Assignment After Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Expression Unique Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP = EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___TYPE = EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___UPPER = EXPRESSION_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___LOWER = EXPRESSION_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Class Extent Expression Type Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___CLASS_EXTENT_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Class Extent Expression Upper Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___CLASS_EXTENT_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 4;

	/**
	 * The operation id for the '<em>Class Extent Expression Lower Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___CLASS_EXTENT_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 5;

	/**
	 * The operation id for the '<em>Class Extent Expression Extent Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___CLASS_EXTENT_EXPRESSION_EXTENT_TYPE__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 6;

	/**
	 * The operation id for the '<em>Validate Class Extent Expression Extent Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION___VALIDATE_CLASS_EXTENT_EXPRESSION_EXTENT_TYPE = EXPRESSION_OPERATION_COUNT + 7;

	/**
	 * The number of operations of the '<em>Class Extent Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_EXTENT_EXPRESSION_OPERATION_COUNT = EXPRESSION_OPERATION_COUNT + 8;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.PositionalTemplateBindingImpl <em>Positional Template Binding</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.PositionalTemplateBindingImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getPositionalTemplateBinding()
	 * @generated
	 */
	int POSITIONAL_TEMPLATE_BINDING = 40;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING__OWNER = TEMPLATE_BINDING__OWNER;

	/**
	 * The feature id for the '<em><b>Argument Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING__ARGUMENT_NAME = TEMPLATE_BINDING_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Positional Template Binding</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING_FEATURE_COUNT = TEMPLATE_BINDING_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___TO_REFERENCE = TEMPLATE_BINDING___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___OWNER = TEMPLATE_BINDING___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___SYNTAX_ELEMENT_OWNER = TEMPLATE_BINDING___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___CURRENT_SCOPE = TEMPLATE_BINDING___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___SYNTAX_ELEMENT_CURRENT_SCOPE = TEMPLATE_BINDING___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___ENCLOSING_STATEMENT = TEMPLATE_BINDING___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___ENCLOSING_EXPRESSION = TEMPLATE_BINDING___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___ASSIGNMENTS_BEFORE = TEMPLATE_BINDING___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = TEMPLATE_BINDING___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = TEMPLATE_BINDING___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = TEMPLATE_BINDING___ASSIGNMENTS_BEFORE__SYNTAXELEMENT;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___UPDATE_ALL__ELIST_ELIST = TEMPLATE_BINDING___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___COMMON_ANCESTOR__ELIST = TEMPLATE_BINDING___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___COMMON_ANCESTORS__ELIST = TEMPLATE_BINDING___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___REMOVE_DUPLICATE_ELEMENTS__ELIST = TEMPLATE_BINDING___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___RESOLVE_IN_LIBRARY__STRING = TEMPLATE_BINDING___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___PRIMITIVE_TYPE__STRING = TEMPLATE_BINDING___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___PRIMITIVE_TYPE____STRING = TEMPLATE_BINDING___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___BOOLEAN_TYPE = TEMPLATE_BINDING___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = TEMPLATE_BINDING___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___INTEGER_TYPE = TEMPLATE_BINDING___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___IS_INTEGER_TYPE__ELEMENTREFERENCE = TEMPLATE_BINDING___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___STRING_TYPE = TEMPLATE_BINDING___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___IS_STRING_TYPE__ELEMENTREFERENCE = TEMPLATE_BINDING___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___UNLIMITED_NATURAL_TYPE = TEMPLATE_BINDING___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = TEMPLATE_BINDING___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___BIT_STRING_TYPE = TEMPLATE_BINDING___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = TEMPLATE_BINDING___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___NATURAL_TYPE = TEMPLATE_BINDING___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___IS_NATURAL_TYPE__ELEMENTREFERENCE = TEMPLATE_BINDING___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___IS_NUMERIC_TYPE__ELEMENTREFERENCE = TEMPLATE_BINDING___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___COLLECTION_FUNCTION_ADD = TEMPLATE_BINDING___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___IS_COLLECTION_CLASS__ELEMENTREFERENCE = TEMPLATE_BINDING___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = TEMPLATE_BINDING___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = TEMPLATE_BINDING___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>To String</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___TO_STRING = TEMPLATE_BINDING_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Matches</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___MATCHES__ELEMENTREFERENCE = TEMPLATE_BINDING_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Matches</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___MATCHES__ELEMENTREFERENCE_QUALIFIEDNAME = TEMPLATE_BINDING_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Bind To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___BIND_TO__ELEMENTREFERENCE = TEMPLATE_BINDING_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Copy</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING___COPY = TEMPLATE_BINDING_OPERATION_COUNT + 4;

	/**
	 * The number of operations of the '<em>Positional Template Binding</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POSITIONAL_TEMPLATE_BINDING_OPERATION_COUNT = TEMPLATE_BINDING_OPERATION_COUNT + 5;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.ConditionalLogicalExpressionImpl <em>Conditional Logical Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.ConditionalLogicalExpressionImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getConditionalLogicalExpression()
	 * @generated
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION = 41;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION__OWNER = BINARY_EXPRESSION__OWNER;

	/**
	 * The feature id for the '<em><b>Upper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION__UPPER = BINARY_EXPRESSION__UPPER;

	/**
	 * The feature id for the '<em><b>Lower</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION__LOWER = BINARY_EXPRESSION__LOWER;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION__TYPE = BINARY_EXPRESSION__TYPE;

	/**
	 * The feature id for the '<em><b>Assignment Before</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION__ASSIGNMENT_BEFORE = BINARY_EXPRESSION__ASSIGNMENT_BEFORE;

	/**
	 * The feature id for the '<em><b>Assignment After</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION__ASSIGNMENT_AFTER = BINARY_EXPRESSION__ASSIGNMENT_AFTER;

	/**
	 * The feature id for the '<em><b>Operand1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION__OPERAND1 = BINARY_EXPRESSION__OPERAND1;

	/**
	 * The feature id for the '<em><b>Operand2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION__OPERAND2 = BINARY_EXPRESSION__OPERAND2;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION__OPERATOR = BINARY_EXPRESSION__OPERATOR;

	/**
	 * The number of structural features of the '<em>Conditional Logical Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION_FEATURE_COUNT = BINARY_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___TO_REFERENCE = BINARY_EXPRESSION___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___OWNER = BINARY_EXPRESSION___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___SYNTAX_ELEMENT_OWNER = BINARY_EXPRESSION___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___CURRENT_SCOPE = BINARY_EXPRESSION___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE = BINARY_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___ENCLOSING_STATEMENT = BINARY_EXPRESSION___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___ENCLOSING_EXPRESSION = BINARY_EXPRESSION___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___ASSIGNMENTS_BEFORE = BINARY_EXPRESSION___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = BINARY_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = BINARY_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___UPDATE_ALL__ELIST_ELIST = BINARY_EXPRESSION___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___COMMON_ANCESTOR__ELIST = BINARY_EXPRESSION___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___COMMON_ANCESTORS__ELIST = BINARY_EXPRESSION___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST = BINARY_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___RESOLVE_IN_LIBRARY__STRING = BINARY_EXPRESSION___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___PRIMITIVE_TYPE__STRING = BINARY_EXPRESSION___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___PRIMITIVE_TYPE____STRING = BINARY_EXPRESSION___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___BOOLEAN_TYPE = BINARY_EXPRESSION___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___INTEGER_TYPE = BINARY_EXPRESSION___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___STRING_TYPE = BINARY_EXPRESSION___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___UNLIMITED_NATURAL_TYPE = BINARY_EXPRESSION___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___BIT_STRING_TYPE = BINARY_EXPRESSION___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___NATURAL_TYPE = BINARY_EXPRESSION___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___COLLECTION_FUNCTION_ADD = BINARY_EXPRESSION___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Type Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___TYPE_CACHED = BINARY_EXPRESSION___TYPE_CACHED;

	/**
	 * The operation id for the '<em>Is Null</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___IS_NULL = BINARY_EXPRESSION___IS_NULL;

	/**
	 * The operation id for the '<em>Is Assignable From Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT = BINARY_EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Type Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT = BINARY_EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Conformant With Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Multiplicity Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT = BINARY_EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___REFERENCE = BINARY_EXPRESSION___REFERENCE;

	/**
	 * The operation id for the '<em>New Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___NEW_ASSIGNMENTS = BINARY_EXPRESSION___NEW_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Expression update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS = BINARY_EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Update Assignments Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___UPDATE_ASSIGNMENTS_CACHED = BINARY_EXPRESSION___UPDATE_ASSIGNMENTS_CACHED;

	/**
	 * The operation id for the '<em>Resolve</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___RESOLVE__STRING = BINARY_EXPRESSION___RESOLVE__STRING;

	/**
	 * The operation id for the '<em>Is Add Target</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___IS_ADD_TARGET__EXPRESSION = BINARY_EXPRESSION___IS_ADD_TARGET__EXPRESSION;

	/**
	 * The operation id for the '<em>Expression Assignment After Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP = BINARY_EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Expression Unique Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP = BINARY_EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>No Null Arguments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___NO_NULL_ARGUMENTS = BINARY_EXPRESSION___NO_NULL_ARGUMENTS;

	/**
	 * The operation id for the '<em>Binary Expression Operand Multiplicity</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___BINARY_EXPRESSION_OPERAND_MULTIPLICITY__DIAGNOSTICCHAIN_MAP = BINARY_EXPRESSION___BINARY_EXPRESSION_OPERAND_MULTIPLICITY__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Binary Expression Operand Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___BINARY_EXPRESSION_OPERAND_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP = BINARY_EXPRESSION___BINARY_EXPRESSION_OPERAND_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___TYPE = BINARY_EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___LOWER = BINARY_EXPRESSION_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___UPPER = BINARY_EXPRESSION_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Conditional Logical Expression Type Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___CONDITIONAL_LOGICAL_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP = BINARY_EXPRESSION_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Conditional Logical Expression Lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___CONDITIONAL_LOGICAL_EXPRESSION_LOWER__DIAGNOSTICCHAIN_MAP = BINARY_EXPRESSION_OPERATION_COUNT + 4;

	/**
	 * The operation id for the '<em>Conditional Logical Expression Upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___CONDITIONAL_LOGICAL_EXPRESSION_UPPER__DIAGNOSTICCHAIN_MAP = BINARY_EXPRESSION_OPERATION_COUNT + 5;

	/**
	 * The operation id for the '<em>Conditional Logical Expression Operands</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___CONDITIONAL_LOGICAL_EXPRESSION_OPERANDS__DIAGNOSTICCHAIN_MAP = BINARY_EXPRESSION_OPERATION_COUNT + 6;

	/**
	 * The operation id for the '<em>Validate Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___VALIDATE_ASSIGNMENTS = BINARY_EXPRESSION_OPERATION_COUNT + 7;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = BINARY_EXPRESSION_OPERATION_COUNT + 8;

	/**
	 * The operation id for the '<em>Update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION___UPDATE_ASSIGNMENTS = BINARY_EXPRESSION_OPERATION_COUNT + 9;

	/**
	 * The number of operations of the '<em>Conditional Logical Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONAL_LOGICAL_EXPRESSION_OPERATION_COUNT = BINARY_EXPRESSION_OPERATION_COUNT + 10;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.LinkOperationExpressionImpl <em>Link Operation Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.LinkOperationExpressionImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getLinkOperationExpression()
	 * @generated
	 */
	int LINK_OPERATION_EXPRESSION = 42;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION__OWNER = INVOCATION_EXPRESSION__OWNER;

	/**
	 * The feature id for the '<em><b>Upper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION__UPPER = INVOCATION_EXPRESSION__UPPER;

	/**
	 * The feature id for the '<em><b>Lower</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION__LOWER = INVOCATION_EXPRESSION__LOWER;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION__TYPE = INVOCATION_EXPRESSION__TYPE;

	/**
	 * The feature id for the '<em><b>Assignment Before</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION__ASSIGNMENT_BEFORE = INVOCATION_EXPRESSION__ASSIGNMENT_BEFORE;

	/**
	 * The feature id for the '<em><b>Assignment After</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION__ASSIGNMENT_AFTER = INVOCATION_EXPRESSION__ASSIGNMENT_AFTER;

	/**
	 * The feature id for the '<em><b>Is Behavior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION__IS_BEHAVIOR = INVOCATION_EXPRESSION__IS_BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Is Association End</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION__IS_ASSOCIATION_END = INVOCATION_EXPRESSION__IS_ASSOCIATION_END;

	/**
	 * The feature id for the '<em><b>Feature</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION__FEATURE = INVOCATION_EXPRESSION__FEATURE;

	/**
	 * The feature id for the '<em><b>Is Operation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION__IS_OPERATION = INVOCATION_EXPRESSION__IS_OPERATION;

	/**
	 * The feature id for the '<em><b>Is Destructor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION__IS_DESTRUCTOR = INVOCATION_EXPRESSION__IS_DESTRUCTOR;

	/**
	 * The feature id for the '<em><b>Is Implicit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION__IS_IMPLICIT = INVOCATION_EXPRESSION__IS_IMPLICIT;

	/**
	 * The feature id for the '<em><b>Referent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION__REFERENT = INVOCATION_EXPRESSION__REFERENT;

	/**
	 * The feature id for the '<em><b>Parameter</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION__PARAMETER = INVOCATION_EXPRESSION__PARAMETER;

	/**
	 * The feature id for the '<em><b>Is Signal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION__IS_SIGNAL = INVOCATION_EXPRESSION__IS_SIGNAL;

	/**
	 * The feature id for the '<em><b>Tuple</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION__TUPLE = INVOCATION_EXPRESSION__TUPLE;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION__OPERATION = INVOCATION_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Is Creation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION__IS_CREATION = INVOCATION_EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Is Clear</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION__IS_CLEAR = INVOCATION_EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Association Name</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION__ASSOCIATION_NAME = INVOCATION_EXPRESSION_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Link Operation Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION_FEATURE_COUNT = INVOCATION_EXPRESSION_FEATURE_COUNT + 4;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___TO_REFERENCE = INVOCATION_EXPRESSION___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___OWNER = INVOCATION_EXPRESSION___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___SYNTAX_ELEMENT_OWNER = INVOCATION_EXPRESSION___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___CURRENT_SCOPE = INVOCATION_EXPRESSION___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE = INVOCATION_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___ENCLOSING_STATEMENT = INVOCATION_EXPRESSION___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___ENCLOSING_EXPRESSION = INVOCATION_EXPRESSION___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___ASSIGNMENTS_BEFORE = INVOCATION_EXPRESSION___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = INVOCATION_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = INVOCATION_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___UPDATE_ALL__ELIST_ELIST = INVOCATION_EXPRESSION___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___COMMON_ANCESTOR__ELIST = INVOCATION_EXPRESSION___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___COMMON_ANCESTORS__ELIST = INVOCATION_EXPRESSION___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST = INVOCATION_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___RESOLVE_IN_LIBRARY__STRING = INVOCATION_EXPRESSION___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___PRIMITIVE_TYPE__STRING = INVOCATION_EXPRESSION___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___PRIMITIVE_TYPE____STRING = INVOCATION_EXPRESSION___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___BOOLEAN_TYPE = INVOCATION_EXPRESSION___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = INVOCATION_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___INTEGER_TYPE = INVOCATION_EXPRESSION___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE = INVOCATION_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___STRING_TYPE = INVOCATION_EXPRESSION___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE = INVOCATION_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___UNLIMITED_NATURAL_TYPE = INVOCATION_EXPRESSION___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = INVOCATION_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___BIT_STRING_TYPE = INVOCATION_EXPRESSION___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = INVOCATION_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___NATURAL_TYPE = INVOCATION_EXPRESSION___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE = INVOCATION_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE = INVOCATION_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___COLLECTION_FUNCTION_ADD = INVOCATION_EXPRESSION___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE = INVOCATION_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = INVOCATION_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = INVOCATION_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Type Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___TYPE_CACHED = INVOCATION_EXPRESSION___TYPE_CACHED;

	/**
	 * The operation id for the '<em>Is Null</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___IS_NULL = INVOCATION_EXPRESSION___IS_NULL;

	/**
	 * The operation id for the '<em>Is Assignable From Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE = INVOCATION_EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT = INVOCATION_EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Type Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT = INVOCATION_EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Conformant With Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE = INVOCATION_EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Multiplicity Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT = INVOCATION_EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___REFERENCE = INVOCATION_EXPRESSION___REFERENCE;

	/**
	 * The operation id for the '<em>New Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___NEW_ASSIGNMENTS = INVOCATION_EXPRESSION___NEW_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Expression update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS = INVOCATION_EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Update Assignments Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___UPDATE_ASSIGNMENTS_CACHED = INVOCATION_EXPRESSION___UPDATE_ASSIGNMENTS_CACHED;

	/**
	 * The operation id for the '<em>Resolve</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___RESOLVE__STRING = INVOCATION_EXPRESSION___RESOLVE__STRING;

	/**
	 * The operation id for the '<em>Is Add Target</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___IS_ADD_TARGET__EXPRESSION = INVOCATION_EXPRESSION___IS_ADD_TARGET__EXPRESSION;

	/**
	 * The operation id for the '<em>Expression Assignment After Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Expression Unique Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = INVOCATION_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT;

	/**
	 * The operation id for the '<em>Referent Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___REFERENT_CACHED = INVOCATION_EXPRESSION___REFERENT_CACHED;

	/**
	 * The operation id for the '<em>Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___TYPE = INVOCATION_EXPRESSION___TYPE;

	/**
	 * The operation id for the '<em>Invocation Expression type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___INVOCATION_EXPRESSION_TYPE = INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_TYPE;

	/**
	 * The operation id for the '<em>Upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___UPPER = INVOCATION_EXPRESSION___UPPER;

	/**
	 * The operation id for the '<em>Invocation Expression upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___INVOCATION_EXPRESSION_UPPER = INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_UPPER;

	/**
	 * The operation id for the '<em>Lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___LOWER = INVOCATION_EXPRESSION___LOWER;

	/**
	 * The operation id for the '<em>Invocation Expression lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___INVOCATION_EXPRESSION_LOWER = INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_LOWER;

	/**
	 * The operation id for the '<em>Parameter Named</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___PARAMETER_NAMED__STRING = INVOCATION_EXPRESSION___PARAMETER_NAMED__STRING;

	/**
	 * The operation id for the '<em>Parameter Count</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___PARAMETER_COUNT = INVOCATION_EXPRESSION___PARAMETER_COUNT;

	/**
	 * The operation id for the '<em>Parameter Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___PARAMETER_IS_ASSIGNABLE_FROM__INPUTNAMEDEXPRESSION = INVOCATION_EXPRESSION___PARAMETER_IS_ASSIGNABLE_FROM__INPUTNAMEDEXPRESSION;

	/**
	 * The operation id for the '<em>Parameter Is Assignable To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___PARAMETER_IS_ASSIGNABLE_TO__OUTPUTNAMEDEXPRESSION = INVOCATION_EXPRESSION___PARAMETER_IS_ASSIGNABLE_TO__OUTPUTNAMEDEXPRESSION;

	/**
	 * The operation id for the '<em>Alternative Constructor Is Valid</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___ALTERNATIVE_CONSTRUCTOR_IS_VALID = INVOCATION_EXPRESSION___ALTERNATIVE_CONSTRUCTOR_IS_VALID;

	/**
	 * The operation id for the '<em>Bind Template Implicit Arguments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___BIND_TEMPLATE_IMPLICIT_ARGUMENTS__ELEMENTREFERENCE_EXPRESSION = INVOCATION_EXPRESSION___BIND_TEMPLATE_IMPLICIT_ARGUMENTS__ELEMENTREFERENCE_EXPRESSION;

	/**
	 * The operation id for the '<em>Bind Template Implicit Arguments1</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___BIND_TEMPLATE_IMPLICIT_ARGUMENTS1__ELEMENTREFERENCE_EXPRESSION = INVOCATION_EXPRESSION___BIND_TEMPLATE_IMPLICIT_ARGUMENTS1__ELEMENTREFERENCE_EXPRESSION;

	/**
	 * The operation id for the '<em>Effective Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___EFFECTIVE_TYPE__ELEMENTREFERENCE_EXPRESSION = INVOCATION_EXPRESSION___EFFECTIVE_TYPE__ELEMENTREFERENCE_EXPRESSION;

	/**
	 * The operation id for the '<em>Invocation Expression parameter Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___INVOCATION_EXPRESSION_PARAMETER_ELEMENTS = INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_PARAMETER_ELEMENTS;

	/**
	 * The operation id for the '<em>Parameter From Property</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___PARAMETER_FROM_PROPERTY__ELEMENTREFERENCE = INVOCATION_EXPRESSION___PARAMETER_FROM_PROPERTY__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Parameter From Property With Multiplicity</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___PARAMETER_FROM_PROPERTY_WITH_MULTIPLICITY__ELEMENTREFERENCE_STRING_STRING = INVOCATION_EXPRESSION___PARAMETER_FROM_PROPERTY_WITH_MULTIPLICITY__ELEMENTREFERENCE_STRING_STRING;

	/**
	 * The operation id for the '<em>Invocation Expression Is Behavior Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___INVOCATION_EXPRESSION_IS_BEHAVIOR_DERIVATION__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_IS_BEHAVIOR_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Invocation Expression Is Association End Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___INVOCATION_EXPRESSION_IS_ASSOCIATION_END_DERIVATION__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_IS_ASSOCIATION_END_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Invocation Expression Is Operation Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___INVOCATION_EXPRESSION_IS_OPERATION_DERIVATION__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_IS_OPERATION_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Invocation Expression Is Destructor Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___INVOCATION_EXPRESSION_IS_DESTRUCTOR_DERIVATION__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_IS_DESTRUCTOR_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Invocation Expression Is Implicit Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___INVOCATION_EXPRESSION_IS_IMPLICIT_DERIVATION__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_IS_IMPLICIT_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Invocation Expression Is Signal Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___INVOCATION_EXPRESSION_IS_SIGNAL_DERIVATION__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_IS_SIGNAL_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Invocation Expression Parameter Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___INVOCATION_EXPRESSION_PARAMETER_DERIVATION__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_PARAMETER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Invocation Expression Type Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___INVOCATION_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Invocation Expression Upper Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___INVOCATION_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Invocation Expression Lower Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___INVOCATION_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Invocation Expression Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___INVOCATION_EXPRESSION_ASSIGNMENTS_BEFORE__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_ASSIGNMENTS_BEFORE__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___UPDATE_ASSIGNMENTS = INVOCATION_EXPRESSION___UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Invocation Expression Template Parameters</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___INVOCATION_EXPRESSION_TEMPLATE_PARAMETERS__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION___INVOCATION_EXPRESSION_TEMPLATE_PARAMETERS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Referent</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___REFERENT = INVOCATION_EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Feature</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___FEATURE = INVOCATION_EXPRESSION_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Link Operation Expression Is Creation Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___LINK_OPERATION_EXPRESSION_IS_CREATION_DERIVATION__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Link Operation Expression Is Clear Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___LINK_OPERATION_EXPRESSION_IS_CLEAR_DERIVATION__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Link Operation Expression Referent Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___LINK_OPERATION_EXPRESSION_REFERENT_DERIVATION__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION_OPERATION_COUNT + 4;

	/**
	 * The operation id for the '<em>Link Operation Expression Feature Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___LINK_OPERATION_EXPRESSION_FEATURE_DERIVATION__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION_OPERATION_COUNT + 5;

	/**
	 * The operation id for the '<em>Link Operation Expression Association Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___LINK_OPERATION_EXPRESSION_ASSOCIATION_REFERENCE__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION_OPERATION_COUNT + 6;

	/**
	 * The operation id for the '<em>Link Operation Expression Argument Compatibility</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___LINK_OPERATION_EXPRESSION_ARGUMENT_COMPATIBILITY__DIAGNOSTICCHAIN_MAP = INVOCATION_EXPRESSION_OPERATION_COUNT + 7;

	/**
	 * The operation id for the '<em>Parameter Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION___PARAMETER_ELEMENTS = INVOCATION_EXPRESSION_OPERATION_COUNT + 8;

	/**
	 * The number of operations of the '<em>Link Operation Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_EXPRESSION_OPERATION_COUNT = INVOCATION_EXPRESSION_OPERATION_COUNT + 9;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.EqualityExpressionImpl <em>Equality Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.EqualityExpressionImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getEqualityExpression()
	 * @generated
	 */
	int EQUALITY_EXPRESSION = 43;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION__OWNER = BINARY_EXPRESSION__OWNER;

	/**
	 * The feature id for the '<em><b>Upper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION__UPPER = BINARY_EXPRESSION__UPPER;

	/**
	 * The feature id for the '<em><b>Lower</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION__LOWER = BINARY_EXPRESSION__LOWER;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION__TYPE = BINARY_EXPRESSION__TYPE;

	/**
	 * The feature id for the '<em><b>Assignment Before</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION__ASSIGNMENT_BEFORE = BINARY_EXPRESSION__ASSIGNMENT_BEFORE;

	/**
	 * The feature id for the '<em><b>Assignment After</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION__ASSIGNMENT_AFTER = BINARY_EXPRESSION__ASSIGNMENT_AFTER;

	/**
	 * The feature id for the '<em><b>Operand1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION__OPERAND1 = BINARY_EXPRESSION__OPERAND1;

	/**
	 * The feature id for the '<em><b>Operand2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION__OPERAND2 = BINARY_EXPRESSION__OPERAND2;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION__OPERATOR = BINARY_EXPRESSION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Is Negated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION__IS_NEGATED = BINARY_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Equality Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION_FEATURE_COUNT = BINARY_EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___TO_REFERENCE = BINARY_EXPRESSION___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___OWNER = BINARY_EXPRESSION___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___SYNTAX_ELEMENT_OWNER = BINARY_EXPRESSION___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___CURRENT_SCOPE = BINARY_EXPRESSION___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE = BINARY_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___ENCLOSING_STATEMENT = BINARY_EXPRESSION___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___ENCLOSING_EXPRESSION = BINARY_EXPRESSION___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___ASSIGNMENTS_BEFORE = BINARY_EXPRESSION___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = BINARY_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = BINARY_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = BINARY_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___UPDATE_ALL__ELIST_ELIST = BINARY_EXPRESSION___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___COMMON_ANCESTOR__ELIST = BINARY_EXPRESSION___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___COMMON_ANCESTORS__ELIST = BINARY_EXPRESSION___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST = BINARY_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___RESOLVE_IN_LIBRARY__STRING = BINARY_EXPRESSION___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___PRIMITIVE_TYPE__STRING = BINARY_EXPRESSION___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___PRIMITIVE_TYPE____STRING = BINARY_EXPRESSION___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___BOOLEAN_TYPE = BINARY_EXPRESSION___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___INTEGER_TYPE = BINARY_EXPRESSION___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___STRING_TYPE = BINARY_EXPRESSION___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___UNLIMITED_NATURAL_TYPE = BINARY_EXPRESSION___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___BIT_STRING_TYPE = BINARY_EXPRESSION___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___NATURAL_TYPE = BINARY_EXPRESSION___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___COLLECTION_FUNCTION_ADD = BINARY_EXPRESSION___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Type Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___TYPE_CACHED = BINARY_EXPRESSION___TYPE_CACHED;

	/**
	 * The operation id for the '<em>Is Null</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___IS_NULL = BINARY_EXPRESSION___IS_NULL;

	/**
	 * The operation id for the '<em>Is Assignable From Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT = BINARY_EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Type Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT = BINARY_EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Conformant With Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Multiplicity Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT = BINARY_EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___REFERENCE = BINARY_EXPRESSION___REFERENCE;

	/**
	 * The operation id for the '<em>New Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___NEW_ASSIGNMENTS = BINARY_EXPRESSION___NEW_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Expression update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS = BINARY_EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Update Assignments Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___UPDATE_ASSIGNMENTS_CACHED = BINARY_EXPRESSION___UPDATE_ASSIGNMENTS_CACHED;

	/**
	 * The operation id for the '<em>Resolve</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___RESOLVE__STRING = BINARY_EXPRESSION___RESOLVE__STRING;

	/**
	 * The operation id for the '<em>Is Add Target</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___IS_ADD_TARGET__EXPRESSION = BINARY_EXPRESSION___IS_ADD_TARGET__EXPRESSION;

	/**
	 * The operation id for the '<em>Expression Assignment After Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP = BINARY_EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Expression Unique Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP = BINARY_EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Validate Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___VALIDATE_ASSIGNMENTS = BINARY_EXPRESSION___VALIDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Binary Expression Operand Multiplicity</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___BINARY_EXPRESSION_OPERAND_MULTIPLICITY__DIAGNOSTICCHAIN_MAP = BINARY_EXPRESSION___BINARY_EXPRESSION_OPERAND_MULTIPLICITY__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Binary Expression Operand Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___BINARY_EXPRESSION_OPERAND_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP = BINARY_EXPRESSION___BINARY_EXPRESSION_OPERAND_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___UPDATE_ASSIGNMENTS = BINARY_EXPRESSION___UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___TYPE = BINARY_EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___LOWER = BINARY_EXPRESSION_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___UPPER = BINARY_EXPRESSION_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Equality Expression Is Negated Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___EQUALITY_EXPRESSION_IS_NEGATED_DERIVATION__DIAGNOSTICCHAIN_MAP = BINARY_EXPRESSION_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Equality Expression Type Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___EQUALITY_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP = BINARY_EXPRESSION_OPERATION_COUNT + 4;

	/**
	 * The operation id for the '<em>Equality Expression Lower Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___EQUALITY_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP = BINARY_EXPRESSION_OPERATION_COUNT + 5;

	/**
	 * The operation id for the '<em>Equality Expression Upper Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___EQUALITY_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP = BINARY_EXPRESSION_OPERATION_COUNT + 6;

	/**
	 * The operation id for the '<em>No Null Arguments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION___NO_NULL_ARGUMENTS = BINARY_EXPRESSION_OPERATION_COUNT + 7;

	/**
	 * The number of operations of the '<em>Equality Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXPRESSION_OPERATION_COUNT = BINARY_EXPRESSION_OPERATION_COUNT + 8;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.AssignmentExpressionImpl <em>Assignment Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.AssignmentExpressionImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getAssignmentExpression()
	 * @generated
	 */
	int ASSIGNMENT_EXPRESSION = 44;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION__OWNER = EXPRESSION__OWNER;

	/**
	 * The feature id for the '<em><b>Upper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION__UPPER = EXPRESSION__UPPER;

	/**
	 * The feature id for the '<em><b>Lower</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION__LOWER = EXPRESSION__LOWER;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION__TYPE = EXPRESSION__TYPE;

	/**
	 * The feature id for the '<em><b>Assignment Before</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION__ASSIGNMENT_BEFORE = EXPRESSION__ASSIGNMENT_BEFORE;

	/**
	 * The feature id for the '<em><b>Assignment After</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION__ASSIGNMENT_AFTER = EXPRESSION__ASSIGNMENT_AFTER;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION__OPERATOR = EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Left Hand Side</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION__LEFT_HAND_SIDE = EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Right Hand Side</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION__RIGHT_HAND_SIDE = EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Assignment</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION__ASSIGNMENT = EXPRESSION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Feature</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION__FEATURE = EXPRESSION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Is Indexed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION__IS_INDEXED = EXPRESSION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Is Arithmetic</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION__IS_ARITHMETIC = EXPRESSION_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Is Logical</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION__IS_LOGICAL = EXPRESSION_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Is Shift</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION__IS_SHIFT = EXPRESSION_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Is Concatenation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION__IS_CONCATENATION = EXPRESSION_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Is Definition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION__IS_DEFINITION = EXPRESSION_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Is Simple</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION__IS_SIMPLE = EXPRESSION_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION__EXPRESSION = EXPRESSION_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Is Feature</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION__IS_FEATURE = EXPRESSION_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Is Data Value Update</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION__IS_DATA_VALUE_UPDATE = EXPRESSION_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Is Collection Conversion</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION__IS_COLLECTION_CONVERSION = EXPRESSION_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Is Bit String Conversion</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION__IS_BIT_STRING_CONVERSION = EXPRESSION_FEATURE_COUNT + 16;

	/**
	 * The number of structural features of the '<em>Assignment Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION_FEATURE_COUNT = EXPRESSION_FEATURE_COUNT + 17;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___TO_REFERENCE = EXPRESSION___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___OWNER = EXPRESSION___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___SYNTAX_ELEMENT_OWNER = EXPRESSION___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___CURRENT_SCOPE = EXPRESSION___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE = EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___ENCLOSING_STATEMENT = EXPRESSION___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___ENCLOSING_EXPRESSION = EXPRESSION___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___ASSIGNMENTS_BEFORE = EXPRESSION___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___UPDATE_ALL__ELIST_ELIST = EXPRESSION___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___COMMON_ANCESTOR__ELIST = EXPRESSION___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___COMMON_ANCESTORS__ELIST = EXPRESSION___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST = EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___RESOLVE_IN_LIBRARY__STRING = EXPRESSION___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___PRIMITIVE_TYPE__STRING = EXPRESSION___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___PRIMITIVE_TYPE____STRING = EXPRESSION___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___BOOLEAN_TYPE = EXPRESSION___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___INTEGER_TYPE = EXPRESSION___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___STRING_TYPE = EXPRESSION___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___UNLIMITED_NATURAL_TYPE = EXPRESSION___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___BIT_STRING_TYPE = EXPRESSION___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___NATURAL_TYPE = EXPRESSION___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___COLLECTION_FUNCTION_ADD = EXPRESSION___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE = EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Type Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___TYPE_CACHED = EXPRESSION___TYPE_CACHED;

	/**
	 * The operation id for the '<em>Is Null</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___IS_NULL = EXPRESSION___IS_NULL;

	/**
	 * The operation id for the '<em>Is Assignable From Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE = EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT = EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Type Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT = EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Conformant With Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Multiplicity Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT = EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___REFERENCE = EXPRESSION___REFERENCE;

	/**
	 * The operation id for the '<em>New Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___NEW_ASSIGNMENTS = EXPRESSION___NEW_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Expression update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS = EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Update Assignments Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___UPDATE_ASSIGNMENTS_CACHED = EXPRESSION___UPDATE_ASSIGNMENTS_CACHED;

	/**
	 * The operation id for the '<em>Resolve</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___RESOLVE__STRING = EXPRESSION___RESOLVE__STRING;

	/**
	 * The operation id for the '<em>Is Add Target</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___IS_ADD_TARGET__EXPRESSION = EXPRESSION___IS_ADD_TARGET__EXPRESSION;

	/**
	 * The operation id for the '<em>Expression Assignment After Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Expression Unique Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP = EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___TYPE = EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___UPPER = EXPRESSION_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___LOWER = EXPRESSION_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = EXPRESSION_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Assignment Expression Is Simple Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___ASSIGNMENT_EXPRESSION_IS_SIMPLE_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 4;

	/**
	 * The operation id for the '<em>Assignment Expression Is Arithmetic Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___ASSIGNMENT_EXPRESSION_IS_ARITHMETIC_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 5;

	/**
	 * The operation id for the '<em>Assignment Expression Is Definition Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___ASSIGNMENT_EXPRESSION_IS_DEFINITION_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 6;

	/**
	 * The operation id for the '<em>Assignment Expression Is Feature Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___ASSIGNMENT_EXPRESSION_IS_FEATURE_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 7;

	/**
	 * The operation id for the '<em>Assignment Expression Is Indexed Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___ASSIGNMENT_EXPRESSION_IS_INDEXED_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 8;

	/**
	 * The operation id for the '<em>Assignment Expression Is Data Value Update Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___ASSIGNMENT_EXPRESSION_IS_DATA_VALUE_UPDATE_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 9;

	/**
	 * The operation id for the '<em>Assignment Expression Assignment Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___ASSIGNMENT_EXPRESSION_ASSIGNMENT_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 10;

	/**
	 * The operation id for the '<em>Assignment Expression Feature Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___ASSIGNMENT_EXPRESSION_FEATURE_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 11;

	/**
	 * The operation id for the '<em>Assignment Expression Expression Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___ASSIGNMENT_EXPRESSION_EXPRESSION_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 12;

	/**
	 * The operation id for the '<em>Assignment Expression Type Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___ASSIGNMENT_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 13;

	/**
	 * The operation id for the '<em>Assignment Expression Upper Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___ASSIGNMENT_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 14;

	/**
	 * The operation id for the '<em>Assignment Expression Lower Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___ASSIGNMENT_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 15;

	/**
	 * The operation id for the '<em>Assignment Expression Simple Assignment Type Conformance</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___ASSIGNMENT_EXPRESSION_SIMPLE_ASSIGNMENT_TYPE_CONFORMANCE__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 16;

	/**
	 * The operation id for the '<em>Assignment Expression Simple Assignment Multiplicity Conformance</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___ASSIGNMENT_EXPRESSION_SIMPLE_ASSIGNMENT_MULTIPLICITY_CONFORMANCE__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 17;

	/**
	 * The operation id for the '<em>Assignment Expression Compound Assignment Type Conformance</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___ASSIGNMENT_EXPRESSION_COMPOUND_ASSIGNMENT_TYPE_CONFORMANCE__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 18;

	/**
	 * The operation id for the '<em>Assignment Expression Compound Assignment Multiplicity Conformance</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___ASSIGNMENT_EXPRESSION_COMPOUND_ASSIGNMENT_MULTIPLICITY_CONFORMANCE__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 19;

	/**
	 * The operation id for the '<em>Assignment Expression Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___ASSIGNMENT_EXPRESSION_ASSIGNMENTS_BEFORE__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 20;

	/**
	 * The operation id for the '<em>Assignment Expression Is Collection Conversion Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___ASSIGNMENT_EXPRESSION_IS_COLLECTION_CONVERSION_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 21;

	/**
	 * The operation id for the '<em>Assignment Expression Is Bit String Conversion Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___ASSIGNMENT_EXPRESSION_IS_BIT_STRING_CONVERSION_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 22;

	/**
	 * The operation id for the '<em>Assignment Expression Data Value Update Legality</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___ASSIGNMENT_EXPRESSION_DATA_VALUE_UPDATE_LEGALITY__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 23;

	/**
	 * The operation id for the '<em>Update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION___UPDATE_ASSIGNMENTS = EXPRESSION_OPERATION_COUNT + 24;

	/**
	 * The number of operations of the '<em>Assignment Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_EXPRESSION_OPERATION_COUNT = EXPRESSION_OPERATION_COUNT + 25;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.LogicalExpressionImpl <em>Logical Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.LogicalExpressionImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getLogicalExpression()
	 * @generated
	 */
	int LOGICAL_EXPRESSION = 45;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION__OWNER = BINARY_EXPRESSION__OWNER;

	/**
	 * The feature id for the '<em><b>Upper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION__UPPER = BINARY_EXPRESSION__UPPER;

	/**
	 * The feature id for the '<em><b>Lower</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION__LOWER = BINARY_EXPRESSION__LOWER;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION__TYPE = BINARY_EXPRESSION__TYPE;

	/**
	 * The feature id for the '<em><b>Assignment Before</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION__ASSIGNMENT_BEFORE = BINARY_EXPRESSION__ASSIGNMENT_BEFORE;

	/**
	 * The feature id for the '<em><b>Assignment After</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION__ASSIGNMENT_AFTER = BINARY_EXPRESSION__ASSIGNMENT_AFTER;

	/**
	 * The feature id for the '<em><b>Operand1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION__OPERAND1 = BINARY_EXPRESSION__OPERAND1;

	/**
	 * The feature id for the '<em><b>Operand2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION__OPERAND2 = BINARY_EXPRESSION__OPERAND2;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION__OPERATOR = BINARY_EXPRESSION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Is Bit Wise</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION__IS_BIT_WISE = BINARY_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Is Bit String Conversion1</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION__IS_BIT_STRING_CONVERSION1 = BINARY_EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Is Bit String Conversion2</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION__IS_BIT_STRING_CONVERSION2 = BINARY_EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Logical Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION_FEATURE_COUNT = BINARY_EXPRESSION_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___TO_REFERENCE = BINARY_EXPRESSION___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___OWNER = BINARY_EXPRESSION___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___SYNTAX_ELEMENT_OWNER = BINARY_EXPRESSION___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___CURRENT_SCOPE = BINARY_EXPRESSION___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE = BINARY_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___ENCLOSING_STATEMENT = BINARY_EXPRESSION___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___ENCLOSING_EXPRESSION = BINARY_EXPRESSION___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___ASSIGNMENTS_BEFORE = BINARY_EXPRESSION___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = BINARY_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = BINARY_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = BINARY_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___UPDATE_ALL__ELIST_ELIST = BINARY_EXPRESSION___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___COMMON_ANCESTOR__ELIST = BINARY_EXPRESSION___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___COMMON_ANCESTORS__ELIST = BINARY_EXPRESSION___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST = BINARY_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___RESOLVE_IN_LIBRARY__STRING = BINARY_EXPRESSION___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___PRIMITIVE_TYPE__STRING = BINARY_EXPRESSION___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___PRIMITIVE_TYPE____STRING = BINARY_EXPRESSION___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___BOOLEAN_TYPE = BINARY_EXPRESSION___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___INTEGER_TYPE = BINARY_EXPRESSION___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___STRING_TYPE = BINARY_EXPRESSION___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___UNLIMITED_NATURAL_TYPE = BINARY_EXPRESSION___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___BIT_STRING_TYPE = BINARY_EXPRESSION___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___NATURAL_TYPE = BINARY_EXPRESSION___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___COLLECTION_FUNCTION_ADD = BINARY_EXPRESSION___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Type Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___TYPE_CACHED = BINARY_EXPRESSION___TYPE_CACHED;

	/**
	 * The operation id for the '<em>Is Null</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___IS_NULL = BINARY_EXPRESSION___IS_NULL;

	/**
	 * The operation id for the '<em>Is Assignable From Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT = BINARY_EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Type Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT = BINARY_EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Conformant With Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Multiplicity Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT = BINARY_EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___REFERENCE = BINARY_EXPRESSION___REFERENCE;

	/**
	 * The operation id for the '<em>New Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___NEW_ASSIGNMENTS = BINARY_EXPRESSION___NEW_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Expression update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS = BINARY_EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Update Assignments Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___UPDATE_ASSIGNMENTS_CACHED = BINARY_EXPRESSION___UPDATE_ASSIGNMENTS_CACHED;

	/**
	 * The operation id for the '<em>Resolve</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___RESOLVE__STRING = BINARY_EXPRESSION___RESOLVE__STRING;

	/**
	 * The operation id for the '<em>Is Add Target</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___IS_ADD_TARGET__EXPRESSION = BINARY_EXPRESSION___IS_ADD_TARGET__EXPRESSION;

	/**
	 * The operation id for the '<em>Expression Assignment After Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP = BINARY_EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Expression Unique Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP = BINARY_EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Validate Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___VALIDATE_ASSIGNMENTS = BINARY_EXPRESSION___VALIDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>No Null Arguments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___NO_NULL_ARGUMENTS = BINARY_EXPRESSION___NO_NULL_ARGUMENTS;

	/**
	 * The operation id for the '<em>Binary Expression Operand Multiplicity</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___BINARY_EXPRESSION_OPERAND_MULTIPLICITY__DIAGNOSTICCHAIN_MAP = BINARY_EXPRESSION___BINARY_EXPRESSION_OPERAND_MULTIPLICITY__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Binary Expression Operand Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___BINARY_EXPRESSION_OPERAND_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP = BINARY_EXPRESSION___BINARY_EXPRESSION_OPERAND_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___UPDATE_ASSIGNMENTS = BINARY_EXPRESSION___UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___TYPE = BINARY_EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___LOWER = BINARY_EXPRESSION_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___UPPER = BINARY_EXPRESSION_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Logical Expression Type Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___LOGICAL_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP = BINARY_EXPRESSION_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Logical Expression Lower Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___LOGICAL_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP = BINARY_EXPRESSION_OPERATION_COUNT + 4;

	/**
	 * The operation id for the '<em>Logical Expression Upper Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___LOGICAL_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP = BINARY_EXPRESSION_OPERATION_COUNT + 5;

	/**
	 * The operation id for the '<em>Logical Expression Operands</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___LOGICAL_EXPRESSION_OPERANDS__DIAGNOSTICCHAIN_MAP = BINARY_EXPRESSION_OPERATION_COUNT + 6;

	/**
	 * The operation id for the '<em>Logical Expression Is Bit String Conversion1 Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___LOGICAL_EXPRESSION_IS_BIT_STRING_CONVERSION1_DERIVATION__DIAGNOSTICCHAIN_MAP = BINARY_EXPRESSION_OPERATION_COUNT + 7;

	/**
	 * The operation id for the '<em>Logical Expression Is Bit String Conversion2 Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___LOGICAL_EXPRESSION_IS_BIT_STRING_CONVERSION2_DERIVATION__DIAGNOSTICCHAIN_MAP = BINARY_EXPRESSION_OPERATION_COUNT + 8;

	/**
	 * The operation id for the '<em>Logical Expression Is Bit Wise Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION___LOGICAL_EXPRESSION_IS_BIT_WISE_DERIVATION__DIAGNOSTICCHAIN_MAP = BINARY_EXPRESSION_OPERATION_COUNT + 9;

	/**
	 * The number of operations of the '<em>Logical Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOGICAL_EXPRESSION_OPERATION_COUNT = BINARY_EXPRESSION_OPERATION_COUNT + 10;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.SequenceConstructionExpressionImpl <em>Sequence Construction Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.SequenceConstructionExpressionImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getSequenceConstructionExpression()
	 * @generated
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION = 46;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION__OWNER = EXPRESSION__OWNER;

	/**
	 * The feature id for the '<em><b>Upper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION__UPPER = EXPRESSION__UPPER;

	/**
	 * The feature id for the '<em><b>Lower</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION__LOWER = EXPRESSION__LOWER;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION__TYPE = EXPRESSION__TYPE;

	/**
	 * The feature id for the '<em><b>Assignment Before</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION__ASSIGNMENT_BEFORE = EXPRESSION__ASSIGNMENT_BEFORE;

	/**
	 * The feature id for the '<em><b>Assignment After</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION__ASSIGNMENT_AFTER = EXPRESSION__ASSIGNMENT_AFTER;

	/**
	 * The feature id for the '<em><b>Elements</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION__ELEMENTS = EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Has Multiplicity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION__HAS_MULTIPLICITY = EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Type Name</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION__TYPE_NAME = EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Is Any</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION__IS_ANY = EXPRESSION_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Sequence Construction Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION_FEATURE_COUNT = EXPRESSION_FEATURE_COUNT + 4;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___TO_REFERENCE = EXPRESSION___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___OWNER = EXPRESSION___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___SYNTAX_ELEMENT_OWNER = EXPRESSION___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___CURRENT_SCOPE = EXPRESSION___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE = EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___ENCLOSING_STATEMENT = EXPRESSION___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___ENCLOSING_EXPRESSION = EXPRESSION___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___ASSIGNMENTS_BEFORE = EXPRESSION___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___UPDATE_ALL__ELIST_ELIST = EXPRESSION___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___COMMON_ANCESTOR__ELIST = EXPRESSION___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___COMMON_ANCESTORS__ELIST = EXPRESSION___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST = EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___RESOLVE_IN_LIBRARY__STRING = EXPRESSION___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___PRIMITIVE_TYPE__STRING = EXPRESSION___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___PRIMITIVE_TYPE____STRING = EXPRESSION___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___BOOLEAN_TYPE = EXPRESSION___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___INTEGER_TYPE = EXPRESSION___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___STRING_TYPE = EXPRESSION___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___UNLIMITED_NATURAL_TYPE = EXPRESSION___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___BIT_STRING_TYPE = EXPRESSION___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___NATURAL_TYPE = EXPRESSION___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___COLLECTION_FUNCTION_ADD = EXPRESSION___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE = EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Type Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___TYPE_CACHED = EXPRESSION___TYPE_CACHED;

	/**
	 * The operation id for the '<em>Is Null</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___IS_NULL = EXPRESSION___IS_NULL;

	/**
	 * The operation id for the '<em>Is Assignable From Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE = EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT = EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Type Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT = EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Conformant With Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE = EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Multiplicity Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT = EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___REFERENCE = EXPRESSION___REFERENCE;

	/**
	 * The operation id for the '<em>New Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___NEW_ASSIGNMENTS = EXPRESSION___NEW_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Expression update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS = EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Update Assignments Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___UPDATE_ASSIGNMENTS_CACHED = EXPRESSION___UPDATE_ASSIGNMENTS_CACHED;

	/**
	 * The operation id for the '<em>Resolve</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___RESOLVE__STRING = EXPRESSION___RESOLVE__STRING;

	/**
	 * The operation id for the '<em>Is Add Target</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___IS_ADD_TARGET__EXPRESSION = EXPRESSION___IS_ADD_TARGET__EXPRESSION;

	/**
	 * The operation id for the '<em>Expression Assignment After Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Expression Unique Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP = EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Collection Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___COLLECTION_TYPE = EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___TYPE = EXPRESSION_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Constructor Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___CONSTRUCTOR_REFERENCE = EXPRESSION_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___UPPER = EXPRESSION_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___LOWER = EXPRESSION_OPERATION_COUNT + 4;

	/**
	 * The operation id for the '<em>Sequence Construction Expression Type Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___SEQUENCE_CONSTRUCTION_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 5;

	/**
	 * The operation id for the '<em>Sequence Construction Expression Upper Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___SEQUENCE_CONSTRUCTION_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 6;

	/**
	 * The operation id for the '<em>Sequence Construction Expression Lower Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___SEQUENCE_CONSTRUCTION_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 7;

	/**
	 * The operation id for the '<em>Sequence Construction Expression Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___SEQUENCE_CONSTRUCTION_EXPRESSION_TYPE__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 8;

	/**
	 * The operation id for the '<em>Sequence Construction Expression Element Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___SEQUENCE_CONSTRUCTION_EXPRESSION_ELEMENT_TYPE__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 9;

	/**
	 * The operation id for the '<em>Sequence Construction Expression Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___SEQUENCE_CONSTRUCTION_EXPRESSION_ASSIGNMENTS_BEFORE__DIAGNOSTICCHAIN_MAP = EXPRESSION_OPERATION_COUNT + 10;

	/**
	 * The operation id for the '<em>Update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION___UPDATE_ASSIGNMENTS = EXPRESSION_OPERATION_COUNT + 11;

	/**
	 * The number of operations of the '<em>Sequence Construction Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_CONSTRUCTION_EXPRESSION_OPERATION_COUNT = EXPRESSION_OPERATION_COUNT + 12;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.SequenceElementsImpl <em>Sequence Elements</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.SequenceElementsImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getSequenceElements()
	 * @generated
	 */
	int SEQUENCE_ELEMENTS = 47;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS__OWNER = SYNTAX_ELEMENT__OWNER;

	/**
	 * The feature id for the '<em><b>Upper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS__UPPER = SYNTAX_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Lower</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS__LOWER = SYNTAX_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Sequence Elements</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS_FEATURE_COUNT = SYNTAX_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS___TO_REFERENCE = SYNTAX_ELEMENT___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS___OWNER = SYNTAX_ELEMENT___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS___SYNTAX_ELEMENT_OWNER = SYNTAX_ELEMENT___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS___CURRENT_SCOPE = SYNTAX_ELEMENT___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS___SYNTAX_ELEMENT_CURRENT_SCOPE = SYNTAX_ELEMENT___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS___ENCLOSING_STATEMENT = SYNTAX_ELEMENT___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS___ENCLOSING_EXPRESSION = SYNTAX_ELEMENT___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS___ASSIGNMENTS_BEFORE = SYNTAX_ELEMENT___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = SYNTAX_ELEMENT___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = SYNTAX_ELEMENT___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = SYNTAX_ELEMENT___ASSIGNMENTS_BEFORE__SYNTAXELEMENT;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS___UPDATE_ALL__ELIST_ELIST = SYNTAX_ELEMENT___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS___COMMON_ANCESTOR__ELIST = SYNTAX_ELEMENT___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS___COMMON_ANCESTORS__ELIST = SYNTAX_ELEMENT___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS___REMOVE_DUPLICATE_ELEMENTS__ELIST = SYNTAX_ELEMENT___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS___RESOLVE_IN_LIBRARY__STRING = SYNTAX_ELEMENT___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS___PRIMITIVE_TYPE__STRING = SYNTAX_ELEMENT___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS___PRIMITIVE_TYPE____STRING = SYNTAX_ELEMENT___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS___BOOLEAN_TYPE = SYNTAX_ELEMENT___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS___INTEGER_TYPE = SYNTAX_ELEMENT___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS___IS_INTEGER_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS___STRING_TYPE = SYNTAX_ELEMENT___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS___IS_STRING_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS___UNLIMITED_NATURAL_TYPE = SYNTAX_ELEMENT___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS___BIT_STRING_TYPE = SYNTAX_ELEMENT___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS___NATURAL_TYPE = SYNTAX_ELEMENT___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS___IS_NATURAL_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS___IS_NUMERIC_TYPE__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS___COLLECTION_FUNCTION_ADD = SYNTAX_ELEMENT___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS___IS_COLLECTION_CLASS__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = SYNTAX_ELEMENT___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Conforms To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS___CONFORMS_TO__ELEMENTREFERENCE = SYNTAX_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Assignments After</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS___ASSIGNMENTS_AFTER = SYNTAX_ELEMENT_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS___UPPER = SYNTAX_ELEMENT_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS___LOWER = SYNTAX_ELEMENT_OPERATION_COUNT + 3;

	/**
	 * The number of operations of the '<em>Sequence Elements</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_ELEMENTS_OPERATION_COUNT = SYNTAX_ELEMENT_OPERATION_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.CollectOrIterateExpressionImpl <em>Collect Or Iterate Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.CollectOrIterateExpressionImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getCollectOrIterateExpression()
	 * @generated
	 */
	int COLLECT_OR_ITERATE_EXPRESSION = 48;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION__OWNER = SEQUENCE_EXPANSION_EXPRESSION__OWNER;

	/**
	 * The feature id for the '<em><b>Upper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION__UPPER = SEQUENCE_EXPANSION_EXPRESSION__UPPER;

	/**
	 * The feature id for the '<em><b>Lower</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION__LOWER = SEQUENCE_EXPANSION_EXPRESSION__LOWER;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION__TYPE = SEQUENCE_EXPANSION_EXPRESSION__TYPE;

	/**
	 * The feature id for the '<em><b>Assignment Before</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION__ASSIGNMENT_BEFORE = SEQUENCE_EXPANSION_EXPRESSION__ASSIGNMENT_BEFORE;

	/**
	 * The feature id for the '<em><b>Assignment After</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION__ASSIGNMENT_AFTER = SEQUENCE_EXPANSION_EXPRESSION__ASSIGNMENT_AFTER;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION__OPERATION = SEQUENCE_EXPANSION_EXPRESSION__OPERATION;

	/**
	 * The feature id for the '<em><b>Variable</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION__VARIABLE = SEQUENCE_EXPANSION_EXPRESSION__VARIABLE;

	/**
	 * The feature id for the '<em><b>Variable Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION__VARIABLE_SOURCE = SEQUENCE_EXPANSION_EXPRESSION__VARIABLE_SOURCE;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION__ARGUMENT = SEQUENCE_EXPANSION_EXPRESSION__ARGUMENT;

	/**
	 * The feature id for the '<em><b>Primary</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION__PRIMARY = SEQUENCE_EXPANSION_EXPRESSION__PRIMARY;

	/**
	 * The feature id for the '<em><b>Is Select Or Reject</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION__IS_SELECT_OR_REJECT = SEQUENCE_EXPANSION_EXPRESSION__IS_SELECT_OR_REJECT;

	/**
	 * The feature id for the '<em><b>Is Collect Or Iterate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION__IS_COLLECT_OR_ITERATE = SEQUENCE_EXPANSION_EXPRESSION__IS_COLLECT_OR_ITERATE;

	/**
	 * The feature id for the '<em><b>Is For All Or Exists Or One</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION__IS_FOR_ALL_OR_EXISTS_OR_ONE = SEQUENCE_EXPANSION_EXPRESSION__IS_FOR_ALL_OR_EXISTS_OR_ONE;

	/**
	 * The feature id for the '<em><b>Is Is Unique</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION__IS_IS_UNIQUE = SEQUENCE_EXPANSION_EXPRESSION__IS_IS_UNIQUE;

	/**
	 * The number of structural features of the '<em>Collect Or Iterate Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION_FEATURE_COUNT = SEQUENCE_EXPANSION_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___TO_REFERENCE = SEQUENCE_EXPANSION_EXPRESSION___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___OWNER = SEQUENCE_EXPANSION_EXPRESSION___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___SYNTAX_ELEMENT_OWNER = SEQUENCE_EXPANSION_EXPRESSION___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___CURRENT_SCOPE = SEQUENCE_EXPANSION_EXPRESSION___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE = SEQUENCE_EXPANSION_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___ENCLOSING_STATEMENT = SEQUENCE_EXPANSION_EXPRESSION___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___ENCLOSING_EXPRESSION = SEQUENCE_EXPANSION_EXPRESSION___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___ASSIGNMENTS_BEFORE = SEQUENCE_EXPANSION_EXPRESSION___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = SEQUENCE_EXPANSION_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = SEQUENCE_EXPANSION_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___UPDATE_ALL__ELIST_ELIST = SEQUENCE_EXPANSION_EXPRESSION___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___COMMON_ANCESTOR__ELIST = SEQUENCE_EXPANSION_EXPRESSION___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___COMMON_ANCESTORS__ELIST = SEQUENCE_EXPANSION_EXPRESSION___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST = SEQUENCE_EXPANSION_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___RESOLVE_IN_LIBRARY__STRING = SEQUENCE_EXPANSION_EXPRESSION___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___PRIMITIVE_TYPE__STRING = SEQUENCE_EXPANSION_EXPRESSION___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___PRIMITIVE_TYPE____STRING = SEQUENCE_EXPANSION_EXPRESSION___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___BOOLEAN_TYPE = SEQUENCE_EXPANSION_EXPRESSION___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___INTEGER_TYPE = SEQUENCE_EXPANSION_EXPRESSION___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___STRING_TYPE = SEQUENCE_EXPANSION_EXPRESSION___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___UNLIMITED_NATURAL_TYPE = SEQUENCE_EXPANSION_EXPRESSION___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___BIT_STRING_TYPE = SEQUENCE_EXPANSION_EXPRESSION___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___NATURAL_TYPE = SEQUENCE_EXPANSION_EXPRESSION___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___COLLECTION_FUNCTION_ADD = SEQUENCE_EXPANSION_EXPRESSION___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Type Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___TYPE_CACHED = SEQUENCE_EXPANSION_EXPRESSION___TYPE_CACHED;

	/**
	 * The operation id for the '<em>Is Null</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___IS_NULL = SEQUENCE_EXPANSION_EXPRESSION___IS_NULL;

	/**
	 * The operation id for the '<em>Is Assignable From Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT = SEQUENCE_EXPANSION_EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Type Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT = SEQUENCE_EXPANSION_EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Conformant With Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Multiplicity Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT = SEQUENCE_EXPANSION_EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___REFERENCE = SEQUENCE_EXPANSION_EXPRESSION___REFERENCE;

	/**
	 * The operation id for the '<em>New Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___NEW_ASSIGNMENTS = SEQUENCE_EXPANSION_EXPRESSION___NEW_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Expression update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS = SEQUENCE_EXPANSION_EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Update Assignments Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___UPDATE_ASSIGNMENTS_CACHED = SEQUENCE_EXPANSION_EXPRESSION___UPDATE_ASSIGNMENTS_CACHED;

	/**
	 * The operation id for the '<em>Resolve</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___RESOLVE__STRING = SEQUENCE_EXPANSION_EXPRESSION___RESOLVE__STRING;

	/**
	 * The operation id for the '<em>Is Add Target</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___IS_ADD_TARGET__EXPRESSION = SEQUENCE_EXPANSION_EXPRESSION___IS_ADD_TARGET__EXPRESSION;

	/**
	 * The operation id for the '<em>Expression Assignment After Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Expression Unique Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = SEQUENCE_EXPANSION_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT;

	/**
	 * The operation id for the '<em>Assignments After Primary</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___ASSIGNMENTS_AFTER_PRIMARY = SEQUENCE_EXPANSION_EXPRESSION___ASSIGNMENTS_AFTER_PRIMARY;

	/**
	 * The operation id for the '<em>Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___TYPE = SEQUENCE_EXPANSION_EXPRESSION___TYPE;

	/**
	 * The operation id for the '<em>Lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___LOWER = SEQUENCE_EXPANSION_EXPRESSION___LOWER;

	/**
	 * The operation id for the '<em>Upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___UPPER = SEQUENCE_EXPANSION_EXPRESSION___UPPER;

	/**
	 * The operation id for the '<em>Sequence Expansion Expression Variable Source Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_VARIABLE_SOURCE_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_VARIABLE_SOURCE_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Sequence Expansion Expression Assignments Before Primary</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_ASSIGNMENTS_BEFORE_PRIMARY__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_ASSIGNMENTS_BEFORE_PRIMARY__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Sequence Expansion Expression Assignments Before Argument</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_ASSIGNMENTS_BEFORE_ARGUMENT__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_ASSIGNMENTS_BEFORE_ARGUMENT__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Sequence Expansion Expression Variable Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_VARIABLE_NAME__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_VARIABLE_NAME__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Sequence Expansion Expression Assignments After Argument</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_ASSIGNMENTS_AFTER_ARGUMENT__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_ASSIGNMENTS_AFTER_ARGUMENT__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Select Or Reject Expression Type Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___SELECT_OR_REJECT_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___SELECT_OR_REJECT_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Select Or Reject Expression Lower Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___SELECT_OR_REJECT_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___SELECT_OR_REJECT_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Select Or Reject Expression Upper Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___SELECT_OR_REJECT_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___SELECT_OR_REJECT_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Select Or Reject Expression Argument</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___SELECT_OR_REJECT_EXPRESSION_ARGUMENT__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___SELECT_OR_REJECT_EXPRESSION_ARGUMENT__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>For All Or Exists Or One Expression Type Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>For All Or Exists Or One Expression Lower Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>For All Or Exists Or One Expression Upper Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>For All Or Exists Or One Expression Argument</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION_ARGUMENT__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION_ARGUMENT__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Is Unique Expression Type Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___IS_UNIQUE_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___IS_UNIQUE_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Is Unique Expression Lower Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___IS_UNIQUE_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___IS_UNIQUE_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Is Unique Expression Upper Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___IS_UNIQUE_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___IS_UNIQUE_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Is Unique Expression Expression Argument</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___IS_UNIQUE_EXPRESSION_EXPRESSION_ARGUMENT__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___IS_UNIQUE_EXPRESSION_EXPRESSION_ARGUMENT__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___UPDATE_ASSIGNMENTS = SEQUENCE_EXPANSION_EXPRESSION___UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Sequence Expansion Expression Operation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_OPERATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_OPERATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Collect Or Iterate Expression Type Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___COLLECT_OR_ITERATE_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Collect Or Iterate Expression Lower Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___COLLECT_OR_ITERATE_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Collect Or Iterate Expression Upper Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION___COLLECT_OR_ITERATE_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Collect Or Iterate Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_OR_ITERATE_EXPRESSION_OPERATION_COUNT = SEQUENCE_EXPANSION_EXPRESSION_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.IsUniqueExpressionImpl <em>Is Unique Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.IsUniqueExpressionImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getIsUniqueExpression()
	 * @generated
	 */
	int IS_UNIQUE_EXPRESSION = 49;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION__OWNER = SEQUENCE_EXPANSION_EXPRESSION__OWNER;

	/**
	 * The feature id for the '<em><b>Upper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION__UPPER = SEQUENCE_EXPANSION_EXPRESSION__UPPER;

	/**
	 * The feature id for the '<em><b>Lower</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION__LOWER = SEQUENCE_EXPANSION_EXPRESSION__LOWER;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION__TYPE = SEQUENCE_EXPANSION_EXPRESSION__TYPE;

	/**
	 * The feature id for the '<em><b>Assignment Before</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION__ASSIGNMENT_BEFORE = SEQUENCE_EXPANSION_EXPRESSION__ASSIGNMENT_BEFORE;

	/**
	 * The feature id for the '<em><b>Assignment After</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION__ASSIGNMENT_AFTER = SEQUENCE_EXPANSION_EXPRESSION__ASSIGNMENT_AFTER;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION__OPERATION = SEQUENCE_EXPANSION_EXPRESSION__OPERATION;

	/**
	 * The feature id for the '<em><b>Variable</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION__VARIABLE = SEQUENCE_EXPANSION_EXPRESSION__VARIABLE;

	/**
	 * The feature id for the '<em><b>Variable Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION__VARIABLE_SOURCE = SEQUENCE_EXPANSION_EXPRESSION__VARIABLE_SOURCE;

	/**
	 * The feature id for the '<em><b>Argument</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION__ARGUMENT = SEQUENCE_EXPANSION_EXPRESSION__ARGUMENT;

	/**
	 * The feature id for the '<em><b>Primary</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION__PRIMARY = SEQUENCE_EXPANSION_EXPRESSION__PRIMARY;

	/**
	 * The feature id for the '<em><b>Is Select Or Reject</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION__IS_SELECT_OR_REJECT = SEQUENCE_EXPANSION_EXPRESSION__IS_SELECT_OR_REJECT;

	/**
	 * The feature id for the '<em><b>Is Collect Or Iterate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION__IS_COLLECT_OR_ITERATE = SEQUENCE_EXPANSION_EXPRESSION__IS_COLLECT_OR_ITERATE;

	/**
	 * The feature id for the '<em><b>Is For All Or Exists Or One</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION__IS_FOR_ALL_OR_EXISTS_OR_ONE = SEQUENCE_EXPANSION_EXPRESSION__IS_FOR_ALL_OR_EXISTS_OR_ONE;

	/**
	 * The feature id for the '<em><b>Is Is Unique</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION__IS_IS_UNIQUE = SEQUENCE_EXPANSION_EXPRESSION__IS_IS_UNIQUE;

	/**
	 * The number of structural features of the '<em>Is Unique Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION_FEATURE_COUNT = SEQUENCE_EXPANSION_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___TO_REFERENCE = SEQUENCE_EXPANSION_EXPRESSION___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___OWNER = SEQUENCE_EXPANSION_EXPRESSION___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___SYNTAX_ELEMENT_OWNER = SEQUENCE_EXPANSION_EXPRESSION___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___CURRENT_SCOPE = SEQUENCE_EXPANSION_EXPRESSION___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE = SEQUENCE_EXPANSION_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___ENCLOSING_STATEMENT = SEQUENCE_EXPANSION_EXPRESSION___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___ENCLOSING_EXPRESSION = SEQUENCE_EXPANSION_EXPRESSION___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___ASSIGNMENTS_BEFORE = SEQUENCE_EXPANSION_EXPRESSION___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = SEQUENCE_EXPANSION_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = SEQUENCE_EXPANSION_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___UPDATE_ALL__ELIST_ELIST = SEQUENCE_EXPANSION_EXPRESSION___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___COMMON_ANCESTOR__ELIST = SEQUENCE_EXPANSION_EXPRESSION___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___COMMON_ANCESTORS__ELIST = SEQUENCE_EXPANSION_EXPRESSION___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST = SEQUENCE_EXPANSION_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___RESOLVE_IN_LIBRARY__STRING = SEQUENCE_EXPANSION_EXPRESSION___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___PRIMITIVE_TYPE__STRING = SEQUENCE_EXPANSION_EXPRESSION___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___PRIMITIVE_TYPE____STRING = SEQUENCE_EXPANSION_EXPRESSION___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___BOOLEAN_TYPE = SEQUENCE_EXPANSION_EXPRESSION___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___INTEGER_TYPE = SEQUENCE_EXPANSION_EXPRESSION___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___STRING_TYPE = SEQUENCE_EXPANSION_EXPRESSION___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___UNLIMITED_NATURAL_TYPE = SEQUENCE_EXPANSION_EXPRESSION___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___BIT_STRING_TYPE = SEQUENCE_EXPANSION_EXPRESSION___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___NATURAL_TYPE = SEQUENCE_EXPANSION_EXPRESSION___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___COLLECTION_FUNCTION_ADD = SEQUENCE_EXPANSION_EXPRESSION___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Type Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___TYPE_CACHED = SEQUENCE_EXPANSION_EXPRESSION___TYPE_CACHED;

	/**
	 * The operation id for the '<em>Is Null</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___IS_NULL = SEQUENCE_EXPANSION_EXPRESSION___IS_NULL;

	/**
	 * The operation id for the '<em>Is Assignable From Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT = SEQUENCE_EXPANSION_EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Type Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT = SEQUENCE_EXPANSION_EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Conformant With Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE = SEQUENCE_EXPANSION_EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Multiplicity Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT = SEQUENCE_EXPANSION_EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___REFERENCE = SEQUENCE_EXPANSION_EXPRESSION___REFERENCE;

	/**
	 * The operation id for the '<em>New Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___NEW_ASSIGNMENTS = SEQUENCE_EXPANSION_EXPRESSION___NEW_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Expression update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS = SEQUENCE_EXPANSION_EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Update Assignments Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___UPDATE_ASSIGNMENTS_CACHED = SEQUENCE_EXPANSION_EXPRESSION___UPDATE_ASSIGNMENTS_CACHED;

	/**
	 * The operation id for the '<em>Resolve</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___RESOLVE__STRING = SEQUENCE_EXPANSION_EXPRESSION___RESOLVE__STRING;

	/**
	 * The operation id for the '<em>Is Add Target</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___IS_ADD_TARGET__EXPRESSION = SEQUENCE_EXPANSION_EXPRESSION___IS_ADD_TARGET__EXPRESSION;

	/**
	 * The operation id for the '<em>Expression Assignment After Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Expression Unique Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = SEQUENCE_EXPANSION_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT;

	/**
	 * The operation id for the '<em>Assignments After Primary</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___ASSIGNMENTS_AFTER_PRIMARY = SEQUENCE_EXPANSION_EXPRESSION___ASSIGNMENTS_AFTER_PRIMARY;

	/**
	 * The operation id for the '<em>Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___TYPE = SEQUENCE_EXPANSION_EXPRESSION___TYPE;

	/**
	 * The operation id for the '<em>Lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___LOWER = SEQUENCE_EXPANSION_EXPRESSION___LOWER;

	/**
	 * The operation id for the '<em>Upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___UPPER = SEQUENCE_EXPANSION_EXPRESSION___UPPER;

	/**
	 * The operation id for the '<em>Sequence Expansion Expression Variable Source Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_VARIABLE_SOURCE_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_VARIABLE_SOURCE_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Sequence Expansion Expression Assignments Before Primary</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_ASSIGNMENTS_BEFORE_PRIMARY__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_ASSIGNMENTS_BEFORE_PRIMARY__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Sequence Expansion Expression Assignments Before Argument</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_ASSIGNMENTS_BEFORE_ARGUMENT__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_ASSIGNMENTS_BEFORE_ARGUMENT__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Sequence Expansion Expression Variable Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_VARIABLE_NAME__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_VARIABLE_NAME__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Sequence Expansion Expression Assignments After Argument</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_ASSIGNMENTS_AFTER_ARGUMENT__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_ASSIGNMENTS_AFTER_ARGUMENT__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Select Or Reject Expression Type Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___SELECT_OR_REJECT_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___SELECT_OR_REJECT_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Select Or Reject Expression Lower Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___SELECT_OR_REJECT_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___SELECT_OR_REJECT_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Select Or Reject Expression Upper Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___SELECT_OR_REJECT_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___SELECT_OR_REJECT_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Select Or Reject Expression Argument</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___SELECT_OR_REJECT_EXPRESSION_ARGUMENT__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___SELECT_OR_REJECT_EXPRESSION_ARGUMENT__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Collect Or Iterate Expression Type Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___COLLECT_OR_ITERATE_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___COLLECT_OR_ITERATE_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Collect Or Iterate Expression Lower Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___COLLECT_OR_ITERATE_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___COLLECT_OR_ITERATE_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Collect Or Iterate Expression Upper Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___COLLECT_OR_ITERATE_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___COLLECT_OR_ITERATE_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>For All Or Exists Or One Expression Type Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>For All Or Exists Or One Expression Lower Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>For All Or Exists Or One Expression Upper Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>For All Or Exists Or One Expression Argument</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION_ARGUMENT__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___FOR_ALL_OR_EXISTS_OR_ONE_EXPRESSION_ARGUMENT__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___UPDATE_ASSIGNMENTS = SEQUENCE_EXPANSION_EXPRESSION___UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Sequence Expansion Expression Operation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_OPERATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION___SEQUENCE_EXPANSION_EXPRESSION_OPERATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Is Unique Expression Type Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___IS_UNIQUE_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Is Unique Expression Lower Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___IS_UNIQUE_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Is Unique Expression Upper Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___IS_UNIQUE_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Is Unique Expression Expression Argument</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION___IS_UNIQUE_EXPRESSION_EXPRESSION_ARGUMENT__DIAGNOSTICCHAIN_MAP = SEQUENCE_EXPANSION_EXPRESSION_OPERATION_COUNT + 3;

	/**
	 * The number of operations of the '<em>Is Unique Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IS_UNIQUE_EXPRESSION_OPERATION_COUNT = SEQUENCE_EXPANSION_EXPRESSION_OPERATION_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.ArithmeticExpressionImpl <em>Arithmetic Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.ArithmeticExpressionImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getArithmeticExpression()
	 * @generated
	 */
	int ARITHMETIC_EXPRESSION = 50;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION__OWNER = BINARY_EXPRESSION__OWNER;

	/**
	 * The feature id for the '<em><b>Upper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION__UPPER = BINARY_EXPRESSION__UPPER;

	/**
	 * The feature id for the '<em><b>Lower</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION__LOWER = BINARY_EXPRESSION__LOWER;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION__TYPE = BINARY_EXPRESSION__TYPE;

	/**
	 * The feature id for the '<em><b>Assignment Before</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION__ASSIGNMENT_BEFORE = BINARY_EXPRESSION__ASSIGNMENT_BEFORE;

	/**
	 * The feature id for the '<em><b>Assignment After</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION__ASSIGNMENT_AFTER = BINARY_EXPRESSION__ASSIGNMENT_AFTER;

	/**
	 * The feature id for the '<em><b>Operand1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION__OPERAND1 = BINARY_EXPRESSION__OPERAND1;

	/**
	 * The feature id for the '<em><b>Operand2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION__OPERAND2 = BINARY_EXPRESSION__OPERAND2;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION__OPERATOR = BINARY_EXPRESSION__OPERATOR;

	/**
	 * The feature id for the '<em><b>Is Concatenation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION__IS_CONCATENATION = BINARY_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Arithmetic Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION_FEATURE_COUNT = BINARY_EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___TO_REFERENCE = BINARY_EXPRESSION___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___OWNER = BINARY_EXPRESSION___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___SYNTAX_ELEMENT_OWNER = BINARY_EXPRESSION___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___CURRENT_SCOPE = BINARY_EXPRESSION___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE = BINARY_EXPRESSION___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___ENCLOSING_STATEMENT = BINARY_EXPRESSION___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___ENCLOSING_EXPRESSION = BINARY_EXPRESSION___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___ASSIGNMENTS_BEFORE = BINARY_EXPRESSION___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = BINARY_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = BINARY_EXPRESSION___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = BINARY_EXPRESSION___ASSIGNMENTS_BEFORE__SYNTAXELEMENT;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___UPDATE_ALL__ELIST_ELIST = BINARY_EXPRESSION___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___COMMON_ANCESTOR__ELIST = BINARY_EXPRESSION___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___COMMON_ANCESTORS__ELIST = BINARY_EXPRESSION___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST = BINARY_EXPRESSION___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___RESOLVE_IN_LIBRARY__STRING = BINARY_EXPRESSION___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___PRIMITIVE_TYPE__STRING = BINARY_EXPRESSION___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___PRIMITIVE_TYPE____STRING = BINARY_EXPRESSION___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___BOOLEAN_TYPE = BINARY_EXPRESSION___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___INTEGER_TYPE = BINARY_EXPRESSION___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___STRING_TYPE = BINARY_EXPRESSION___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___UNLIMITED_NATURAL_TYPE = BINARY_EXPRESSION___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___BIT_STRING_TYPE = BINARY_EXPRESSION___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___NATURAL_TYPE = BINARY_EXPRESSION___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___COLLECTION_FUNCTION_ADD = BINARY_EXPRESSION___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Type Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___TYPE_CACHED = BINARY_EXPRESSION___TYPE_CACHED;

	/**
	 * The operation id for the '<em>Is Null</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___IS_NULL = BINARY_EXPRESSION___IS_NULL;

	/**
	 * The operation id for the '<em>Is Assignable From Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT = BINARY_EXPRESSION___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Type Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT = BINARY_EXPRESSION___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Conformant With Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE = BINARY_EXPRESSION___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Multiplicity Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT = BINARY_EXPRESSION___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___REFERENCE = BINARY_EXPRESSION___REFERENCE;

	/**
	 * The operation id for the '<em>New Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___NEW_ASSIGNMENTS = BINARY_EXPRESSION___NEW_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Expression update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS = BINARY_EXPRESSION___EXPRESSION_UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Update Assignments Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___UPDATE_ASSIGNMENTS_CACHED = BINARY_EXPRESSION___UPDATE_ASSIGNMENTS_CACHED;

	/**
	 * The operation id for the '<em>Resolve</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___RESOLVE__STRING = BINARY_EXPRESSION___RESOLVE__STRING;

	/**
	 * The operation id for the '<em>Is Add Target</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___IS_ADD_TARGET__EXPRESSION = BINARY_EXPRESSION___IS_ADD_TARGET__EXPRESSION;

	/**
	 * The operation id for the '<em>Expression Assignment After Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP = BINARY_EXPRESSION___EXPRESSION_ASSIGNMENT_AFTER_DERIVATION__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Expression Unique Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP = BINARY_EXPRESSION___EXPRESSION_UNIQUE_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Validate Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___VALIDATE_ASSIGNMENTS = BINARY_EXPRESSION___VALIDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>No Null Arguments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___NO_NULL_ARGUMENTS = BINARY_EXPRESSION___NO_NULL_ARGUMENTS;

	/**
	 * The operation id for the '<em>Binary Expression Operand Multiplicity</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___BINARY_EXPRESSION_OPERAND_MULTIPLICITY__DIAGNOSTICCHAIN_MAP = BINARY_EXPRESSION___BINARY_EXPRESSION_OPERAND_MULTIPLICITY__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Binary Expression Operand Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___BINARY_EXPRESSION_OPERAND_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP = BINARY_EXPRESSION___BINARY_EXPRESSION_OPERAND_ASSIGNMENTS__DIAGNOSTICCHAIN_MAP;

	/**
	 * The operation id for the '<em>Update Assignments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___UPDATE_ASSIGNMENTS = BINARY_EXPRESSION___UPDATE_ASSIGNMENTS;

	/**
	 * The operation id for the '<em>Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___TYPE = BINARY_EXPRESSION_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___LOWER = BINARY_EXPRESSION_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___UPPER = BINARY_EXPRESSION_OPERATION_COUNT + 2;

	/**
	 * The operation id for the '<em>Arithmetic Expression Is Concatenation Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___ARITHMETIC_EXPRESSION_IS_CONCATENATION_DERIVATION__DIAGNOSTICCHAIN_MAP = BINARY_EXPRESSION_OPERATION_COUNT + 3;

	/**
	 * The operation id for the '<em>Arithmetic Expression Type Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___ARITHMETIC_EXPRESSION_TYPE_DERIVATION__DIAGNOSTICCHAIN_MAP = BINARY_EXPRESSION_OPERATION_COUNT + 4;

	/**
	 * The operation id for the '<em>Arithmetic Expression Lower Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___ARITHMETIC_EXPRESSION_LOWER_DERIVATION__DIAGNOSTICCHAIN_MAP = BINARY_EXPRESSION_OPERATION_COUNT + 5;

	/**
	 * The operation id for the '<em>Arithmetic Expression Upper Derivation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___ARITHMETIC_EXPRESSION_UPPER_DERIVATION__DIAGNOSTICCHAIN_MAP = BINARY_EXPRESSION_OPERATION_COUNT + 6;

	/**
	 * The operation id for the '<em>Arithmetic Expression Operand Types</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION___ARITHMETIC_EXPRESSION_OPERAND_TYPES__DIAGNOSTICCHAIN_MAP = BINARY_EXPRESSION_OPERATION_COUNT + 7;

	/**
	 * The number of operations of the '<em>Arithmetic Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARITHMETIC_EXPRESSION_OPERATION_COUNT = BINARY_EXPRESSION_OPERATION_COUNT + 8;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.uml.alf.impl.FeatureLeftHandSideImpl <em>Feature Left Hand Side</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.uml.alf.impl.FeatureLeftHandSideImpl
	 * @see org.eclipse.papyrus.uml.alf.impl.AlfPackageImpl#getFeatureLeftHandSide()
	 * @generated
	 */
	int FEATURE_LEFT_HAND_SIDE = 51;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE__OWNER = LEFT_HAND_SIDE__OWNER;

	/**
	 * The feature id for the '<em><b>Upper</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE__UPPER = LEFT_HAND_SIDE__UPPER;

	/**
	 * The feature id for the '<em><b>Lower</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE__LOWER = LEFT_HAND_SIDE__LOWER;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE__TYPE = LEFT_HAND_SIDE__TYPE;

	/**
	 * The feature id for the '<em><b>Assignment Before</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE__ASSIGNMENT_BEFORE = LEFT_HAND_SIDE__ASSIGNMENT_BEFORE;

	/**
	 * The feature id for the '<em><b>Assignment After</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE__ASSIGNMENT_AFTER = LEFT_HAND_SIDE__ASSIGNMENT_AFTER;

	/**
	 * The feature id for the '<em><b>Referent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE__REFERENT = LEFT_HAND_SIDE__REFERENT;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE__EXPRESSION = LEFT_HAND_SIDE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Feature Left Hand Side</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE_FEATURE_COUNT = LEFT_HAND_SIDE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>To Reference</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___TO_REFERENCE = LEFT_HAND_SIDE___TO_REFERENCE;

	/**
	 * The operation id for the '<em>Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___OWNER = LEFT_HAND_SIDE___OWNER;

	/**
	 * The operation id for the '<em>Syntax Element owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___SYNTAX_ELEMENT_OWNER = LEFT_HAND_SIDE___SYNTAX_ELEMENT_OWNER;

	/**
	 * The operation id for the '<em>Current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___CURRENT_SCOPE = LEFT_HAND_SIDE___CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Syntax Element current Scope</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___SYNTAX_ELEMENT_CURRENT_SCOPE = LEFT_HAND_SIDE___SYNTAX_ELEMENT_CURRENT_SCOPE;

	/**
	 * The operation id for the '<em>Enclosing Statement</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___ENCLOSING_STATEMENT = LEFT_HAND_SIDE___ENCLOSING_STATEMENT;

	/**
	 * The operation id for the '<em>Enclosing Expression</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___ENCLOSING_EXPRESSION = LEFT_HAND_SIDE___ENCLOSING_EXPRESSION;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___ASSIGNMENTS_BEFORE = LEFT_HAND_SIDE___ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE = LEFT_HAND_SIDE___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE;

	/**
	 * The operation id for the '<em>Syntax Element assignments Before base</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE = LEFT_HAND_SIDE___SYNTAX_ELEMENT_ASSIGNMENTS_BEFORE_BASE;

	/**
	 * The operation id for the '<em>Update All</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___UPDATE_ALL__ELIST_ELIST = LEFT_HAND_SIDE___UPDATE_ALL__ELIST_ELIST;

	/**
	 * The operation id for the '<em>Common Ancestor</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___COMMON_ANCESTOR__ELIST = LEFT_HAND_SIDE___COMMON_ANCESTOR__ELIST;

	/**
	 * The operation id for the '<em>Common Ancestors</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___COMMON_ANCESTORS__ELIST = LEFT_HAND_SIDE___COMMON_ANCESTORS__ELIST;

	/**
	 * The operation id for the '<em>Remove Duplicate Elements</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___REMOVE_DUPLICATE_ELEMENTS__ELIST = LEFT_HAND_SIDE___REMOVE_DUPLICATE_ELEMENTS__ELIST;

	/**
	 * The operation id for the '<em>Resolve In Library</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___RESOLVE_IN_LIBRARY__STRING = LEFT_HAND_SIDE___RESOLVE_IN_LIBRARY__STRING;

	/**
	 * The operation id for the '<em>Primitive Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___PRIMITIVE_TYPE__STRING = LEFT_HAND_SIDE___PRIMITIVE_TYPE__STRING;

	/**
	 * The operation id for the '<em>Primitive Type </em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___PRIMITIVE_TYPE____STRING = LEFT_HAND_SIDE___PRIMITIVE_TYPE____STRING;

	/**
	 * The operation id for the '<em>Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___BOOLEAN_TYPE = LEFT_HAND_SIDE___BOOLEAN_TYPE;

	/**
	 * The operation id for the '<em>Is Boolean Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___IS_BOOLEAN_TYPE__ELEMENTREFERENCE = LEFT_HAND_SIDE___IS_BOOLEAN_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___INTEGER_TYPE = LEFT_HAND_SIDE___INTEGER_TYPE;

	/**
	 * The operation id for the '<em>Is Integer Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___IS_INTEGER_TYPE__ELEMENTREFERENCE = LEFT_HAND_SIDE___IS_INTEGER_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___STRING_TYPE = LEFT_HAND_SIDE___STRING_TYPE;

	/**
	 * The operation id for the '<em>Is String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___IS_STRING_TYPE__ELEMENTREFERENCE = LEFT_HAND_SIDE___IS_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___UNLIMITED_NATURAL_TYPE = LEFT_HAND_SIDE___UNLIMITED_NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Unlimited Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE = LEFT_HAND_SIDE___IS_UNLIMITED_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___BIT_STRING_TYPE = LEFT_HAND_SIDE___BIT_STRING_TYPE;

	/**
	 * The operation id for the '<em>Is Bit String Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___IS_BIT_STRING_TYPE__ELEMENTREFERENCE = LEFT_HAND_SIDE___IS_BIT_STRING_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___NATURAL_TYPE = LEFT_HAND_SIDE___NATURAL_TYPE;

	/**
	 * The operation id for the '<em>Is Natural Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___IS_NATURAL_TYPE__ELEMENTREFERENCE = LEFT_HAND_SIDE___IS_NATURAL_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Numeric Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___IS_NUMERIC_TYPE__ELEMENTREFERENCE = LEFT_HAND_SIDE___IS_NUMERIC_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Collection Function Add</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___COLLECTION_FUNCTION_ADD = LEFT_HAND_SIDE___COLLECTION_FUNCTION_ADD;

	/**
	 * The operation id for the '<em>Is Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___IS_COLLECTION_CLASS__ELEMENTREFERENCE = LEFT_HAND_SIDE___IS_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Integer Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE = LEFT_HAND_SIDE___IS_INTEGER_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Bit String Collection Class</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE = LEFT_HAND_SIDE___IS_BIT_STRING_COLLECTION_CLASS__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Type Cached</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___TYPE_CACHED = LEFT_HAND_SIDE___TYPE_CACHED;

	/**
	 * The operation id for the '<em>Is Null</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___IS_NULL = LEFT_HAND_SIDE___IS_NULL;

	/**
	 * The operation id for the '<em>Is Assignable From Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE = LEFT_HAND_SIDE___IS_ASSIGNABLE_FROM_ELEMENT__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Assignable From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT = LEFT_HAND_SIDE___IS_ASSIGNABLE_FROM__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Type Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT = LEFT_HAND_SIDE___IS_TYPE_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Is Conformant With Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE = LEFT_HAND_SIDE___IS_CONFORMANT_WITH_TYPE__ELEMENTREFERENCE;

	/**
	 * The operation id for the '<em>Is Multiplicity Conformant With</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT = LEFT_HAND_SIDE___IS_MULTIPLICITY_CONFORMANT_WITH__ASSIGNABLEELEMENT;

	/**
	 * The operation id for the '<em>Assignments Before</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___ASSIGNMENTS_BEFORE__SYNTAXELEMENT = LEFT_HAND_SIDE___ASSIGNMENTS_BEFORE__SYNTAXELEMENT;

	/**
	 * The operation id for the '<em>Assignments After</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___ASSIGNMENTS_AFTER = LEFT_HAND_SIDE___ASSIGNMENTS_AFTER;

	/**
	 * The operation id for the '<em>Type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___TYPE = LEFT_HAND_SIDE___TYPE;

	/**
	 * The operation id for the '<em>Left Hand Side type</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___LEFT_HAND_SIDE_TYPE = LEFT_HAND_SIDE___LEFT_HAND_SIDE_TYPE;

	/**
	 * The operation id for the '<em>Upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___UPPER = LEFT_HAND_SIDE___UPPER;

	/**
	 * The operation id for the '<em>Left Hand Side upper</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___LEFT_HAND_SIDE_UPPER = LEFT_HAND_SIDE___LEFT_HAND_SIDE_UPPER;

	/**
	 * The operation id for the '<em>Lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___LOWER = LEFT_HAND_SIDE___LOWER;

	/**
	 * The operation id for the '<em>Left Hand Side lower</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___LEFT_HAND_SIDE_LOWER = LEFT_HAND_SIDE___LEFT_HAND_SIDE_LOWER;

	/**
	 * The operation id for the '<em>Assigned Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___ASSIGNED_NAME = LEFT_HAND_SIDE___ASSIGNED_NAME;

	/**
	 * The operation id for the '<em>Is Data Value Update</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_LEFT_HAND_SIDE___IS_DATA_VALUE_UPDATE = LEFT_HAND_SIDE___IS_DATA_VALUE_UPDATE;

	/**
	 * The opera