/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.modelexplorer.handlers;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.internationalization.utils.utils.LabelInternationalization;
import org.eclipse.papyrus.infra.internationalization.utils.utils.LabelInternationalizationPreferencesUtils;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.modelexplorer.commands.RenameTableLabelCommand;
import org.eclipse.papyrus.infra.nattable.modelexplorer.handlers.AbstractTableCommandHandler;
import org.eclipse.papyrus.infra.nattable.modelexplorer.messages.Messages;
import org.eclipse.papyrus.views.modelexplorer.commands.RenameElementCommand;
import org.eclipse.papyrus.views.modelexplorer.util.ModelExplorerEditionUtil;

public class RenameTableHandler
extends AbstractTableCommandHandler {
    protected Command getCommand(IEvaluationContext context) {
        TransactionalEditingDomain editingDomain = this.getEditingDomain(context);
        List<Table> tables = this.getSelectedTables();
        if (editingDomain != null && tables.size() == 1) {
            Table table = tables.get(0);
            String tableLabel = LabelInternationalization.getInstance().getTableLabelWithoutName(table);
            if (tableLabel != null && LabelInternationalizationPreferencesUtils.getInternationalizationPreference((EObject)table)) {
                RenameTableLabelCommand cmd = new RenameTableLabelCommand(editingDomain, "ChangeTableLabelCommand", (EObject)table, tableLabel, Messages.RenameTableHandler_Label_DialogTitle);
                return new GMFtoEMFCommandWrapper((ICommand)cmd);
            }
            String currentName = table.getName();
            if (currentName != null) {
                EStructuralFeature nameFeature = table.eClass().getEStructuralFeature("name");
                return new RenameElementCommand(editingDomain, "RenameTableCommand", (EObject)table, currentName, nameFeature, Messages.RenameTableHandler_RenameAnExistingTable, Messages.RenameTableHandler_NewName);
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected boolean computeEnabled(IEvaluationContext context) {
        boolean computeEnabled = super.computeEnabled(context);
        if (computeEnabled) {
            List selectedElements = this.getSelectedElements();
            EObject selection = (EObject)selectedElements.get(0);
            computeEnabled = !EMFHelper.isReadOnly((EObject)selection);
        }
        return computeEnabled;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        EObject selectedTable = this.getSelectedElement();
        if (ModelExplorerEditionUtil.isHandledByDirectEditor((EObject)selectedTable)) {
            ModelExplorerEditionUtil.editElement((EObject)selectedTable);
        } else {
            super.execute(event);
        }
        return null;
    }
}

