/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.stereotype.migration;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.commands.RemoveEAnnotationDetailCommand;
import org.eclipse.papyrus.uml.diagram.common.stereotype.migration.StereotypeEAnnotationMigration;
import org.eclipse.papyrus.uml.diagram.common.stereotype.migration.commands.StereotypeLabelMigrationCommand;
import org.eclipse.papyrus.uml.diagram.common.util.CommandUtil;

public class StereotypeEAnnotationLabelMigration
extends StereotypeEAnnotationMigration {
    public static final String LABEL = "Migration of Stereotype Label";

    public StereotypeEAnnotationLabelMigration(View view) {
        super(view);
    }

    @Override
    public void cleanEAnnotationDetails(View view) {
        TransactionalEditingDomain domain = CommandUtil.resolveEditingDomain(view);
        RemoveEAnnotationDetailCommand deleteStereotype = new RemoveEAnnotationDetailCommand(domain, this.eAnnotation, "StereotypeList");
        CommandUtil.executeUnsafeCommand((Command)deleteStereotype, (Object)view);
        RemoveEAnnotationDetailCommand deleteQNList = new RemoveEAnnotationDetailCommand(domain, this.eAnnotation, "StereotypeWithQualifiedNameList");
        CommandUtil.executeUnsafeCommand((Command)deleteQNList, (Object)view);
    }

    @Override
    public boolean hasEAnnotationDetails(View view) {
        return this.migrationHelper.getStereotypesToDisplay((EModelElement)this.hostView) != null;
    }

    @Override
    public ICommand getStereotypeMigrationCommand(View view) {
        return new StereotypeLabelMigrationCommand(LABEL, view);
    }
}

