/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.drafter.model;

import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.core.resource.EMFLogicalModel;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class CreatedPapyrusProfileModel
extends EMFLogicalModel {
    public static final String UML_FILE_EXTENSION = "uml";
    public static final String MODEL_ID = CreatedPapyrusProfileModel.class.getName();
    public static final String PROFILE_FILE_EXTENSION = "profile";
    protected URI uriWithoutExtension;
    protected boolean isAdditionalResourcesRequired;
    protected Resource umlResource;
    protected Resource diResource;
    protected Resource notationResource;

    public CreatedPapyrusProfileModel(ModelSet owner, URI uriWithoutExtension, boolean isAdditionalResourcesRequired) {
        this.init(owner);
        this.uriWithoutExtension = uriWithoutExtension;
        this.isAdditionalResourcesRequired = isAdditionalResourcesRequired;
        String currentExtension = uriWithoutExtension.fileExtension();
        if (!PROFILE_FILE_EXTENSION.equals(currentExtension)) {
            uriWithoutExtension.appendFileExtension(PROFILE_FILE_EXTENSION);
        }
        this.createModel();
        owner.registerModel((IModel)this);
    }

    public String getIdentifier() {
        return this.uriWithoutExtension.toString();
    }

    protected String getModelFileExtension() {
        return UML_FILE_EXTENSION;
    }

    public void createModel() {
        this.umlResource = this.createUmlResource();
        if (this.umlResource.getContents().isEmpty()) {
            Profile profile = this.createProfile();
            this.umlResource.getContents().add((Object)profile);
        }
        this.resource = this.umlResource;
        if (this.isAdditionalResourcesRequired) {
            this.notationResource = this.createNotationResource();
            this.diResource = this.createDiResource();
        }
    }

    private Resource createUmlResource() {
        this.umlResource = this.createResource(this.uriWithoutExtension.appendFileExtension(UML_FILE_EXTENSION));
        return this.umlResource;
    }

    private Resource createNotationResource() {
        this.notationResource = this.createResource(this.uriWithoutExtension.appendFileExtension("notation"));
        return this.notationResource;
    }

    private Resource createDiResource() {
        this.diResource = this.createResource(this.uriWithoutExtension.appendFileExtension("di"));
        return this.diResource;
    }

    private Profile createProfile() {
        Profile resultProfile = UMLFactory.eINSTANCE.createProfile();
        return resultProfile;
    }

    /*
     * Unable to fully structure code
     */
    protected Resource createResource(URI resourceURI) {
        modelSet = this.getModelManager();
        resource = modelSet.getResource(resourceURI, false);
        if (resource != null) {
            try {
                modelSet.getResource(resourceURI, true);
            }
            catch (RuntimeException e) {
                attributes = modelSet.getURIConverter().getAttributes(resourceURI, Collections.singletonMap("requestedAttributes", Collections.singleton("length")));
                length = (Number)attributes.get("length");
                if (length == null || length.longValue() <= 0L) ** GOTO lbl14
                throw e;
            }
        } else {
            resource = this.getModelManager().createResource(resourceURI);
        }
lbl14:
        // 3 sources

        this.configureResource(resource);
        return resource;
    }

    protected boolean isRelatedResource(Resource resource) {
        if (resource == null) {
            return false;
        }
        return resource.getURI().trimFileExtension().equals(this.uriWithoutExtension);
    }

    public Profile getProfile() {
        return (Profile)this.umlResource.getContents().get(0);
    }

    public Resource getProfileResource() {
        return this.umlResource;
    }

    protected boolean isRootElement(EObject object) {
        return super.isRootElement(object) && object instanceof Profile;
    }

    protected boolean isSupportedRoot(EObject object) {
        return UMLPackage.Literals.PROFILE.isInstance((Object)object);
    }
}

