/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.edit.parts;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.layout.FreeFormLayoutEx;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.FigureUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.figures.CompactStateFigure;
import org.eclipse.papyrus.uml.diagram.timing.custom.figures.CrossFigure;
import org.eclipse.papyrus.uml.diagram.timing.custom.figures.DimensioningArrowFigure;
import org.eclipse.papyrus.uml.diagram.timing.custom.figures.GeneralOrderingHorizontalFigure;
import org.eclipse.papyrus.uml.diagram.timing.custom.figures.SmallSquareFigure;
import org.eclipse.papyrus.uml.diagram.timing.custom.figures.VerticalMarkFigure;
import org.eclipse.papyrus.uml.diagram.timing.custom.layouts.FillLayout;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.CompactLifelineCompartmentEditPartCN;

public class CustomCompactLifelineCompartmentEditPart
extends CompactLifelineCompartmentEditPartCN {
    public static final int FIRST_STATE_OFFSET = 100;

    public CustomCompactLifelineCompartmentEditPart(View view) {
        super(view);
    }

    @Override
    public IFigure createFigure() {
        final ResizableCompartmentFigure figure = (ResizableCompartmentFigure)super.createFigure();
        figure.setBorder(null);
        figure.getScrollPane().setBorder(null);
        figure.setLayoutManager((LayoutManager)new FillLayout());
        figure.getContentPane().setLayoutManager((LayoutManager)new FreeFormLayoutEx(){

            public void layout(IFigure container) {
                if (!(container.getParent().getLayoutManager() instanceof FillLayout)) {
                    container.getParent().setLayoutManager((LayoutManager)new FillLayout());
                }
                Rectangle clientArea = container.getParent().getClientArea();
                List children = container.getChildren();
                int x = clientArea.x + 100;
                int centerY = clientArea.y + clientArea.height / 2;
                int currentStateInvariantX = 0;
                int currentStateInvariantWidth = 0;
                int currentStateInvariantHeight = 0;
                int lastOccurrenceX = 0;
                boolean currentStateInvariantInfinite = false;
                boolean destruction = false;
                int destructionX = Integer.MAX_VALUE;
                int i = 0;
                while (i < children.size()) {
                    IFigure child = (IFigure)children.get(i);
                    CrossFigure crossFigure = (CrossFigure)FigureUtils.findChildFigureInstance((IFigure)child, CrossFigure.class);
                    if (crossFigure != null) {
                        Rectangle constraint = (Rectangle)this.getConstraint(child);
                        destruction = true;
                        destructionX = constraint.x;
                    }
                    ++i;
                }
                IFigure nextChild = null;
                int i2 = 0;
                while (i2 < children.size()) {
                    Dimension size;
                    Dimension preferredSize;
                    IFigure child = (IFigure)children.get(i2);
                    nextChild = i2 < children.size() - 1 ? (IFigure)children.get(i2 + 1) : null;
                    IFigure occurrenceFigure = CustomCompactLifelineCompartmentEditPart.getOccurrenceChild(child);
                    CompactStateFigure stateInvariantFigure = (CompactStateFigure)FigureUtils.findChildFigureInstance((IFigure)child, CompactStateFigure.class);
                    VerticalMarkFigure verticalMarkFigure = (VerticalMarkFigure)FigureUtils.findChildFigureInstance((IFigure)child, VerticalMarkFigure.class);
                    DimensioningArrowFigure dimensioningArrowFigure = (DimensioningArrowFigure)FigureUtils.findChildFigureInstance((IFigure)figure, DimensioningArrowFigure.class);
                    GeneralOrderingHorizontalFigure generalOrderingHorizontalFigure = (GeneralOrderingHorizontalFigure)FigureUtils.findChildFigureInstance((IFigure)figure, GeneralOrderingHorizontalFigure.class);
                    Rectangle constraint = (Rectangle)this.getConstraint(child);
                    if (occurrenceFigure != null) {
                        preferredSize = occurrenceFigure.getPreferredSize();
                        if (nextChild != null && FigureUtils.findChildFigureInstance((IFigure)nextChild, CompactStateFigure.class) != null) {
                            child.setBounds(new Rectangle(constraint.x, centerY - preferredSize.height / 2, preferredSize.width, preferredSize.height));
                            x = constraint.x + preferredSize.width;
                        } else {
                            int posX = constraint.x;
                            posX = Math.max(posX, currentStateInvariantX - 2);
                            posX = Math.min(posX, currentStateInvariantX + currentStateInvariantWidth - 2);
                            posX = Math.max(posX, lastOccurrenceX);
                            int halfHeight = CompactStateFigure.computeHalfHeightAtAbscissa(posX - currentStateInvariantX + 2, currentStateInvariantWidth, currentStateInvariantHeight, currentStateInvariantInfinite);
                            int topPos = centerY - halfHeight - 2;
                            int bottomPos = centerY + halfHeight - 2 - 1;
                            int posY = Math.abs(constraint.y - topPos) < Math.abs(constraint.y - bottomPos) ? topPos : bottomPos;
                            child.setBounds(new Rectangle(posX, posY, preferredSize.width, preferredSize.height));
                            lastOccurrenceX = x = posX + preferredSize.width;
                        }
                    } else if (stateInvariantFigure != null) {
                        int width;
                        preferredSize = stateInvariantFigure.getPreferredSize();
                        int height = Math.min(preferredSize.height, clientArea.height);
                        IFigure nextStateChangeOccurrence = CustomCompactLifelineCompartmentEditPart.findNextStateChangeOccurrence(children, i2 + 1);
                        if (nextStateChangeOccurrence != null) {
                            stateInvariantFigure.setInfinite(false);
                            currentStateInvariantInfinite = false;
                            width = ((Rectangle)this.getConstraint((IFigure)nextStateChangeOccurrence)).x - x;
                        } else if (destruction) {
                            stateInvariantFigure.setInfinite(false);
                            currentStateInvariantInfinite = false;
                            width = destructionX - x;
                        } else {
                            stateInvariantFigure.setInfinite(true);
                            currentStateInvariantInfinite = true;
                            width = clientArea.width - x;
                        }
                        child.setBounds(new Rectangle(x, centerY - height / 2, width, height));
                        currentStateInvariantX = x;
                        currentStateInvariantWidth = width;
                        currentStateInvariantHeight = height;
                        x += width;
                    } else if (verticalMarkFigure != null) {
                        size = verticalMarkFigure.getPreferredSize();
                        int margin = 3;
                        int y = centerY - 16 - 12 - 3;
                        child.setBounds(new Rectangle(constraint.x, y, size.width, size.height));
                    } else if (dimensioningArrowFigure != null) {
                        size = dimensioningArrowFigure.getPreferredSize();
                        if (constraint.width == Integer.MAX_VALUE) {
                            child.setBounds(new Rectangle(constraint.x, constraint.y, clientArea.width - constraint.x, size.height));
                        } else {
                            child.setBounds(new Rectangle(constraint.x, constraint.y, constraint.width, size.height));
                        }
                    } else if (generalOrderingHorizontalFigure != null) {
                        size = generalOrderingHorizontalFigure.getPreferredSize();
                        child.setBounds(new Rectangle(constraint.x, constraint.y, constraint.width, size.height));
                    }
                    ++i2;
                }
            }

            protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
                return new Dimension(-1, -1);
            }
        });
        return figure;
    }

    protected static IFigure getOccurrenceChild(IFigure child) {
        IFigure occurrenceFigure = FigureUtils.findChildFigureInstance((IFigure)child, SmallSquareFigure.class);
        if (occurrenceFigure == null) {
            occurrenceFigure = FigureUtils.findChildFigureInstance((IFigure)child, CrossFigure.class);
        }
        return occurrenceFigure;
    }

    protected static IFigure findNextStateChangeOccurrence(List<IFigure> children, int startIndex) {
        int i = startIndex;
        while (i < children.size() - 1) {
            IFigure figure1 = children.get(i);
            IFigure figure2 = children.get(i + 1);
            if (CustomCompactLifelineCompartmentEditPart.getOccurrenceChild(figure1) != null && FigureUtils.findChildFigureInstance((IFigure)figure2, CompactStateFigure.class) != null) {
                return figure1;
            }
            ++i;
        }
        return null;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        ((ResizableCompartmentFigure)this.getFigure()).getScrollPane().setScrollBarVisibility(0);
        this.refreshBounds();
    }

    public boolean isSelectable() {
        return false;
    }

    public Command getCommand(Request request) {
        if (request instanceof CreateConnectionRequest) {
            CreateConnectionRequest createConnectionRequest = (CreateConnectionRequest)request;
            if ("connection start".equals(request.getType())) {
                if (createConnectionRequest.getTargetEditPart() instanceof CompactLifelineCompartmentEditPartCN) {
                    createConnectionRequest.setTargetEditPart(this.getParent());
                }
                return this.getParent().getCommand(request);
            }
            if ("connection end".equals(request.getType())) {
                if (createConnectionRequest.getSourceEditPart() instanceof CompactLifelineCompartmentEditPartCN) {
                    createConnectionRequest.setSourceEditPart(this.getParent());
                }
                return this.getParent().getCommand(request);
            }
        }
        return super.getCommand(request);
    }
}

