/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.edit.policies;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands.CompactLifelineCreateCommandCN;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands.FullLifelineCreateCommandCN;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.policies.InteractionCompartmentItemSemanticEditPolicyTN;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.LifelineUtils;
import org.eclipse.papyrus.uml.diagram.timing.providers.UMLElementTypes;
import org.eclipse.uml2.uml.Lifeline;

public class CustomInteractionCompartmentItemSemanticEditPolicy
extends InteractionCompartmentItemSemanticEditPolicyTN {
    @Override
    protected Command getCreateCommand(CreateElementRequest req) {
        IElementType elementType = req.getElementType();
        if (UMLElementTypes.Lifeline_FullShape == elementType) {
            return this.getGEFWrapper((ICommand)new FullLifelineCreateCommandCN(req, DiagramUtils.getDiagramFrom((EditPart)this.getHost())){

                @Override
                protected void doConfigure(Lifeline newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    super.doConfigure(newElement, monitor, info);
                    LifelineUtils.setLifelineType(newElement, LifelineUtils.LifelineType.full);
                }
            });
        }
        if (UMLElementTypes.Lifeline_CompactShape == elementType) {
            return this.getGEFWrapper((ICommand)new CompactLifelineCreateCommandCN(req, DiagramUtils.getDiagramFrom((EditPart)this.getHost())){

                @Override
                protected void doConfigure(Lifeline newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    super.doConfigure(newElement, monitor, info);
                    LifelineUtils.setLifelineType(newElement, LifelineUtils.LifelineType.compact);
                }
            });
        }
        return super.getCreateCommand(req);
    }
}

