/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.essentialocl.attributes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.PrimitiveType;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.internal.complete.CompleteClassInternal;
import org.eclipse.ocl.pivot.internal.complete.CompleteModelInternal;
import org.eclipse.ocl.pivot.internal.complete.CompletePackageInternal;
import org.eclipse.ocl.pivot.internal.manager.OperationArguments;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.manager.TemplateParameterSubstitutionVisitor;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.values.TemplateParameterSubstitutions;

public abstract class AbstractOperationMatcher
implements OperationArguments {
    private static Comparator<@NonNull Operation> operationComparator = new Comparator<Operation>(){

        @Override
        public int compare(@NonNull Operation o1, @NonNull Operation o2) {
            int s2;
            int diff;
            String n1 = o1.getName();
            String n2 = o2.getName();
            if (n1 == null) {
                n1 = "";
            }
            if (n2 == null) {
                n2 = "";
            }
            if ((diff = n1.compareTo(n2)) != 0) {
                return diff;
            }
            List ownedParameters1 = o1.getOwnedParameters();
            List ownedParameters2 = o2.getOwnedParameters();
            int s1 = ownedParameters1.size();
            diff = s1 - (s2 = ownedParameters2.size());
            if (diff != 0) {
                return diff;
            }
            int i = 0;
            while (i < s1) {
                Parameter p1 = (Parameter)ownedParameters1.get(i);
                Parameter p2 = (Parameter)ownedParameters2.get(i);
                n1 = p1.getName();
                n2 = p2.getName();
                if (n1 == null) {
                    n1 = "";
                }
                if (n2 == null) {
                    n2 = "";
                }
                if ((diff = n1.compareTo(n2)) != 0) {
                    return diff;
                }
                ++i;
            }
            EObject e1 = o1.eContainer();
            EObject e2 = o2.eContainer();
            while (e1 instanceof NamedElement && e2 instanceof NamedElement) {
                n1 = ((NamedElement)e1).getName();
                n2 = ((NamedElement)e2).getName();
                if (n1 == null) {
                    n1 = "";
                }
                if (n2 == null) {
                    n2 = "";
                }
                if ((diff = n1.compareTo(n2)) != 0) {
                    return diff;
                }
                e1 = e1.eContainer();
                e2 = e2.eContainer();
            }
            return 0;
        }
    };
    protected final @NonNull EnvironmentFactoryInternal environmentFactory;
    protected final @NonNull PivotMetamodelManager metamodelManager;
    protected final @Nullable Type sourceType;
    private @Nullable List<@NonNull Operation> ambiguities = null;

    protected AbstractOperationMatcher(@NonNull EnvironmentFactoryInternal environmentFactory, @Nullable Type sourceType, @Nullable Type sourceTypeValue) {
        this.environmentFactory = environmentFactory;
        this.metamodelManager = environmentFactory.getMetamodelManager();
        this.sourceType = sourceType;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected int compareMatches(@NonNull Object match1, @NonNull TemplateParameterSubstitutions referenceBindings, @NonNull Object match2, @NonNull TemplateParameterSubstitutions candidateBindings, boolean useCoercions) {
        CompletePackageInternal s2;
        Type specializedCandidateType;
        CompleteModelInternal completeModel = this.environmentFactory.getCompleteModel();
        @NonNull Operation reference = (Operation)match1;
        @NonNull Operation candidate = (Operation)match2;
        Class referenceClass = reference.getOwningClass();
        Class candidateClass = candidate.getOwningClass();
        Class referenceType = referenceClass;
        Class candidateType = candidateClass;
        Type specializedReferenceType = referenceType != null ? completeModel.getSpecializedType((Type)referenceType, referenceBindings) : null;
        Type type = specializedCandidateType = candidateType != null ? completeModel.getSpecializedType((Type)candidateType, candidateBindings) : null;
        if (reference instanceof Iteration && candidate instanceof Iteration && specializedReferenceType != null && specializedCandidateType != null) {
            int iteratorCountDelta = ((Iteration)candidate).getOwnedIterators().size() - ((Iteration)reference).getOwnedIterators().size();
            if (iteratorCountDelta != 0) {
                return iteratorCountDelta;
            }
            if (referenceType != candidateType) {
                if (this.metamodelManager.conformsTo(specializedReferenceType, TemplateParameterSubstitutions.EMPTY, specializedCandidateType, TemplateParameterSubstitutions.EMPTY)) {
                    return 1;
                }
                if (this.metamodelManager.conformsTo(specializedCandidateType, TemplateParameterSubstitutions.EMPTY, specializedReferenceType, TemplateParameterSubstitutions.EMPTY)) {
                    return -1;
                }
            }
        }
        int referenceConversions = 0;
        int candidateConversions = 0;
        Type comparedSourceType = this.sourceType;
        if (comparedSourceType != specializedReferenceType) {
            ++referenceConversions;
        }
        if (comparedSourceType != specializedCandidateType) {
            ++candidateConversions;
        }
        @NonNull List candidateParameters = PivotUtilInternal.getOwnedParametersList((Operation)candidate);
        @NonNull List referenceParameters = PivotUtilInternal.getOwnedParametersList((Operation)reference);
        int i = 0;
        while (i < candidateParameters.size()) {
            OCLExpression pivotArgument = this.getArgument(i);
            Type argumentType = pivotArgument.getType();
            Parameter referenceParameter = (Parameter)referenceParameters.get(i);
            Parameter candidateParameter = (Parameter)candidateParameters.get(i);
            referenceType = PivotUtilInternal.getType((TypedElement)referenceParameter);
            candidateType = PivotUtilInternal.getType((TypedElement)candidateParameter);
            specializedReferenceType = completeModel.getSpecializedType((Type)referenceType, referenceBindings);
            specializedCandidateType = completeModel.getSpecializedType((Type)candidateType, candidateBindings);
            if (argumentType != specializedReferenceType) {
                ++referenceConversions;
            }
            if (argumentType != specializedCandidateType) {
                ++candidateConversions;
            }
            ++i;
        }
        if (candidateConversions != referenceConversions) {
            return candidateConversions - referenceConversions;
        }
        int verdict = this.metamodelManager.compareOperationMatches(reference, referenceBindings, candidate, candidateBindings);
        if (verdict != 0) {
            return verdict;
        }
        if (this.isRedefinitionOf(reference, candidate)) {
            return 1;
        }
        if (this.isRedefinitionOf(candidate, reference)) {
            return -1;
        }
        Package p1 = PivotUtil.getContainingPackage((EObject)reference);
        Package p2 = PivotUtil.getContainingPackage((EObject)candidate);
        if (p1 == null) {
            return 0;
        }
        if (p2 == null) {
            return 0;
        }
        CompletePackageInternal s1 = completeModel.getCompletePackage(p1);
        if (s1 != (s2 = completeModel.getCompletePackage(p2))) {
            return 0;
        }
        int i1 = s1.getIndex(p1);
        int i2 = s2.getIndex(p2);
        int indexDiff = i2 - i1;
        if (indexDiff != 0) {
            return indexDiff;
        }
        if (specializedReferenceType != null && specializedCandidateType != null) {
            if (this.metamodelManager.conformsTo(specializedReferenceType, referenceBindings, specializedCandidateType, candidateBindings)) {
                return 1;
            }
            if (this.metamodelManager.conformsTo(specializedCandidateType, candidateBindings, specializedReferenceType, referenceBindings)) {
                return -1;
            }
        }
        return 0;
    }

    public @Nullable List<@NonNull Operation> getAmbiguities() {
        return this.ambiguities;
    }

    public @Nullable Operation getBestOperation( @NonNull EssentialOCLCSLeft2RightVisitor.Invocations invocations, boolean useCoercions) {
        this.ambiguities = null;
        Operation bestOperation = null;
        TemplateParameterSubstitutions bestBindings = TemplateParameterSubstitutions.EMPTY;
        List<@NonNull Operation> ambiguities2 = this.ambiguities;
        for (NamedElement namedElement : invocations) {
            Operation candidateOperation;
            TemplateParameterSubstitutions candidateBindings;
            if (!(namedElement instanceof Operation) || (candidateBindings = this.matches(candidateOperation = (Operation)namedElement, useCoercions)) == null) continue;
            if (bestOperation == null) {
                bestOperation = candidateOperation;
                bestBindings = candidateBindings;
                continue;
            }
            int comparison = this.compareMatches(bestOperation, bestBindings, candidateOperation, candidateBindings, useCoercions);
            if (comparison < 0) {
                bestOperation = candidateOperation;
                bestBindings = candidateBindings;
                this.ambiguities = null;
                continue;
            }
            if (comparison != 0) continue;
            if (ambiguities2 == null) {
                this.ambiguities = ambiguities2 = new ArrayList<Operation>();
                ambiguities2.add(bestOperation);
            }
            ambiguities2.add(candidateOperation);
        }
        if (ambiguities2 != null) {
            Collections.sort(ambiguities2, operationComparator);
        }
        return bestOperation;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected boolean isRedefinitionOf(@NonNull Operation operation1, @NonNull Operation operation2) {
        @NonNull Iterable redefinedOperations = PivotUtil.getRedefinedOperations((Operation)operation1);
        for (Operation redefinedOperation : redefinedOperations) {
            if (redefinedOperation == operation2) {
                return true;
            }
            if (!this.isRedefinitionOf(redefinedOperation, operation2)) continue;
            return true;
        }
        return false;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @Nullable TemplateParameterSubstitutions matches(@NonNull Operation candidateOperation, boolean useCoercions) {
        @NonNull List candidateParameters = PivotUtilInternal.getOwnedParametersList((Operation)candidateOperation);
        int iSize = this.getArgumentCount();
        if (iSize != candidateParameters.size()) {
            return null;
        }
        TemplateParameterSubstitutions bindings = TemplateParameterSubstitutionVisitor.createBindings((EnvironmentFactoryInternal)this.environmentFactory, (Type)this.sourceType, null, (Operation)candidateOperation);
        int i = 0;
        while (i < iSize) {
            Parameter candidateParameter = (Parameter)candidateParameters.get(i);
            OCLExpression expression = this.getArgument(i);
            Type candidateType = PivotUtilInternal.getType((TypedElement)candidateParameter);
            Type expressionType = PivotUtilInternal.getType((TypedElement)expression);
            if (!this.metamodelManager.conformsTo(expressionType, TemplateParameterSubstitutions.EMPTY, candidateType, bindings)) {
                boolean coerceable = false;
                if (useCoercions) {
                    CompleteClassInternal completeClass = this.metamodelManager.getCompleteClass(expressionType);
                    for (Class partialClass : completeClass.getPartialClasses()) {
                        if (!(partialClass instanceof PrimitiveType)) continue;
                        for (Operation coercion : ((PrimitiveType)partialClass).getCoercions()) {
                            Type corcedSourceType = coercion.getType();
                            if (corcedSourceType == null || !corcedSourceType.conformsTo((StandardLibrary)this.metamodelManager.getStandardLibrary(), candidateType)) continue;
                            coerceable = true;
                            break;
                        }
                        if (coerceable) break;
                    }
                }
                if (!coerceable) {
                    return null;
                }
            }
            ++i;
        }
        return bindings;
    }
}

