/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.generics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Stack;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.corext.refactoring.generics.ElementStructureEnvironment;
import org.eclipse.jdt.internal.corext.refactoring.generics.InferTypeArgumentsTCModel;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.GenericType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.CollectionElementVariable2;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.ConstraintVariable2;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.ITypeConstraint2;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.SubTypeConstraint2;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.TypeEquivalenceSet;

public class ParametricStructureComputer {
    private static final boolean DEBUG_INITIALIZATION = false;
    private final ElementStructureEnvironment fElemStructureEnv = new ElementStructureEnvironment();
    private final ConstraintVariable2[] fAllConstraintVariables;
    private InferTypeArgumentsTCModel fTCModel;
    private Stack<ConstraintVariable2> fWorkList2 = new Stack();

    public ParametricStructureComputer(ConstraintVariable2[] allConstraintVariables, InferTypeArgumentsTCModel tcModel) {
        this.fAllConstraintVariables = allConstraintVariables;
        this.fTCModel = tcModel;
    }

    public ElementStructureEnvironment getElemStructureEnv() {
        return this.fElemStructureEnv;
    }

    private void dumpContainerStructure() {
        System.out.println("\n*** Container Structure: ***\n");
        ConstraintVariable2[] constraintVariable2Array = this.fAllConstraintVariables;
        int n = this.fAllConstraintVariables.length;
        int n2 = 0;
        while (n2 < n) {
            ConstraintVariable2 v = constraintVariable2Array[n2];
            if (this.elemStructure(v) != null && this.elemStructure(v) != ParametricStructure.NONE) {
                System.out.println("elemStructure(" + v.toString() + ") = " + this.elemStructure(v));
            }
            ++n2;
        }
        System.out.println();
    }

    private void setStructureAndPush(ConstraintVariable2 v, ParametricStructure structure) {
        this.setElemStructure(v, structure);
        this.fWorkList2.push(v);
    }

    private void initializeContainerStructure() {
        ConstraintVariable2[] constraintVariable2Array = this.fAllConstraintVariables;
        int n = this.fAllConstraintVariables.length;
        int n2 = 0;
        while (n2 < n) {
            ConstraintVariable2 v = constraintVariable2Array[n2];
            TType varType = ParametricStructureComputer.declaredTypeOf(v);
            if (varType != null) {
                if (this.isParametricType(varType) && !this.isUnmodifiableFieldOrMethod(v)) {
                    this.setStructureAndPush(v, this.newParametricType(varType));
                } else if (!this.mightBeParametric(varType)) {
                    this.setStructureAndPush(v, ParametricStructure.NONE);
                }
            }
            ++n2;
        }
    }

    protected static TType declaredTypeOf(ConstraintVariable2 cv) {
        return cv.getType();
    }

    private boolean mightBeParametric(TType type) {
        return this.isParametricType(type);
    }

    private void computeContainerStructure() {
        this.initializeContainerStructure();
        while (!this.fWorkList2.isEmpty()) {
            ConstraintVariable2 v = this.fWorkList2.pop();
            for (ITypeConstraint2 constraint : this.fTCModel.getUsedIn(v)) {
                SubTypeConstraint2 stc = (SubTypeConstraint2)constraint;
                ConstraintVariable2 lhs = stc.getLeft();
                ConstraintVariable2 rhs = stc.getRight();
                this.unifyContainerStructure(lhs, rhs);
            }
            TypeEquivalenceSet typeEquivalenceSet = v.getTypeEquivalenceSet();
            if (typeEquivalenceSet == null) continue;
            ConstraintVariable2[] contributingVariables = typeEquivalenceSet.getContributingVariables();
            int i = 0;
            while (i + 1 < contributingVariables.length) {
                ConstraintVariable2 first = contributingVariables[i];
                ConstraintVariable2 second = contributingVariables[i + 1];
                this.unifyContainerStructure(first, second);
                ++i;
            }
        }
    }

    private void unifyContainerStructure(ConstraintVariable2 lhs, ConstraintVariable2 rhs) {
        if (this.isUnmodifiableFieldOrMethod(lhs) || this.isUnmodifiableFieldOrMethod(rhs)) {
            return;
        }
        if (this.updateStructureOfVar(lhs, this.elemStructure(rhs), TypeOperator.SubType)) {
            if (lhs instanceof CollectionElementVariable2) {
                this.updateParentContainerStructureFrom((CollectionElementVariable2)lhs, rhs);
            }
            this.updateElementVarStructureFromParent(lhs);
        }
        if (this.updateStructureOfVar(rhs, this.elemStructure(lhs), TypeOperator.SuperType)) {
            if (rhs instanceof CollectionElementVariable2) {
                this.updateParentContainerStructureFrom((CollectionElementVariable2)rhs, lhs);
            }
            this.updateElementVarStructureFromParent(rhs);
        }
    }

    private ParametricStructure newParametricType(TType varType) {
        GenericType genericType = (GenericType)varType.getTypeDeclaration();
        return new ParametricStructure(genericType);
    }

    private boolean isUnmodifiableFieldOrMethod(ConstraintVariable2 v) {
        return false;
    }

    private boolean isParametricType(TType type) {
        return type.isParameterizedType() || type.isGenericType() || type.isRawType() && type.getTypeDeclaration().isGenericType();
    }

    private boolean updateStructureOfIthParamFrom(ParametricStructure structure1, int i, ParametricStructure otherStructure) {
        boolean otherStructured;
        boolean param1Unknown;
        if (otherStructure == null) {
            return false;
        }
        Assert.isTrue((structure1 != otherStructure ? 1 : 0) != 0, (String)"updateStructureOfIthParamFrom(): attempt to unify ith param of a parametric type with itself!");
        ParametricStructure param1 = structure1.getParameters()[i];
        boolean bl = param1Unknown = param1 == null;
        if (param1Unknown) {
            structure1.getParameters()[i] = otherStructure;
            return true;
        }
        boolean paramStructured = param1 != ParametricStructure.NONE;
        boolean bl2 = otherStructured = otherStructure != ParametricStructure.NONE;
        if (paramStructured && otherStructured) {
            if (param1.getBase().equals(otherStructure.getBase())) {
                return this.updateStructureOfType(param1, otherStructure);
            }
            structure1.getParameters()[i] = ParametricStructure.NONE;
            return true;
        }
        return false;
    }

    private void updateElementVarStructureFromParent(ConstraintVariable2 v) {
        if (this.elemStructure(v) != ParametricStructure.NONE && this.fTCModel.getElementVariables(v).size() > 0) {
            ParametricStructure t = this.elemStructure(v);
            for (CollectionElementVariable2 typeVar : this.fTCModel.getElementVariables(v).values()) {
                int declarationTypeVariableIndex = typeVar.getDeclarationTypeVariableIndex();
                if (declarationTypeVariableIndex == -1) continue;
                this.updateStructureOfVar(typeVar, t.getParameters()[declarationTypeVariableIndex], TypeOperator.Equals);
            }
        }
    }

    private void updateParentContainerStructureFrom(CollectionElementVariable2 elemVar, ConstraintVariable2 v1) {
        ConstraintVariable2 elemContainer = elemVar.getParentConstraintVariable();
        ParametricStructure elemContainerStructure = this.elemStructure(elemContainer);
        if (elemContainerStructure == ParametricStructure.NONE) {
            return;
        }
        if (elemContainerStructure == null) {
            elemContainerStructure = this.newParametricType(elemContainer.getType());
            this.setStructureAndPush(elemContainer, elemContainerStructure);
        }
        ParametricStructure v1Structure = this.elemStructure(v1);
        int parmIdx = elemVar.getDeclarationTypeVariableIndex();
        if (parmIdx == -1) {
            return;
        }
        if (elemContainerStructure == v1Structure || this.containsSubStructure(v1Structure, elemContainerStructure)) {
            if (this.elemStructure(elemVar) != ParametricStructure.NONE) {
                this.setStructureAndPush(elemVar, ParametricStructure.NONE);
            }
            if (elemContainerStructure.getParameters()[parmIdx] == null) {
                elemContainerStructure.getParameters()[parmIdx] = ParametricStructure.NONE;
                this.fWorkList2.push(elemContainer);
            }
        } else if (this.updateStructureOfIthParamFrom(elemContainerStructure, parmIdx, v1Structure)) {
            this.setStructureAndPush(elemVar, elemContainerStructure.getParameters()[parmIdx]);
            this.fWorkList2.push(elemContainer);
        }
    }

    private boolean containsSubStructure(ParametricStructure containingStructure, ParametricStructure subStructure) {
        if (containingStructure == null) {
            return false;
        }
        ParametricStructure[] parametricStructureArray = containingStructure.getParameters();
        int n = parametricStructureArray.length;
        int n2 = 0;
        while (n2 < n) {
            ParametricStructure parameter = parametricStructureArray[n2];
            if (parameter == subStructure || this.containsSubStructure(parameter, subStructure)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean updateStructureOfType(ParametricStructure type1, ParametricStructure type2) {
        if (type1 == null || type2 == null) {
            return false;
        }
        ParametricStructure[] parms1 = type1.getParameters();
        ParametricStructure[] parms2 = type2.getParameters();
        boolean someChange = false;
        Assert.isTrue((parms1.length == parms2.length ? 1 : 0) != 0);
        int i = 0;
        while (i < parms1.length) {
            if (type1 == parms2[i]) {
                if (parms1[i] != ParametricStructure.NONE) {
                    parms1[i] = ParametricStructure.NONE;
                    someChange = true;
                }
            } else if (this.updateStructureOfIthParamFrom(type1, i, parms2[i])) {
                someChange = true;
            }
            ++i;
        }
        return someChange;
    }

    private boolean updateStructureOfVar(ConstraintVariable2 v, ParametricStructure type2, TypeOperator op) {
        boolean vStructured;
        boolean type2Structured;
        if (type2 == null) {
            return false;
        }
        ParametricStructure vStructure = this.elemStructure(v);
        boolean vStructureUnknown = vStructure == null;
        boolean bl = type2Structured = type2 != ParametricStructure.NONE;
        if (vStructureUnknown) {
            this.setStructureAndPush(v, type2);
            return true;
        }
        boolean bl2 = vStructured = vStructure != ParametricStructure.NONE;
        if (vStructured && !type2Structured) {
            if (op == TypeOperator.Equals || op == TypeOperator.SuperType) {
                this.setStructureAndPush(v, type2);
                return true;
            }
        } else if (vStructured && type2Structured) {
            if (!vStructure.getBase().equals(type2.getBase())) {
                if (op == TypeOperator.SuperType) {
                    this.setStructureAndPush(v, ParametricStructure.NONE);
                    return true;
                }
            } else if (this.updateStructureOfType(vStructure, type2)) {
                this.fWorkList2.push(v);
                return true;
            }
        }
        return false;
    }

    private void setElemStructure(ConstraintVariable2 v, ParametricStructure t) {
        this.fElemStructureEnv.setElemStructure(v, t);
    }

    private ParametricStructure elemStructure(ConstraintVariable2 v) {
        return this.fElemStructureEnv.elemStructure(v);
    }

    public Collection<CollectionElementVariable2> createElemConstraintVariables() {
        HashSet<CollectionElementVariable2> newVars = new HashSet<CollectionElementVariable2>();
        this.computeContainerStructure();
        ConstraintVariable2[] constraintVariable2Array = this.fAllConstraintVariables;
        int n = this.fAllConstraintVariables.length;
        int n2 = 0;
        while (n2 < n) {
            ConstraintVariable2 constraintVariable = constraintVariable2Array[n2];
            newVars.addAll(this.createVariablesFor(constraintVariable));
            ++n2;
        }
        return newVars;
    }

    private Collection<CollectionElementVariable2> createVariablesFor(ConstraintVariable2 v) {
        ParametricStructure t = this.elemStructure(v);
        if (t == null || t == ParametricStructure.NONE) {
            return Collections.emptyList();
        }
        ParametricStructure parmType = t;
        GenericType base = parmType.getBase();
        if (this.isParametricType(base)) {
            return this.createAndInitVars(v, parmType);
        }
        throw new IllegalStateException("Attempt to create element variables for parametric variable of unknown type: " + parmType);
    }

    private Collection<CollectionElementVariable2> getElementVariables(GenericType base, ConstraintVariable2 parent) {
        this.fTCModel.makeElementVariables(parent, base);
        return this.fTCModel.getElementVariables(parent).values();
    }

    private Collection<CollectionElementVariable2> createAndInitVars(ConstraintVariable2 v, ParametricStructure parmType) {
        Collection<CollectionElementVariable2> elementVars = this.getElementVariables(parmType.getBase(), v);
        Collection<CollectionElementVariable2> result = this.createVars(elementVars, parmType.getParameters());
        return result;
    }

    private Collection<CollectionElementVariable2> createVars(Collection<CollectionElementVariable2> cvs, ParametricStructure[] parms) {
        int declarationTypeVariableIndex;
        if (parms.length > 0) {
            for (CollectionElementVariable2 childVar : cvs) {
                declarationTypeVariableIndex = childVar.getDeclarationTypeVariableIndex();
                if (declarationTypeVariableIndex == -1) continue;
                this.setElemStructure(childVar, parms[declarationTypeVariableIndex]);
            }
        } else {
            for (CollectionElementVariable2 childVar : cvs) {
                declarationTypeVariableIndex = childVar.getDeclarationTypeVariableIndex();
                if (declarationTypeVariableIndex == -1) continue;
                this.setElemStructure(childVar, ParametricStructure.NONE);
            }
        }
        ArrayList<CollectionElementVariable2> result = new ArrayList<CollectionElementVariable2>(cvs.size() * 2);
        for (CollectionElementVariable2 childVar : cvs) {
            int declarationTypeVariableIndex2 = childVar.getDeclarationTypeVariableIndex();
            if (declarationTypeVariableIndex2 == -1) continue;
            result.add(childVar);
            result.addAll(this.createVariablesFor(childVar));
        }
        return result;
    }

    public static class ParametricStructure {
        public static final ParametricStructure NONE = new ParametricStructure();
        private final GenericType fBase;
        private final ParametricStructure[] fParameters;

        public ParametricStructure(GenericType base) {
            if (base == null) {
                throw new NullPointerException();
            }
            this.fBase = base;
            this.fParameters = new ParametricStructure[base.getTypeParameters().length];
        }

        private ParametricStructure() {
            this.fBase = null;
            this.fParameters = new ParametricStructure[0];
        }

        public ParametricStructure[] getParameters() {
            return this.fParameters;
        }

        public GenericType getBase() {
            return this.fBase;
        }

        public String toString() {
            if (this == NONE) {
                return "NONE";
            }
            return "ParamStructure " + this.fBase.toString() + '<' + Arrays.asList(this.fParameters) + '>';
        }
    }

    static class TypeOperator {
        private final String fOp;
        public static TypeOperator Equals = new TypeOperator("=^=");
        public static TypeOperator SubType = new TypeOperator("<=");
        public static TypeOperator SuperType = new TypeOperator("=>");

        private TypeOperator(String op) {
            this.fOp = op;
        }

        public String toString() {
            return this.fOp;
        }
    }
}

