/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.util;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.AbstractRepresentation;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.Representation;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.RepresentationKind;
import org.eclipse.papyrus.infra.tools.util.ClasspathHelper;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.core.registries.ElementTypeConfigurationTypeRegistry;

public class ExpansionModelValidationUtil {
    public static boolean validate_facrtories(AbstractRepresentation abstractRepresentation, DiagnosticChain diagnostic, Map<?, ?> context) {
        boolean valid = true;
        if (diagnostic != null && abstractRepresentation.getKind() == null && (abstractRepresentation.getEditPartQualifiedName() == null || "".equals(abstractRepresentation.getEditPartQualifiedName().trim())) && (abstractRepresentation.getViewFactory() == null || "".equals(abstractRepresentation.getViewFactory().trim()))) {
            valid = false;
            diagnostic.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel", 1, "The representation '" + abstractRepresentation.getName() + "' has no kind, no editpartQualifiedName, no viewFactory.", new Object[]{abstractRepresentation}));
        }
        return valid;
    }

    public static boolean validate_loadclasses(AbstractRepresentation abstractRepresentation, DiagnosticChain diagnostic, Map<?, ?> context) {
        boolean valid = true;
        if (diagnostic != null) {
            Object loadedClass;
            URI modelContextURI = EcoreUtil.getURI((EObject)abstractRepresentation);
            if (abstractRepresentation.getEditPartQualifiedName() != null && !"".equals(abstractRepresentation.getEditPartQualifiedName().trim()) && (loadedClass = ClasspathHelper.INSTANCE.findClass(abstractRepresentation.getEditPartQualifiedName(), modelContextURI, null)) == null) {
                valid = false;
                diagnostic.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel", 1, "The representation '" + abstractRepresentation.getName() + "' references an edit part that does not exist: " + abstractRepresentation.getEditPartQualifiedName(), new Object[]{abstractRepresentation}));
            }
            if (abstractRepresentation.getViewFactory() != null && !"".equals(abstractRepresentation.getViewFactory().trim()) && (loadedClass = ClasspathHelper.INSTANCE.findClass(abstractRepresentation.getViewFactory(), modelContextURI, null)) == null) {
                valid = false;
                diagnostic.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel", 1, "The representation '" + abstractRepresentation.getName() + "' references a view factory that does not exist: " + abstractRepresentation.getViewFactory(), new Object[]{abstractRepresentation}));
            }
        }
        return valid;
    }

    public static boolean validate_loadclasses(RepresentationKind abstractRepresentation, DiagnosticChain diagnostic, Map<?, ?> context) {
        boolean valid = true;
        if (diagnostic != null) {
            Object loadedClass;
            URI modelContextURI = EcoreUtil.getURI((EObject)abstractRepresentation);
            if (!(abstractRepresentation.getEditPartQualifiedName() == null && "".equals(abstractRepresentation.getEditPartQualifiedName().trim()) || (loadedClass = ClasspathHelper.INSTANCE.findClass(abstractRepresentation.getEditPartQualifiedName(), modelContextURI, null)) != null)) {
                valid = false;
                diagnostic.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel", 1, "The representation '" + abstractRepresentation.getName() + "' references an edit part that does not exist " + abstractRepresentation.getEditPartQualifiedName(), new Object[]{abstractRepresentation}));
            }
            if (!(abstractRepresentation.getViewFactory() == null && "".equals(abstractRepresentation.getViewFactory().trim()) || (loadedClass = ClasspathHelper.INSTANCE.findClass(abstractRepresentation.getViewFactory(), modelContextURI, null)) != null)) {
                valid = false;
                diagnostic.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel", 1, "The representation '" + abstractRepresentation.getName() + "' references a view factory that does not exist " + abstractRepresentation.getViewFactory(), new Object[]{abstractRepresentation}));
            }
        }
        return valid;
    }

    public static boolean validate_ElementType(Representation abstractRepresentation, DiagnosticChain diagnostic, Map<?, ?> context) {
        IElementType elementType;
        boolean valid = true;
        ElementTypeConfigurationTypeRegistry.getInstance();
        if (abstractRepresentation.getGraphicalElementTypeRef() != null) {
            ElementTypeConfiguration o = abstractRepresentation.getGraphicalElementTypeRef();
            if (o instanceof ElementTypeConfiguration) {
                ElementTypeConfiguration elementTypeConfiguration = o;
                elementType = ElementTypeRegistry.getInstance().getType(elementTypeConfiguration.getIdentifier());
            } else {
                elementType = null;
            }
        } else {
            elementType = null;
        }
        if (elementType == null) {
            valid = false;
            diagnostic.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel", 1, "The representation '" + abstractRepresentation.getName() + "' references a element type that does not exist " + abstractRepresentation.getGraphicalElementTypeRef(), new Object[]{abstractRepresentation}));
        }
        return valid;
    }
}

