/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DurationObservation;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.TimeObservation;
import org.eclipse.uml2.uml.UMLPackage;

public class SequenceViewDependentsAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeSetCommand(SetRequest request) {
        EObject element = request.getElementToEdit();
        View view = this.findView(element);
        if (view != null) {
            EStructuralFeature feature = request.getFeature();
            Object value = request.getValue();
            if (!(value instanceof List)) {
                return null;
            }
            ArrayList<Edge> destroyEdges = new ArrayList<Edge>();
            ArrayList<NamedElement> targetObjects = new ArrayList<NamedElement>();
            if (element instanceof Comment && UMLPackage.Literals.COMMENT__ANNOTATED_ELEMENT == feature) {
                targetObjects.addAll((Collection<NamedElement>)((Comment)element).getAnnotatedElements());
            } else if (element instanceof DurationObservation && UMLPackage.Literals.DURATION_OBSERVATION__EVENT == feature) {
                targetObjects.addAll((Collection<NamedElement>)((DurationObservation)element).getEvents());
            } else if (element instanceof TimeObservation && UMLPackage.Literals.TIME_OBSERVATION__EVENT == feature) {
                targetObjects.add(((TimeObservation)element).getEvent());
            } else if (element instanceof Constraint && UMLPackage.Literals.CONSTRAINT__CONSTRAINED_ELEMENT == feature) {
                targetObjects.addAll((Collection<NamedElement>)((Constraint)element).getConstrainedElements());
            }
            for (Element element2 : targetObjects) {
                if (value instanceof List && ((List)value).contains(element2)) continue;
                View target = this.findView((EObject)element2);
                List sourceConnections = ViewUtil.getSourceConnections((View)view);
                for (Object connector : sourceConnections) {
                    Edge edge;
                    if (!(connector instanceof Edge) || target != (edge = (Edge)connector).getTarget()) continue;
                    destroyEdges.add(edge);
                }
            }
            if (!destroyEdges.isEmpty()) {
                TransactionalEditingDomain transactionalEditingDomain = request.getEditingDomain();
                CompositeCommand command = new CompositeCommand("Clear Connectors");
                for (Edge edge : destroyEdges) {
                    ICommand result;
                    DestroyElementRequest destroy = new DestroyElementRequest(transactionalEditingDomain, (EObject)edge, false);
                    Object eHelperContext = destroy.getEditHelperContext();
                    IElementType context = ElementTypeRegistry.getInstance().getElementType(eHelperContext);
                    if (context == null || (result = context.getEditCommand((IEditCommandRequest)destroy)) == null) continue;
                    command.add((IUndoableOperation)result);
                }
                return command;
            }
        }
        return super.getBeforeSetCommand(request);
    }

    private View findView(EObject element) {
        if (element == null) {
            return null;
        }
        Collection settings = CacheAdapter.getInstance().getNonNavigableInverseReferences(element);
        for (EStructuralFeature.Setting ref : settings) {
            View view;
            if (!NotationPackage.eINSTANCE.getView_Element().equals(ref.getEStructuralFeature()) || (view = (View)ref.getEObject()) == null) continue;
            return view;
        }
        return null;
    }
}

