/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.stereotype.display.manager.axis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.RowHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.command.RowHideCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.tree.TreeLayer;
import org.eclipse.papyrus.infra.emf.gmf.util.GMFUnsafe;
import org.eclipse.papyrus.infra.emf.nattable.manager.axis.EObjectTreeAxisManagerForEventList;
import org.eclipse.papyrus.infra.nattable.layer.PapyrusGridLayer;
import org.eclipse.papyrus.infra.nattable.layerstack.RowHeaderHierarchicalLayerStack;
import org.eclipse.papyrus.infra.nattable.manager.axis.IAxisManagerForEventList;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.ITreeItemAxis;
import org.eclipse.papyrus.infra.ui.util.WorkbenchPartHelper;
import org.eclipse.papyrus.uml.nattable.stereotype.display.Activator;
import org.eclipse.ui.IEditorPart;
import org.eclipse.uml2.uml.Element;

public class NotationTreeTableAxisManager
extends EObjectTreeAxisManagerForEventList
implements IAxisManagerForEventList {
    private Collection<Object> selectionList = null;

    protected void fillChildrenForSemanticElement(ITreeItemAxis axis) {
        super.fillChildrenForSemanticElement(axis);
    }

    protected void fillChildrenForTreeFillingConfiguration(ITreeItemAxis axis) {
        super.fillChildrenForTreeFillingConfiguration(axis);
    }

    public void fillListWithGrandSon(ITreeItemAxis element) {
        super.fillListWithGrandSon(element);
    }

    public void fillListWithRoots() {
        if (this.getTableEditingDomain() != null && this.getRepresentedContentProvider().getAxis().isEmpty()) {
            Command cmd;
            IEditorPart part = WorkbenchPartHelper.getCurrentActiveEditorPart();
            DiagramEditor editor = null;
            if (part instanceof IAdaptable) {
                editor = (DiagramEditor)part.getAdapter(DiagramEditor.class);
            } else if (part instanceof DiagramEditor) {
                editor = (DiagramEditor)part;
            }
            this.selectionList = new ArrayList<Object>();
            if (editor != null && !editor.getDiagramGraphicalViewer().getSelection().isEmpty()) {
                IStructuredSelection selection = (IStructuredSelection)editor.getDiagramGraphicalViewer().getSelection();
                for (Object obj : selection) {
                    View v;
                    if (obj instanceof IAdaptable && (v = (View)((IAdaptable)obj).getAdapter(View.class)) != null && this.isStereotypedElement(v)) {
                        this.selectionList.add(v);
                    }
                    if (!(obj instanceof View) || !this.isStereotypedElement((View)obj)) continue;
                    this.selectionList.add(obj);
                }
            }
            if ((cmd = this.getAddAxisCommand(this.getTableEditingDomain(), this.selectionList)) != null) {
                try {
                    GMFUnsafe.write((TransactionalEditingDomain)this.getTableEditingDomain(), (Command)cmd);
                }
                catch (InterruptedException e) {
                    Activator.log.error((Throwable)e);
                }
                catch (RollbackException e) {
                    Activator.log.error((Throwable)e);
                }
            }
            return;
        }
        super.fillListWithRoots();
    }

    protected boolean isStereotypedElement(View view) {
        return view.getElement() instanceof Element && !((Element)view.getElement()).getAppliedStereotypes().isEmpty();
    }

    public boolean isAlreadyManaged(Object object) {
        return super.isAlreadyManaged(object);
    }

    protected void updateManagedList(List<Object> toAdd, List<Object> toRemove) {
        super.updateManagedList(toAdd, toRemove);
        this.getTableManager().refreshNatTable();
    }

    public void fillListWithChildren(ITreeItemAxis parentAxis) {
        super.fillListWithChildren(parentAxis);
    }

    protected void manageSetNotification(Notification notification) {
        super.manageSetNotification(notification);
    }

    protected void manageUnsetNotification(Notification notification) {
        super.manageUnsetNotification(notification);
    }

    protected void manageAddITreeItemAxisForSemanticElement(ITreeItemAxis axis) {
        super.manageAddITreeItemAxisForSemanticElement(axis);
    }

    protected void manageAddNotification(Notification notification) {
        super.manageAddNotification(notification);
    }

    protected void manageAddManyNotification(Notification notification) {
        super.manageAddManyNotification(notification);
    }

    protected void manageMoveNotification(Notification notification) {
        super.manageMoveNotification(notification);
    }

    protected void manageRemoveITreeItemAxisForSemanticElement(ITreeItemAxis axis) {
        super.manageRemoveITreeItemAxisForSemanticElement(axis);
    }

    protected void manageRemoveNotification(Notification notification) {
        super.manageRemoveNotification(notification);
    }

    protected void manageRemoveSemanticElement(Object object) {
        super.manageRemoveSemanticElement(object);
    }

    protected void manageRemoveManyNotification(Notification notification) {
        super.manageRemoveManyNotification(notification);
    }

    protected void updateChildren(ITreeItemAxis semanticElementRepresentation) {
        super.updateChildren(semanticElementRepresentation);
    }

    protected void updateSemanticElement(Object semanticElement) {
        super.updateSemanticElement(semanticElement);
    }

    public void managedHideShowCategoriesForDepth(List<Integer> depthToHide, List<Integer> depthToShow) {
        super.managedHideShowCategoriesForDepth(depthToHide, depthToShow);
        if (this.selectionList != null && !this.selectionList.isEmpty()) {
            RowHideShowLayer layer = this.getRowHideShowLayer();
            NatTable natTable = (NatTable)this.getTableManager().getAdapter(NatTable.class);
            if (natTable == null) {
                return;
            }
            TreeLayer treeLayer = this.getTreeLayer();
            if (treeLayer != null) {
                int cpt = this.selectionList.size() - 1;
                while (cpt >= 0) {
                    treeLayer.expandTreeRow(cpt);
                    natTable.doCommand((ILayerCommand)new RowHideCommand((ILayer)layer, cpt));
                    --cpt;
                }
            }
        }
    }

    private TreeLayer getTreeLayer() {
        PapyrusGridLayer gridLayer;
        ILayer rowLayer;
        NatTable natTable = (NatTable)this.getTableManager().getAdapter(NatTable.class);
        ILayer layer = natTable.getLayer();
        if (layer instanceof PapyrusGridLayer && (rowLayer = (gridLayer = (PapyrusGridLayer)layer).getRowHeaderLayer()) instanceof RowHeaderHierarchicalLayerStack) {
            return ((RowHeaderHierarchicalLayerStack)rowLayer).getTreeLayer();
        }
        return null;
    }

    public void dispose() {
        if (this.selectionList != null) {
            this.selectionList.clear();
            this.selectionList = null;
        }
        super.dispose();
    }
}

