/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.nattable.celleditor.config;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultBooleanDisplayConverter;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.CheckBoxCellEditor;
import org.eclipse.papyrus.infra.nattable.celleditor.config.ICellAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.painter.CustomCheckBoxPainter;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;

public class SingleBooleanCellEditorConfiguration
implements ICellAxisConfiguration {
    private static final String ID = "org.eclipse.papyrus.infra.emf.nattable.celleditor.configuration.SingleBooleanCellEditorConfiguration.CheckBox";

    public String getConfigurationId() {
        return ID;
    }

    public String getConfigurationDescription() {
        return "This configuration provides a CheckBox editor for a single Boolean";
    }

    public boolean handles(Table table, Object axisElement) {
        EClassifier etype;
        EStructuralFeature feature;
        Object object = AxisUtils.getRepresentedElement((Object)axisElement);
        if (object instanceof EStructuralFeature && !(feature = (EStructuralFeature)object).isMany() && (etype = feature.getEType()) instanceof EDataType) {
            EDataType datatype = (EDataType)etype;
            return "Boolean".equals(datatype.getName()) || "EBoolean".equals(datatype.getName());
        }
        return false;
    }

    public void configureCellEditor(IConfigRegistry configRegistry, Object axis, String configLabel) {
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new CustomCheckBoxPainter(), "NORMAL", configLabel);
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new CheckBoxCellEditor(), "NORMAL", configLabel);
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultBooleanDisplayConverter(), "NORMAL", configLabel);
    }
}

