/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.figureview.view;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.gmf.figureview.view.FigureLabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class FigureHierarchyView
extends ViewPart {
    private ISelectionListener myEditPartlistener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            Object selectedobject;
            if (selection instanceof IStructuredSelection && (selectedobject = ((IStructuredSelection)selection).getFirstElement()) instanceof GraphicalEditPart) {
                GraphicalEditPart graphicalEP = (GraphicalEditPart)selectedobject;
                IFigure figure = graphicalEP.getContentPane();
                if (FigureHierarchyView.this.viewer != null) {
                    FigureHierarchyView.this.viewer.setInput((Object)new Object[]{figure});
                    FigureHierarchyView.this.viewer.expandAll();
                }
            }
        }
    };
    private TreeViewer viewer;

    public void setFocus() {
        TreeViewer viewer = this.getViewer();
        if (viewer != null && !viewer.getControl().isDisposed()) {
            viewer.getControl().setFocus();
        }
    }

    protected Tree createTree(Composite parent) {
        Tree tree = new Tree(parent, 66306);
        tree.setLinesVisible(true);
        return tree;
    }

    protected TreeViewer getViewer() {
        return this.viewer;
    }

    public FigureHierarchyView() {
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        selectionService.addSelectionListener(this.myEditPartlistener);
    }

    protected void createColumns() {
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.getTree().setLinesVisible(true);
        TreeColumn tcName = new TreeColumn(this.viewer.getTree(), 16384);
        tcName.setText("Figure");
        tcName.setWidth(300);
        TreeColumn tcFigBounds = new TreeColumn(this.viewer.getTree(), 16384);
        tcFigBounds.setText("Figure bounds");
        tcFigBounds.setWidth(250);
        TreeColumn tcLayoutManager = new TreeColumn(this.viewer.getTree(), 16384);
        tcLayoutManager.setText("Layout manager");
        tcLayoutManager.setWidth(150);
        TreeColumn tcBorder = new TreeColumn(this.viewer.getTree(), 16384);
        tcBorder.setText("Border (width)");
        tcBorder.setWidth(150);
        TreeColumn tcLineWidth = new TreeColumn(this.viewer.getTree(), 16384);
        tcLineWidth.setText("Line width");
        tcLineWidth.setWidth(100);
    }

    public void createPartControl(Composite parent) {
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        tbm.add((IAction)this.getClearViewAction());
        this.viewer = new TreeViewer(this.createTree(parent));
        this.viewer.setContentProvider(this.getContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.createColumns();
    }

    protected ITableLabelProvider getLabelProvider() {
        return new FigureLabelProvider();
    }

    protected Action getClearViewAction() {
        return new Action(){

            public void run() {
                FigureHierarchyView.this.clear();
            }

            public boolean isEnabled() {
                return true;
            }

            public String getToolTipText() {
                return this.getText();
            }

            public String getText() {
                return "Clear the view";
            }
        };
    }

    protected IContentProvider getContentProvider() {
        return new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Object[]) {
                    return (Object[])inputElement;
                }
                return null;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                return this.getChildren(element).length != 0;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof IFigure) {
                    return ((IFigure)parentElement).getChildren().toArray();
                }
                return new Object[0];
            }
        };
    }

    public void dispose() {
        super.dispose();
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        selectionService.removeSelectionListener(this.myEditPartlistener);
    }

    private void clear() {
        this.viewer.setInput(null);
    }
}

