/**
 * Copyright (c) 2007, 2010, 2013 Borland Software Corporation and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Alexander Shatalin (Borland) - initial API and implementation
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 */
package aspects.xpt.navigator;

import aspects.xpt.navigator.NavigatorItem;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.gmf.codegen.gmfgen.GenNavigator;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common;
import xpt.editor.VisualIDRegistry;

@Singleton
@SuppressWarnings("all")
public class NavigatorSorter extends xpt.navigator.NavigatorSorter {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  private VisualIDRegistry xptVisualIDRegistry;
  
  @Inject
  private NavigatorItem xptNavigatorItem;
  
  @Override
  public CharSequence category(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public int category(Object element) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (element instanceof ");
    CharSequence _qualifiedClassName = this.xptNavigatorItem.qualifiedClassName(it);
    _builder.append(_qualifiedClassName, "\t");
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    CharSequence _qualifiedClassName_1 = this.xptNavigatorItem.qualifiedClassName(it);
    _builder.append(_qualifiedClassName_1, "\t\t");
    _builder.append(" item = (");
    CharSequence _qualifiedClassName_2 = this.xptNavigatorItem.qualifiedClassName(it);
    _builder.append(_qualifiedClassName_2, "\t\t");
    _builder.append(") element;");
    _builder.newLineIfNotEmpty();
    {
      boolean _generateCreateShortcutAction = it.getEditorGen().getDiagram().generateCreateShortcutAction();
      if (_generateCreateShortcutAction) {
        _builder.append("\t");
        _builder.append("if (item.getView().getEAnnotation(\"Shortcut\") != null) {  ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append(_nonNLS, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("return SHORTCUTS_CATEGORY;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("return ");
    CharSequence _visualIDMethodCall = this.xptVisualIDRegistry.getVisualIDMethodCall(it.getEditorGen().getDiagram());
    _builder.append(_visualIDMethodCall, "\t");
    _builder.append("(item.getView()).hashCode();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return GROUP_CATEGORY;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
}
