/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dev.project.management.handlers;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.papyrus.dev.project.management.Activator;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.statushandlers.StatusManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SyncManifestAndPOMVersions
extends AbstractHandler {
    private static final Pattern BUNDLE_VERSION = Pattern.compile("^Bundle-Version:\\s*(\\S+)\\s*$", 8);
    private static final Pattern POM_FIXUP = Pattern.compile("^(<\\?xml\\s.*?\\?>)\\s*(<project>)\\s*$", 8);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final Map<IFile, IFile> pomsByManifest = this.getAllPOMsByManifest();
        ISchedulingRule[] rules = (ISchedulingRule[])Stream.concat(pomsByManifest.keySet().stream(), pomsByManifest.values().stream()).toArray(ISchedulingRule[]::new);
        MultiRule jobRule = new MultiRule(rules);
        Job updateJob = new Job("Synchronize POM versions", jobRule){
            {
                super($anonymous0);
                this.setRule((ISchedulingRule)multiRule);
            }

            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)"Updating POMs...", (int)pomsByManifest.size());
                pomsByManifest.forEach((manifest, pom) -> {
                    try {
                        if (sub.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        String version = SyncManifestAndPOMVersions.this.getVersion((IFile)manifest);
                        if (version != null) {
                            version = version.replace(".qualifier", "-SNAPSHOT");
                            Document xml = SyncManifestAndPOMVersions.this.slurpXML((IFile)pom);
                            Element versionElement = SyncManifestAndPOMVersions.this.findVersion(xml);
                            if (versionElement != null && !version.equals(versionElement.getTextContent())) {
                                versionElement.setTextContent(version);
                                SyncManifestAndPOMVersions.this.write(xml, (IFile)pom);
                            }
                        }
                        sub.worked(1);
                    }
                    catch (CoreException e) {
                        StatusManager.getManager().handle(e.getStatus(), 2);
                    }
                });
                sub.done();
                return Status.OK_STATUS;
            }
        };
        updateJob.schedule();
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        IProgressService progress = window.getWorkbench().getProgressService();
        progress.showInDialog(window.getShell(), updateJob);
        return null;
    }

    Map<IFile, IFile> getAllPOMsByManifest() {
        HashMap<IFile, IFile> result = new HashMap<IFile, IFile>();
        Stream.of(ResourcesPlugin.getWorkspace().getRoot().getProjects()).filter(this::hasPluginOrFeatureNature).forEach(project -> {
            IFile pom = project.getFile("pom.xml");
            if (pom != null && pom.isAccessible()) {
                IFile manifest = project.getFile("feature.xml");
                if (!manifest.isAccessible()) {
                    manifest = project.getFile("META-INF/MANIFEST.MF");
                }
                if (manifest.isAccessible()) {
                    result.put(manifest, pom);
                }
            }
        });
        return result;
    }

    String slurpText(IFile file) throws CoreException {
        StringBuilder result = new StringBuilder();
        CharBuffer buf = CharBuffer.allocate(4096);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(file.getContents(), Charset.forName(file.getCharset())));){
                while (reader.read(buf) >= 0) {
                    buf.flip();
                    result.append(buf);
                    buf.rewind();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.dev.project.management", "Failed to read manifest", (Throwable)e));
        }
        return result.toString();
    }

    Document slurpXML(IFile xmlFile) throws CoreException {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream input = xmlFile.getContents();){
                return builder.parse(input);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.dev.project.management", "Failed to read manifest file", (Throwable)e));
        }
    }

    void write(Document xml, IFile xmlFile) throws CoreException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (StringWriter writer = new StringWriter();){
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("encoding", "UTF-8");
                xml.setXmlStandalone(true);
                xml.setXmlVersion("1.0");
                StreamResult result = new StreamResult(writer);
                transformer.transform(new DOMSource(xml), result);
                String text = writer.toString();
                Matcher fixup = POM_FIXUP.matcher(text);
                if (fixup.find()) {
                    StringBuffer fixed = new StringBuffer(text.length() + 2);
                    fixup.appendReplacement(fixed, String.valueOf(fixup.group(1)) + '\n' + fixup.group(2));
                    fixup.appendTail(fixed);
                    text = fixed.toString();
                }
                ByteArrayInputStream input = new ByteArrayInputStream(text.getBytes(Charset.forName("UTF-8")));
                xmlFile.setContents((InputStream)input, false, true, null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.dev.project.management", "Failed to update POM", (Throwable)e));
        }
    }

    String getVersion(IFile manifest) throws CoreException {
        String result = null;
        switch (manifest.getName()) {
            case "MANIFEST.MF": {
                String text = this.slurpText(manifest);
                Matcher m = BUNDLE_VERSION.matcher(text);
                if (!m.find()) break;
                result = m.group(1);
                break;
            }
            case "feature.xml": {
                Document xml = this.slurpXML(manifest);
                result = xml.getDocumentElement().getAttribute("version");
            }
        }
        return result;
    }

    Element findVersion(Document pom) {
        Element project = pom.getDocumentElement();
        return this.stream(project.getChildNodes()).filter(n -> "version".equals(n.getNodeName())).filter(Element.class::isInstance).map(Element.class::cast).findFirst().orElse(null);
    }

    Stream<Node> stream(NodeList nodes) {
        Stream.Builder<Node> result = Stream.builder();
        int i = 0;
        while (i < nodes.getLength()) {
            result.add(nodes.item(i));
            ++i;
        }
        return result.build();
    }

    boolean hasPluginOrFeatureNature(IProject project) {
        boolean result = false;
        if (project.isAccessible()) {
            try {
                IProjectDescription desc = project.getDescription();
                List<String> natures = Arrays.asList(desc.getNatureIds());
                result = natures.contains("org.eclipse.pde.PluginNature") || natures.contains("org.eclipse.pde.FeatureNature");
            }
            catch (CoreException e) {
                Activator.log.log(e.getStatus());
            }
        }
        return result;
    }
}

