/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.releng.tools.internal.popup.actions;

import com.google.inject.Injector;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cbi.targetplatform.pde.Converter;
import org.eclipse.cbi.targetplatform.ui.internal.TargetplatformActivator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.jobs.JobGroup;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.releng.tools.internal.Activator;
import org.eclipse.papyrus.releng.tools.internal.Messages;
import org.eclipse.papyrus.releng.tools.internal.popup.actions.UpdateDependencies;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class GenerateTargetsHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sSelection = (IStructuredSelection)selection;
            Iterator iterator = sSelection.iterator();
            final ArrayList<IFile> tpdFiles = new ArrayList<IFile>();
            try {
                while (iterator.hasNext()) {
                    Object next = iterator.next();
                    if (!(next instanceof IResource)) continue;
                    this.collectTPDFiles((IResource)next, tpdFiles);
                }
                final Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
                if (!tpdFiles.isEmpty()) {
                    new UpdateDependencies().updateDependencies(tpdFiles, activeShell);
                    String jobTitle = String.format(Messages.GenerateTargetsHandler_GenerateTargetFile, tpdFiles.size());
                    Job topLevelJob = new Job(jobTitle){

                        protected IStatus run(IProgressMonitor monitor) {
                            int maxThreads = 2;
                            JobGroup tpdConverters = new JobGroup(Messages.GenerateTargetsHandler_GenerateTarget, maxThreads, tpdFiles.size());
                            for (IFile tpdFile : tpdFiles) {
                                GenerateTargetsHandler.this.generate(tpdFile, tpdConverters);
                            }
                            try {
                                tpdConverters.join(0L, monitor);
                            }
                            catch (InterruptedException e) {
                                return new Status(4, "org.eclipse.papyrus.releng.tools", Messages.GenerateTargetsHandler_UnexpectedException, (Throwable)e);
                            }
                            return tpdConverters.getResult();
                        }
                    };
                    topLevelJob.setUser(true);
                    topLevelJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                        public void done(IJobChangeEvent event) {
                            if (Display.getCurrent() != null) {
                                this.done(event.getResult());
                            } else {
                                Display.getDefault().asyncExec(() -> this.done(event.getResult()));
                            }
                        }

                        void done(IStatus status) {
                            String title = Messages.GenerateTargetsHandler_GenerateTarget;
                            switch (status.getCode()) {
                                case 0: 
                                case 1: {
                                    MessageDialog.openInformation((Shell)activeShell, (String)title, (String)Messages.GenerateTargetsHandler_OperationComplete);
                                    break;
                                }
                                case 8: {
                                    MessageDialog.openInformation((Shell)activeShell, (String)title, (String)Messages.GenerateTargetsHandler_OperationCanceled);
                                    break;
                                }
                                case 4: {
                                    MessageDialog.openError((Shell)activeShell, (String)title, (String)Messages.GenerateTargetsHandler_OperationCompleteWithError);
                                    break;
                                }
                                case 2: {
                                    MessageDialog.openWarning((Shell)activeShell, (String)title, (String)Messages.GenerateTargetsHandler_OperationCompleteWithWarning);
                                }
                            }
                        }
                    });
                    topLevelJob.schedule();
                }
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.papyrus.releng.tools", Messages.GenerateTargetsHandler_UnexpectedException, (Throwable)e));
            }
        }
        return null;
    }

    protected void collectTPDFiles(IResource resource, List<IFile> result) throws CoreException {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            if ("tpd".equals(file.getFileExtension())) {
                result.add(file);
            }
        } else if (resource instanceof IContainer) {
            this.collectTPDFiles((IContainer)resource, result);
        }
    }

    protected void collectTPDFiles(IContainer parent, List<IFile> result) throws CoreException {
        IResource[] iResourceArray = parent.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource child = iResourceArray[n2];
            this.collectTPDFiles(child, result);
            ++n2;
        }
    }

    protected void generate(final IFile file, JobGroup jobGroup) {
        String filePath = file.getLocation().toFile().getAbsolutePath();
        final URI tpdURI = URI.createFileURI((String)filePath);
        final Converter converter = new Converter();
        Injector injector = TargetplatformActivator.getInstance().getInjector("org.eclipse.cbi.targetplatform.TargetPlatform");
        injector.injectMembers((Object)converter);
        Job job = new Job(String.valueOf(Messages.GenerateTargetsHandler_GenerateTargetPlatformFor) + file.getLocation().lastSegment()){

            protected IStatus run(IProgressMonitor monitor) {
                Diagnostic result = converter.generateTargetDefinitionFile(tpdURI, (IProgressMonitor)new NullProgressMonitor());
                if (result.getSeverity() >= 2) {
                    Activator.getDefault().getLog().log(BasicDiagnostic.toIStatus((Diagnostic)result));
                }
                try {
                    file.getParent().refreshLocal(1, null);
                    GenerateTargetsHandler.this.generateEclipseTarget(file);
                }
                catch (CoreException ex) {
                    return new Status(4, "org.eclipse.papyrus.releng.tools", Messages.GenerateTargetsHandler_UnexpectedException, (Throwable)ex);
                }
                return BasicDiagnostic.toIStatus((Diagnostic)result);
            }
        };
        job.setJobGroup(jobGroup);
        job.schedule();
    }

    protected void generateEclipseTarget(IFile tpdFile) throws CoreException {
        String targetSuffix = "eclipse";
        IContainer parent = tpdFile.getParent();
        String fileName = tpdFile.getFullPath().removeFileExtension().addFileExtension("target").lastSegment();
        IFile portableTargetFile = parent.getFile((IPath)new Path(fileName));
        IFolder eclipseFolder = parent.getParent().getFolder((IPath)new Path(targetSuffix));
        if (!eclipseFolder.exists()) {
            eclipseFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        IFile eclipseTargetFile = eclipseFolder.getFile(fileName.replaceAll("portable", targetSuffix));
        InputStream convertedStream = this.convert(portableTargetFile.getContents(), "http://download.eclipse.org/", "file:/home/data/httpd/download.eclipse.org/");
        convertedStream = this.convert(convertedStream, "https://download.eclipse.org/", "file:/home/data/httpd/download.eclipse.org/");
        if (eclipseTargetFile.exists()) {
            eclipseTargetFile.setContents(convertedStream, 0, null);
        } else {
            eclipseTargetFile.create(convertedStream, true, null);
        }
        eclipseFolder.refreshLocal(1, null);
    }

    protected InputStream convert(InputStream source, String sourcePattern, String targetPattern) throws CoreException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(source));
        StringBuilder builder = new StringBuilder();
        String patternSt = sourcePattern.replaceAll("\\.", "\\.");
        Pattern pattern = Pattern.compile(patternSt);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                Matcher matcher = pattern.matcher(line);
                String newLine = matcher.replaceAll(targetPattern);
                builder.append(newLine).append("\n");
            }
        }
        catch (IOException ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.releng.tools", Messages.GenerateTargetsHandler_UnexpectedError, (Throwable)ex));
        }
        ByteArrayInputStream result = new ByteArrayInputStream(builder.toString().getBytes());
        return result;
    }
}

