/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.palette.handler;

import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.PapyrusPalettePreferences;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class AbstractUndeployPaletteConfigurationHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(currentSelection instanceof IStructuredSelection) || currentSelection.isEmpty()) {
            return null;
        }
        IStructuredSelection selection = (IStructuredSelection)currentSelection;
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        this.doExecute(selection, activeShell, (IProgressMonitor)new NullProgressMonitor());
        return null;
    }

    protected void doExecute(IStructuredSelection selection, Shell activeShell, IProgressMonitor monitor) {
        Iterator selectionIterator = selection.iterator();
        MultiStatus result = new MultiStatus("org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration", 0, "The palette configuration has been successfully deactivated and undeployed", null);
        while (selectionIterator.hasNext()) {
            Object selectedElement = selectionIterator.next();
            if (!(selectedElement instanceof IAdaptable)) continue;
            IFile selectedFile = (IFile)((IAdaptable)selectedElement).getAdapter(IFile.class);
            if (selectedFile == null) {
                monitor.worked(1);
                result.add((IStatus)new Status(4, "org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration", "The selected element is not a file"));
                continue;
            }
            String fileName = selectedFile.getFullPath().removeFileExtension().lastSegment();
            monitor.subTask("Undeploy " + fileName);
            String editorId = this.getEditorID(fileName);
            if (editorId == null) {
                MessageDialog.openInformation((Shell)activeShell, (String)"Not deployed", (String)"This palette is currently not deployed");
                result.add((IStatus)new Status(4, "org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration", "The palette configuration " + fileName + " was not undeployed already"));
                continue;
            }
            result.add(this.deactivatePalette(fileName, editorId));
        }
        if (result.getChildren().length == 1) {
            if (result.isOK()) {
                MessageDialog.openInformation((Shell)activeShell, (String)"Success", (String)result.getMessage());
            } else if (result.getSeverity() < 4) {
                StatusManager.getManager().handle((IStatus)result, 2);
            }
        } else if (result.isOK()) {
            MessageDialog.openInformation((Shell)activeShell, (String)"Success", (String)result.getMessage());
        } else {
            MultiStatus actualResult = new MultiStatus("org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration", result.getCode(), "Some errors occurred during the deployment", result.getException());
            actualResult.merge((IStatus)result);
        }
    }

    protected abstract XMLMemento getMemento();

    protected abstract IStatus deactivatePalette(String var1, String var2);

    protected String getEditorID(String identifier) {
        return PapyrusPalettePreferences.getEditorID((String)identifier, (XMLMemento)this.getMemento());
    }
}

