/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.edit.policies;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultCreationEditPolicy;
import org.eclipse.papyrus.uml.diagram.timing.custom.Messages;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands.RefreshCommandForDo;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands.RefreshCommandForUndo;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.EditPartUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.LifelineUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.StateDefinitionUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.StateInvariantUtils;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.FullLifelineEditPartCN;
import org.eclipse.uml2.uml.Lifeline;

public class CustomFullLifelineStateDefinitionCompartmentCreationEditPolicy
extends DefaultCreationEditPolicy {
    protected Command getCreateCommand(CreateViewRequest request) {
        Command superCommand = super.getCreateCommand(request);
        List viewDescriptors = request.getViewDescriptors();
        if (viewDescriptors.size() == 1 && "Node_StateDefinitionShape".equals(((CreateViewRequest.ViewDescriptor)viewDescriptors.get(0)).getSemanticHint())) {
            View lifelineView = (View)this.getHost().getParent().getModel();
            Lifeline lifeline = (Lifeline)lifelineView.getElement();
            List children = this.getHost().getChildren();
            boolean firstStateDefinition = children.size() == 0;
            return this.createStateDefinitionCommand(superCommand, lifeline, firstStateDefinition);
        }
        return super.getCreateCommand(request);
    }

    private Command createStateDefinitionCommand(Command superCommand, Lifeline lifeline, final boolean first) {
        CompoundCommand compoundCommand = new CompoundCommand(Messages.CustomFullLifelineStateDefinitionCompartmentCreationEditPolicy_CreateStateDefinition);
        final FullLifelineEditPartCN lifelineEditPart = this.getLifelineEditPart();
        compoundCommand.add((Command)new RefreshCommandForUndo((GraphicalEditPart)lifelineEditPart));
        compoundCommand.add(superCommand);
        final CommandResult superCommandResult = ((ICommandProxy)superCommand).getICommand().getCommandResult();
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)lifeline);
        if (editingDomain == null) {
            throw new IllegalStateException("no editing domain");
        }
        AbstractTransactionalCommand initStateDefinitionCommand = new AbstractTransactionalCommand(editingDomain, Messages.CustomFullLifelineStateDefinitionCompartmentCreationEditPolicy_InitializeStateDefinition, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                CreateViewRequest.ViewDescriptor viewDescriptor = (CreateViewRequest.ViewDescriptor)superCommandResult.getReturnValue();
                View stateDefinitionView = (View)viewDescriptor.getAdapter(View.class);
                StateDefinitionUtils.initNewStateDefinitionName(stateDefinitionView);
                if (first) {
                    String id = StateDefinitionUtils.getStateDefinitionViewID(stateDefinitionView);
                    StateInvariantUtils.createStateInvariant(id, lifelineEditPart, -1, -1, -1);
                    View lifelineView = (View)lifelineEditPart.getModel();
                    Lifeline lifeline = (Lifeline)lifelineView.getElement();
                    LifelineUtils.updateFragmentNames(lifeline, lifelineView);
                }
                return CommandResult.newOKCommandResult();
            }
        };
        compoundCommand.add((Command)new ICommandProxy((ICommand)initStateDefinitionCommand));
        compoundCommand.add((Command)new RefreshCommandForDo((GraphicalEditPart)this.getLifelineEditPart()));
        return compoundCommand;
    }

    protected FullLifelineEditPartCN getLifelineEditPart() {
        return (FullLifelineEditPartCN)EditPartUtils.findParentEditPartWithId(this.getHost(), "Lifeline_FullShape");
    }
}

