/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.providers;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.diagram.core.internal.DiagramPlugin;
import org.eclipse.gmf.runtime.diagram.core.internal.l10n.DiagramCoreMessages;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.providers.IViewProvider;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateDiagramViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateEdgeViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateNodeViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateViewForKindOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateViewOperation;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.osgi.util.NLS;

public class AbstractViewProvider
extends AbstractProvider
implements IViewProvider {
    private static String viewCreationMethodName = "createView";
    private static String diagramCreationMethodName = "createDiagram";
    public static final ClassToCreationMethodMap classToCreateMethod = new ClassToCreationMethodMap();

    public final boolean provides(IOperation operation) {
        if (operation instanceof CreateViewForKindOperation) {
            return this.provides((CreateViewForKindOperation)operation);
        }
        assert (operation instanceof CreateViewOperation) : "operation is not CreateViewOperation in AbstractViewProvider";
        if (operation instanceof CreateDiagramViewOperation) {
            return this.provides((CreateDiagramViewOperation)operation);
        }
        if (operation instanceof CreateEdgeViewOperation) {
            return this.provides((CreateEdgeViewOperation)operation);
        }
        if (operation instanceof CreateNodeViewOperation) {
            return this.provides((CreateNodeViewOperation)operation);
        }
        return false;
    }

    public final Diagram createDiagram(IAdaptable contextElement, String diagramKind, PreferencesHint preferencesHint) {
        return (Diagram)this.createNewView(this.getDiagramViewClass(contextElement, diagramKind), new Object[]{contextElement, diagramKind, preferencesHint});
    }

    public Edge createEdge(IAdaptable semanticAdapter, View containerView, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        return (Edge)this.createNewView(this.getEdgeViewClass(semanticAdapter, containerView, semanticHint), new Object[]{semanticAdapter, containerView, semanticHint, new Integer(index), persisted, preferencesHint});
    }

    public Node createNode(IAdaptable semanticAdapter, View containerView, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        return (Node)this.createNewView(this.getNodeViewClass(semanticAdapter, containerView, semanticHint), new Object[]{semanticAdapter, containerView, semanticHint, new Integer(index), persisted, preferencesHint});
    }

    protected boolean provides(CreateViewForKindOperation op) {
        if (op.getViewKind() == Node.class) {
            return this.getNodeViewClass(op.getSemanticAdapter(), op.getContainerView(), op.getSemanticHint()) != null;
        }
        if (op.getViewKind() == Edge.class) {
            return this.getEdgeViewClass(op.getSemanticAdapter(), op.getContainerView(), op.getSemanticHint()) != null;
        }
        return true;
    }

    protected boolean provides(CreateDiagramViewOperation operation) {
        return this.getDiagramViewClass(operation.getSemanticAdapter(), operation.getSemanticHint()) != null;
    }

    protected boolean provides(CreateEdgeViewOperation operation) {
        return this.getEdgeViewClass(operation.getSemanticAdapter(), operation.getContainerView(), operation.getSemanticHint()) != null;
    }

    protected boolean provides(CreateNodeViewOperation operation) {
        return this.getNodeViewClass(operation.getSemanticAdapter(), operation.getContainerView(), operation.getSemanticHint()) != null;
    }

    protected Class<?> getDiagramViewClass(IAdaptable semanticAdapter, String diagramKind) {
        return null;
    }

    protected Class<?> getEdgeViewClass(IAdaptable semanticAdapter, View containerView, String semanticHint) {
        return null;
    }

    protected Class<?> getNodeViewClass(IAdaptable semanticAdapter, View containerView, String semanticHint) {
        return null;
    }

    private View createNewView(Class<?> viewClass, Object[] constructorParams) {
        Method method;
        Object factory;
        block7: {
            Constructor<?> constructor;
            block6: {
                try {
                    assert (viewClass != null) : "Null viewClass in AbstractProvider";
                    assert (constructorParams != null) : "Null constructorParams in AbstractProvider";
                    constructor = this.getFactoryConstructor(viewClass);
                    if (constructor != null) break block6;
                    Log.error((Plugin)DiagramPlugin.getInstance(), (int)7, (String)("View (" + viewClass + ") is missing a proper creation Factory"));
                    return null;
                }
                catch (Throwable e) {
                    String eMsg = NLS.bind((String)DiagramCoreMessages.AbstractViewProvider_create_view_failed_ERROR_, (Object)viewClass.getName());
                    Log.warning((Plugin)DiagramPlugin.getInstance(), (int)2, (String)eMsg, (Throwable)e);
                    return null;
                }
            }
            factory = constructor.newInstance(new Object[0]);
            method = this.getCreationMethod(viewClass, constructorParams);
            if (method != null) break block7;
            Log.error((Plugin)DiagramPlugin.getInstance(), (int)7, (String)("View (" + viewClass + ") is missing a proper creation Factory"));
            return null;
        }
        return (View)method.invoke(factory, constructorParams);
    }

    private Constructor<?> getFactoryConstructor(Class<?> viewClass) {
        if (viewClass != null) {
            Constructor<?>[] ctors = viewClass.getConstructors();
            int i = 0;
            while (i < ctors.length) {
                if (ctors[i].getParameterTypes().length == 0) {
                    return ctors[i];
                }
                ++i;
            }
        }
        return null;
    }

    private Method getCreationMethod(Class<?> viewClass, Object[] params) {
        if (viewClass != null) {
            Method method = classToCreateMethod.getCreationMethod(viewClass);
            if (method != null) {
                return method;
            }
            Method[] methods = viewClass.getMethods();
            int i = 0;
            while (i < methods.length) {
                method = methods[i];
                String methodName = method.getName();
                if (methodName.equals(viewCreationMethodName) || methodName.equals(diagramCreationMethodName)) {
                    classToCreateMethod.addMethod(viewClass, method);
                    return method;
                }
                ++i;
            }
        }
        return null;
    }

    protected EClass getSemanticEClass(IAdaptable semanticAdapter) {
        if (semanticAdapter == null) {
            return null;
        }
        EObject eObject = (EObject)semanticAdapter.getAdapter(EObject.class);
        if (eObject != null) {
            return EMFCoreUtil.getProxyClass((EObject)eObject);
        }
        IElementType type = (IElementType)semanticAdapter.getAdapter(IElementType.class);
        if (type != null) {
            return type.getEClass();
        }
        return null;
    }

    protected EObject getSemanticElement(IAdaptable semanticAdapter) {
        if (semanticAdapter == null) {
            return null;
        }
        EObject eObject = (EObject)semanticAdapter.getAdapter(EObject.class);
        if (eObject != null) {
            return EMFCoreUtil.resolve((TransactionalEditingDomain)TransactionUtil.getEditingDomain((EObject)eObject), (EObject)eObject);
        }
        return null;
    }

    protected EObject getSemanticElement(IAdaptable semanticAdapter, TransactionalEditingDomain domain) {
        if (semanticAdapter == null) {
            return null;
        }
        EObject eObject = (EObject)semanticAdapter.getAdapter(EObject.class);
        if (eObject != null) {
            return EMFCoreUtil.resolve((TransactionalEditingDomain)domain, (EObject)eObject);
        }
        return null;
    }

    protected static class ClassToCreationMethodMap
    extends HashMap<Class<?>, Method> {
        static final long serialVersionUID = 1L;

        protected ClassToCreationMethodMap() {
        }

        public void addMethod(Class<?> clazz, Method method) {
            if (this.get(clazz) == null) {
                this.put(clazz, method);
            }
        }

        public Method getCreationMethod(Class<?> clazz) {
            return (Method)this.get(clazz);
        }
    }
}

