/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.contentprovider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.emf.utils.ENamedElementComparator;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.EStructuralFeatureValueFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.IFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.utils.FillingConfigurationUtils;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;

public abstract class AbstractContainmentFeatureContentProvider
implements IStaticContentProvider {
    private Table table;
    private final boolean onColumn;
    private List<EClass> eClasses;

    public AbstractContainmentFeatureContentProvider(Table table, List<EClass> eClasses, boolean onColumn) {
        this.table = table;
        this.onColumn = onColumn;
        this.eClasses = eClasses;
    }

    public Object[] getElements(Object inputElement) {
        TreeSet<EStructuralFeature> availableFeatures = new TreeSet<EStructuralFeature>((Comparator<EStructuralFeature>)new ENamedElementComparator());
        for (EClass eClass : this.eClasses) {
            EList allFeatures = eClass.getEAllStructuralFeatures();
            for (EStructuralFeature eStructuralFeature : allFeatures) {
                if (!(eStructuralFeature instanceof EReference) || !((EReference)eStructuralFeature).isContainment() || !eStructuralFeature.isChangeable() || !eStructuralFeature.isMany()) continue;
                availableFeatures.add(eStructuralFeature);
            }
        }
        Collection<IFillingConfiguration> fillingConfigurations = FillingConfigurationUtils.getFillingConfigurationUsedInTable(this.table, this.onColumn);
        ArrayList<EStructuralFeature> listenFeatures = new ArrayList<EStructuralFeature>();
        for (IFillingConfiguration current : fillingConfigurations) {
            if (!(current instanceof EStructuralFeatureValueFillingConfiguration)) continue;
            listenFeatures.add(((EStructuralFeatureValueFillingConfiguration)current).getListenFeature());
        }
        ArrayList<EClassifier> types = new ArrayList<EClassifier>();
        ListIterator iter = listenFeatures.listIterator();
        boolean hasFillingMode = listenFeatures.size() != 0;
        while (iter.hasNext()) {
            EStructuralFeature current = (EStructuralFeature)iter.next();
            if (!current.isDerived() || current.isChangeable() || ((EReference)current).isContainment()) continue;
            iter.remove();
            types.add(current.getEType());
        }
        if (hasFillingMode) {
            HashSet<EStructuralFeature> bestFeatures = new HashSet<EStructuralFeature>();
            bestFeatures.addAll(listenFeatures);
            for (EClassifier eClassifier : types) {
                for (EStructuralFeature availableFeature : availableFeatures) {
                    EClassifier currentEType = availableFeature.getEType();
                    if (eClassifier instanceof EClass && currentEType instanceof EClass) {
                        if (eClassifier != currentEType && !((EClass)eClassifier).isSuperTypeOf((EClass)currentEType)) continue;
                        bestFeatures.add(availableFeature);
                        continue;
                    }
                    if (currentEType != eClassifier) continue;
                    bestFeatures.add(availableFeature);
                }
            }
            return bestFeatures.toArray();
        }
        if (listenFeatures.size() != 0) {
            availableFeatures.retainAll(listenFeatures);
        }
        return availableFeatures.toArray();
    }

    public final void dispose() {
        this.table = null;
    }

    public final void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public final Object[] getElements() {
        return this.getElements(null);
    }
}

