/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.sync;

import org.eclipse.papyrus.infra.sync.EMFDispatch;
import org.eclipse.papyrus.infra.sync.EMFDispatchManager;
import org.eclipse.papyrus.infra.sync.MasterSlaveSyncBucket;
import org.eclipse.papyrus.infra.sync.SyncBucket;
import org.eclipse.papyrus.infra.sync.SyncItem;
import org.eclipse.papyrus.infra.sync.SyncObject;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;

public abstract class SyncFeature<M, T, X>
extends SyncObject {
    private SyncBucket<M, T, X> bucket;

    public SyncFeature(SyncBucket<M, T, X> bucket) {
        super(bucket.getSyncService());
        this.bucket = bucket;
    }

    @Override
    public boolean isActive() {
        return this.getBucket().isActive();
    }

    public abstract void observe(SyncItem<M, T> var1);

    public abstract void unobserve(SyncItem<M, T> var1);

    public abstract void synchronize(SyncItem<M, T> var1, SyncItem<M, T> var2, X var3);

    protected final SyncBucket<M, T, X> getBucket() {
        return this.bucket;
    }

    public void clear() {
        this.onClear();
        this.bucket = null;
    }

    protected void onClear() {
    }

    protected void onChange(SyncItem<M, T> origin, X message) {
        this.bucket.propagate(this, origin, message);
    }

    protected final SyncItem<M, T> getMaster() {
        MasterSlaveSyncBucket msb = (MasterSlaveSyncBucket)TypeUtils.as(this.getBucket(), MasterSlaveSyncBucket.class);
        return msb == null ? null : msb.getMaster();
    }

    protected final <D extends EMFDispatch> EMFDispatchManager<D> createSingleDispatchManager() {
        return this.getSyncService().createSingleDispatchManager();
    }

    protected final <D extends EMFDispatch> EMFDispatchManager<D> createMultipleDispatchManager() {
        return this.getSyncService().createMultipleDispatchManager();
    }
}

