/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.search.ui.query;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.search.ui.query.AbstractPapyrusQuery;
import org.eclipse.papyrus.uml.search.ui.query.IPapyrusQueryProvider;
import org.eclipse.papyrus.uml.search.ui.query.PapyrusAdvancedQuery;
import org.eclipse.papyrus.uml.search.ui.query.PapyrusQuery;
import org.eclipse.papyrus.uml.search.ui.query.QueryInfo;
import org.eclipse.papyrus.views.search.scope.ScopeEntry;
import org.eclipse.papyrus.views.search.utils.DefaultServiceRegistryTracker;
import org.eclipse.papyrus.views.search.utils.IServiceRegistryTracker;
import org.eclipse.uml2.uml.UMLPackage;

public class WorkspaceQueryProvider
implements IPapyrusQueryProvider {
    protected Set<EObject> umlMetaClasses = new HashSet<EObject>();

    @Override
    public boolean canProvideFor(URI scope) {
        return true;
    }

    @Override
    public AbstractPapyrusQuery createSimpleSearchQuery(QueryInfo queryInfo) {
        this.initMetaClasses();
        Collection<ScopeEntry> scopeEntries = WorkspaceQueryProvider.createScopeEntries(queryInfo.getScope());
        return new PapyrusQuery(queryInfo.getQueryText(), queryInfo.isCaseSensitive(), queryInfo.isRegularExpression(), scopeEntries, this.umlMetaClasses.toArray(), queryInfo.isSearchAllStringAttributes());
    }

    @Override
    public AbstractPapyrusQuery createAdvancedSearchQuery(QueryInfo queryInfo) {
        Collection<ScopeEntry> scopeEntries = WorkspaceQueryProvider.createScopeEntries(queryInfo.getScope());
        return new PapyrusAdvancedQuery(queryInfo.getQueryText(), queryInfo.isCaseSensitive(), queryInfo.isRegularExpression(), scopeEntries, queryInfo.getParticipantTypes().toArray(), queryInfo.isSearchForAllSter(), queryInfo.isSearchForAnySter());
    }

    private void initMetaClasses() {
        if (this.umlMetaClasses.isEmpty()) {
            for (EClassifier eClassifier : UMLPackage.eINSTANCE.getEClassifiers()) {
                if (!(eClassifier instanceof EClass)) continue;
                this.umlMetaClasses.add((EObject)eClassifier);
            }
        }
    }

    public static Collection<ScopeEntry> createScopeEntries(Collection<URI> scope) {
        IServiceRegistryTracker tracker = WorkspaceQueryProvider.createServiceRegistryTracker();
        HashSet<ScopeEntry> results = new HashSet<ScopeEntry>();
        for (URI uri : scope) {
            ScopeEntry scopeEntry = new ScopeEntry(uri, tracker);
            results.add(scopeEntry);
        }
        return results;
    }

    static IServiceRegistryTracker createServiceRegistryTracker() {
        return new DefaultServiceRegistryTracker();
    }
}

