/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dev.assistants.codegen.generator;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.gmf.codegen.gmfgen.ElementType;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.papyrus.dev.assistants.codegen.generator.ElementTypeToAssistantRule;
import org.eclipse.papyrus.dev.assistants.codegen.generator.GMFGenToAssistantRule;
import org.eclipse.papyrus.infra.gmfdiag.assistant.AssistantFactory;
import org.eclipse.papyrus.infra.gmfdiag.assistant.ConnectionAssistant;
import org.eclipse.papyrus.infra.gmfdiag.assistant.ModelingAssistantProvider;
import org.eclipse.papyrus.infra.gmfdiag.assistant.PopupAssistant;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;
import org.eclipse.papyrus.uml.profile.types.generator.UMLElementTypes;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class ModelingAssistantProviderRule
extends org.eclipse.papyrus.uml.profile.assistants.generator.ModelingAssistantProviderRule {
    @Extension
    private static AssistantFactory assistantFactory = AssistantFactory.eINSTANCE;
    @Inject
    @Extension
    private ElementTypeToAssistantRule _elementTypeToAssistantRule;
    @Inject
    @Extension
    private GMFGenToAssistantRule _gMFGenToAssistantRule;
    @Inject
    @Extension
    private UMLElementTypes _uMLElementTypes;
    private final HashMap<ArrayList<?>, ModelingAssistantProvider> _createCache_toModelingAssistantProvider = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, ModelingAssistantProvider> _createCache_toModelingAssistantProvider_1 = CollectionLiterals.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelingAssistantProvider toModelingAssistantProvider(ElementTypeSetConfiguration elementTypeSet) {
        ModelingAssistantProvider _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new ElementTypeSetConfiguration[]{elementTypeSet});
        HashMap<ArrayList<?>, ModelingAssistantProvider> hashMap = this._createCache_toModelingAssistantProvider;
        synchronized (hashMap) {
            ModelingAssistantProvider _createModelingAssistantProvider;
            if (this._createCache_toModelingAssistantProvider.containsKey(_cacheKey)) {
                return this._createCache_toModelingAssistantProvider.get(_cacheKey);
            }
            _result = _createModelingAssistantProvider = assistantFactory.createModelingAssistantProvider();
            this._createCache_toModelingAssistantProvider.put(_cacheKey, _result);
        }
        this._init_toModelingAssistantProvider(_result, elementTypeSet);
        return _result;
    }

    private void _init_toModelingAssistantProvider(final ModelingAssistantProvider it, ElementTypeSetConfiguration elementTypeSet) {
        it.setName(elementTypeSet.getName());
        Consumer<ElementTypeConfiguration> _function = new Consumer<ElementTypeConfiguration>(){

            @Override
            public void accept(ElementTypeConfiguration type) {
                boolean _not;
                boolean _isRelationship = ModelingAssistantProviderRule.this._uMLElementTypes.isRelationship(type);
                boolean bl = _not = !_isRelationship;
                if (_not) {
                    it.getElementTypeIDs().add((Object)type.getIdentifier());
                    it.getPopupAssistants().add((Object)ModelingAssistantProviderRule.this._elementTypeToAssistantRule.toPopupAssistant(type));
                } else {
                    it.getRelationshipTypeIDs().add((Object)type.getIdentifier());
                    it.getConnectionAssistants().add((Object)ModelingAssistantProviderRule.this._elementTypeToAssistantRule.toConnectionAssistant(type));
                }
            }
        };
        elementTypeSet.getElementTypeConfigurations().forEach((Consumer)_function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelingAssistantProvider toModelingAssistantProvider(GenEditorGenerator editor) {
        ModelingAssistantProvider _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new GenEditorGenerator[]{editor});
        HashMap<ArrayList<?>, ModelingAssistantProvider> hashMap = this._createCache_toModelingAssistantProvider_1;
        synchronized (hashMap) {
            ModelingAssistantProvider _createModelingAssistantProvider;
            if (this._createCache_toModelingAssistantProvider_1.containsKey(_cacheKey)) {
                return this._createCache_toModelingAssistantProvider_1.get(_cacheKey);
            }
            _result = _createModelingAssistantProvider = assistantFactory.createModelingAssistantProvider();
            this._createCache_toModelingAssistantProvider_1.put(_cacheKey, _result);
        }
        this._init_toModelingAssistantProvider_1(_result, editor);
        return _result;
    }

    private void _init_toModelingAssistantProvider_1(ModelingAssistantProvider it, GenEditorGenerator editor) {
        it.setName(editor.getModelID());
        Functions.Function1<GenNode, String> _function = new Functions.Function1<GenNode, String>(){

            public String apply(GenNode it) {
                ElementType _elementType = it.getElementType();
                String _uniqueIdentifier = null;
                if (_elementType != null) {
                    _uniqueIdentifier = _elementType.getUniqueIdentifier();
                }
                return _uniqueIdentifier;
            }
        };
        Iterables.addAll((Collection)it.getElementTypeIDs(), (Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map(this._gMFGenToAssistantRule.validNodes(editor.getDiagram()), (Functions.Function1)_function)));
        Functions.Function1<GenLink, String> _function_1 = new Functions.Function1<GenLink, String>(){

            public String apply(GenLink it) {
                ElementType _elementType = it.getElementType();
                String _uniqueIdentifier = null;
                if (_elementType != null) {
                    _uniqueIdentifier = _elementType.getUniqueIdentifier();
                }
                return _uniqueIdentifier;
            }
        };
        Iterables.addAll((Collection)it.getRelationshipTypeIDs(), (Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map(this._gMFGenToAssistantRule.validLinks(editor.getDiagram()), (Functions.Function1)_function_1)));
        Functions.Function1<GenNode, PopupAssistant> _function_2 = new Functions.Function1<GenNode, PopupAssistant>(){

            public PopupAssistant apply(GenNode it) {
                return ModelingAssistantProviderRule.this._gMFGenToAssistantRule.toPopupAssistant(it);
            }
        };
        Iterables.addAll((Collection)it.getPopupAssistants(), (Iterable)IterableExtensions.map(this._gMFGenToAssistantRule.validNodes(editor.getDiagram()), (Functions.Function1)_function_2));
        Functions.Function1<GenLink, ConnectionAssistant> _function_3 = new Functions.Function1<GenLink, ConnectionAssistant>(){

            public ConnectionAssistant apply(GenLink it) {
                return ModelingAssistantProviderRule.this._gMFGenToAssistantRule.toConnectionAssistant(it);
            }
        };
        Iterables.addAll((Collection)it.getConnectionAssistants(), (Iterable)IterableExtensions.map(this._gMFGenToAssistantRule.validLinks(editor.getDiagram()), (Functions.Function1)_function_3));
    }
}

