/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.palette.dialog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteStack;
import org.eclipse.gef.palette.PaletteToolbar;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gmf.runtime.common.core.service.ProviderPriority;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditorWithFlyOutPalette;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.PaletteUtil;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.ChildConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.Configuration;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.DrawerConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.PaletteConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.PaletteconfigurationFactory;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.SeparatorConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.StackConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.ToolConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.utils.CreatePaletteItemUtil;
import org.eclipse.papyrus.infra.properties.ui.runtime.DisplayEngine;
import org.eclipse.papyrus.infra.properties.ui.util.PropertiesDisplayHelper;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.toolsmiths.palette.Messages;
import org.eclipse.papyrus.toolsmiths.palette.provider.PaletteLabelProvider;
import org.eclipse.papyrus.toolsmiths.palette.provider.ProfileToolsMetaclassStereotypeTreeContentProvider;
import org.eclipse.papyrus.toolsmiths.palette.provider.ProfileToolsStereotypeMetaclassTreeContentProvider;
import org.eclipse.papyrus.toolsmiths.palette.provider.UMLToolsTreeContentProvider;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;

public class PaletteConfigurationContentPage
extends WizardPage {
    protected static final String ADD_ICON = "/icons/arrow_right.gif";
    protected static final String CREATE_DRAWERS_ICON = "/icons/new_drawer.gif";
    protected static final String CREATE_SEPARATOR_ICON = "/icons/new_separator.gif";
    protected static final String CREATE_STACK_ICON = "/icons/new_stack.gif";
    protected static final String CREATE_TOOL_ICON = "/icons/new_tool.gif";
    protected static final String DELETE_ICON = "/icons/delete.gif";
    protected static final String REMOVE_ICON = "/icons/arrow_left.gif";
    protected static final String SHOWN_TOOLS_ICON = "/icons/tools_shown.gif";
    protected static final String WIZARD_ICON = "/icons/local_desc_wiz.png";
    protected static final String SWITCH_CONTENT_PROVIDER_ICON = "/icons/switch_provider.gif";
    private static final String DRAWER_LABEL = Messages.PaletteConfigurationContentPage_Drawer;
    private static final String NEW_TOOL_LABEL = Messages.PaletteConfigurationContentPage_NewTool;
    private static final String SEPARATOR_LABEL = Messages.PaletteConfigurationContentPage_Separator;
    private static final String STACK_LABEL = Messages.PaletteConfigurationContentPage_Stack;
    private static final String UML_TOOLS_LABEL = Messages.PaletteConfigurationContentPage_UMLTools;
    private static final String VALIDATOR = "validator";
    private Button addButton;
    private Button removeButton;
    private TreeViewer availableToolsViewer;
    private Combo profileCombo;
    private List<String> profileComboList = new ArrayList<String>();
    private TreeViewer paletteTreeViewer;
    private DisplayEngine displayEngine;
    private final ViewerFilter drawerFilter = new DrawerFilter();
    private AdapterFactoryEditingDomain editingDomain;
    private IEditorPart editorPart;
    private PaletteLabelProvider paletteLabelProvider;
    private ProviderPriority priority;
    private Composite propertiesComposite;
    protected ToolItem toggleContentProvider;
    private ToolBar toolbar;
    private final ViewerFilter toolFilter = new ToolFilter();
    EContentAdapter adapter = new EContentAdapter(){

        public void notifyChanged(Notification msg) {
            PaletteConfigurationContentPage.this.setPageComplete(PaletteConfigurationContentPage.this.validatePage());
        }
    };
    private PaletteConfiguration paletteConfigurationModel;
    Diagnostician diagnostician = new Diagnostician(){

        public String getObjectLabel(EObject eObject) {
            String label = null;
            if (eObject instanceof Configuration) {
                label = ((Configuration)eObject).getLabel();
            }
            if (label == null || label.isEmpty()) {
                label = EcoreUtil.getIdentification((EObject)eObject);
            }
            return label;
        }
    };

    public PaletteConfigurationContentPage(IEditorPart editorPart, AdapterFactoryEditingDomain editingDomain) {
        super(Messages.Local_Palette_ContentPage_Name, Messages.Local_Palette_ContentPage_Title, Activator.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.infra.gmfdiag.common", (String)WIZARD_ICON));
        this.editorPart = editorPart;
        this.editingDomain = editingDomain;
        this.paletteConfigurationModel = this.getPaletteConfigurationModel();
        this.paletteConfigurationModel.eAdapters().add((Object)this.adapter);
    }

    protected PaletteConfigurationContentPage(String pageName) {
        super(pageName);
    }

    protected void addAvailableToolsDragSupport() {
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance(), LocalSelectionTransfer.getTransfer(), FileTransfer.getInstance()};
        int dndOperations = 7;
        this.availableToolsViewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)this.availableToolsViewer));
    }

    protected void addPalettePreviewDragSupport() {
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance(), LocalSelectionTransfer.getTransfer(), FileTransfer.getInstance()};
        int dndOperations = 7;
        this.paletteTreeViewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)this.paletteTreeViewer));
    }

    protected void addPalettePreviewDropSupport() {
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance(), LocalSelectionTransfer.getTransfer(), FileTransfer.getInstance()};
        int dndOperations = 7;
        EditingDomainViewerDropAdapter listener = new EditingDomainViewerDropAdapter((EditingDomain)this.editingDomain, (Viewer)this.paletteTreeViewer){

            public void dragEnter(DropTargetEvent event) {
                super.dragEnter(event);
                this.expandItem(event);
            }

            public void drop(DropTargetEvent event) {
                super.drop(event);
                this.expandItem(event);
            }

            private void expandItem(DropTargetEvent event) {
                if (event.item instanceof TreeItem) {
                    Object target = ((TreeItem)event.item).getData();
                    if (target == null) {
                        target = PaletteConfigurationContentPage.this.paletteTreeViewer.getInput();
                    }
                    PaletteConfigurationContentPage.this.paletteTreeViewer.expandToLevel(target, 1);
                }
            }
        };
        this.paletteTreeViewer.addDropSupport(dndOperations, transfers, (DropTargetListener)listener);
    }

    protected MouseListener createAddButtonListener() {
        return new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                IStructuredSelection selection = (IStructuredSelection)PaletteConfigurationContentPage.this.availableToolsViewer.getSelection();
                if (selection == null || selection.size() < 1) {
                    return;
                }
                PaletteEntry entry = (PaletteEntry)selection.getFirstElement();
                if (entry == null) {
                    return;
                }
                selection = (IStructuredSelection)PaletteConfigurationContentPage.this.paletteTreeViewer.getSelection();
                Configuration target = (Configuration)selection.getFirstElement();
                CompoundCommand command = new CompoundCommand();
                ToolConfiguration node = CreatePaletteItemUtil.createToolConfiguration((PaletteEntry)entry, (ResourceSet)PaletteConfigurationContentPage.this.editingDomain.getResourceSet());
                if (node != null) {
                    if (target instanceof PaletteConfiguration) {
                        command.append((Command)new AddCommand((EditingDomain)PaletteConfigurationContentPage.this.editingDomain, ((PaletteConfiguration)target).getDrawerConfigurations(), (Object)((DrawerConfiguration)node)));
                    } else if (target instanceof DrawerConfiguration) {
                        command.append((Command)new AddCommand((EditingDomain)PaletteConfigurationContentPage.this.editingDomain, ((DrawerConfiguration)target).getOwnedConfigurations(), (Object)node));
                    } else if (target instanceof StackConfiguration) {
                        command.append((Command)new AddCommand((EditingDomain)PaletteConfigurationContentPage.this.editingDomain, ((StackConfiguration)target).getOwnedConfigurations(), (Object)node));
                    }
                }
                command.append(CreatePaletteItemUtil.createElementTypesElement((EditingDomain)PaletteConfigurationContentPage.this.editingDomain, (ToolEntry)((ToolEntry)entry), (ToolConfiguration)node));
                PaletteConfigurationContentPage.this.execute((Command)command);
                PaletteConfigurationContentPage.this.paletteTreeViewer.expandToLevel((Object)target, 1);
            }
        };
    }

    protected void createAddRemoveButtons() {
        Composite composite = new Composite((Composite)this.getControl(), 0);
        GridLayout layout = new GridLayout(1, true);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(0x1000000, 0x1000000, false, true);
        composite.setLayoutData((Object)data);
        this.addButton = new Button(composite, 0);
        this.addButton.setImage(Activator.getDefault().getImage(ADD_ICON));
        this.addButton.setToolTipText(Messages.PapyrusPaletteCustomizerDialog_AddButtonTooltip);
        this.addButton.addMouseListener(this.createAddButtonListener());
        this.addButton.setEnabled(false);
        this.removeButton = new Button(composite, 0);
        this.removeButton.setImage(Activator.getDefault().getImage(REMOVE_ICON));
        this.removeButton.setToolTipText(Messages.PapyrusPaletteCustomizerDialog_RemoveButtonTooltip);
        this.removeButton.addMouseListener(this.createRemoveButtonListener());
        this.removeButton.setEnabled(false);
    }

    protected void createAvailableToolsGroup() {
        Composite parent = (Composite)this.getControl();
        Composite availableToolsComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        availableToolsComposite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        availableToolsComposite.setLayoutData((Object)data);
        Label label = new Label(availableToolsComposite, 0);
        label.setText(Messages.Local_Palette_Available_Tools);
        data = new GridData(16384, 0x1000000, true, false);
        label.setLayoutData((Object)data);
        ToolBar toolbar = new ToolBar(availableToolsComposite, 256);
        data = new GridData(131072, 4, false, false);
        toolbar.setLayoutData((Object)data);
        this.populateAvailableToolsToolBar(toolbar);
        this.createProfileCombo(availableToolsComposite);
        Tree tree = new Tree(availableToolsComposite, 2052);
        data = new GridData(4, 4, true, true, 2, 1);
        data.widthHint = 350;
        data.heightHint = 200;
        tree.setLayoutData((Object)data);
        this.availableToolsViewer = new TreeViewer(tree);
        this.availableToolsViewer.setContentProvider((IContentProvider)new UMLToolsTreeContentProvider());
        this.paletteLabelProvider = new PaletteLabelProvider();
        this.availableToolsViewer.setLabelProvider((IBaseLabelProvider)this.paletteLabelProvider);
        LabelViewerComparator labelComparator = new LabelViewerComparator();
        this.availableToolsViewer.setComparator((ViewerComparator)labelComparator);
        this.availableToolsViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                boolean visible = true;
                if (element instanceof PaletteStack && "noteStack".equals(((PaletteStack)element).getId())) {
                    visible = false;
                } else if (element instanceof PaletteToolbar && "standardGroup".equals(((PaletteToolbar)element).getId())) {
                    visible = false;
                }
                return visible;
            }
        });
        this.availableToolsViewer.addFilter((ViewerFilter)new DrawerFilter());
        this.addAvailableToolsDragSupport();
        this.profileCombo.deselectAll();
        this.profileCombo.select(this.profileCombo.getItems().length - 1);
    }

    protected ToolItem createCheckToolBarItem(ToolBar toolbar, String shownElementsIcon, String tooltip, Listener listener) {
        ToolItem item = new ToolItem(toolbar, 2080);
        item.setImage(Activator.getDefault().getImage(shownElementsIcon));
        item.setToolTipText(tooltip);
        item.addListener(13, listener);
        return item;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite control = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        control.setLayout((Layout)layout);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setControl((Control)control);
        this.createAvailableToolsGroup();
        this.createAddRemoveButtons();
        this.createPalettePreviewGroup();
        this.createPropertiesGroup();
        ISelectionChangedListener listener = this.createToolsViewerSelectionChangeListener();
        this.availableToolsViewer.addSelectionChangedListener(listener);
        this.paletteTreeViewer.addSelectionChangedListener(listener);
        Dialog.applyDialogFont((Control)control);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setPageComplete(this.validatePage());
    }

    protected Listener createNewDrawerListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                EObject palette = (EObject)((Resource)PaletteConfigurationContentPage.this.editingDomain.getResourceSet().getResources().get(0)).getContents().get(0);
                if (palette instanceof PaletteConfiguration) {
                    DrawerConfiguration drawer = PaletteconfigurationFactory.eINSTANCE.createDrawerConfiguration();
                    drawer.setLabel(DRAWER_LABEL);
                    EList drawerConfigurations = ((PaletteConfiguration)palette).getDrawerConfigurations();
                    AddCommand addCommand = new AddCommand((EditingDomain)PaletteConfigurationContentPage.this.editingDomain, drawerConfigurations, (Object)drawer);
                    PaletteConfigurationContentPage.this.execute((Command)addCommand);
                    PaletteConfigurationContentPage.this.paletteTreeViewer.refresh();
                }
            }
        };
    }

    protected Listener createNewSeparatorListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                Object object = ((IStructuredSelection)PaletteConfigurationContentPage.this.paletteTreeViewer.getSelection()).getFirstElement();
                SeparatorConfiguration separator = PaletteconfigurationFactory.eINSTANCE.createSeparatorConfiguration();
                separator.setLabel(SEPARATOR_LABEL);
                separator.setId(CreatePaletteItemUtil.generateID((String)SEPARATOR_LABEL));
                AddCommand addCommand = null;
                if (object instanceof DrawerConfiguration) {
                    addCommand = new AddCommand((EditingDomain)PaletteConfigurationContentPage.this.editingDomain, ((DrawerConfiguration)object).getOwnedConfigurations(), (Object)separator);
                } else if (object instanceof ChildConfiguration) {
                    EList ownedConfigurations = ((DrawerConfiguration)((ChildConfiguration)object).eContainer()).getOwnedConfigurations();
                    int index = ownedConfigurations.indexOf(object);
                    addCommand = new AddCommand((EditingDomain)PaletteConfigurationContentPage.this.editingDomain, ownedConfigurations, (Object)separator, index);
                }
                PaletteConfigurationContentPage.this.execute((Command)addCommand);
                PaletteConfigurationContentPage.this.paletteTreeViewer.expandToLevel(object, 1);
                PaletteConfigurationContentPage.this.paletteTreeViewer.refresh();
            }
        };
    }

    protected Listener createNewStackListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                Object object = ((IStructuredSelection)PaletteConfigurationContentPage.this.paletteTreeViewer.getSelection()).getFirstElement();
                StackConfiguration stack = PaletteconfigurationFactory.eINSTANCE.createStackConfiguration();
                stack.setLabel(STACK_LABEL);
                stack.setId(CreatePaletteItemUtil.generateID((String)STACK_LABEL));
                AddCommand addCommand = null;
                if (object instanceof DrawerConfiguration) {
                    addCommand = new AddCommand((EditingDomain)PaletteConfigurationContentPage.this.editingDomain, ((DrawerConfiguration)object).getOwnedConfigurations(), (Object)stack);
                } else if (object instanceof ChildConfiguration) {
                    EList ownedConfigurations = ((DrawerConfiguration)((ChildConfiguration)object).eContainer()).getOwnedConfigurations();
                    int index = ownedConfigurations.indexOf(object);
                    addCommand = new AddCommand((EditingDomain)PaletteConfigurationContentPage.this.editingDomain, ownedConfigurations, (Object)stack, index);
                }
                PaletteConfigurationContentPage.this.execute((Command)addCommand);
                PaletteConfigurationContentPage.this.paletteTreeViewer.expandToLevel(object, 1);
                PaletteConfigurationContentPage.this.paletteTreeViewer.refresh();
            }
        };
    }

    protected void execute(Command command) {
        if (command != null && command.canExecute()) {
            this.editingDomain.getCommandStack().execute(command);
        }
    }

    protected Listener createNewToolListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                Object object = ((IStructuredSelection)PaletteConfigurationContentPage.this.paletteTreeViewer.getSelection()).getFirstElement();
                ToolConfiguration tool = PaletteconfigurationFactory.eINSTANCE.createToolConfiguration();
                tool.setLabel(NEW_TOOL_LABEL);
                AddCommand addCommand = null;
                if (object instanceof DrawerConfiguration || object instanceof StackConfiguration) {
                    if (object instanceof DrawerConfiguration) {
                        addCommand = new AddCommand((EditingDomain)PaletteConfigurationContentPage.this.editingDomain, ((DrawerConfiguration)object).getOwnedConfigurations(), (Object)tool);
                    } else if (object instanceof StackConfiguration) {
                        addCommand = new AddCommand((EditingDomain)PaletteConfigurationContentPage.this.editingDomain, ((StackConfiguration)object).getOwnedConfigurations(), (Object)tool);
                    }
                } else if (object instanceof ChildConfiguration) {
                    EObject eContainer = ((EObject)object).eContainer();
                    if (eContainer instanceof DrawerConfiguration) {
                        EList ownedConfigurations = ((DrawerConfiguration)eContainer).getOwnedConfigurations();
                        int index = ownedConfigurations.indexOf(object);
                        addCommand = new AddCommand((EditingDomain)PaletteConfigurationContentPage.this.editingDomain, ownedConfigurations, (Object)tool, index);
                    } else if (eContainer instanceof StackConfiguration) {
                        EList ownedConfigurations = ((StackConfiguration)eContainer).getOwnedConfigurations();
                        int index = ownedConfigurations.indexOf(object);
                        addCommand = new AddCommand((EditingDomain)PaletteConfigurationContentPage.this.editingDomain, ownedConfigurations, (Object)tool, index);
                    }
                }
                PaletteConfigurationContentPage.this.execute((Command)addCommand);
                PaletteConfigurationContentPage.this.paletteTreeViewer.expandToLevel(object, 1);
                PaletteConfigurationContentPage.this.paletteTreeViewer.refresh();
            }
        };
    }

    protected void createPalettePreviewGroup() {
        Composite parent = (Composite)this.getControl();
        Composite paletteComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        paletteComposite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        paletteComposite.setLayoutData((Object)data);
        Label label = new Label(paletteComposite, 0);
        label.setText(Messages.Local_Palette_Palette_Preview);
        data = new GridData(16384, 0x1000000, true, false);
        label.setLayoutData((Object)data);
        this.toolbar = new ToolBar(paletteComposite, 256);
        data = new GridData(131072, 4, false, false);
        this.toolbar.setLayoutData((Object)data);
        this.populatePalettePreviewToolBar(this.toolbar);
        Tree tree = new Tree(paletteComposite, 2052);
        data = new GridData(4, 4, true, true, 2, 1);
        data.widthHint = 350;
        data.heightHint = 200;
        tree.setLayoutData((Object)data);
        this.paletteTreeViewer = new TreeViewer(tree);
        this.paletteTreeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.editingDomain.getAdapterFactory()));
        this.paletteTreeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.editingDomain.getAdapterFactory()));
        this.paletteTreeViewer.setInput((Object)this.editingDomain.getResourceSet());
        this.paletteTreeViewer.setSelection((ISelection)new StructuredSelection(this.editingDomain.getResourceSet().getResources().get(0)), true);
        new AdapterFactoryTreeEditor(this.paletteTreeViewer.getTree(), this.editingDomain.getAdapterFactory());
        this.paletteTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PaletteConfigurationContentPage.this.handlePalettePreviewSelectionChanged(event);
            }
        });
        this.handlePalettePreviewSelectionChanged(null);
        this.addPalettePreviewDropSupport();
        this.addPalettePreviewDragSupport();
    }

    protected Combo createProfileCombo(Composite availableToolsComposite) {
        this.profileCombo = new Combo(availableToolsComposite, 2056);
        GridData data = new GridData(4, 4, true, false, 2, 1);
        this.profileCombo.setLayoutData((Object)data);
        List<Profile> profiles = this.getAllAppliedProfiles();
        int profileNumber = profiles.size();
        int i = 0;
        while (i < profileNumber) {
            String name;
            if (profiles.get(i).eIsProxy()) {
                name = NLS.bind((String)"<unresolved: {0}>", (Object)URI.decode((String)EcoreUtil.getURI((EObject)((EObject)profiles.get(i))).lastSegment()));
            } else {
                name = profiles.get(i).getName();
                if (name == null) {
                    name = NLS.bind((String)"<unnamed: {0}>", (Object)URI.decode((String)EcoreUtil.getURI((EObject)((EObject)profiles.get(i))).lastSegment()));
                }
            }
            this.profileComboList.add(i, name);
            ++i;
        }
        this.profileComboList.add(UML_TOOLS_LABEL);
        this.profileCombo.setItems(this.profileComboList.toArray(new String[0]));
        ProfileComboSelectionListener listener = new ProfileComboSelectionListener();
        this.profileCombo.addSelectionListener((SelectionListener)listener);
        this.profileCombo.addModifyListener((ModifyListener)listener);
        return this.profileCombo;
    }

    protected void createPropertiesGroup() {
        Composite parent = (Composite)this.getControl();
        Label entryInformationLabel = new Label(parent, 0);
        entryInformationLabel.setText(Messages.Local_Palette_Entry_Information);
        GridData data = new GridData(4, 4, true, false);
        data.horizontalSpan = 3;
        entryInformationLabel.setLayoutData((Object)data);
        this.propertiesComposite = new Composite(parent, 0);
        FillLayout layout = new FillLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.propertiesComposite.setLayout((Layout)layout);
        GridData data2 = new GridData(4, 4, true, true);
        data2.horizontalSpan = 3;
        data2.heightHint = 340;
        this.propertiesComposite.setLayoutData((Object)data2);
    }

    protected MouseListener createRemoveButtonListener() {
        return new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                PaletteConfigurationContentPage.this.deleteSelectedConfiguration();
            }
        };
    }

    protected Listener createRemoveElementListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                PaletteConfigurationContentPage.this.deleteSelectedConfiguration();
            }
        };
    }

    protected void deleteSelectedConfiguration() {
        IStructuredSelection selection = (IStructuredSelection)this.paletteTreeViewer.getSelection();
        if (selection != null && 1 <= selection.size()) {
            for (final Object object : selection) {
                if (!(object instanceof Configuration)) continue;
                AbstractCommand deleteCommand = new AbstractCommand(){

                    public void redo() {
                        this.execute();
                    }

                    public void execute() {
                        EcoreUtil.delete((EObject)((EObject)object));
                    }

                    public boolean prepare() {
                        return true;
                    }
                };
                deleteCommand.canExecute();
                this.editingDomain.getCommandStack().execute((Command)deleteCommand);
            }
            this.paletteTreeViewer.refresh();
            if (this.displayEngine != null) {
                this.displayEngine.removeSection(this.propertiesComposite);
            }
        }
    }

    protected Listener createShowDrawerListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                if (event.widget instanceof ToolItem) {
                    ToolItem item = (ToolItem)event.widget;
                    if (item.getSelection()) {
                        PaletteConfigurationContentPage.this.availableToolsViewer.addFilter(PaletteConfigurationContentPage.this.drawerFilter);
                        item.setSelection(true);
                    } else {
                        PaletteConfigurationContentPage.this.availableToolsViewer.removeFilter(PaletteConfigurationContentPage.this.drawerFilter);
                        item.setSelection(false);
                    }
                }
            }
        };
    }

    protected Listener createsShowToolListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                if (event.widget instanceof ToolItem) {
                    ToolItem item = (ToolItem)event.widget;
                    if (item.getSelection()) {
                        PaletteConfigurationContentPage.this.availableToolsViewer.addFilter(PaletteConfigurationContentPage.this.toolFilter);
                        item.setSelection(true);
                    } else {
                        PaletteConfigurationContentPage.this.availableToolsViewer.removeFilter(PaletteConfigurationContentPage.this.toolFilter);
                        item.setSelection(false);
                    }
                }
            }
        };
    }

    protected Listener createSwitchToolsContentProviderListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                if (event.widget instanceof ToolItem) {
                    ToolItem item = (ToolItem)event.widget;
                    int index = PaletteConfigurationContentPage.this.profileCombo.getSelectionIndex();
                    Collection<PaletteEntry> standardEntries = PaletteConfigurationContentPage.this.getAllVisibleStandardEntries();
                    Profile profile = PaletteConfigurationContentPage.this.getAllAppliedProfiles().get(index);
                    if (item.getSelection()) {
                        PaletteConfigurationContentPage.this.availableToolsViewer.setContentProvider((IContentProvider)new ProfileToolsStereotypeMetaclassTreeContentProvider(profile, standardEntries));
                        item.setSelection(true);
                    } else {
                        PaletteConfigurationContentPage.this.availableToolsViewer.setContentProvider((IContentProvider)new ProfileToolsMetaclassStereotypeTreeContentProvider(profile, standardEntries));
                        item.setSelection(false);
                    }
                    PaletteConfigurationContentPage.this.availableToolsViewer.setInput((Object)profile);
                }
            }
        };
    }

    protected void createToolBarItem(ToolBar toolbar, String itemIcon, String tooltip, Listener listener, ToolBarItemValidator validator) {
        ToolItem item = new ToolItem(toolbar, 2048);
        item.setImage(Activator.getDefault().getImage("org.eclipse.papyrus.infra.gmfdiag.common", itemIcon));
        item.setToolTipText(tooltip);
        item.addListener(13, listener);
        item.setData(VALIDATOR, (Object)validator);
    }

    protected ISelectionChangedListener createToolsViewerSelectionChangeListener() {
        return new ISelectionChangedListener(){

            protected boolean isAddValidTarget(Object source, Object target) {
                boolean isAddValidTarget = false;
                if (source instanceof PaletteEntry) {
                    if (source instanceof PaletteDrawer) {
                        isAddValidTarget = target == null;
                    } else if (source instanceof ToolEntry) {
                        isAddValidTarget = target instanceof DrawerConfiguration || target instanceof StackConfiguration;
                    }
                }
                return isAddValidTarget;
            }

            protected boolean isRemoveValidSource(Object source) {
                return source instanceof Configuration;
            }

            public void selectionChanged(SelectionChangedEvent event) {
                Object target;
                Object source = ((IStructuredSelection)PaletteConfigurationContentPage.this.availableToolsViewer.getSelection()).getFirstElement();
                if (this.isAddValidTarget(source, target = ((IStructuredSelection)PaletteConfigurationContentPage.this.paletteTreeViewer.getSelection()).getFirstElement())) {
                    PaletteConfigurationContentPage.this.addButton.setEnabled(true);
                } else {
                    PaletteConfigurationContentPage.this.addButton.setEnabled(false);
                }
                if (this.isRemoveValidSource(target)) {
                    PaletteConfigurationContentPage.this.removeButton.setEnabled(true);
                } else {
                    PaletteConfigurationContentPage.this.removeButton.setEnabled(false);
                }
            }
        };
    }

    public void dispose() {
        if (this.displayEngine != null) {
            this.displayEngine.dispose();
        }
        this.paletteConfigurationModel.eAdapters().remove((Object)this.adapter);
        super.dispose();
    }

    protected List<Profile> getAllAppliedProfiles() {
        EObject element;
        Package topPackage = null;
        if (this.editorPart instanceof DiagramEditorWithFlyOutPalette && (element = ((DiagramEditorWithFlyOutPalette)this.editorPart).getDiagram().getElement()) instanceof Element) {
            topPackage = ((Element)element).getNearestPackage();
        }
        return topPackage != null ? topPackage.getAllAppliedProfiles() : Collections.emptyList();
    }

    protected Collection<PaletteEntry> getAllVisibleStandardEntries() {
        HashSet<PaletteEntry> result = new HashSet<PaletteEntry>();
        for (PaletteEntry entry : PaletteUtil.getAvailableEntriesSet((IEditorPart)this.editorPart, (ProviderPriority)this.priority).values()) {
            if (this.getRootParent(entry) == null) continue;
            result.add(entry);
        }
        return result;
    }

    protected PaletteRoot getRootParent(PaletteEntry entry) {
        PaletteRoot paletteRoot = null;
        PaletteContainer parent = entry.getParent();
        if (parent instanceof PaletteRoot) {
            paletteRoot = (PaletteRoot)parent;
        } else if (parent != null) {
            paletteRoot = this.getRootParent((PaletteEntry)parent);
        }
        return paletteRoot;
    }

    protected void handlePalettePreviewSelectionChanged(SelectionChangedEvent event) {
        TreeSelection selection;
        Object firstSelected;
        if (event != null && (firstSelected = (selection = (TreeSelection)event.getSelection()).getFirstElement()) instanceof Configuration) {
            if (this.displayEngine != null) {
                this.displayEngine.removeSection(this.propertiesComposite);
            }
            this.displayEngine = PropertiesDisplayHelper.display((Object)firstSelected, (Composite)this.propertiesComposite);
            this.propertiesComposite.layout();
        }
        if (this.toolbar != null && !this.toolbar.isDisposed()) {
            int i = 0;
            while (i < this.toolbar.getItemCount()) {
                ToolItem item = this.toolbar.getItem(i);
                Object validator = item.getData(VALIDATOR);
                if (validator instanceof ToolBarItemValidator) {
                    item.setEnabled(((ToolBarItemValidator)validator).isEnable());
                }
                ++i;
            }
        }
    }

    protected void populateAvailableToolsToolBar(ToolBar toolbar) {
        this.toggleContentProvider = this.createCheckToolBarItem(toolbar, SWITCH_CONTENT_PROVIDER_ICON, Messages.Local_Palette_SwitchToolsContentProvider_Tooltip, this.createSwitchToolsContentProviderListener());
        this.toggleContentProvider.setSelection(true);
        this.toggleContentProvider.setEnabled(false);
        this.createCheckToolBarItem(toolbar, SHOWN_TOOLS_ICON, Messages.Local_Palette_ShowTools_Tooltip, this.createsShowToolListener());
    }

    protected void populatePalettePreviewToolBar(ToolBar toolbar) {
        PaletteConfigurationEntrySelectedValidator validator = new PaletteConfigurationEntrySelectedValidator();
        PaletteConfigurationStackLeafSelectedValidator validatorForNotStackChild = new PaletteConfigurationStackLeafSelectedValidator();
        this.createToolBarItem(toolbar, DELETE_ICON, Messages.PapyrusPaletteCustomizerDialog_RemoveButtonTooltip, this.createRemoveElementListener(), validator);
        this.createToolBarItem(toolbar, CREATE_DRAWERS_ICON, Messages.Local_Palette_Create_Drawer_Tooltip, this.createNewDrawerListener(), null);
        this.createToolBarItem(toolbar, CREATE_SEPARATOR_ICON, Messages.Local_Palette_Create_Separator_Tooltip, this.createNewSeparatorListener(), validatorForNotStackChild);
        this.createToolBarItem(toolbar, CREATE_TOOL_ICON, Messages.Local_Palette_Create_Tool_Tooltip, this.createNewToolListener(), validator);
        this.createToolBarItem(toolbar, CREATE_STACK_ICON, Messages.Local_Palette_Create_Stack_Tooltip, this.createNewStackListener(), validatorForNotStackChild);
    }

    public void setPriority(ProviderPriority priority) {
        this.priority = priority;
    }

    public ProviderPriority getPriority() {
        return this.priority;
    }

    protected boolean validatePage() {
        boolean valid;
        Diagnostic validate = this.diagnostician.validate((EObject)this.paletteConfigurationModel);
        boolean bl = valid = validate.getSeverity() == 0;
        if (!valid) {
            this.setErrorMessage(((Diagnostic)validate.getChildren().get(0)).getMessage());
        } else {
            this.setErrorMessage(null);
        }
        return valid;
    }

    protected PaletteConfiguration getPaletteConfigurationModel() {
        EObject eObject;
        EList contents;
        PaletteConfiguration paletteModel = null;
        EList resources = this.editingDomain.getResourceSet().getResources();
        if (!resources.isEmpty() && !(contents = ((Resource)resources.get(0)).getContents()).isEmpty() && (eObject = (EObject)contents.get(0)) instanceof PaletteConfiguration) {
            paletteModel = (PaletteConfiguration)eObject;
        }
        Assert.isNotNull(paletteModel);
        return paletteModel;
    }

    protected class DrawerFilter
    extends ViewerFilter {
        protected DrawerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            boolean notDrawer = true;
            if (element instanceof PaletteDrawer) {
                notDrawer = false;
            }
            return notDrawer;
        }
    }

    public static enum EntryType {
        ASPECT_TOOL,
        DRAWER,
        SEPARATOR,
        STACK,
        TOOL;

    }

    protected class LabelViewerComparator
    extends ViewerComparator {
        public int compare(Viewer testViewer, Object e1, Object e2) {
            String label1 = "";
            String label2 = "";
            if (e1 instanceof PaletteEntry) {
                label1 = ((PaletteEntry)e1).getLabel();
            } else if (e1 instanceof Stereotype) {
                label1 = ((Stereotype)e1).getName();
            }
            if (e2 instanceof PaletteEntry) {
                label2 = ((PaletteEntry)e2).getLabel();
            } else if (e2 instanceof Stereotype) {
                label2 = ((Stereotype)e2).getName();
            }
            int comparaison = label1 == null && label2 == null ? 0 : (label1 == null ? 1 : (label2 == null ? -1 : label1.compareTo(label2)));
            return comparaison;
        }
    }

    protected class PaletteConfigurationEntrySelectedValidator
    implements ToolBarItemValidator {
        protected PaletteConfigurationEntrySelectedValidator() {
        }

        @Override
        public boolean isEnable() {
            IStructuredSelection selection;
            boolean enable = false;
            if (PaletteConfigurationContentPage.this.paletteTreeViewer != null && !PaletteConfigurationContentPage.this.paletteTreeViewer.getControl().isDisposed() && (selection = (IStructuredSelection)PaletteConfigurationContentPage.this.paletteTreeViewer.getSelection()) != null) {
                Object object = selection.getFirstElement();
                enable = object instanceof Configuration;
            }
            return enable;
        }
    }

    protected class PaletteConfigurationStackLeafSelectedValidator
    implements ToolBarItemValidator {
        protected PaletteConfigurationStackLeafSelectedValidator() {
        }

        @Override
        public boolean isEnable() {
            IStructuredSelection selection;
            boolean enable = false;
            if (PaletteConfigurationContentPage.this.paletteTreeViewer != null && !PaletteConfigurationContentPage.this.paletteTreeViewer.getControl().isDisposed() && (selection = (IStructuredSelection)PaletteConfigurationContentPage.this.paletteTreeViewer.getSelection()) != null) {
                Object object = selection.getFirstElement();
                enable = object instanceof Configuration && !(((Configuration)object).eContainer() instanceof StackConfiguration);
            }
            return enable;
        }
    }

    protected class ProfileComboSelectionListener
    implements SelectionListener,
    ModifyListener {
        protected ProfileComboSelectionListener() {
        }

        protected void handleSelectionChanged() {
            int index = PaletteConfigurationContentPage.this.profileCombo.getSelectionIndex();
            if (index >= 0 && index < PaletteConfigurationContentPage.this.profileCombo.getItems().length) {
                String name = PaletteConfigurationContentPage.this.profileComboList.get(index);
                Collection<PaletteEntry> standardEntries = PaletteConfigurationContentPage.this.getAllVisibleStandardEntries();
                if (UML_TOOLS_LABEL.equals(name)) {
                    PaletteConfigurationContentPage.this.availableToolsViewer.setContentProvider((IContentProvider)new UMLToolsTreeContentProvider());
                    PaletteConfigurationContentPage.this.availableToolsViewer.setInput(standardEntries);
                    PaletteConfigurationContentPage.this.toggleContentProvider.setEnabled(false);
                } else {
                    if (PaletteConfigurationContentPage.this.toggleContentProvider != null && !PaletteConfigurationContentPage.this.toggleContentProvider.isDisposed()) {
                        PaletteConfigurationContentPage.this.toggleContentProvider.setEnabled(true);
                    }
                    Profile profile = PaletteConfigurationContentPage.this.getAllAppliedProfiles().get(index);
                    if (PaletteConfigurationContentPage.this.toggleContentProvider.getSelection()) {
                        PaletteConfigurationContentPage.this.availableToolsViewer.setContentProvider((IContentProvider)new ProfileToolsStereotypeMetaclassTreeContentProvider(profile, standardEntries));
                    } else {
                        PaletteConfigurationContentPage.this.availableToolsViewer.setContentProvider((IContentProvider)new ProfileToolsMetaclassStereotypeTreeContentProvider(profile, standardEntries));
                    }
                    PaletteConfigurationContentPage.this.availableToolsViewer.setInput((Object)profile);
                }
            }
        }

        public void modifyText(ModifyEvent e) {
            this.handleSelectionChanged();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            this.handleSelectionChanged();
        }
    }

    static interface ToolBarItemValidator {
        public boolean isEnable();
    }

    protected class ToolFilter
    extends ViewerFilter {
        protected ToolFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return !(element instanceof ToolEntry);
        }
    }
}

