/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.groups.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.uml.diagram.common.groups.core.PendingGroupNotificationsManager;
import org.eclipse.papyrus.uml.diagram.common.groups.core.ui.ChooseChildrenNotificationConfigurator;
import org.eclipse.papyrus.uml.diagram.common.groups.core.ui.NotificationConfigurator;

public class ChooseChildrenNotificationCommand
extends AbstractTransactionalCommand {
    private List<IGraphicalEditPart> allChildren;
    private List<IGraphicalEditPart> automaticChildren;
    private IAdaptable adapter;
    private IGraphicalEditPart mainEditPart;
    private IGraphicalEditPart host;
    private PendingGroupNotificationsManager manager;
    private List<ChooseChildrenNotificationConfigurator> createdNotificationConfigurator;
    private DiagramEditPart diagramPart;

    public ChooseChildrenNotificationCommand(TransactionalEditingDomain domain, String label, List<IGraphicalEditPart> _allChildren, List<IGraphicalEditPart> _automaticChildren, IAdaptable _adapter, IGraphicalEditPart getHost, DiagramEditPart _diagramPart) {
        super(domain, label, null);
        this.allChildren = _allChildren;
        this.automaticChildren = _automaticChildren;
        this.adapter = _adapter;
        this.host = getHost;
        this.diagramPart = _diagramPart;
        this.manager = PendingGroupNotificationsManager.getInstanceForDiagram(DiagramEditPartsUtil.getDiagramEditPart((EditPart)getHost));
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.getEditPartFromEditPartAdapter().booleanValue() && !this.allChildren.isEmpty()) {
            this.getEditPartFromViewAdapter(this.allChildren.get(0));
        }
        if (this.mainEditPart != null) {
            this.createdNotificationConfigurator = new ArrayList<ChooseChildrenNotificationConfigurator>();
            NotificationConfigurator configurator = PendingGroupNotificationsManager.getInstanceForDiagram(this.diagramPart).getChooseChildrenPendingNotification(this.mainEditPart);
            ChooseChildrenNotificationConfigurator notificationConfigurator = null;
            if (configurator == null) {
                if (!this.allChildren.isEmpty() && this.isChildrenToChoose()) {
                    notificationConfigurator = new ChooseChildrenNotificationConfigurator(this.mainEditPart, this.allChildren, this.automaticChildren, this.host, this.manager);
                    notificationConfigurator.runConfigurator();
                }
            } else if (configurator instanceof ChooseChildrenNotificationConfigurator && (notificationConfigurator = (ChooseChildrenNotificationConfigurator)configurator).isThereAnyModification(this.mainEditPart, this.allChildren, this.automaticChildren, this.host)) {
                notificationConfigurator.closeNotification();
                if (!this.allChildren.isEmpty() && this.isChildrenToChoose()) {
                    notificationConfigurator = new ChooseChildrenNotificationConfigurator(this.mainEditPart, this.allChildren, this.automaticChildren, this.host, this.manager);
                    notificationConfigurator.runConfigurator();
                }
            }
            if (notificationConfigurator != null) {
                this.createdNotificationConfigurator.add(notificationConfigurator);
            }
            return CommandResult.newOKCommandResult();
        }
        return CommandResult.newErrorCommandResult((String)"The editPart of the adaptable element has not been found");
    }

    private boolean isChildrenToChoose() {
        return this.allChildren.size() > this.automaticChildren.size();
    }

    private Boolean getEditPartFromEditPartAdapter() {
        Object _mainEditPart = this.adapter.getAdapter(EditPart.class);
        if (_mainEditPart instanceof IGraphicalEditPart) {
            this.mainEditPart = (IGraphicalEditPart)_mainEditPart;
            return true;
        }
        return false;
    }

    private Boolean getEditPartFromViewAdapter(IGraphicalEditPart any) {
        View childView;
        Object auxPart;
        Object view = this.adapter.getAdapter(View.class);
        Map registery = any.getViewer().getEditPartRegistry();
        if (view instanceof View && (auxPart = registery.get(childView = (View)view)) instanceof IGraphicalEditPart) {
            this.mainEditPart = (IGraphicalEditPart)auxPart;
            return true;
        }
        return false;
    }

    protected void didUndo(Transaction tx) {
        for (ChooseChildrenNotificationConfigurator notifConfigurator : this.createdNotificationConfigurator) {
            notifConfigurator.closeNotification();
        }
        super.didUndo(tx);
    }
}

