/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.editor;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.edit.gui.AbstractDialogCellEditor;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.ITableAxisElementProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablecell.Cell;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.papyrus.uml.nattable.utils.UMLTableUtils;
import org.eclipse.papyrus.uml.tools.providers.UMLContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLFilteredLabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class SingleReferenceValueCellEditor
extends AbstractDialogCellEditor {
    private EObject returnedValue;
    protected ITableAxisElementProvider manager;
    private Object axisElement;

    public SingleReferenceValueCellEditor(Object axisElement, ITableAxisElementProvider elementProvider) {
        this.axisElement = axisElement;
        this.manager = elementProvider;
    }

    public int open() {
        NatTable nattable;
        int result = ((TreeSelectorDialog)this.dialog).open();
        if (this.manager instanceof IAdaptable && (nattable = (NatTable)((IAdaptable)this.manager).getAdapter(NatTable.class)) != null && !nattable.isDisposed()) {
            nattable.forceFocus();
        }
        return result;
    }

    public Object createDialogInstance() {
        int columnIndex = this.layerCell.getColumnIndex();
        int rowIndex = this.layerCell.getRowIndex();
        Object row = this.manager.getRowElement(rowIndex);
        Object column = this.manager.getColumnElement(columnIndex);
        row = AxisUtils.getRepresentedElement((Object)row);
        column = AxisUtils.getRepresentedElement((Object)column);
        Element editedElement = null;
        Object feature = null;
        if (row instanceof EObject && column == this.axisElement) {
            editedElement = (Element)row;
            feature = column;
        } else {
            editedElement = (Element)column;
            feature = row;
        }
        Cell cell = ((INattableModelManager)this.manager).getCell(column, row);
        EStructuralFeature realFeature = null;
        Element realEditedObject = null;
        Stereotype stereotype = null;
        List<Stereotype> stereotypesWithEditedFeatureAppliedOnElement = null;
        if (feature instanceof EStructuralFeature) {
            realFeature = (EStructuralFeature)feature;
            realEditedObject = editedElement;
        } else {
            String id = AxisUtils.getPropertyId((Object)this.axisElement);
            stereotypesWithEditedFeatureAppliedOnElement = UMLTableUtils.getAppliedStereotypesWithThisProperty(editedElement, id);
            stereotype = stereotypesWithEditedFeatureAppliedOnElement.get(0);
            realEditedObject = editedElement.getStereotypeApplication(stereotypesWithEditedFeatureAppliedOnElement.get(0));
            Property prop = UMLTableUtils.getRealStereotypeProperty((EObject)editedElement, id);
            realFeature = realEditedObject.eClass().getEStructuralFeature(prop.getName());
        }
        if (stereotypesWithEditedFeatureAppliedOnElement == null || stereotypesWithEditedFeatureAppliedOnElement.size() <= 1) {
            this.dialog = this.createDialog((EObject)realEditedObject, realFeature, stereotype, editedElement.eResource().getResourceSet(), cell);
        }
        return this.dialog;
    }

    protected Object createDialog(EObject realEditedObject, EStructuralFeature realFeature, Stereotype stereotype, ResourceSet resourceSet, Cell cell) {
        UMLContentProvider p = new UMLContentProvider(realEditedObject, realFeature, stereotype, resourceSet);
        StringBuffer dialogTitle = new StringBuffer(realFeature.getName());
        if (dialogTitle.length() > 0) {
            String first = dialogTitle.substring(0, 1).toUpperCase();
            dialogTitle.replace(0, 1, first);
        }
        Object value = realEditedObject.eGet(realFeature);
        TreeSelectorDialog dialog = new TreeSelectorDialog(Display.getDefault().getActiveShell()){

            public void okPressed() {
                super.okPressed();
                SingleReferenceValueCellEditor.this.returnedValue = (EObject)this.getResult()[0];
                SingleReferenceValueCellEditor.this.editHandler.commit((Object)SingleReferenceValueCellEditor.this.returnedValue, SelectionLayer.MoveDirectionEnum.NONE);
            }
        };
        EncapsulatedContentProvider provider = new EncapsulatedContentProvider((IStructuredContentProvider)p);
        dialog.setContentProvider((ITreeContentProvider)provider);
        dialog.setLabelProvider((ILabelProvider)new UMLFilteredLabelProvider());
        dialog.setInitialElementSelections(Collections.singletonList(value));
        dialog.setTitle(dialogTitle.toString());
        return dialog;
    }

    public Object getDialogInstance() {
        return this.dialog;
    }

    public Object getEditorValue() {
        return this.returnedValue;
    }

    public void setEditorValue(Object value) {
    }

    public void close() {
    }

    public boolean isClosed() {
        return false;
    }
}

