/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.hyperlink.ui;

import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.papyrus.infra.hyperlink.Activator;
import org.eclipse.papyrus.infra.hyperlink.messages.Messages;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractEditHyperlinkShell
extends TrayDialog {
    protected static final String OBJECT_LABEL = Messages.AbstractEditHyperlinkShell_object;
    private Text tooltipInputText = null;
    private CLabel tooltipInputLabel = null;
    private Text objectLabeltext = null;
    private CLabel objectLabel = null;
    private Button useDefaultCheckBox = null;
    private Button searchButton = null;
    private boolean hasSearchButton;

    protected AbstractEditHyperlinkShell(Shell shell, boolean hasSearchButton) {
        super(shell);
        this.hasSearchButton = hasSearchButton;
    }

    protected AbstractEditHyperlinkShell(IShellProvider shellProvider, boolean hasSearchButton) {
        super(shellProvider);
        this.hasSearchButton = hasSearchButton;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.AbstractEditHyperlinkShell_EditHyperLink);
        newShell.setToolTipText(Messages.AbstractEditHyperlinkShell_EditionOfAHyperLink);
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        GridData gridData51 = new GridData();
        gridData51.horizontalAlignment = 4;
        gridData51.verticalAlignment = 2;
        GridData gridData3 = new GridData();
        gridData3.grabExcessHorizontalSpace = true;
        gridData3.verticalAlignment = 2;
        gridData3.horizontalAlignment = 4;
        GridData gridData2 = new GridData();
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.verticalAlignment = 2;
        gridData2.horizontalAlignment = 4;
        GridData gridData1 = new GridData();
        gridData1.horizontalSpan = this.hasSearchButton ? 5 : 6;
        gridData1.verticalAlignment = 2;
        gridData1.grabExcessHorizontalSpace = true;
        gridData1.grabExcessVerticalSpace = false;
        gridData1.horizontalAlignment = 4;
        GridData gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 2;
        gridData.grabExcessHorizontalSpace = true;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 7;
        gridLayout.makeColumnsEqualWidth = true;
        result.setLayout((Layout)gridLayout);
        this.objectLabel = new CLabel(result, 0);
        this.objectLabel.setText(OBJECT_LABEL);
        this.objectLabeltext = new Text(result, 2048);
        this.objectLabeltext.setLayoutData((Object)gridData1);
        if (this.hasSearchButton) {
            this.searchButton = new Button(result, 8);
            this.searchButton.setImage(Activator.getDefault().getIcon("loupe"));
            this.searchButton.setLayoutData((Object)gridData51);
            this.searchButton.setText("");
            this.searchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractEditHyperlinkShell.this.onSearch();
                }
            });
        }
        this.tooltipInputLabel = new CLabel(result, 0);
        this.tooltipInputLabel.setText(Messages.AbstractEditHyperlinkShell_ToolTipText);
        this.tooltipInputLabel.setToolTipText(Messages.AbstractEditHyperlinkShell_ToolTipText_);
        this.tooltipInputText = new Text(result, 2048);
        this.tooltipInputText.setLayoutData((Object)gridData);
        this.useDefaultCheckBox = new Button(result, 32);
        this.useDefaultCheckBox.setText(Messages.AbstractEditHyperlinkShell_UseDefault);
        this.useDefaultCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractEditHyperlinkShell.this.onUseDefaultTooltip();
            }
        });
        this.contentsCreated();
        return result;
    }

    protected void contentsCreated() {
    }

    protected Text getTooltipInputText() {
        return this.tooltipInputText;
    }

    protected Text getObjectLabelText() {
        return this.objectLabeltext;
    }

    protected CLabel getObjectLabel() {
        return this.objectLabel;
    }

    protected Button getUseDefaultCheckBox() {
        return this.useDefaultCheckBox;
    }

    protected Button getSearchButton() {
        return this.searchButton;
    }

    protected void onSearch() {
    }

    protected void onUseDefaultTooltip() {
    }
}

