/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.impl.ocl.tracker.activeocl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.ParserException;
import org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.impl.ocl.activeocl.ActiveOclListener;
import org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.impl.ocl.activeocl.ActiveOclResult;
import org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.impl.ocl.tracker.activeocl.DependencyEvaluator;
import org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.impl.ocl.tracker.activeocl.ListeningDependencyCollector;

class ActiveOclResultImpl
implements ActiveOclResult,
ActiveOclListener {
    private final List<ActiveOclListener> myListeners = new ArrayList<ActiveOclListener>();
    private Object myResult;
    private final ListeningDependencyCollector myDependencyCollector = new ListeningDependencyCollector(this);
    private final DependencyEvaluator myDependencyEvaluator;

    public ActiveOclResultImpl(EObject context, String oclExp) throws ParserException {
        this.myDependencyEvaluator = new DependencyEvaluator(context, oclExp, this.myDependencyCollector);
        this.myResult = this.myDependencyEvaluator.evaluate();
    }

    @Override
    public void onResultChanged() {
        this.myDependencyCollector.clear();
        Object newResult = this.myDependencyEvaluator.evaluate();
        if (this.myResult == null && newResult == null || this.myResult != null && this.myResult.equals(newResult)) {
            return;
        }
        this.myResult = newResult;
        for (ActiveOclListener listener : this.myListeners) {
            listener.onResultChanged();
        }
    }

    @Override
    public void removeListener(ActiveOclListener listener) {
        this.myListeners.remove(listener);
    }

    @Override
    public Object getResult() {
        return this.myResult;
    }

    @Override
    public void dispose() {
        this.myDependencyCollector.clear();
    }

    @Override
    public boolean canListenForChanges() {
        return true;
    }

    @Override
    public void addListener(ActiveOclListener listener) {
        this.myListeners.add(listener);
    }

    @Override
    public Notifier adaptToEMFNotifier() {
        return null;
    }
}

