/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.internal.services.status;

import org.eclipse.papyrus.infra.ui.Activator;
import org.eclipse.papyrus.infra.ui.api.services.IStatusService;
import org.eclipse.papyrus.infra.ui.api.services.StatusServiceEvent;
import org.eclipse.papyrus.infra.ui.internal.services.status.BeginStatusEvent;
import org.eclipse.papyrus.infra.ui.internal.services.status.EndStatusEvent;
import org.eclipse.papyrus.infra.ui.internal.services.status.ProgressDialog;
import org.eclipse.papyrus.infra.ui.internal.services.status.StepStatusEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class StatusService
implements IStatusService {
    private static final String DATA_SPLASH_SHELL = "org.eclipse.ui.workbench.splashShell";
    private ProgressDialog dialog;

    @Override
    public void trigger(StatusServiceEvent event) {
        if (event instanceof BeginStatusEvent) {
            try {
                Shell splashShell = (Shell)Display.getCurrent().getData(DATA_SPLASH_SHELL);
                if (splashShell == null || splashShell.isDisposed()) {
                    this.dialog = new ProgressDialog(Display.getDefault().getActiveShell(), ((BeginStatusEvent)event).getExecutionTitle(), ((BeginStatusEvent)event).getMessage());
                    this.dialog.open();
                    this.dialog.work(((BeginStatusEvent)event).getMessage());
                }
            }
            catch (IllegalArgumentException e) {
                Activator.log.error((Throwable)e);
            }
        } else if (event instanceof StepStatusEvent) {
            if (this.dialog != null && this.dialog instanceof ProgressDialog) {
                this.dialog.work(((StepStatusEvent)event).getMessage());
            }
        } else if (event instanceof EndStatusEvent && this.dialog != null) {
            this.dialog.close();
            this.dialog = null;
        }
    }
}

