/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.viewpoints.policy;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.papyrus.infra.viewpoints.policy.Activator;
import org.eclipse.papyrus.infra.viewpoints.policy.IProfileHelper;

public class ProfileUtils {
    private static final String EXTENSION_ID = "org.eclipse.papyrus.infra.viewpoints.policy.profilehelper";
    private static final IProfileHelper profileHelper = ProfileUtils.readProfileHelper();

    public static IProfileHelper getProfileHelper() {
        return profileHelper;
    }

    private static IProfileHelper readProfileHelper() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(EXTENSION_ID);
        try {
            IConfigurationElement[] iConfigurationElementArray = point.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                try {
                    IProfileHelper instance = (IProfileHelper)e.createExecutableExtension("class");
                    if (instance != null) {
                        return instance;
                    }
                }
                catch (ClassCastException | CoreException ex) {
                    Activator.log.error(ex);
                }
                ++n2;
            }
        }
        catch (Throwable t) {
            Activator.log.error(t);
        }
        return new DefaultProfileHelper();
    }

    private static class DefaultProfileHelper
    implements IProfileHelper {
        private DefaultProfileHelper() {
        }

        @Override
        public Collection<EPackage> getAppliedProfiles(EObject model) {
            return new ArrayList<EPackage>(0);
        }

        @Override
        public Collection<EClass> getAppliedStereotypes(EObject object) {
            return new ArrayList<EClass>(0);
        }
    }
}

