/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.notation.NamedStyle;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.AddAllCustomStyleListValueCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.AddCustomStyleListValueCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.RemoveAllCustomStyleListValueCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.RemoveCustomStyleListValueCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.SetCustomStyleListValueCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.listener.CustomStyleListener;
import org.eclipse.papyrus.infra.ui.emf.databinding.EMFObservableList;
import org.eclipse.papyrus.infra.widgets.editors.AbstractEditor;

public class CustomStyleObservableList
extends EMFObservableList
implements IChangeListener {
    protected EClass eClass;
    protected String styleName;
    protected View view;
    protected EditingDomain domain;
    protected CustomStyleListener listener;
    protected boolean styleExists;
    protected boolean changing = false;
    protected IObservableList observableConcreteList;

    public CustomStyleObservableList(View view, String styleName, EditingDomain domain, EClass eClass, EStructuralFeature feature) {
        super((List)CustomStyleObservableList.getWrappedList(view, styleName, eClass, feature), domain, null, null);
        this.eClass = eClass;
        this.feature = feature;
        this.styleName = styleName;
        this.view = view;
        this.domain = domain;
        this.observableConcreteList = (IObservableList)this.concreteList;
        this.styleExists = this.styleExists();
        this.listener = new CustomStyleListener(view, feature, (IChangeListener)this, styleName);
        view.eAdapters().add((Object)this.listener);
    }

    public void commit(AbstractEditor editor) {
        this.changing = true;
        super.commit(editor);
        this.changing = false;
    }

    protected boolean styleExists() {
        for (Style style : this.view.getStyles()) {
            NamedStyle namedStyle;
            if (!this.eClass.isInstance((Object)style) || !this.styleName.equals((namedStyle = (NamedStyle)style).getName())) continue;
            return true;
        }
        return false;
    }

    protected boolean isStyleCreated() {
        return this.getNamedStyle() != null;
    }

    protected NamedStyle getNamedStyle() {
        return this.view.getNamedStyle(this.eClass, this.styleName);
    }

    private static IObservableList getWrappedList(View view, String styleName, EClass eClass, EStructuralFeature feature) {
        NamedStyle style = view.getNamedStyle(eClass, styleName);
        if (style != null) {
            return EMFProperties.list((EStructuralFeature)feature).observe((Object)style);
        }
        return new WritableList();
    }

    public Command getAddCommand(int index, Object value) {
        return new AddCustomStyleListValueCommand(this.domain, this.view, this.styleName, this.eClass, this.feature, value, index);
    }

    public Command getAddCommand(Object value) {
        return new AddCustomStyleListValueCommand(this.domain, this.view, this.styleName, this.eClass, this.feature, value);
    }

    public Command getAddAllCommand(Collection<?> values) {
        return new AddAllCustomStyleListValueCommand(this.domain, this.view, this.styleName, this.eClass, this.feature, values);
    }

    public Command getAddAllCommand(int index, Collection<?> values) {
        return new AddCustomStyleListValueCommand(this.domain, this.view, this.styleName, this.eClass, this.feature, values, index);
    }

    public Command getRemoveCommand(Object value) {
        return new RemoveCustomStyleListValueCommand(this.domain, this.view, this.styleName, this.eClass, this.feature, value);
    }

    public Command getRemoveAllCommand(Collection<?> values) {
        return new RemoveAllCustomStyleListValueCommand(this.domain, this.view, this.styleName, this.eClass, this.feature, values);
    }

    public Command getSetCommand(int index, Object value) {
        return new SetCustomStyleListValueCommand(this.domain, this.view, this.styleName, this.eClass, this.feature, index, value);
    }

    public void handleChange(ChangeEvent event) {
        this.styleExists = this.styleExists();
        if (this.styleExists != this.styleExists) {
            this.observableConcreteList.dispose();
            this.observableConcreteList = this.getConcreteList();
            this.concreteList = this.observableConcreteList;
            this.observableConcreteList.addChangeListener((IChangeListener)this);
        }
        if (!this.changing) {
            this.refreshCacheList();
        }
    }

    protected IObservableList getConcreteList() {
        return CustomStyleObservableList.getWrappedList(this.view, this.styleName, this.eClass, this.feature);
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (this.listener != null) {
            this.view.eAdapters().remove((Object)this.listener);
            this.listener.dispose();
            this.listener = null;
        }
        this.observableConcreteList.dispose();
        super.dispose();
    }
}

