/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.event.CellSelectionEvent;
import org.eclipse.nebula.widgets.nattable.selection.event.ColumnSelectionEvent;
import org.eclipse.nebula.widgets.nattable.selection.event.ISelectionEvent;
import org.eclipse.nebula.widgets.nattable.selection.event.RowSelectionEvent;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.provider.TableStructuredSelection;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.TableSelectionWrapper;
import org.eclipse.papyrus.infra.nattable.utils.TypeSelectionEnum;
import org.eclipse.papyrus.infra.tools.util.ListHelper;
import org.eclipse.ui.services.IDisposable;

public class TableSelectionProvider
implements ISelectionProvider,
IDisposable,
ILayerListener {
    private SelectionLayer selectionLayer;
    private final ILayerListener selectionListener;
    private ISelection currentSelection;
    private final List<ISelectionChangedListener> listeners;
    private INattableModelManager manager;
    private boolean isDisposed = false;

    public TableSelectionProvider(INattableModelManager manager, SelectionLayer selectionLayer) {
        this.selectionLayer = selectionLayer;
        this.selectionListener = this;
        this.selectionLayer.addLayerListener(this.selectionListener);
        this.currentSelection = new StructuredSelection();
        this.listeners = new ArrayList<ISelectionChangedListener>();
        this.manager = manager;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public synchronized ISelection getSelection() {
        return this.currentSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized void setSelection(ISelection selection) {
        if (this.currentSelection.equals(selection)) {
            return;
        }
        this.currentSelection = selection;
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.currentSelection);
        for (ISelectionChangedListener current : this.listeners) {
            current.selectionChanged(event);
        }
    }

    protected void calculateAndStoreNewSelection(ILayerEvent event) {
        StructuredSelection newSelection;
        Collection<Object> selection = new HashSet();
        if (event instanceof ISelectionEvent) {
            TableSelectionWrapper wrapper = new TableSelectionWrapper(ListHelper.asList((Object[])this.selectionLayer.getSelectedCellPositions()), new HashMap<Integer, Object>(0), new HashMap<Integer, Object>(0));
            TypeSelectionEnum typeSelectionEvent = TypeSelectionEnum.NONE;
            boolean isWithShiftMask = false;
            boolean isWithControlMask = false;
            if (event instanceof CellSelectionEvent) {
                typeSelectionEvent = TypeSelectionEnum.CELL;
                isWithShiftMask = ((CellSelectionEvent)event).isWithShiftMask();
                isWithControlMask = ((CellSelectionEvent)event).isWithControlMask();
            } else if (event instanceof ColumnSelectionEvent) {
                typeSelectionEvent = TypeSelectionEnum.COLUMN;
                isWithShiftMask = ((ColumnSelectionEvent)event).isWithShiftMask();
                isWithControlMask = ((ColumnSelectionEvent)event).isWithControlMask();
            } else if (event instanceof RowSelectionEvent) {
                typeSelectionEvent = TypeSelectionEnum.ROW;
                isWithShiftMask = ((RowSelectionEvent)event).isWithShiftMask();
                isWithControlMask = ((RowSelectionEvent)event).isWithControlMask();
            }
            selection = !TypeSelectionEnum.NONE.equals((Object)typeSelectionEvent) ? (isWithShiftMask ? this.calculateSelectionWithShiftMask(wrapper, typeSelectionEvent) : (isWithControlMask ? this.calculateSelectionWithControlMask(wrapper, typeSelectionEvent, event) : this.calculateSelectionRowsAndColumnsWithTypeSelectionEvent(wrapper, typeSelectionEvent, event))) : this.calculateSelectionRowsAndColumnsWithoutTypeSelectionEvent(wrapper, event);
            newSelection = selection.isEmpty() ? new TableStructuredSelection(this.manager.getTable().getContext(), wrapper) : new TableStructuredSelection(selection.toArray(), wrapper);
        } else {
            newSelection = new StructuredSelection((Object)this.manager.getTable().getContext());
        }
        this.setSelection((ISelection)newSelection);
    }

    protected Collection<Object> calculateSelectionWithShiftMask(TableSelectionWrapper wrapper, TypeSelectionEnum typeSelectionEvent) {
        block9: {
            block8: {
                if (!TypeSelectionEnum.CELL.equals((Object)typeSelectionEvent)) break block8;
                if (!(this.currentSelection instanceof TableStructuredSelection)) break block9;
                TableSelectionWrapper existingWrapper = (TableSelectionWrapper)((TableStructuredSelection)this.currentSelection).getAdapter(TableSelectionWrapper.class);
                wrapper.getFullySelectedRows().putAll(existingWrapper.getFullySelectedRows());
                wrapper.getFullySelectedColumns().putAll(existingWrapper.getFullySelectedColumns());
                break block9;
            }
            if (TypeSelectionEnum.ROW.equals((Object)typeSelectionEvent)) {
                int[] nArray = this.selectionLayer.getFullySelectedRowPositions();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    int rowIndex = this.selectionLayer.getRowIndexByPosition(i);
                    Object el = this.manager.getRowElement(rowIndex);
                    if (el != null && !wrapper.getFullySelectedRows().containsKey(rowIndex) && this.isSelectedCellsContainsRow(wrapper.getSelectedCells(), this.manager.getBodyLayerStack().getRowHideShowLayer().getRowPositionByIndex(rowIndex))) {
                        wrapper.getFullySelectedRows().put(rowIndex, el);
                    }
                    ++n2;
                }
            } else if (TypeSelectionEnum.COLUMN.equals((Object)typeSelectionEvent)) {
                if (this.currentSelection instanceof TableStructuredSelection) {
                    TableSelectionWrapper existingWrapper = (TableSelectionWrapper)((TableStructuredSelection)this.currentSelection).getAdapter(TableSelectionWrapper.class);
                    wrapper.getFullySelectedRows().putAll(existingWrapper.getFullySelectedRows());
                    wrapper.getFullySelectedColumns().putAll(existingWrapper.getFullySelectedColumns());
                }
                int[] nArray = this.selectionLayer.getFullySelectedColumnPositions();
                int n = nArray.length;
                int n3 = 0;
                while (n3 < n) {
                    int i = nArray[n3];
                    int columnIndex = this.selectionLayer.getColumnIndexByPosition(i);
                    Object el = this.manager.getColumnElement(columnIndex);
                    if (el != null && !wrapper.getFullySelectedColumns().containsKey(columnIndex) && this.isSelectedCellsContainsColumn(wrapper.getSelectedCells(), this.manager.getBodyLayerStack().getColumnHideShowLayer().getColumnPositionByIndex(columnIndex))) {
                        wrapper.getFullySelectedColumns().put(columnIndex, el);
                    }
                    ++n3;
                }
            }
        }
        return this.calculateSelectionFromWrapper(wrapper);
    }

    protected Collection<Object> calculateSelectionWithControlMask(TableSelectionWrapper wrapper, TypeSelectionEnum typeSelectionEvent, ILayerEvent event) {
        if (this.currentSelection instanceof TableStructuredSelection) {
            TableSelectionWrapper existingWrapper = (TableSelectionWrapper)((TableStructuredSelection)this.currentSelection).getAdapter(TableSelectionWrapper.class);
            wrapper.getFullySelectedRows().putAll(existingWrapper.getFullySelectedRows());
            wrapper.getFullySelectedColumns().putAll(existingWrapper.getFullySelectedColumns());
        }
        if (TypeSelectionEnum.CELL.equals((Object)typeSelectionEvent)) {
            int columnPosition = ((CellSelectionEvent)event).getColumnPosition();
            int rowPosition = ((CellSelectionEvent)event).getRowPosition();
            PositionCoordinate tmpCoordinate = new PositionCoordinate((ILayer)this.selectionLayer, columnPosition, rowPosition);
            if (!wrapper.getSelectedCells().contains(tmpCoordinate)) {
                if (wrapper.getFullySelectedRows().containsKey(rowPosition)) {
                    wrapper.getFullySelectedRows().remove(rowPosition);
                }
                if (wrapper.getFullySelectedColumns().containsKey(columnPosition)) {
                    wrapper.getFullySelectedColumns().remove(columnPosition);
                }
            }
        } else {
            this.calculateSelectionRowsAndColumnsWithTypeSelectionEvent(wrapper, typeSelectionEvent, event);
        }
        return this.calculateSelectionFromWrapper(wrapper);
    }

    protected Collection<Object> calculateSelectionRowsAndColumnsWithTypeSelectionEvent(TableSelectionWrapper wrapper, TypeSelectionEnum typeSelectionEvent, ILayerEvent event) {
        block11: {
            block10: {
                if (!TypeSelectionEnum.COLUMN.equals((Object)typeSelectionEvent)) break block10;
                for (Range range : ((ColumnSelectionEvent)event).getColumnPositionRanges()) {
                    int index = range.start;
                    while (index < range.end) {
                        int columnIndex = this.selectionLayer.getColumnIndexByPosition(index);
                        Object el = this.manager.getColumnElement(columnIndex);
                        if (wrapper.getFullySelectedColumns().containsKey(index)) {
                            wrapper.getFullySelectedColumns().remove(columnIndex);
                        } else if (el != null && this.isSelectedCellsContainsColumn(wrapper.getSelectedCells(), this.manager.getBodyLayerStack().getColumnHideShowLayer().getColumnPositionByIndex(columnIndex))) {
                            wrapper.getFullySelectedColumns().put(columnIndex, el);
                        }
                        ++index;
                    }
                }
                break block11;
            }
            if (!TypeSelectionEnum.ROW.equals((Object)typeSelectionEvent)) break block11;
            for (Range range : ((RowSelectionEvent)event).getRowPositionRanges()) {
                int index = range.start;
                while (index < range.end) {
                    int rowIndex = this.selectionLayer.getRowIndexByPosition(index);
                    Object el = this.manager.getRowElement(rowIndex);
                    if (wrapper.getFullySelectedRows().containsKey(index)) {
                        wrapper.getFullySelectedRows().remove(rowIndex);
                    } else if (el != null && this.isSelectedCellsContainsRow(wrapper.getSelectedCells(), this.manager.getBodyLayerStack().getRowHideShowLayer().getRowPositionByIndex(rowIndex))) {
                        wrapper.getFullySelectedRows().put(rowIndex, el);
                    }
                    ++index;
                }
            }
        }
        return this.calculateSelectionFromWrapper(wrapper);
    }

    private boolean isSelectedCellsContainsRow(Collection<PositionCoordinate> selectedCells, int rowIndex) {
        boolean result = false;
        Iterator<PositionCoordinate> selectedCellsIterator = selectedCells.iterator();
        while (!result && selectedCellsIterator.hasNext()) {
            PositionCoordinate selectedCell = selectedCellsIterator.next();
            if (selectedCell.getRowPosition() != rowIndex) continue;
            result = true;
        }
        return result;
    }

    private boolean isSelectedCellsContainsColumn(Collection<PositionCoordinate> selectedCells, int columnIndex) {
        boolean result = false;
        Iterator<PositionCoordinate> selectedCellsIterator = selectedCells.iterator();
        while (!result && selectedCellsIterator.hasNext()) {
            PositionCoordinate selectedCell = selectedCellsIterator.next();
            if (selectedCell.getColumnPosition() != columnIndex) continue;
            result = true;
        }
        return result;
    }

    protected Collection<Object> calculateSelectionFromWrapper(TableSelectionWrapper wrapper) {
        ArrayList<Object> selection = new ArrayList<Object>();
        ArrayList<Integer> selectedColumnsIndexes = new ArrayList<Integer>();
        for (Map.Entry<Integer, Object> selectedColumn : wrapper.getFullySelectedColumns().entrySet()) {
            Object selectedObject = AxisUtils.getRepresentedElement(selectedColumn.getValue());
            selection.add(selectedObject);
            selectedColumnsIndexes.add(selectedColumn.getKey());
        }
        ArrayList<Integer> selectedRowsIndexes = new ArrayList<Integer>();
        for (Map.Entry<Integer, Object> selectedRow : wrapper.getFullySelectedRows().entrySet()) {
            Object selectedObject = AxisUtils.getRepresentedElement(selectedRow.getValue());
            selection.add(selectedObject);
            selectedRowsIndexes.add(selectedRow.getKey());
        }
        for (PositionCoordinate cellLocation : wrapper.getSelectedCells()) {
            ILayerCell cell;
            int colPos = cellLocation.getColumnPosition();
            int rowPos = cellLocation.getRowPosition();
            if (selectedColumnsIndexes.contains(new Integer(this.selectionLayer.getColumnIndexByPosition(colPos))) || selectedRowsIndexes.contains(new Integer(this.selectionLayer.getRowIndexByPosition(rowPos))) || (cell = this.selectionLayer.getCellByPosition(colPos, rowPos)) == null) continue;
            Object value = cell.getDataValue();
            if (value != null) {
                if (value instanceof Collection) {
                    for (Object current : (Collection)value) {
                        selection.add(current);
                    }
                    continue;
                }
                selection.add(value);
                continue;
            }
            selection.add(cell);
        }
        return selection;
    }

    protected Collection<Object> calculateSelectionRowsAndColumnsWithoutTypeSelectionEvent(TableSelectionWrapper wrapper, ILayerEvent event) {
        ArrayList<Object> selection = new ArrayList<Object>();
        ArrayList<Integer> selectedRowsIndexes = new ArrayList<Integer>();
        int[] nArray = this.selectionLayer.getFullySelectedRowPositions();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            int rowIndex = this.selectionLayer.getRowIndexByPosition(i);
            selectedRowsIndexes.add(new Integer(rowIndex));
            Object el = this.manager.getRowElement(rowIndex);
            if (el != null) {
                wrapper.getFullySelectedRows().put(rowIndex, el);
                el = AxisUtils.getRepresentedElement(el);
                selection.add(el);
            }
            ++n2;
        }
        ArrayList<Integer> selectedColumnsIndexes = new ArrayList<Integer>();
        int[] rowIndex = this.selectionLayer.getFullySelectedColumnPositions();
        int n3 = rowIndex.length;
        n = 0;
        while (n < n3) {
            int i = rowIndex[n];
            int columnIndex = this.selectionLayer.getColumnIndexByPosition(i);
            selectedColumnsIndexes.add(new Integer(columnIndex));
            Object el = this.manager.getColumnElement(columnIndex);
            if (el != null) {
                wrapper.getFullySelectedColumns().put(columnIndex, el);
                el = AxisUtils.getRepresentedElement(el);
                selection.add(el);
            }
            ++n;
        }
        for (PositionCoordinate cellLocation : wrapper.getSelectedCells()) {
            ILayerCell cell;
            int colPos = cellLocation.getColumnPosition();
            int rowPos = cellLocation.getRowPosition();
            if (selectedColumnsIndexes.contains(new Integer(this.selectionLayer.getColumnIndexByPosition(colPos))) || selectedRowsIndexes.contains(new Integer(this.selectionLayer.getRowIndexByPosition(rowPos))) || (cell = this.selectionLayer.getCellByPosition(colPos, rowPos)) == null) continue;
            Object value = cell.getDataValue();
            if (value != null) {
                if (value instanceof Collection) {
                    for (Object current : (Collection)value) {
                        selection.add(current);
                    }
                    continue;
                }
                selection.add(value);
                continue;
            }
            selection.add(cell);
        }
        return selection;
    }

    public void dispose() {
        this.isDisposed = true;
        this.manager = null;
        this.setSelection((ISelection)StructuredSelection.EMPTY);
        if (this.selectionLayer != null) {
            this.selectionLayer.removeLayerListener(this.selectionListener);
            this.selectionLayer = null;
        }
        this.listeners.clear();
    }

    public void handleLayerEvent(ILayerEvent event) {
        if (!this.isDisposed && event instanceof ISelectionEvent) {
            this.calculateAndStoreNewSelection(event);
        }
    }
}

