/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editpolicies;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.ExternalReferenceEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.SemanticElementHelper;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.helper.StereotypeDisplayUtil;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;

public class ImportedElementEditPolicy
extends ExternalReferenceEditPolicy {
    protected boolean isExternalRef(View diagramElement) {
        if (!super.isExternalRef(diagramElement)) {
            return false;
        }
        if (diagramElement == null) {
            return false;
        }
        View primaryView = SemanticElementHelper.findTopView((EObject)diagramElement);
        if (primaryView == null) {
            return false;
        }
        EObject semanticElement = primaryView.getElement();
        if (!(semanticElement instanceof Element)) {
            return false;
        }
        if (semanticElement instanceof Property) {
            return this.isInheritedProperty(diagramElement);
        }
        if (semanticElement instanceof Constraint || semanticElement instanceof Comment) {
            return false;
        }
        EObject parentView = primaryView.eContainer();
        if (!(parentView instanceof View)) {
            return false;
        }
        EObject parentSemanticElement = ((View)parentView).getElement();
        if (!(parentSemanticElement instanceof Element)) {
            return false;
        }
        if (StereotypeDisplayUtil.getInstance().isStereotypeView(this.getView())) {
            return false;
        }
        Element semanticUMLElement = (Element)semanticElement;
        Element parentUMLElement = (Element)parentSemanticElement;
        if (parentUMLElement instanceof Package) {
            return semanticUMLElement.getNearestPackage() != parentUMLElement;
        }
        return semanticUMLElement.getNearestPackage() != parentUMLElement.getNearestPackage();
    }

    protected boolean isInheritedProperty(View diagramElement) {
        View primaryView = SemanticElementHelper.findTopView((EObject)diagramElement);
        if (primaryView == null) {
            return false;
        }
        View parentView = (View)primaryView.eContainer();
        if (parentView == null) {
            return false;
        }
        EObject semanticElement = SemanticElementHelper.findSemanticElement((EObject)diagramElement);
        if (!(semanticElement instanceof Property)) {
            return false;
        }
        Property property = (Property)semanticElement;
        EObject semanticParent = SemanticElementHelper.findSemanticElement((EObject)parentView);
        if (semanticParent instanceof Property) {
            return false;
        }
        if (semanticParent instanceof Classifier) {
            return property.eContainer() != semanticParent;
        }
        return true;
    }
}

