/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.parser.stereotype;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.papyrus.uml.diagram.common.parser.assist.FixedSetCompletionProcessor;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.helper.StereotypeDisplayConstant;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class AppliedStereotypeParser
implements ISemanticParser {
    private final String myDefaultPrintString;

    public AppliedStereotypeParser() {
        this(null);
    }

    public AppliedStereotypeParser(String defaultPrintString) {
        this.myDefaultPrintString = defaultPrintString;
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        Object feature;
        if (notification instanceof Notification && (feature = ((Notification)notification).getFeature()) instanceof EStructuralFeature) {
            EStructuralFeature featureImpl = (EStructuralFeature)feature;
            return featureImpl.getName().startsWith("base_");
        }
        return false;
    }

    public List<?> getSemanticElementsBeingParsed(EObject eObject) {
        Element element = (Element)eObject;
        LinkedList result = new LinkedList();
        result.addAll(element.getStereotypeApplications());
        return result;
    }

    public IContentAssistProcessor getCompletionProcessor(IAdaptable subject) {
        Element element = this.doAdapt(subject);
        LinkedList remaining = new LinkedList();
        remaining.addAll(element.getApplicableStereotypes());
        remaining.removeAll((Collection<?>)element.getAppliedStereotypes());
        LinkedList<String> names = new LinkedList<String>();
        for (Stereotype next : remaining) {
            names.add(next.getName());
        }
        return new FixedSetCompletionProcessor(names);
    }

    public String getEditString(IAdaptable element, int flags) {
        Element subject = this.doAdapt(element);
        EList stereos = subject.getAppliedStereotypes();
        if (stereos.isEmpty()) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        for (Stereotype next : stereos) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(UMLLabelInternationalization.getInstance().getKeyword(next));
        }
        return result.toString();
    }

    public ICommand getParseCommand(IAdaptable element, String newString, int flags) {
        return UnexecutableCommand.INSTANCE;
    }

    public String getPrintString(IAdaptable element, int flags) {
        String editString = this.getEditString(element, flags);
        if (editString != null && !editString.isEmpty()) {
            return String.valueOf(StereotypeDisplayConstant.QUOTE_LEFT) + editString + StereotypeDisplayConstant.QUOTE_RIGHT;
        }
        return this.myDefaultPrintString;
    }

    public boolean isAffectingEvent(Object event, int flags) {
        return false;
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return ParserEditStatus.UNEDITABLE_STATUS;
    }

    private Element doAdapt(IAdaptable adaptable) {
        Element element = (Element)adaptable.getAdapter(EObject.class);
        return element;
    }
}

