/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.custom.policies;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.commands.SemanticAdapter;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.commands.CustomStateResizeCommand;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.StateEditPart;

public class CustomRegionCompartmentXYLayoutEditPolicy
extends XYLayoutEditPolicy {
    public Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
        if (request == null || child == null || constraint == null) {
            throw new IllegalArgumentException();
        }
        if (child instanceof StateEditPart) {
            View state = (View)child.getModel();
            int dx = request.getSizeDelta().width;
            int dy = request.getSizeDelta().height;
            if (dx == 0 && dy == 0) {
                return super.createChangeConstraintCommand(request, child, constraint);
            }
            TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
            CompositeTransactionalCommand cc = new CompositeTransactionalCommand(editingDomain, DiagramUIMessages.AddCommand_Label);
            SemanticAdapter adaptableForState = new SemanticAdapter(null, (Object)state);
            CustomStateResizeCommand resizeStateMachine = new CustomStateResizeCommand((IAdaptable)adaptableForState, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint(), editingDomain, DiagramUIMessages.CreateCommand_Label, request, (Rectangle)constraint, false);
            cc.add((IUndoableOperation)resizeStateMachine);
            return new ICommandProxy(cc.reduce());
        }
        return super.createChangeConstraintCommand(request, child, constraint);
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        if (child instanceof StateEditPart) {
            ResizableEditPolicy policy = new ResizableEditPolicy(){

                public void eraseSourceFeedback(Request request) {
                    if ("drop".equals(request.getType())) {
                        this.eraseChangeBoundsFeedback((ChangeBoundsRequest)request);
                    } else {
                        super.eraseSourceFeedback(request);
                    }
                }

                public void showSourceFeedback(Request request) {
                    if ("drop".equals(request.getType())) {
                        this.showChangeBoundsFeedback((ChangeBoundsRequest)request);
                    } else {
                        super.showSourceFeedback(request);
                    }
                }
            };
            return policy;
        }
        return super.createChildEditPolicy(child);
    }

    public EditPart getTargetEditPart(Request request) {
        if (request instanceof CreateUnspecifiedTypeConnectionRequest) {
            return this.getHost().getParent().getParent().getParent();
        }
        return super.getTargetEditPart(request);
    }
}

