/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards.kind;

import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.core.architecture.RepresentationKind;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureViewpoint;

public class RepresentationKindContentProvider
implements IStructuredContentProvider {
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        ArchitectureDomainManager manager = ArchitectureDomainManager.getInstance();
        if (inputElement instanceof Object[]) {
            TreeSet<RepresentationKind> result = new TreeSet<RepresentationKind>(new Comparator<RepresentationKind>(){

                @Override
                public int compare(RepresentationKind o1, RepresentationKind o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            Object[] objectArray = (Object[])inputElement;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object next = objectArray[n2];
                if (next instanceof String) {
                    String viewpointId = (String)next;
                    MergedArchitectureViewpoint viewpoint = manager.getArchitectureViewpointById(viewpointId);
                    result.addAll(viewpoint.getRepresentationKinds());
                }
                ++n2;
            }
            return result.toArray(new Object[result.size()]);
        }
        if (inputElement instanceof String) {
            String viewpointId = (String)inputElement;
            MergedArchitectureViewpoint viewpoint = manager.getArchitectureViewpointById(viewpointId);
            Collection result = viewpoint.getRepresentationKinds();
            return result.toArray(new Object[result.size()]);
        }
        return null;
    }
}

