/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.papyrus.infra.nattable.manager.table.ITableAxisElementProvider;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.uml.nattable.editor.AbstractUMLMultiValueCellEditor;
import org.eclipse.papyrus.uml.nattable.editor.EObjectTreeDialog;
import org.eclipse.papyrus.uml.nattable.utils.UMLTableUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class DatatypeDialogCellEditor
extends AbstractUMLMultiValueCellEditor {
    public DatatypeDialogCellEditor(Object axisElement, ITableAxisElementProvider provider) {
        super(axisElement, provider);
    }

    @Override
    public Object createDialogInstance() {
        int columnIndex = this.layerCell.getColumnIndex();
        int rowIndex = this.layerCell.getRowIndex();
        Object row = this.manager.getRowElement(rowIndex);
        Object column = this.manager.getColumnElement(columnIndex);
        row = AxisUtils.getRepresentedElement((Object)row);
        column = AxisUtils.getRepresentedElement((Object)column);
        Element editedElement = null;
        Object feature = null;
        if (row instanceof EObject && column == this.getAxisElement()) {
            editedElement = (Element)row;
            feature = column;
        } else {
            editedElement = (Element)column;
            feature = row;
        }
        EStructuralFeature realFeature = null;
        Element realEditedObject = null;
        Stereotype stereotype = null;
        List<Stereotype> stereotypesWithEditedFeatureAppliedOnElement = null;
        if (feature instanceof EStructuralFeature) {
            realFeature = (EStructuralFeature)feature;
            realEditedObject = editedElement;
        } else {
            String id = AxisUtils.getPropertyId((Object)this.getAxisElement());
            stereotypesWithEditedFeatureAppliedOnElement = UMLTableUtils.getAppliedStereotypesWithThisProperty(editedElement, id);
            stereotype = stereotypesWithEditedFeatureAppliedOnElement.get(0);
            realEditedObject = editedElement.getStereotypeApplication(stereotypesWithEditedFeatureAppliedOnElement.get(0));
            Property prop = UMLTableUtils.getRealStereotypeProperty((EObject)editedElement, id);
            realFeature = realEditedObject.eClass().getEStructuralFeature(prop.getName());
        }
        if (stereotypesWithEditedFeatureAppliedOnElement == null || stereotypesWithEditedFeatureAppliedOnElement.size() <= 1) {
            this.dialog = this.createDialog((EObject)realEditedObject, realFeature, stereotype, editedElement.eResource().getResourceSet());
        }
        return this.dialog;
    }

    @Override
    protected ReferenceValueFactory getFactory() {
        return null;
    }

    @Override
    protected IElementSelector getElementSelector(boolean isUnique, ILabelProvider labelProvider, IStaticContentProvider contentProvider) {
        return null;
    }

    @Override
    protected Object createDialog(EObject realEditedObject, EStructuralFeature realFeature, Stereotype stereotype, ResourceSet resourceSet) {
        return new EObjectTreeDialog(Display.getDefault().getActiveShell(), realEditedObject, realFeature, "DataType Edition"){

            protected void okPressed() {
                Object[] result;
                super.okPressed();
                ArrayList<Object> newValue = new ArrayList<Object>();
                Object[] objectArray = result = this.getResult();
                int n = result.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    newValue.add(object);
                    ++n2;
                }
                DatatypeDialogCellEditor.this.editHandler.commit(newValue, SelectionLayer.MoveDirectionEnum.NONE);
            }
        };
    }
}

