/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.textedit.common.xtext.ui.contentassist;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.uml.textedit.common.xtext.ui.contentassist.AbstractUmlCommonProposalProvider;
import org.eclipse.papyrus.uml.textedit.common.xtext.ui.internal.UmlCommonActivator;
import org.eclipse.papyrus.uml.textedit.common.xtext.umlCommon.BoundSpecification;
import org.eclipse.papyrus.uml.textedit.common.xtext.umlCommon.MultiplicityRule;
import org.eclipse.papyrus.uml.textedit.common.xtext.umlCommon.QualifiedName;
import org.eclipse.papyrus.uml.textedit.common.xtext.umlCommon.TypeRule;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Type;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

public class UmlCommonProposalProvider
extends AbstractUmlCommonProposalProvider {
    protected ILabelProvider labelProvider;
    private Namespace model = null;
    private Element contextElement = null;
    private Class<?> wantedType = Type.class;

    public UmlCommonProposalProvider() {
        this.initModel();
    }

    protected Namespace getModel() {
        return this.model;
    }

    protected Element getContextElement() {
        return this.contextElement;
    }

    protected void initModel() {
        EObject first;
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        ISelection mySelection = activePage.getSelection();
        if (mySelection instanceof IStructuredSelection && (first = EMFHelper.getEObject((Object)((IStructuredSelection)mySelection).getFirstElement())) instanceof Element) {
            Element element;
            this.contextElement = element = (Element)first;
            if (element != null) {
                EList namespaces = element.getNearestPackage().allNamespaces();
                this.model = namespaces.size() == 0 ? element.getNearestPackage() : (Namespace)namespaces.get(namespaces.size() - 1);
            }
        }
        try {
            this.labelProvider = ((LabelProviderService)ServiceUtilsForEObject.getInstance().getService(LabelProviderService.class, (Object)this.model)).getLabelProvider();
        }
        catch (ServiceException ex) {
            Logger.getLogger(UmlCommonActivator.class).error((Object)ex);
            this.labelProvider = new LabelProvider();
        }
        Assert.isNotNull((Object)this.contextElement, (String)"I can't find the edited element");
        Assert.isNotNull((Object)this.model, (String)"I can't find the model owning the edited element");
    }

    @Override
    public void complete_MultiplicityRule(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String one = "[1]";
        String one_star = "[1..*]";
        String star = "[*]";
        String completionString = "";
        String displayString = "";
        ICompletionProposal completionProposal = null;
        completionString = one.substring(context.getPrefix().length());
        displayString = one;
        completionProposal = this.createCompletionProposal(completionString, displayString, context);
        acceptor.accept(completionProposal);
        completionString = one_star.substring(context.getPrefix().length());
        displayString = one_star + "     ";
        completionProposal = this.createCompletionProposal(completionString, displayString, context);
        acceptor.accept(completionProposal);
        completionString = star.substring(context.getPrefix().length());
        displayString = star;
        completionProposal = this.createCompletionProposal(completionString, displayString, context);
        acceptor.accept(completionProposal);
    }

    @Override
    public void completeMultiplicityRule_Bounds(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        block4: {
            if (!(model instanceof MultiplicityRule)) {
                return;
            }
            MultiplicityRule multiplicityRule = (MultiplicityRule)model;
            if (multiplicityRule.getBounds().size() == 2) {
                String value = ((BoundSpecification)multiplicityRule.getBounds().get(1)).getValue();
                try {
                    Integer.valueOf(value);
                }
                catch (Exception e) {
                    if (((BoundSpecification)multiplicityRule.getBounds().get(0)).getValue().equals("*") || ((BoundSpecification)multiplicityRule.getBounds().get(1)).getValue().equals("*")) break block4;
                    String completionString = "*";
                    String displayString = "*";
                    ICompletionProposal completionProposal = this.createCompletionProposal(completionString, displayString, context);
                    acceptor.accept(completionProposal);
                }
            }
        }
    }

    @Override
    public void completeQualifiedName_Path(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
    }

    @Override
    public void completeQualifiedName_Remaining(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        List<Type> accessibleType;
        ICompletionProposal completionProposal;
        String displayString;
        String completionString;
        QualifiedName path = (QualifiedName)model;
        for (NamedElement n : path.getPath().getOwnedMembers()) {
            if (!(n instanceof Namespace)) continue;
            if (n.getName().startsWith(context.getPrefix())) {
                completionString = String.valueOf(n.getName().substring(context.getPrefix().length())) + "::";
                displayString = String.valueOf(n.getName()) + "::";
                completionProposal = this.createCompletionProposal(n, completionString, displayString, context);
                accessibleType = this.getRecursivelyOwnedType((Namespace)n);
                accessibleType.addAll(this.getRecursivelyImportedType((Namespace)n));
                if (accessibleType.size() != 0) {
                    acceptor.accept(completionProposal);
                }
            }
            if (!n.getName().startsWith(context.getPrefix())) continue;
            completionString = n.getName().substring(context.getPrefix().length());
            displayString = n.getName();
            completionProposal = this.createCompletionProposal(n, completionString, displayString, context);
            if (!this.isWantedType((Element)n)) continue;
            acceptor.accept(completionProposal);
        }
        for (Package p : path.getPath().getImportedPackages()) {
            if (!p.getName().startsWith(context.getPrefix())) continue;
            completionString = String.valueOf(p.getName().substring(context.getPrefix().length())) + "::";
            displayString = String.valueOf(p.getName()) + "::";
            completionProposal = this.createCompletionProposal((NamedElement)p, completionString, displayString, context);
            accessibleType = this.getRecursivelyOwnedType((Namespace)p);
            accessibleType.addAll(this.getRecursivelyImportedType((Namespace)p));
            if (accessibleType.size() == 0) continue;
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completeTypeRule_Path(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Namespace root = this.getModel();
        if (root == null) {
            return;
        }
        String completionString = String.valueOf(root.getName()) + "::";
        String displayString = String.valueOf(root.getName()) + "::";
        ICompletionProposal completionProposal = this.createCompletionProposalWithReplacementOfPrefix((NamedElement)root, completionString, displayString, context);
        acceptor.accept(completionProposal);
        EList importedPackages = root.getImportedPackages();
        for (Package p : importedPackages) {
            if (!p.getName().startsWith(context.getPrefix())) continue;
            completionString = String.valueOf(p.getName().substring(context.getPrefix().length())) + "::";
            displayString = String.valueOf(p.getName()) + "::";
            completionProposal = this.createCompletionProposal((NamedElement)root, completionString, displayString, context);
            List<Type> accessibleType = this.getRecursivelyOwnedType((Namespace)p);
            accessibleType.addAll(this.getRecursivelyImportedType((Namespace)p));
            if (accessibleType.size() == 0) continue;
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completeTypeRule_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Package namespace = this.getContextElement().getNearestPackage();
        if (model instanceof TypeRule) {
            TypeRule typeRule = (TypeRule)model;
            QualifiedName path = typeRule.getPath();
            while (path.getRemaining() != null) {
                path = path.getRemaining();
            }
            namespace = path.getPath();
        }
        for (NamedElement n : namespace.getOwnedMembers()) {
            if (this.isWantedType((Element)n) && n.getName().startsWith(context.getPrefix())) {
                String completionString = n.getName().substring(context.getPrefix().length());
                String displayString = n.getName();
                ICompletionProposal completionProposal = this.createCompletionProposal(n, completionString, displayString, context);
                acceptor.accept(completionProposal);
            }
            if (!(n instanceof Namespace)) continue;
            for (Type t : this.getRecursivelyOwnedType((Namespace)n)) {
                if (!t.getName().startsWith(context.getPrefix())) continue;
                String completionString = t.getName().substring(context.getPrefix().length());
                String displayString = t.getName();
                ICompletionProposal completionProposal = this.createCompletionProposal((NamedElement)t, completionString, displayString, context);
                acceptor.accept(completionProposal);
            }
        }
    }

    protected ICompletionProposal createCompletionProposal(NamedElement namedElement, String completionString, String displayString, ContentAssistContext context) {
        String additionalProposalInfo = namedElement.getQualifiedName() + "\n" + '(' + namedElement.eClass().getName() + ')';
        CompletionProposal completionProposal = new CompletionProposal(completionString, context.getOffset(), context.getSelectedText().length(), completionString.length(), this.labelProvider.getImage((Object)namedElement), " " + displayString, null, additionalProposalInfo);
        return completionProposal;
    }

    protected ICompletionProposal createCompletionProposal(String completionString, String displayString, ContentAssistContext context) {
        CompletionProposal completionProposal = new CompletionProposal(completionString, context.getOffset(), context.getSelectedText().length(), completionString.length(), null, " " + displayString, null, null);
        return completionProposal;
    }

    protected ICompletionProposal createCompletionProposalWithReplacementOfPrefix(NamedElement namedElement, String completionString, String displayString, ContentAssistContext context) {
        String additionalProposalInfo = namedElement.getQualifiedName() + "\n" + '(' + namedElement.eClass().getName() + ')';
        CompletionProposal completionProposal = new CompletionProposal(completionString, context.getOffset() - context.getPrefix().length(), context.getPrefix().length(), completionString.length(), this.labelProvider.getImage((Object)namedElement), " " + displayString, null, additionalProposalInfo);
        return completionProposal;
    }

    protected List<Type> getRecursivelyImportedType(Namespace context) {
        ArrayList<Type> recursivelyImportedTypes = new ArrayList<Type>();
        EList importedPackages = context.getImportedPackages();
        for (Package p : importedPackages) {
            recursivelyImportedTypes.addAll(this.getRecursivelyOwnedType((Namespace)p));
        }
        return recursivelyImportedTypes;
    }

    protected List<Type> getRecursivelyOwnedType(Namespace context) {
        ArrayList<Type> recursivelyOwnedTypes = new ArrayList<Type>();
        EList allOwnedElements = context.getOwnedElements();
        for (Element e : allOwnedElements) {
            if (this.isWantedType(e)) {
                recursivelyOwnedTypes.add((Type)e);
            }
            if (!(e instanceof Namespace)) continue;
            recursivelyOwnedTypes.addAll(this.getRecursivelyOwnedType((Namespace)e));
        }
        return recursivelyOwnedTypes;
    }

    protected boolean isWantedType(Element e) {
        return this.wantedType.isInstance(e);
    }

    public void setWantedType(Class<?> type) {
        this.wantedType = type;
    }
}

