/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.internationalization.ui.handlers;

import java.util.Iterator;
import java.util.Locale;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.commands.AddToResourceCommand;
import org.eclipse.papyrus.infra.emf.commands.RemoveFromResourcecommand;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResource;
import org.eclipse.papyrus.infra.internationalization.common.command.LocaleInternationalizationPreferenceCommand;
import org.eclipse.papyrus.infra.internationalization.common.command.UseInternationalizationPreferenceCommand;
import org.eclipse.papyrus.infra.internationalization.ui.Activator;
import org.eclipse.papyrus.infra.internationalization.ui.dialogs.InternationalizationDialog;
import org.eclipse.papyrus.infra.ui.command.AbstractCommandHandler;
import org.eclipse.ui.PlatformUI;

public class InternationalizationCommandHandler
extends AbstractCommandHandler {
    protected Command getCommand(IEvaluationContext context) {
        InternationalizationDialog dialog;
        UnexecutableCommand resultCommand = UnexecutableCommand.INSTANCE;
        EObject selectedElement = this.getSelectedElement();
        URI neededURIResource = this.getRootNotationURI(selectedElement);
        Resource notationResource = null;
        Iterator resources = selectedElement.eResource().getResourceSet().getResources().iterator();
        while (resources.hasNext() && notationResource == null) {
            Resource resource = (Resource)resources.next();
            if (!neededURIResource.equals(resource.getURI())) continue;
            notationResource = resource;
        }
        if (notationResource != null && (dialog = new InternationalizationDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), notationResource.getURI(), true)).open() == 0) {
            boolean useInternationalizationValue = dialog.getUseInternationalizationValue();
            Locale localeValue = dialog.getLocaleValue();
            EAnnotation annotation = null;
            for (EObject objectContent : notationResource.getContents()) {
                if (!(objectContent instanceof EAnnotation) || !"Internationalization".equals(((EAnnotation)objectContent).getSource())) continue;
                annotation = (EAnnotation)objectContent;
            }
            CompoundCommand compoundCommand = new CompoundCommand("Create internationalization command");
            if (annotation != null) {
                try {
                    compoundCommand.append((Command)new RemoveFromResourcecommand(ServiceUtilsForResource.getInstance().getTransactionalEditingDomain((Object)notationResource), notationResource, (EObject)annotation));
                }
                catch (ServiceException e) {
                    Activator.log.error((Throwable)e);
                }
                compoundCommand.append((Command)new UseInternationalizationPreferenceCommand(notationResource.getURI(), false));
            }
            if (useInternationalizationValue && localeValue != null) {
                annotation = EcoreFactory.eINSTANCE.createEAnnotation();
                annotation.setSource("Internationalization");
                if (useInternationalizationValue) {
                    annotation.getDetails().put((Object)"use", (Object)Boolean.toString(useInternationalizationValue));
                    compoundCommand.append((Command)new UseInternationalizationPreferenceCommand(notationResource.getURI(), useInternationalizationValue));
                }
                if (localeValue != null) {
                    annotation.getDetails().put((Object)"language", (Object)localeValue.toString());
                    compoundCommand.append((Command)new LocaleInternationalizationPreferenceCommand(notationResource.getURI(), localeValue.toString()));
                }
                compoundCommand.append((Command)new GMFtoEMFCommandWrapper((ICommand)new AddToResourceCommand(((ModelSet)notationResource.getResourceSet()).getTransactionalEditingDomain(), notationResource, (EObject)annotation)));
            }
            if (!compoundCommand.isEmpty()) {
                resultCommand = compoundCommand;
            }
        }
        return resultCommand;
    }

    protected URI getRootNotationURI(EObject selectedObject) {
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)selectedObject);
        URI rootURI = rootContainer.eResource().getURI();
        return rootURI.trimFileExtension().appendFileExtension("notation");
    }

    public void setEnabled(Object evaluationContext) {
        this.setBaseEnabled(true);
    }
}

