/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.custom.policies;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.adapter.SemanticAdapter;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.commands.CustomFirstRegionInCompositeStateCreateElementCommand;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.RegionCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.RegionEditPart;
import org.eclipse.papyrus.uml.diagram.statemachine.providers.UMLElementTypes;

public class CustomStateCompartmentCreationEditPolicy
extends CreationEditPolicy {
    IFigure sizeOnDropFeedback = null;
    String dropLocation = "";

    public Command getCommand(Request request) {
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(editingDomain, DiagramUIMessages.AddCommand_Label);
        if (this.understandsRequest(request)) {
            if (request instanceof CreateViewRequest) {
                CreateViewRequest createViewRequest = (CreateViewRequest)request;
                for (CreateViewRequest.ViewDescriptor vd : createViewRequest.getViewDescriptors()) {
                    if (!vd.getSemanticHint().equals(((IHintedType)UMLElementTypes.Region_Shape).getSemanticHint())) continue;
                    View stateCompartmentView = (View)this.getHost().getModel();
                    SemanticAdapter adaptableForStateCompartmentView = new SemanticAdapter(null, (Object)stateCompartmentView);
                    CustomFirstRegionInCompositeStateCreateElementCommand createNewRegion = new CustomFirstRegionInCompositeStateCreateElementCommand((IAdaptable)adaptableForStateCompartmentView, null, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint(), editingDomain, DiagramUIMessages.CreateCommand_Label, this.dropLocation);
                    cc.compose((IUndoableOperation)createNewRegion);
                    return new ICommandProxy(cc.reduce());
                }
            } else if (request instanceof CreateUnspecifiedTypeRequest) {
                CreateUnspecifiedTypeRequest unspecReq = (CreateUnspecifiedTypeRequest)request;
                for (IElementType elementType : unspecReq.getElementTypes()) {
                    if (!((IHintedType)elementType).getSemanticHint().equals(((IHintedType)UMLElementTypes.Region_Shape).getSemanticHint())) continue;
                    View stateCompartmentView = (View)this.getHost().getModel();
                    SemanticAdapter adaptableForStateCompartmentView = new SemanticAdapter(null, (Object)stateCompartmentView);
                    CustomFirstRegionInCompositeStateCreateElementCommand createNewRegion = new CustomFirstRegionInCompositeStateCreateElementCommand((IAdaptable)adaptableForStateCompartmentView, null, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint(), editingDomain, DiagramUIMessages.CreateCommand_Label, this.dropLocation);
                    cc.compose((IUndoableOperation)createNewRegion);
                    return new ICommandProxy(cc.reduce());
                }
            } else if (request instanceof ChangeBoundsRequest) {
                ChangeBoundsRequest changeBoundsRequest = (ChangeBoundsRequest)request;
                Point mouseLocation = changeBoundsRequest.getLocation();
                DropObjectsRequest dropRequest = new DropObjectsRequest();
                dropRequest.setLocation(mouseLocation);
                ArrayList<View> list = new ArrayList<View>();
                for (Object next : changeBoundsRequest.getEditParts()) {
                    EditPart ep;
                    if (!(next instanceof EditPart) || !((ep = (EditPart)next) instanceof RegionEditPart)) continue;
                    View regionToDrag = (View)ep.getModel();
                    list.add(regionToDrag);
                }
                dropRequest.setObjects(list);
                return this.getHost().getCommand((Request)dropRequest);
            }
            return super.getCommand(request);
        }
        return null;
    }

    protected Command getCreateCommand(CreateViewRequest request) {
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        CompositeTransactionalCommand cc = null;
        for (CreateViewRequest.ViewDescriptor descriptor : request.getViewDescriptors()) {
            if (!((IHintedType)UMLElementTypes.Region_Shape).getSemanticHint().equals(descriptor.getSemanticHint())) continue;
            SemanticAdapter compartment = new SemanticAdapter(null, this.getHost().getModel());
            CustomFirstRegionInCompositeStateCreateElementCommand command = new CustomFirstRegionInCompositeStateCreateElementCommand((IAdaptable)compartment, descriptor.getElementAdapter(), ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint(), editingDomain, DiagramUIMessages.CreateCommand_Label, this.dropLocation);
            if (cc != null) continue;
            cc = new CompositeTransactionalCommand(editingDomain, DiagramUIMessages.AddCommand_Label);
            cc.compose((IUndoableOperation)command);
        }
        return cc != null ? new ICommandProxy(cc.reduce()) : super.getCreateCommand(request);
    }

    public EditPart getTargetEditPart(Request request) {
        if (request instanceof CreateUnspecifiedTypeRequest) {
            List elementTypes;
            CreateUnspecifiedTypeRequest createUnspecifiedTypeRequest = (CreateUnspecifiedTypeRequest)request;
            if (this.understandsRequest(request) && (elementTypes = createUnspecifiedTypeRequest.getElementTypes()).size() == 1 && (IElementType)elementTypes.get(0) == UMLElementTypes.ConnectionPointReference_Shape && this.getHost() instanceof ShapeCompartmentEditPart) {
                return this.getHost().getParent();
            }
        } else if (request instanceof CreateViewRequest) {
            CreateViewRequest create = (CreateViewRequest)request;
            for (CreateViewRequest.ViewDescriptor descriptor : create.getViewDescriptors()) {
                RegionCompartmentEditPart compartment;
                RegionEditPart existingRegion;
                if (!((IHintedType)UMLElementTypes.Region_Shape).getSemanticHint().equals(descriptor.getSemanticHint()) || (existingRegion = (RegionEditPart)((Object)Iterables.getLast((Iterable)Iterables.filter((Iterable)this.getHost().getChildren(), RegionEditPart.class), null))) == null || (compartment = (RegionCompartmentEditPart)((Object)Iterables.getFirst((Iterable)Iterables.filter((Iterable)existingRegion.getChildren(), RegionCompartmentEditPart.class), null))) == null) continue;
                return compartment.getTargetEditPart(request);
            }
        }
        return super.getTargetEditPart(request);
    }
}

