/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.modelrepair.ui;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.emf.resource.DependencyManager;
import org.eclipse.papyrus.uml.modelrepair.Activator;
import org.eclipse.papyrus.uml.modelrepair.ui.providers.ResourceLabelProvider;
import org.eclipse.papyrus.uml.modelrepair.ui.providers.ResourceLinksContentProvider;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class ModelRepairDialog
extends TrayDialog {
    private ModelSet modelSet;
    protected TreeViewer viewer;
    protected Tree tree;
    protected TreeEditor editor;
    protected Text textEditor;
    protected TreeItem currentSelection;

    public ModelRepairDialog(Shell shell, ModelSet modelSet) {
        super(shell);
        this.modelSet = modelSet;
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        Composite self = new Composite(contents, 0);
        self.setLayout((Layout)new GridLayout(1, false));
        self.setLayoutData((Object)new GridData(4, 4, true, true));
        Label descriptionLabel = new Label(self, 0);
        String description = "Press F2 or double click on an element to change its URI\n";
        description = String.valueOf(description) + "Edit a root element to modify all dependencies to the selected resource\n";
        description = String.valueOf(description) + "Edit a child element to modify only the dependencies from the root resource to the selected one\n";
        descriptionLabel.setText(description);
        descriptionLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        Label warningLabel = new Label(self, 0);
        String warning = "/!\\ Modifying the dependencies between models may result into an inconsistent state and a corrupted model /!\\\n";
        warning = String.valueOf(warning) + "Most corrupted model can be repaired with this tool";
        warningLabel.setText(warning);
        warningLabel.setForeground(Display.getCurrent().getSystemColor(4));
        warningLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        this.viewer = new TreeViewer(self, 67584);
        this.tree = this.viewer.getTree();
        TableLayout layout = new TableLayout();
        this.tree.setLayout((Layout)layout);
        this.tree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tree.setHeaderVisible(true);
        TreeColumn nameColumn = new TreeColumn(this.tree, 0);
        nameColumn.setText("Resource");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(25, 250, true));
        TreeColumn locationColumn = new TreeColumn(this.tree, 0);
        locationColumn.setText("Location");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(45, 450, true));
        TreeColumn versionColumn = new TreeColumn(this.tree, 0);
        versionColumn.setText("Read-only");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, 100, true));
        this.viewer.setContentProvider((IContentProvider)new ResourceLinksContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ResourceLabelProvider((ResourceSet)this.modelSet));
        this.viewer.setInput((Object)this.modelSet);
        this.editor = new TreeEditor(this.tree);
        this.editor.setColumn(1);
        this.editor.horizontalAlignment = 0x1000000;
        this.editor.grabHorizontal = true;
        this.textEditor = new Text((Composite)this.tree, 2048);
        this.textEditor.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (e.widget == ModelRepairDialog.this.textEditor) {
                    ModelRepairDialog.this.validate();
                }
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.textEditor.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    ModelRepairDialog.this.validate();
                    e.doit = false;
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.viewer.getTree().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x100000B && e.widget == ModelRepairDialog.this.tree) {
                    ModelRepairDialog.this.editElement(ModelRepairDialog.this.tree);
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (e.widget == ModelRepairDialog.this.tree) {
                    ModelRepairDialog.this.editElement(ModelRepairDialog.this.tree);
                    e.doit = false;
                }
            }
        });
        return contents;
    }

    protected void editElement(Tree tree) {
        if (tree.getSelection().length == 0) {
            return;
        }
        this.currentSelection = tree.getSelection()[0];
        Object element = this.currentSelection.getData();
        this.textEditor.setText(((ILabelProvider)this.viewer.getLabelProvider()).getText(element));
        this.editor.setEditor((Control)this.textEditor, this.currentSelection);
        this.textEditor.setFocus();
        this.textEditor.forceFocus();
        this.textEditor.setSelection(this.textEditor.getText().length());
    }

    protected void validate() {
        this.editor.setEditor(null);
        this.textEditor.setVisible(false);
        if (this.currentSelection == null) {
            return;
        }
        TransactionalEditingDomain domain = TransactionalEditingDomain.Factory.INSTANCE.getEditingDomain((ResourceSet)this.modelSet);
        domain.getCommandStack().execute((Command)new RecordingCommand(domain, "Change URI"){

            protected void doExecute() {
                ModelRepairDialog.this.doValidate();
            }
        });
        this.viewer.refresh();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doValidate() {
        URI uriToReplace;
        URI newURI = URI.createURI((String)this.textEditor.getText());
        Resource fromResource = null;
        if (this.currentSelection.getParentItem() == null) {
            Object element = this.currentSelection.getData();
            if (!(element instanceof Resource)) return;
            uriToReplace = ((Resource)element).getURI();
        } else {
            TreeItem parentItem = this.currentSelection.getParentItem();
            Object parentData = parentItem.getData();
            if (!(parentData instanceof Resource)) {
                return;
            }
            fromResource = (Resource)parentData;
            Object element = this.currentSelection.getData();
            if (!(element instanceof URI)) return;
            uriToReplace = (URI)element;
        }
        if (uriToReplace == null) {
            return;
        }
        if (uriToReplace.equals(newURI)) {
            return;
        }
        DependencyManager dependencyManager = fromResource == null ? new DependencyManager((ResourceSet)this.modelSet) : new DependencyManager(fromResource);
        dependencyManager.updateDependencies(uriToReplace, newURI, null, null);
    }

    protected void okPressed() {
        try {
            this.modelSet.save((IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException ex) {
            Activator.log.error((Throwable)ex);
        }
        super.okPressed();
    }

    public void create() {
        super.create();
        this.getShell().setText("Edit model links");
        this.getShell().pack();
    }

    protected boolean isResizable() {
        return true;
    }

    public boolean isHelpAvailable() {
        return false;
    }
}

