/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.resource;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProtocolTransition;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.internal.resource.UMLSaveImpl;
import org.eclipse.uml2.uml.util.UMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMI2UMLSaveImpl
extends UMLSaveImpl {
    protected static final String CMOF_XMLNS = "xmlns:cmof";
    protected static final String CMOF_URI = "http://www.omg.org/spec/MOF/20131001/cmof.xmi";
    protected boolean declareCMOF = false;

    public XMI2UMLSaveImpl(XMLHelper helper) {
        super(helper);
    }

    public void addNamespaceDeclarations() {
        super.addNamespaceDeclarations();
        if (this.declareCMOF) {
            this.doc.addAttribute(CMOF_XMLNS, CMOF_URI);
        }
    }

    @Override
    protected void init(XMLResource resource, Map<?, ?> options) {
        super.init(resource, options);
        this.featureTable = new Lookup(this.map, this.extendedMetaData);
    }

    protected void saveContainedMany(EObject eObject, EStructuralFeature eStructuralFeature) {
        if (eStructuralFeature == EcorePackage.Literals.EMODEL_ELEMENT__EANNOTATIONS) {
            this.doc.startElement("xmi:Extension");
            this.doc.addAttribute("extender", "http://www.eclipse.org/emf/2002/Ecore");
            super.saveContainedMany(eObject, eStructuralFeature);
            this.doc.endElement();
        } else if (eStructuralFeature == UMLPackage.Literals.NAMESPACE__ELEMENT_IMPORT) {
            if (eObject instanceof Profile) {
                List metaclassReferences = ((InternalEList)this.helper.getValue(eObject, (EStructuralFeature)UMLPackage.Literals.PROFILE__METACLASS_REFERENCE)).basicList();
                List values = ((InternalEList)this.helper.getValue(eObject, eStructuralFeature)).basicList();
                int size = values.size();
                int i = 0;
                while (i < size) {
                    InternalEObject value = (InternalEObject)values.get(i);
                    if (value != null) {
                        this.saveElement(value, (EStructuralFeature)(metaclassReferences.contains(value) ? UMLPackage.Literals.PROFILE__METACLASS_REFERENCE : UMLPackage.Literals.NAMESPACE__ELEMENT_IMPORT));
                    }
                    ++i;
                }
            } else {
                super.saveContainedMany(eObject, eStructuralFeature);
            }
        } else if (eStructuralFeature == UMLPackage.Literals.NAMESPACE__OWNED_RULE) {
            if (eObject instanceof Behavior) {
                List postcondition = ((InternalEList)this.helper.getValue(eObject, (EStructuralFeature)UMLPackage.Literals.BEHAVIOR__POSTCONDITION)).basicList();
                List precondition = ((InternalEList)this.helper.getValue(eObject, (EStructuralFeature)UMLPackage.Literals.BEHAVIOR__PRECONDITION)).basicList();
                List values = ((InternalEList)this.helper.getValue(eObject, eStructuralFeature)).basicList();
                int size = values.size();
                int i = 0;
                while (i < size) {
                    InternalEObject value = (InternalEObject)values.get(i);
                    if (value != null) {
                        this.saveElement(value, (EStructuralFeature)(postcondition.contains(value) ? UMLPackage.Literals.BEHAVIOR__POSTCONDITION : (precondition.contains(value) ? UMLPackage.Literals.BEHAVIOR__PRECONDITION : UMLPackage.Literals.NAMESPACE__OWNED_RULE)));
                    }
                    ++i;
                }
            } else if (eObject instanceof Operation) {
                Object bodyCondition = this.helper.getValue(eObject, (EStructuralFeature)UMLPackage.Literals.OPERATION__BODY_CONDITION);
                List postcondition = ((InternalEList)this.helper.getValue(eObject, (EStructuralFeature)UMLPackage.Literals.OPERATION__POSTCONDITION)).basicList();
                List precondition = ((InternalEList)this.helper.getValue(eObject, (EStructuralFeature)UMLPackage.Literals.OPERATION__PRECONDITION)).basicList();
                List values = ((InternalEList)this.helper.getValue(eObject, eStructuralFeature)).basicList();
                int size = values.size();
                int i = 0;
                while (i < size) {
                    InternalEObject value = (InternalEObject)values.get(i);
                    if (value != null) {
                        this.saveElement(value, (EStructuralFeature)(bodyCondition == value ? UMLPackage.Literals.OPERATION__BODY_CONDITION : (postcondition.contains(value) ? UMLPackage.Literals.OPERATION__POSTCONDITION : (precondition.contains(value) ? UMLPackage.Literals.OPERATION__PRECONDITION : UMLPackage.Literals.NAMESPACE__OWNED_RULE))));
                    }
                    ++i;
                }
            } else if (eObject instanceof ProtocolTransition) {
                Object postCondition = this.helper.getValue(eObject, (EStructuralFeature)UMLPackage.Literals.PROTOCOL_TRANSITION__POST_CONDITION);
                Object preCondition = this.helper.getValue(eObject, (EStructuralFeature)UMLPackage.Literals.PROTOCOL_TRANSITION__PRE_CONDITION);
                Object guard = this.helper.getValue(eObject, (EStructuralFeature)UMLPackage.Literals.TRANSITION__GUARD);
                List values = ((InternalEList)this.helper.getValue(eObject, eStructuralFeature)).basicList();
                int size = values.size();
                int i = 0;
                while (i < size) {
                    InternalEObject value = (InternalEObject)values.get(i);
                    if (value != null) {
                        this.saveElement(value, (EStructuralFeature)(postCondition == value ? UMLPackage.Literals.PROTOCOL_TRANSITION__POST_CONDITION : (preCondition == value ? UMLPackage.Literals.PROTOCOL_TRANSITION__PRE_CONDITION : (guard == value ? UMLPackage.Literals.TRANSITION__GUARD : UMLPackage.Literals.NAMESPACE__OWNED_RULE))));
                    }
                    ++i;
                }
            } else if (eObject instanceof State) {
                Object stateInvariant = this.helper.getValue(eObject, (EStructuralFeature)UMLPackage.Literals.STATE__STATE_INVARIANT);
                List values = ((InternalEList)this.helper.getValue(eObject, eStructuralFeature)).basicList();
                int size = values.size();
                int i = 0;
                while (i < size) {
                    InternalEObject value = (InternalEObject)values.get(i);
                    if (value != null) {
                        this.saveElement(value, (EStructuralFeature)(stateInvariant == value ? UMLPackage.Literals.STATE__STATE_INVARIANT : UMLPackage.Literals.NAMESPACE__OWNED_RULE));
                    }
                    ++i;
                }
            } else if (eObject instanceof Transition) {
                Object guard = this.helper.getValue(eObject, (EStructuralFeature)UMLPackage.Literals.TRANSITION__GUARD);
                List values = ((InternalEList)this.helper.getValue(eObject, eStructuralFeature)).basicList();
                int size = values.size();
                int i = 0;
                while (i < size) {
                    InternalEObject value = (InternalEObject)values.get(i);
                    if (value != null) {
                        this.saveElement(value, (EStructuralFeature)(guard == value ? UMLPackage.Literals.TRANSITION__GUARD : UMLPackage.Literals.NAMESPACE__OWNED_RULE));
                    }
                    ++i;
                }
            } else {
                super.saveContainedMany(eObject, eStructuralFeature);
            }
        } else if (eStructuralFeature == UMLPackage.Literals.NAMESPACE__PACKAGE_IMPORT) {
            if (eObject instanceof Profile) {
                List metamodelReferences = ((InternalEList)this.helper.getValue(eObject, (EStructuralFeature)UMLPackage.Literals.PROFILE__METAMODEL_REFERENCE)).basicList();
                List values = ((InternalEList)this.helper.getValue(eObject, eStructuralFeature)).basicList();
                int size = values.size();
                int i = 0;
                while (i < size) {
                    InternalEObject value = (InternalEObject)values.get(i);
                    if (value != null) {
                        this.saveElement(value, (EStructuralFeature)(metamodelReferences.contains(value) ? UMLPackage.Literals.PROFILE__METAMODEL_REFERENCE : UMLPackage.Literals.NAMESPACE__PACKAGE_IMPORT));
                    }
                    ++i;
                }
            } else {
                super.saveContainedMany(eObject, eStructuralFeature);
            }
        } else {
            super.saveContainedMany(eObject, eStructuralFeature);
        }
    }

    protected Object writeTopObject(EObject top) {
        return this.writeTopObjects(Collections.singletonList(top));
    }

    public Object writeTopObjects(List<? extends EObject> contents) {
        if (!this.toDOM) {
            this.doc.startElement("xmi:XMI");
            Object mark = this.doc.mark();
            int i = 0;
            int size = contents.size();
            while (i < size) {
                EObject top = contents.get(i);
                EClass eClass = top.eClass();
                if (this.extendedMetaData == null || this.featureTable.getDocumentRoot(eClass.getEPackage()) != eClass) {
                    String name = this.helper.getQName(eClass);
                    this.doc.startElement(name);
                    this.root = top;
                    this.saveElementID(top);
                } else {
                    this.doc.startElement(null);
                    this.root = top;
                    this.saveFeatures(top);
                    this.doc.addLine();
                }
                ++i;
            }
            int index = contents.size();
            TreeIterator properContents = EcoreUtil.getAllProperContents(contents, (boolean)false);
            while (properContents.hasNext()) {
                String nsURI;
                EObject eObject = (EObject)properContents.next();
                if (!(eObject instanceof Profile)) continue;
                Profile profile = (Profile)eObject;
                String nsPrefix = (String)UMLUtil.getTaggedValue(profile, "Ecore::EPackage", "nsPrefix");
                if (nsPrefix == null) {
                    nsPrefix = profile.getName();
                }
                if (!UML2Util.isEmpty((String)nsPrefix)) {
                    this.declareCMOF = true;
                    this.doc.startElement("cmof:Tag");
                    this.doc.addAttribute(this.idAttributeName, "_" + index++);
                    this.doc.addAttribute("name", "org.omg.xmi.nsPrefix");
                    this.doc.addAttribute("value", nsPrefix);
                    this.doc.addAttribute("element", this.helper.getIDREF((EObject)profile));
                    this.doc.endEmptyElement();
                }
                if ((nsURI = (String)UMLUtil.getTaggedValue(profile, "Ecore::EPackage", "nsURI")) == null) {
                    nsURI = profile.getURI();
                }
                if (UML2Util.isEmpty((String)nsURI)) continue;
                this.declareCMOF = true;
                this.doc.startElement("cmof:Tag");
                this.doc.addAttribute(this.idAttributeName, "_" + index++);
                this.doc.addAttribute("name", "org.omg.xmi.nsURI");
                this.doc.addAttribute("value", nsURI);
                this.doc.addAttribute("element", this.helper.getIDREF((EObject)profile));
                this.doc.endEmptyElement();
            }
            this.doc.endElement();
            return mark;
        }
        return super.writeTopObjects(contents);
    }

    protected static class Lookup
    extends UMLSaveImpl.Lookup {
        public Lookup(XMLResource.XMLMap map, ExtendedMetaData extendedMetaData) {
            super(map, extendedMetaData);
        }

        protected int featureKind(EStructuralFeature f) {
            if (f == UMLPackage.Literals.BEHAVIOR__POSTCONDITION || f == UMLPackage.Literals.BEHAVIOR__PRECONDITION || f == UMLPackage.Literals.CONSTRAINT__CONTEXT || f == UMLPackage.Literals.ELEMENT_IMPORT__IMPORTING_NAMESPACE || f == UMLPackage.Literals.OPERATION__BODY_CONDITION || f == UMLPackage.Literals.OPERATION__POSTCONDITION || f == UMLPackage.Literals.OPERATION__PRECONDITION || f == UMLPackage.Literals.PACKAGE_IMPORT__IMPORTING_NAMESPACE || f == UMLPackage.Literals.PROFILE__METACLASS_REFERENCE || f == UMLPackage.Literals.PROFILE__METAMODEL_REFERENCE || f == UMLPackage.Literals.PROTOCOL_TRANSITION__POST_CONDITION || f == UMLPackage.Literals.PROTOCOL_TRANSITION__PRE_CONDITION || f == UMLPackage.Literals.STATE__STATE_INVARIANT || f == UMLPackage.Literals.TRANSITION__GUARD) {
                return 0;
            }
            return !f.isTransient() && ((EStructuralFeature.Internal)f).isContainer() ? (f.isUnsettable() ? 12 : 8) : (f == UMLPackage.Literals.CONNECTABLE_ELEMENT__END || f == UMLPackage.Literals.VERTEX__INCOMING || f == UMLPackage.Literals.VERTEX__OUTGOING ? 9 : super.featureKind(f));
        }
    }
}

